/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.ClassUtils;
import org.cyclops.cyclopscore.datastructure.SingleCache;
import org.cyclops.cyclopscore.network.CodecField;
import org.cyclops.cyclopscore.network.ExtendedBuffer;
import org.cyclops.cyclopscore.network.PacketBase;

public abstract class PacketCodec
extends PacketBase {
    private static Map<Class<?>, ICodecAction> codecActions = Maps.newHashMap();
    protected SingleCache<Void, List<Field>> fieldCache = new SingleCache<Void, List<Field>>(new SingleCache.ICacheUpdater<Void, List<Field>>(){

        @Override
        public List<Field> getNewValue(Void key) {
            LinkedList fieldList = Lists.newLinkedList();
            for (Class<?> clazz = PacketCodec.this.getClass(); clazz != PacketCodec.class && clazz != null; clazz = clazz.getSuperclass()) {
                Field[] fields = clazz.getDeclaredFields();
                Arrays.sort(fields, new Comparator<Field>(){

                    @Override
                    public int compare(Field o1, Field o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                for (Field field : fields) {
                    if (!field.isAnnotationPresent(CodecField.class)) continue;
                    fieldList.add(field);
                }
            }
            return fieldList;
        }

        @Override
        public boolean isKeyEqual(Void cacheKey, Void newKey) {
            return true;
        }
    });

    @Nullable
    protected static ICodecAction getActionSuper(Class<?> clazz) {
        ICodecAction action;
        if (ClassUtils.isPrimitiveWrapper(clazz)) {
            clazz = ClassUtils.wrapperToPrimitive(clazz);
        }
        if ((action = codecActions.get(clazz)) == null) {
            for (Class<?> iface : clazz.getInterfaces()) {
                action = codecActions.get(iface);
                if (action == null) continue;
                return action;
            }
            Class superClass = clazz.getSuperclass();
            if (superClass != null) {
                return PacketCodec.getActionSuper(superClass);
            }
            return null;
        }
        return action;
    }

    protected static ICodecAction getAction(Class<?> clazz) {
        ICodecAction action = PacketCodec.getActionSuper(clazz);
        if (action == null) {
            System.err.println("No ICodecAction was found for " + clazz + ". You should add one in PacketCodec.");
        }
        return action;
    }

    private void loopCodecFields(ICodecRunnable runnable) {
        try {
            for (Field field : this.fieldCache.get(null)) {
                Class<?> clazz = field.getType();
                ICodecAction action = PacketCodec.getAction(clazz);
                boolean accessible = field.isAccessible();
                if (!accessible) {
                    field.setAccessible(true);
                }
                runnable.run(field, action);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void encode(ExtendedBuffer output) {
        this.loopCodecFields((field, action) -> {
            Object object = null;
            try {
                object = field.get(this);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
            action.encode(object, output);
        });
    }

    @Override
    public void decode(ExtendedBuffer input) {
        this.loopCodecFields((field, action) -> {
            Object object = action.decode(input);
            try {
                field.set(this, object);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                e.printStackTrace();
            }
        });
    }

    static {
        codecActions.put(String.class, new ICodecAction(){

            @Override
            public void encode(Object object, ExtendedBuffer output) {
                output.writeString((String)object);
            }

            @Override
            public Object decode(ExtendedBuffer input) {
                return input.readString();
            }
        });
        codecActions.put(Double.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, ExtendedBuffer output) {
                output.writeDouble((Double)object);
            }

            @Override
            public Object decode(ExtendedBuffer input) {
                return input.readDouble();
            }
        });
        codecActions.put(Integer.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, ExtendedBuffer output) {
                output.writeInt((Integer)object);
            }

            @Override
            public Object decode(ExtendedBuffer input) {
                return input.readInt();
            }
        });
        codecActions.put(Long.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, ExtendedBuffer output) {
                output.writeLong((Long)object);
            }

            @Override
            public Object decode(ExtendedBuffer input) {
                return input.readLong();
            }
        });
        codecActions.put(Short.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, ExtendedBuffer output) {
                output.writeShort(((Short)object).shortValue());
            }

            @Override
            public Object decode(ExtendedBuffer input) {
                return input.readShort();
            }
        });
        codecActions.put(Boolean.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, ExtendedBuffer output) {
                output.writeBoolean((Boolean)object);
            }

            @Override
            public Object decode(ExtendedBuffer input) {
                return input.readBoolean();
            }
        });
        codecActions.put(Float.TYPE, new ICodecAction(){

            @Override
            public void encode(Object object, ExtendedBuffer output) {
                output.writeFloat(((Float)object).floatValue());
            }

            @Override
            public Object decode(ExtendedBuffer input) {
                return Float.valueOf(input.readFloat());
            }
        });
        codecActions.put(Vec3d.class, new ICodecAction(){

            @Override
            public void encode(Object object, ExtendedBuffer output) {
                Vec3d v = (Vec3d)object;
                output.writeDouble(v.field_72450_a);
                output.writeDouble(v.field_72448_b);
                output.writeDouble(v.field_72449_c);
            }

            @Override
            public Object decode(ExtendedBuffer input) {
                double x = input.readDouble();
                double y = input.readDouble();
                double z = input.readDouble();
                return new Vec3d(x, y, z);
            }
        });
        codecActions.put(Map.class, new ICodecAction(){

            @Override
            public void encode(Object object, ExtendedBuffer output) {
                Map map = (Map)object;
                output.writeInt(map.size());
                Set entries = map.entrySet();
                ICodecAction keyAction = null;
                ICodecAction valueAction = null;
                for (Map.Entry entry : entries) {
                    if (keyAction == null) {
                        keyAction = PacketCodec.getAction(entry.getKey().getClass());
                        output.writeString(entry.getKey().getClass().getName());
                    }
                    if (valueAction == null) {
                        valueAction = PacketCodec.getAction(entry.getValue().getClass());
                        output.writeString(entry.getValue().getClass().getName());
                    }
                    keyAction.encode(entry.getKey(), output);
                    valueAction.encode(entry.getValue(), output);
                }
            }

            @Override
            public Object decode(ExtendedBuffer input) {
                HashMap map = Maps.newHashMap();
                int size = input.readInt();
                if (size == 0) {
                    return map;
                }
                try {
                    ICodecAction keyAction = PacketCodec.getAction(Class.forName(input.readString()));
                    ICodecAction valueAction = PacketCodec.getAction(Class.forName(input.readString()));
                    for (int i = 0; i < size; ++i) {
                        Object key = keyAction.decode(input);
                        Object value = valueAction.decode(input);
                        map.put(key, value);
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                return map;
            }
        });
        codecActions.put(NBTTagCompound.class, new ICodecAction(){

            @Override
            public void encode(Object object, ExtendedBuffer output) {
                output.func_150786_a((NBTTagCompound)object);
            }

            @Override
            public Object decode(ExtendedBuffer input) {
                try {
                    return input.func_150793_b();
                }
                catch (IOException ioexception) {
                    throw new EncoderException((Throwable)ioexception);
                }
            }
        });
        codecActions.put(ItemStack.class, new ICodecAction(){

            @Override
            public void encode(Object object, ExtendedBuffer output) {
                output.func_150788_a((ItemStack)object);
            }

            @Override
            public Object decode(ExtendedBuffer input) {
                try {
                    return input.func_150791_c();
                }
                catch (IOException ioexception) {
                    throw new EncoderException((Throwable)ioexception);
                }
            }
        });
        codecActions.put(FluidStack.class, new ICodecAction(){

            @Override
            public void encode(Object object, ExtendedBuffer output) {
                output.func_150786_a(((FluidStack)object).writeToNBT(new NBTTagCompound()));
            }

            @Override
            public Object decode(ExtendedBuffer input) {
                try {
                    return FluidStack.loadFluidStackFromNBT((NBTTagCompound)input.func_150793_b());
                }
                catch (IOException ioexception) {
                    throw new EncoderException((Throwable)ioexception);
                }
            }
        });
        codecActions.put(EnumFacing.class, new ICodecAction(){

            @Override
            public void encode(Object object, ExtendedBuffer output) {
                output.writeInt(((EnumFacing)object).ordinal());
            }

            @Override
            public Object decode(ExtendedBuffer input) {
                return EnumFacing.field_82609_l[input.readInt()];
            }
        });
        codecActions.put(BlockPos.class, new ICodecAction(){

            @Override
            public void encode(Object object, ExtendedBuffer output) {
                output.func_179255_a((BlockPos)object);
            }

            @Override
            public Object decode(ExtendedBuffer input) {
                return input.func_179259_c();
            }
        });
        codecActions.put(List.class, new ICodecAction(){

            @Override
            public void encode(Object object, ExtendedBuffer output) {
                List list = (List)object;
                output.writeInt(list.size());
                if (list.size() == 0) {
                    return;
                }
                ICodecAction valueAction = null;
                for (int i = 0; i < list.size(); ++i) {
                    Object value = list.get(i);
                    if (value == null) continue;
                    if (valueAction == null) {
                        valueAction = PacketCodec.getAction(value.getClass());
                        output.writeString(value.getClass().getName());
                    }
                    output.writeInt(i);
                    valueAction.encode(value, output);
                }
                if (valueAction == null) {
                    output.writeString("__noclass");
                } else {
                    output.writeInt(-1);
                }
            }

            @Override
            public Object decode(ExtendedBuffer input) {
                int size = input.readInt();
                if (size == 0) {
                    return Collections.emptyList();
                }
                ArrayList list = Lists.newArrayListWithExpectedSize((int)size);
                try {
                    String className = input.readString();
                    if (!className.equals("__noclass")) {
                        int i;
                        ICodecAction valueAction = PacketCodec.getAction(Class.forName(className));
                        int currentLength = 0;
                        while ((i = input.readInt()) >= 0) {
                            while (currentLength < i) {
                                list.add(null);
                                ++currentLength;
                            }
                            Object value = valueAction.decode(input);
                            list.add(value);
                            ++currentLength;
                        }
                        while (currentLength < size) {
                            list.add(null);
                            ++currentLength;
                        }
                    } else {
                        for (int i = 0; i < size; ++i) {
                            list.add(null);
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
                return list;
            }
        });
    }

    private static interface ICodecRunnable {
        public void run(Field var1, ICodecAction var2);
    }

    private static interface ICodecAction {
        public void encode(Object var1, ExtendedBuffer var2);

        public Object decode(ExtendedBuffer var1);
    }
}

