/*
 * Decompiled with CFR 0.152.
 */
package com.kjmaster.inventorygenerators.common.generators;

import com.kjmaster.inventorygenerators.InventoryGenerators;
import com.kjmaster.inventorygenerators.client.IHasModel;
import com.kjmaster.inventorygenerators.client.KeyHandler;
import com.kjmaster.inventorygenerators.common.generators.IInventoryGenerator;
import com.kjmaster.inventorygenerators.common.init.InitModGenerators;
import com.kjmaster.kjlib.common.energy.IItemEnergy;
import com.kjmaster.kjlib.common.energy.InvEnergyStorage;
import com.kjmaster.kjlib.common.items.ItemBase;
import com.kjmaster.kjlib.utils.CapabilityUtils;
import com.kjmaster.kjlib.utils.StringHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class ItemInventoryGenerator
extends ItemBase
implements IInventoryGenerator,
IItemEnergy,
IHasModel {
    public ItemInventoryGenerator(String name) {
        super(name, InventoryGenerators.invGenTab, 1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        final ModelResourceLocation onModel = new ModelResourceLocation(this.getRegistryName() + "_on", "inventory");
        final ModelResourceLocation offModel = new ModelResourceLocation(this.getRegistryName() + "_off", "inventory");
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{onModel, offModel});
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                if (ItemInventoryGenerator.this.isOn(stack) && ItemInventoryGenerator.this.getBurnTime(stack) > 0) {
                    return onModel;
                }
                return offModel;
            }
        });
    }

    public void func_77622_d(ItemStack stack, World world, EntityPlayer player) {
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof EntityPlayer && !world.field_72995_K) {
            IInventoryGenerator inventoryGenerator = (IInventoryGenerator)stack.func_77973_b();
            if (!stack.func_77942_o()) {
                this.giveTagCompound(stack);
            }
            if (inventoryGenerator.getBurnTime(stack) < 0) {
                inventoryGenerator.setBurnTime(stack, 0);
            }
            if (inventoryGenerator.isOn(stack)) {
                EntityPlayer player = (EntityPlayer)entity;
                IItemHandler inv = (IItemHandler)CapabilityUtils.getCapability((ICapabilityProvider)stack, (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
                if (inv == null) {
                    return;
                }
                ItemStack speedUpgradeStack = inv.getStackInSlot(1);
                int numSpeedUpgrades = speedUpgradeStack.func_190916_E();
                for (int i = 0; i <= numSpeedUpgrades; ++i) {
                    if (inventoryGenerator.getBurnTime(stack) <= 0 && !inventoryGenerator.getFuel(stack).func_190926_b() && this.getInternalEnergyStored(stack) != this.getMaxEnergyStored(stack)) {
                        ItemStack fuel = this.getFuel(stack);
                        inventoryGenerator.setBurnTime(stack, inventoryGenerator.calculateTime(fuel));
                        fuel.func_190918_g(1);
                    } else if (this.getInternalEnergyStored(stack) != this.getMaxEnergyStored(stack) && inventoryGenerator.getBurnTime(stack) > 0) {
                        inventoryGenerator.setBurnTime(stack, inventoryGenerator.getBurnTime(stack) - 1);
                        int rfToGive = inventoryGenerator.calculatePower(stack);
                        inventoryGenerator.receiveInternalEnergy(stack, rfToGive);
                    }
                    if (!inventoryGenerator.isInChargingMode(stack)) continue;
                    ArrayList<ItemStack> chargeables = inventoryGenerator.getChargeables(player);
                    inventoryGenerator.giveEnergyToChargeables(chargeables, stack);
                }
                if (inv.getStackInSlot(3).func_190926_b() && this.hasSideEffect() && inventoryGenerator.getBurnTime(stack) > 0) {
                    this.giveSideEffect(player);
                }
            }
        }
    }

    public void giveSideEffect(EntityPlayer player) {
    }

    public boolean hasSideEffect() {
        return false;
    }

    @Override
    public void giveTagCompound(ItemStack stack) {
        NBTTagCompound nbtTagCompound = new NBTTagCompound();
        nbtTagCompound.func_74757_a("On", false);
        nbtTagCompound.func_74757_a("Charging", false);
        nbtTagCompound.func_74768_a("Energy", 0);
        nbtTagCompound.func_74768_a("BurnTime", 0);
        stack.func_77982_d(nbtTagCompound);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            this.turnOn(stack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new InvEnergyProvider(stack, this);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
    }

    public void addMoreInformation(ItemStack stack, List<String> tooltip) {
        int numSpeedUpgrades;
        if (this.isOn(stack)) {
            tooltip.add(StringHelper.getNoticeText((String)"info.invgens.1"));
            tooltip.add(StringHelper.getDeactivationText((String)"info.invgens.2"));
        } else {
            tooltip.add(StringHelper.getActivationText((String)"info.invgens.3"));
        }
        if (this.isInChargingMode(stack)) {
            tooltip.add(StringHelper.getNoticeText((String)"info.invgens.modeOn"));
        } else {
            tooltip.add(StringHelper.getNoticeText((String)"info.invgens.modeOff"));
        }
        IItemHandler inv = (IItemHandler)CapabilityUtils.getCapability((ICapabilityProvider)stack, (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (inv == null) {
            numSpeedUpgrades = 0;
        } else {
            ItemStack speedUpgradesStack = inv.getStackInSlot(1);
            numSpeedUpgrades = speedUpgradesStack.func_190916_E();
        }
        tooltip.add(StringHelper.localizeFormat((String)"info.invgens.mode", (Object[])new Object[]{StringHelper.getKeyName((int)KeyHandler.MODE_KEY.func_151463_i())}));
        tooltip.add(StringHelper.localize((String)"info.invgens.charge") + ": " + StringHelper.getScaledNumber((long)this.getInternalEnergyStored(stack)) + " / " + StringHelper.getScaledNumber((long)this.getMaxEnergyStored(stack)) + " RF");
        tooltip.add(StringHelper.localize((String)"info.invgens.send") + "/" + StringHelper.localize((String)"info.invgens.receive") + ": " + StringHelper.formatNumber((long)this.getSend()) + "/" + StringHelper.formatNumber((long)this.getReceive()) + " RF/t * " + StringHelper.formatNumber((long)(numSpeedUpgrades + 1)));
        tooltip.add(StringHelper.localize((String)"info.invgens.burnTimeLeft") + ": " + StringHelper.formatNumber((long)this.getBurnTime(stack)));
    }

    @Override
    public ArrayList<ItemStack> getChargeables(EntityPlayer player) {
        ArrayList<ItemStack> chargeables = new ArrayList<ItemStack>();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack invStack = player.field_71071_by.func_70301_a(i);
            IEnergyStorage energyStorage = (IEnergyStorage)CapabilityUtils.getCapability((ICapabilityProvider)invStack, (Capability)CapabilityEnergy.ENERGY, null);
            if (energyStorage == null || energyStorage.getEnergyStored() >= energyStorage.getMaxEnergyStored()) continue;
            chargeables.add(invStack);
        }
        return chargeables;
    }

    @Override
    public void giveEnergyToChargeables(ArrayList<ItemStack> chargeables, ItemStack stack) {
        for (ItemStack chargeableStack : chargeables) {
            IEnergyStorage storage = (IEnergyStorage)CapabilityUtils.getCapability((ICapabilityProvider)chargeableStack, (Capability)CapabilityEnergy.ENERGY, null);
            int energySent = storage.receiveEnergy(this.getInternalEnergyStored(stack) / chargeables.size(), false);
            this.extractEnergy(stack, energySent, false);
        }
        chargeables.clear();
    }

    @Override
    public void receiveInternalEnergy(ItemStack stack, int energy) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbtTagCompound = stack.func_77978_p();
            if (nbtTagCompound.func_74764_b("Energy")) {
                int stored = this.getInternalEnergyStored(stack);
                int newEnergy = stored + energy;
                nbtTagCompound.func_74768_a("Energy", newEnergy);
            } else {
                nbtTagCompound.func_74768_a("Energy", 0);
            }
        } else {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74768_a("Energy", 0);
            stack.func_77955_b(nbtTagCompound);
        }
    }

    @Override
    public int getInternalEnergyStored(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound.func_74764_b("Energy")) {
                return tagCompound.func_74762_e("Energy");
            }
            tagCompound.func_74768_a("Energy", 0);
        } else {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74768_a("Energy", 0);
            stack.func_77955_b(nbtTagCompound);
        }
        return 0;
    }

    @Override
    public boolean isItemValid(ItemStack stack) {
        return false;
    }

    @Override
    public int calculateTime(ItemStack stack) {
        return 0;
    }

    @Override
    public int calculatePower(ItemStack stack) {
        return Math.min(this.getMaxEnergyStored(stack) - this.getInternalEnergyStored(stack), this.getSend());
    }

    @Override
    public boolean isInChargingMode(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbtTagCompound = stack.func_77978_p();
            if (nbtTagCompound.func_74764_b("Charging")) {
                return nbtTagCompound.func_74767_n("Charging");
            }
            nbtTagCompound.func_74757_a("Charging", false);
        } else {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74757_a("Charging", false);
            stack.func_77955_b(nbtTagCompound);
        }
        return false;
    }

    @Override
    public void changeMode(ItemStack stack) {
        if (this.isInChargingMode(stack) && stack.func_77942_o()) {
            NBTTagCompound nbtTagCompound = stack.func_77978_p();
            nbtTagCompound.func_74757_a("Charging", false);
        } else if (stack.func_77942_o()) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            tagCompound.func_74757_a("Charging", true);
        } else {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74757_a("Charging", false);
            stack.func_77955_b(nbtTagCompound);
        }
    }

    @Override
    public boolean isOn(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbtTagCompound = stack.func_77978_p();
            if (nbtTagCompound.func_74764_b("On")) {
                return nbtTagCompound.func_74767_n("On");
            }
            nbtTagCompound.func_74757_a("On", false);
        } else {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74757_a("On", false);
            stack.func_77955_b(nbtTagCompound);
        }
        return false;
    }

    @Override
    public void turnOn(ItemStack stack) {
        if (this.isOn(stack) && stack.func_77942_o()) {
            NBTTagCompound nbtTagCompound = stack.func_77978_p();
            nbtTagCompound.func_74757_a("On", false);
        } else if (stack.func_77942_o()) {
            NBTTagCompound tagCompound = stack.func_77978_p();
            tagCompound.func_74757_a("On", true);
        } else {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74757_a("On", false);
            stack.func_77955_b(nbtTagCompound);
        }
    }

    @Override
    public int getBurnTime(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbtTagCompound = stack.func_77978_p();
            if (nbtTagCompound.func_74764_b("BurnTime")) {
                return nbtTagCompound.func_74762_e("BurnTime");
            }
            nbtTagCompound.func_74768_a("BurnTime", 0);
        } else {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74768_a("BurnTime", 0);
            stack.func_77955_b(nbtTagCompound);
        }
        return 0;
    }

    @Override
    public void setBurnTime(ItemStack stack, int burnTime) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbtTagCompound = stack.func_77978_p();
            if (nbtTagCompound.func_74764_b("BurnTime")) {
                nbtTagCompound.func_74768_a("BurnTime", burnTime);
            } else {
                nbtTagCompound.func_74768_a("BurnTime", 0);
            }
        } else {
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            nbtTagCompound.func_74768_a("BurnTime", 0);
            stack.func_77955_b(nbtTagCompound);
        }
    }

    @Override
    public ItemStack getFuel(ItemStack stack) {
        IItemHandler inv = (IItemHandler)CapabilityUtils.getCapability((ICapabilityProvider)stack, (Capability)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return inv.getStackInSlot(0);
    }

    public int getMaxEnergyStored(ItemStack container) {
        return 100000;
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (!container.func_77942_o()) {
            NBTTagCompound newTagCompound = new NBTTagCompound();
            newTagCompound.func_74768_a("Energy", 0);
            container.func_77982_d(newTagCompound);
        }
        int energyExtracted = Math.min(this.getInternalEnergyStored(container), Math.min(this.getMaxEnergyStored(container), maxExtract));
        if (!simulate) {
            int stored = this.getInternalEnergyStored(container);
            container.func_77978_p().func_74768_a("Energy", stored -= energyExtracted);
        }
        return energyExtracted;
    }

    public int getSend() {
        return 40;
    }

    public int getReceive() {
        return 0;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        return EnumActionResult.FAIL;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged) && (slotChanged || this.getInternalEnergyStored(oldStack) > 0 != this.getInternalEnergyStored(newStack) > 0);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean func_77636_d(ItemStack stack) {
        super.func_77636_d(stack);
        return this.isOn(stack);
    }

    private class InvEnergyProvider
    implements ICapabilitySerializable<NBTBase> {
        private final IItemHandler inv;
        private final InvEnergyStorage energyStorage;

        InvEnergyProvider(ItemStack stack, IItemEnergy iItemEnergy) {
            this.energyStorage = new InvEnergyStorage(ItemInventoryGenerator.this.getMaxEnergyStored(stack), ItemInventoryGenerator.this.getReceive(), ItemInventoryGenerator.this.getSend(), stack, iItemEnergy);
            this.inv = new ItemStackHandler(4){

                @Nonnull
                public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                    Item item = stack.func_77973_b();
                    boolean isSpeedUpgrade = item.equals(InitModGenerators.speedUpgrade);
                    boolean isAutoPullUpgrade = item.equals(InitModGenerators.autoPullUpgrade);
                    boolean isNoEffectUpgrade = item.equals(InitModGenerators.noEffectUpgrade);
                    if (slot == 0 && !stack.func_190926_b() && ItemInventoryGenerator.this.isItemValid(stack)) {
                        return super.insertItem(slot, stack, simulate);
                    }
                    if (slot == 1 && !stack.func_190926_b() && isSpeedUpgrade) {
                        return super.insertItem(slot, stack, simulate);
                    }
                    if (slot == 2 && !stack.func_190926_b() && isAutoPullUpgrade) {
                        return super.insertItem(slot, stack, simulate);
                    }
                    if (slot == 3 && !stack.func_190926_b() && isNoEffectUpgrade) {
                        return super.insertItem(slot, stack, simulate);
                    }
                    return stack;
                }
            };
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || this.energyStorage.hasCapability(capability, facing);
        }

        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inv);
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)CapabilityEnergy.ENERGY.cast((Object)this.energyStorage);
            }
            return null;
        }

        public NBTBase serializeNBT() {
            NBTBase nbtBase = CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inv, null);
            NBTBase nbtBase1 = this.energyStorage.serializeNBT();
            NBTTagCompound nbtTagCompound = new NBTTagCompound();
            if (nbtBase1 != null) {
                nbtTagCompound.func_74782_a("EnergyStorage", nbtBase1);
            }
            if (nbtBase != null) {
                nbtTagCompound.func_74782_a("Inv", nbtBase);
            }
            return nbtTagCompound;
        }

        public void deserializeNBT(NBTBase nbt) {
            NBTTagCompound nbtTagCompound = (NBTTagCompound)nbt;
            if (nbtTagCompound.func_74764_b("EnergyStorage")) {
                NBTBase nbtBase1 = nbtTagCompound.func_74781_a("EnergyStorage");
                this.energyStorage.deserializeNBT(nbtBase1);
            }
            if (nbtTagCompound.func_74764_b("Inv")) {
                NBTBase nbtBase = nbtTagCompound.func_74781_a("Inv");
                CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inv, null, nbtBase);
            }
        }
    }
}

