/*
 * Decompiled with CFR 0.152.
 */
package QuantumStorage.tiles;

import QuantumStorage.QuantumStorage;
import QuantumStorage.client.AdvancedGui;
import QuantumStorage.client.GuiBuilderQuantumStorage;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import reborncore.common.network.VanillaPacketDispatcher;

public abstract class AdvancedTileEntity
extends TileEntity {
    private EnumFacing facing = EnumFacing.NORTH;
    public float prevLidAngle;
    public float lidAngle;
    public ItemStackHandler inv = null;
    @SideOnly(value=Side.CLIENT)
    private GuiBuilderQuantumStorage builder;
    public static final AxisAlignedBB FULL_BLOCK_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    protected AdvancedTileEntity() {
    }

    public EnumFacing getFacing() {
        return this.facing;
    }

    public void setFacing(EnumFacing facing) {
        this.facing = facing;
    }

    public void rotateAround() {
        this.setFacing(this.getFacing().func_176746_e());
        this.field_145850_b.func_175641_c(this.field_174879_c, this.getBlock(), 2, this.getFacing().ordinal());
    }

    public abstract String getName();

    public ItemStackHandler getInv() {
        return this.inv;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.inv != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.inv != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inv);
        }
        return (T)super.getCapability(capability, facing);
    }

    @SideOnly(value=Side.CLIENT)
    public GuiBuilderQuantumStorage getBuilder() {
        if (this.builder == null) {
            this.builder = new GuiBuilderQuantumStorage();
        }
        return this.builder;
    }

    public int getXSize() {
        return 176;
    }

    public int getYsize() {
        return 176;
    }

    @SideOnly(value=Side.CLIENT)
    public void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY, int guiLeft, int guiTop, int xSize, int ySize, AdvancedGui gui) {
        this.getBuilder().drawDefaultBackground((GuiScreen)gui, guiLeft, guiTop, xSize, ySize);
        this.getBuilder().drawPlayerSlots((GuiScreen)gui, guiLeft + xSize / 2, guiTop + 93, true);
        if (this.getSlots() != null) {
            for (Slot s : this.getSlots()) {
                this.getBuilder().drawSlot((GuiScreen)gui, guiLeft + s.field_75223_e - 1, guiTop + s.field_75221_f - 1);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void drawGuiContainerForegroundLayer(int mouseX, int mouseY, GuiContainer gui, int guiLeft, int guiTop) {
    }

    public abstract List<Slot> getSlots();

    public int inventoryOffsetX() {
        return 8;
    }

    public int inventoryOffsetY() {
        return 94;
    }

    public abstract TileEntity createNewTileEntity(World var1, int var2);

    public abstract boolean onBlockActivated(World var1, BlockPos var2, IBlockState var3, EntityPlayer var4, EnumHand var5, EnumFacing var6, float var7, float var8, float var9);

    public void openGui(EntityPlayer player, AdvancedTileEntity machine) {
        if (!player.func_70093_af()) {
            player.openGui((Object)QuantumStorage.INSTANCE, 0, machine.field_145850_b, machine.field_174879_c.func_177958_n(), machine.field_174879_c.func_177956_o(), machine.field_174879_c.func_177952_p());
        }
    }

    public EnumBlockRenderType getRenderType(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public AxisAlignedBB getBoundingBox(IBlockState state, IBlockAccess source, BlockPos pos) {
        return FULL_BLOCK_AABB;
    }

    public void onBlockClicked(World worldIn, BlockPos pos, EntityPlayer playerIn) {
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        compound = super.func_189515_b(compound);
        compound.func_74774_a("facing", (byte)this.getFacing().ordinal());
        return compound;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.facing = EnumFacing.field_82609_l[compound.func_74771_c("facing")];
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, this.func_189517_E_());
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        super.onDataPacket(net, packet);
        this.func_145839_a(packet.func_148857_g());
    }

    public void sync() {
        VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this);
    }

    public void writeToNBTWithoutCoords(NBTTagCompound tagCompound) {
        tagCompound = super.func_189515_b(tagCompound);
        if (this.getInv() != null) {
            tagCompound.func_179237_a(this.getInv().serializeNBT());
        }
    }

    public void readFromNBTWithoutCoords(NBTTagCompound compound) {
        this.getInv().deserializeNBT(compound);
    }

    public abstract Block getBlock();

    public ItemStack getDropWithNBT() {
        NBTTagCompound tileEntity = new NBTTagCompound();
        ItemStack dropStack = new ItemStack(this.getBlock(), 1);
        this.writeToNBTWithoutCoords(tileEntity);
        dropStack.func_77982_d(new NBTTagCompound());
        dropStack.func_77978_p().func_74782_a("tileEntity", (NBTBase)tileEntity);
        return dropStack;
    }

    public abstract void addRecipe();

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
    }

    public BlockRenderLayer getBlockLayer() {
        return BlockRenderLayer.SOLID;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }
}

