/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostsouls;

import java.util.function.Function;
import javax.annotation.Nullable;
import mcjty.lostcities.api.ILostCities;
import mcjty.lostsouls.commands.CommandDebug;
import mcjty.lostsouls.commands.CommandSetHaunt;
import mcjty.lostsouls.data.LostSoulData;
import mcjty.lostsouls.proxy.CommonProxy;
import net.minecraft.command.ICommand;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.event.FMLServerStoppedEvent;
import org.apache.logging.log4j.Logger;

@Mod(modid="lostsouls", name="Lost Souls", dependencies="required-after:lostcities@[2.0.3,);after:forge@[13.19.0.2176,)", version="1.1.4", acceptedMinecraftVersions="[1.12,1.13)", acceptableRemoteVersions="*")
public class LostSouls {
    public static final String MODID = "lostsouls";
    public static final String VERSION = "1.1.4";
    public static final String LOSTCITY_VERSION = "2.0.3";
    public static final String MIN_FORGE11_VER = "13.19.0.2176";
    @SidedProxy(clientSide="mcjty.lostsouls.proxy.ClientProxy", serverSide="mcjty.lostsouls.proxy.ServerProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="lostsouls")
    public static LostSouls instance;
    public static ILostCities lostCities;
    public static Logger logger;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent e) {
        logger = e.getModLog();
        proxy.preInit(e);
        FMLInterModComms.sendFunctionMessage((String)"lostcities", (String)"getLostCities", (String)"mcjty.lostsouls.LostSouls$GetLostCities");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent e) {
        proxy.init(e);
    }

    @Mod.EventHandler
    public void serverLoad(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandDebug());
        event.registerServerCommand((ICommand)new CommandSetHaunt());
    }

    @Mod.EventHandler
    public void serverStopped(FMLServerStoppedEvent event) {
        LostSoulData.clearInstance();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent e) {
        proxy.postInit(e);
    }

    public static class GetLostCities
    implements Function<ILostCities, Void> {
        @Override
        @Nullable
        public Void apply(ILostCities lc) {
            lostCities = lc;
            return null;
        }
    }
}

