/*
 * Decompiled with CFR 0.152.
 */
package nc.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import nc.util.BlockPosHelper;
import nc.util.ItemStackHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class BlockFinder {
    private final BlockPos pos;
    private final World world;
    private final int meta;
    private Random rand = new Random();

    public BlockFinder(BlockPos pos, World world) {
        this(pos, world, 4);
    }

    public BlockFinder(BlockPos pos, World world, int meta) {
        this.pos = pos;
        this.world = world;
        this.meta = meta;
    }

    public IBlockState getBlockState(BlockPos pos) {
        return this.world.func_180495_p(pos);
    }

    public IBlockState getBlockState(int x, int y, int z) {
        return this.getBlockState(this.position(x, y, z));
    }

    public BlockPos position(int x, int y, int z) {
        if (this.meta == 4) {
            return new BlockPos(this.pos.func_177958_n() + x, this.pos.func_177956_o() + y, this.pos.func_177952_p() + z);
        }
        if (this.meta == 2) {
            return new BlockPos(this.pos.func_177958_n() - z, this.pos.func_177956_o() + y, this.pos.func_177952_p() + x);
        }
        if (this.meta == 5) {
            return new BlockPos(this.pos.func_177958_n() - x, this.pos.func_177956_o() + y, this.pos.func_177952_p() - z);
        }
        if (this.meta == 3) {
            return new BlockPos(this.pos.func_177958_n() + z, this.pos.func_177956_o() + y, this.pos.func_177952_p() - x);
        }
        return new BlockPos(this.pos.func_177958_n() + x, this.pos.func_177956_o() + y, this.pos.func_177952_p() + z);
    }

    public boolean find(BlockPos pos, Object ... blocks) {
        for (int i = 0; i < blocks.length; ++i) {
            if (blocks[i] == null) continue;
            if (blocks[i] instanceof IBlockState && this.getBlockState(pos) == (IBlockState)blocks[i]) {
                return true;
            }
            boolean isSubClass = String.class.isAssignableFrom(blocks[i].getClass());
            if (blocks[i] instanceof String && this.findOre(pos, (String)blocks[i])) {
                return true;
            }
            isSubClass = Block.class.isAssignableFrom(blocks[i].getClass());
            if (!isSubClass || this.getBlockState(pos).func_177230_c() != (Block)blocks[i]) continue;
            return true;
        }
        return false;
    }

    public boolean find(int x, int y, int z, Object ... blocks) {
        return this.find(this.position(x, y, z), blocks);
    }

    public boolean findOre(BlockPos pos, String ... names) {
        ArrayList stackList = new ArrayList();
        for (int i = 0; i < names.length; ++i) {
            NonNullList stacks = OreDictionary.getOres((String)names[i]);
            stackList.addAll(stacks);
        }
        ItemStack stack = ItemStackHelper.blockStateToStack(this.getBlockState(pos));
        for (ItemStack oreStack : stackList) {
            if (!oreStack.func_77969_a(stack)) continue;
            return true;
        }
        return false;
    }

    public boolean findOre(int x, int y, int z, String ... names) {
        return this.findOre(this.position(x, y, z), names);
    }

    public int configurationCount(BlockPos[] posArray, Object ... blocks) {
        int count = 0;
        for (BlockPos pos : posArray) {
            if (!this.find(pos, blocks)) continue;
            ++count;
        }
        return count;
    }

    public boolean configuration(BlockPos[] posArray, Object ... blocks) {
        return this.configurationCount(posArray, blocks) >= posArray.length;
    }

    public int configurationCount(List<BlockPos[]> posArrays, Object ... blocks) {
        int count = 0;
        for (BlockPos[] horizontals : posArrays) {
            count = Math.max(count, this.configurationCount(horizontals, blocks));
        }
        return count;
    }

    public boolean adjacent(BlockPos pos, int dist, Object ... blocks) {
        BlockPosHelper posHelper = new BlockPosHelper(pos);
        for (BlockPos blockPos : posHelper.adjacents(dist)) {
            if (!this.find(blockPos, blocks)) continue;
            return true;
        }
        return false;
    }

    public boolean adjacent(int x, int y, int z, int dist, Object ... blocks) {
        return this.adjacent(this.position(x, y, z), dist, blocks);
    }

    public int adjacentCount(BlockPos pos, int dist, Object ... blocks) {
        int count = 0;
        BlockPosHelper posHelper = new BlockPosHelper(pos);
        for (BlockPos blockPos : posHelper.adjacents(dist)) {
            if (!this.find(blockPos, blocks)) continue;
            ++count;
        }
        return count;
    }

    public int adjacentCount(int x, int y, int z, int dist, Object ... blocks) {
        return this.adjacentCount(this.position(x, y, z), dist, blocks);
    }

    public boolean adjacentSurround(BlockPos pos, int dist, Object ... blocks) {
        return this.adjacentCount(pos, dist, blocks) >= 6;
    }

    public boolean adjacentSurround(int x, int y, int z, int dist, Object ... blocks) {
        return this.adjacentSurround(this.position(x, y, z), dist, blocks);
    }

    public boolean adjacentAnd(BlockPos pos, int dist, Object ... blocks) {
        for (Object block : blocks) {
            if (this.adjacent(pos, dist, block)) continue;
            return false;
        }
        return true;
    }

    public boolean adjacentAnd(int x, int y, int z, int dist, Object ... blocks) {
        return this.adjacentAnd(this.position(x, y, z), dist, blocks);
    }

    public int horizontalCount(BlockPos pos, int dist, Object ... blocks) {
        BlockPosHelper posHelper = new BlockPosHelper(pos);
        return this.configurationCount(posHelper.horizontalsList(dist), blocks);
    }

    public int horizontalCount(int x, int y, int z, int dist, Object ... blocks) {
        return this.horizontalCount(this.position(x, y, z), dist, blocks);
    }

    public boolean horizontal(BlockPos pos, int dist, Object ... blocks) {
        return this.horizontalCount(pos, dist, blocks) >= 4;
    }

    public boolean horizontal(int x, int y, int z, int dist, Object ... blocks) {
        return this.horizontal(this.position(x, y, z), dist, blocks);
    }

    public boolean horizontalAnd(BlockPos pos, int dist, Object ... blocks) {
        for (Object block : blocks) {
            if (this.horizontal(pos, dist, block)) continue;
            return false;
        }
        return true;
    }

    public boolean horizontalAnd(int x, int y, int z, int dist, Object ... blocks) {
        return this.horizontalAnd(this.position(x, y, z), dist, blocks);
    }

    public int horizontalYCount(BlockPos pos, int dist, Object ... blocks) {
        BlockPosHelper posHelper = new BlockPosHelper(pos);
        return this.configurationCount(posHelper.horizontalsY(dist), blocks);
    }

    public int horizontalYCount(int x, int y, int z, int dist, Object ... blocks) {
        return this.horizontalYCount(this.position(x, y, z), dist, blocks);
    }

    public boolean horizontalY(BlockPos pos, int dist, Object ... blocks) {
        return this.horizontalYCount(pos, dist, blocks) >= 4;
    }

    public boolean horizontalY(int x, int y, int z, int dist, Object ... blocks) {
        return this.horizontalY(this.position(x, y, z), dist, blocks);
    }

    public boolean horizontalYAnd(BlockPos pos, int dist, Object ... blocks) {
        for (Object block : blocks) {
            if (this.horizontalY(pos, dist, block)) continue;
            return false;
        }
        return true;
    }

    public boolean horizontalYAnd(int x, int y, int z, int dist, Object ... blocks) {
        return this.horizontalYAnd(this.position(x, y, z), dist, blocks);
    }

    public int axialCount(BlockPos pos, int dist, Object ... blocks) {
        BlockPosHelper posHelper = new BlockPosHelper(pos);
        return this.configurationCount(posHelper.axialsList(dist), blocks);
    }

    public int axialCount(int x, int y, int z, int dist, Object ... blocks) {
        return this.axialCount(this.position(x, y, z), dist, blocks);
    }

    public boolean axial(BlockPos pos, int dist, Object ... blocks) {
        return this.axialCount(pos, dist, blocks) >= 2;
    }

    public boolean axial(int x, int y, int z, int dist, Object ... blocks) {
        return this.axial(this.position(x, y, z), dist, blocks);
    }

    public boolean axialAnd(BlockPos pos, int dist, Object ... blocks) {
        for (Object block : blocks) {
            if (this.axial(pos, dist, block)) continue;
            return false;
        }
        return true;
    }

    public boolean axialAnd(int x, int y, int z, int dist, Object ... blocks) {
        return this.axialAnd(this.position(x, y, z), dist, blocks);
    }

    public int vertexCount(BlockPos pos, Object ... blocks) {
        BlockPosHelper posHelper = new BlockPosHelper(pos);
        return this.configurationCount(posHelper.vertexList(), blocks);
    }

    public int vertexCount(int x, int y, int z, Object ... blocks) {
        return this.vertexCount(this.position(x, y, z), blocks);
    }

    public boolean vertex(BlockPos pos, Object ... blocks) {
        return this.vertexCount(pos, blocks) >= 3;
    }

    public boolean vertex(int x, int y, int z, Object ... blocks) {
        return this.vertex(this.position(x, y, z), blocks);
    }

    public boolean vertexAnd(BlockPos pos, Object ... blocks) {
        for (Object block : blocks) {
            if (this.vertex(pos, block)) continue;
            return false;
        }
        return true;
    }

    public boolean vertexAnd(int x, int y, int z, Object ... blocks) {
        return this.vertexAnd(this.position(x, y, z), blocks);
    }

    public BlockPos getCentre(int xMin, int xMax, int yMin, int yMax, int zMin, int zMax) {
        return this.position((xMin + xMax) / 2, (yMin + yMax) / 2, (zMin + zMin) / 2);
    }

    public int randomBetween(int min, int max) {
        return min + this.rand.nextInt(max + 1);
    }

    public BlockPos randomWithin(int xMin, int xMax, int yMin, int yMax, int zMin, int zMax) {
        return this.position(this.randomBetween(xMin, xMax), this.randomBetween(yMin, yMax), this.randomBetween(zMin, zMax));
    }
}

