/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.colossalchests.client.render.tileentity;

import com.google.common.collect.Maps;
import java.util.Calendar;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelChest;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import org.cyclops.colossalchests.ColossalChests;
import org.cyclops.colossalchests.GeneralConfig;
import org.cyclops.colossalchests.block.ColossalChestConfig;
import org.cyclops.colossalchests.block.PropertyMaterial;
import org.cyclops.colossalchests.tileentity.TileColossalChest;
import org.cyclops.cyclopscore.client.render.tileentity.RenderTileEntityModel;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.tileentity.CyclopsTileEntity;

public class RenderTileEntityColossalChest
extends RenderTileEntityModel<TileColossalChest, ModelChest> {
    public static final Map<PropertyMaterial.Type, ResourceLocation> TEXTURES_CHEST = Maps.newHashMap();
    public static final Map<PropertyMaterial.Type, ResourceLocation> TEXTURES_INTERFACE = Maps.newHashMap();

    public RenderTileEntityColossalChest(ModelChest model) {
        super((Object)model, null);
    }

    protected void preRotate(TileColossalChest chestTile) {
        if (chestTile.isStructureComplete()) {
            Vec3d renderOffset = chestTile.getRenderOffset();
            GlStateManager.func_179137_b((double)(-renderOffset.field_72450_a), (double)renderOffset.field_72448_b, (double)renderOffset.field_72449_c);
        }
        GlStateManager.func_179109_b((float)0.5f, (float)(0.5f - (float)chestTile.getSizeSingular() * 0.0625f), (float)0.5f);
        float size = (float)chestTile.getSizeSingular() * 1.125f;
        GlStateManager.func_179152_a((float)size, (float)size, (float)size);
    }

    protected void postRotate(TileColossalChest tile) {
        GlStateManager.func_179109_b((float)-0.5f, (float)0.0f, (float)-0.5f);
    }

    protected void renderModel(TileColossalChest chestTile, ModelChest model, float partialTick, int destroyStage) {
        if (chestTile.isStructureComplete()) {
            this.func_147499_a(TEXTURES_CHEST.get((Object)chestTile.getMaterial()));
            GlStateManager.func_179094_E();
            if (ColossalChestConfig.chestAnimation) {
                float lidangle = chestTile.prevLidAngle + (chestTile.lidAngle - chestTile.prevLidAngle) * partialTick;
                lidangle = 1.0f - lidangle;
                lidangle = 1.0f - lidangle * lidangle * lidangle;
                model.field_78234_a.field_78795_f = -(lidangle * (float)Math.PI / 2.0f);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)-0.5f, (float)0.0f);
            model.func_78231_a();
            GlStateManager.func_179121_F();
        }
    }

    public void render(TileColossalChest tile, double x, double y, double z, float partialTick, int destroyStage, float alpha) {
        super.render((CyclopsTileEntity)tile, x, y, z, partialTick, destroyStage, alpha);
        if (tile.isStructureComplete() && tile.lidAngle == 0.0f && (GeneralConfig.alwaysShowInterfaceOverlay || Minecraft.func_71410_x().field_71439_g.func_70093_af())) {
            GlStateManager.func_179091_B();
            GlStateManager.func_179092_a((int)516, (float)0.1f);
            GlStateManager.func_179147_l();
            GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
            GlStateManager.func_179094_E();
            GlStateManager.func_179123_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179091_B();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)((float)x), (float)((float)y), (float)((float)z));
            this.func_147499_a(TEXTURES_INTERFACE.get((Object)tile.getMaterial()));
            for (Vec3i interfaceLocation : tile.getInterfaceLocations()) {
                float translateX = interfaceLocation.func_177958_n() - tile.func_174877_v().func_177958_n();
                float translateY = interfaceLocation.func_177956_o() - tile.func_174877_v().func_177956_o();
                float translateZ = interfaceLocation.func_177952_p() - tile.func_174877_v().func_177952_p();
                GlStateManager.func_179109_b((float)translateX, (float)translateY, (float)translateZ);
                this.renderInterface(interfaceLocation.equals((Object)tile.func_174877_v()));
                GlStateManager.func_179109_b((float)(-translateX), (float)(-translateY), (float)(-translateZ));
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179099_b();
            GlStateManager.func_179121_F();
            GlStateManager.func_179101_C();
            GlStateManager.func_179084_k();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public boolean isGlobalRenderer(TileColossalChest tile) {
        return true;
    }

    protected void setMatrixOrientation(EnumFacing direction) {
        float translateX = -1.0f - (float)direction.func_82601_c();
        float translateY = direction.func_96559_d();
        float translateZ = direction.func_82599_e();
        if (direction == EnumFacing.NORTH) {
            translateZ += 1.0f;
            translateX += 2.0f;
            translateY -= 1.0f;
        } else if (direction == EnumFacing.EAST) {
            translateX += 3.0f;
            translateY -= 1.0f;
            translateZ += 1.0f;
        } else if (direction == EnumFacing.WEST) {
            translateY -= 1.0f;
        } else if (direction == EnumFacing.SOUTH) {
            translateX += 1.0f;
            translateY -= 1.0f;
        } else if (direction == EnumFacing.UP) {
            translateX += 1.0f;
            translateZ += 1.0f;
        } else if (direction == EnumFacing.DOWN) {
            translateX += 1.0f;
        }
        GlStateManager.func_179109_b((float)(translateX * 16.0f), (float)(translateY * 16.0f), (float)(translateZ * 16.0f));
        int rotationY = 0;
        int rotationX = 0;
        if (direction == EnumFacing.SOUTH) {
            rotationY = 0;
        } else if (direction == EnumFacing.NORTH) {
            rotationY = 180;
        } else if (direction == EnumFacing.EAST) {
            rotationY = 90;
        } else if (direction == EnumFacing.WEST) {
            rotationY = -90;
        } else if (direction == EnumFacing.UP) {
            rotationX = -90;
        } else if (direction == EnumFacing.DOWN) {
            rotationX = 90;
        }
        GlStateManager.func_179114_b((float)rotationY, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)rotationX, (float)1.0f, (float)0.0f, (float)0.0f);
    }

    protected void renderInterface(boolean core) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            GlStateManager.func_179094_E();
            float scale = 0.063f;
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)1.0f);
            this.setMatrixOrientation(side);
            BufferBuilder worldRenderer = Tessellator.func_178181_a().func_178180_c();
            worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181709_i);
            float indent = -0.2f;
            if (side == EnumFacing.UP) {
                indent = -15.8f;
            }
            if (side == EnumFacing.DOWN) {
                indent *= 2.0f;
            }
            int alpha = core ? 255 : 150;
            float posMin = core ? 5.0f : 6.0f;
            float posMax = 16.0f - posMin;
            float texMin = 0.0625f * posMin;
            float texMax = 1.0f - texMin;
            worldRenderer.func_181662_b((double)posMax, (double)posMax, (double)indent).func_187315_a((double)texMax, (double)texMax).func_181669_b(255, 255, 255, alpha).func_181675_d();
            worldRenderer.func_181662_b((double)posMax, (double)posMin, (double)indent).func_187315_a((double)texMax, (double)texMin).func_181669_b(255, 255, 255, alpha).func_181675_d();
            worldRenderer.func_181662_b((double)posMin, (double)posMin, (double)indent).func_187315_a((double)texMin, (double)texMin).func_181669_b(255, 255, 255, alpha).func_181675_d();
            worldRenderer.func_181662_b((double)posMin, (double)posMax, (double)indent).func_187315_a((double)texMin, (double)texMax).func_181669_b(255, 255, 255, alpha).func_181675_d();
            Tessellator.func_178181_a().func_78381_a();
            GlStateManager.func_179121_F();
        }
    }

    static {
        Calendar calendar = Calendar.getInstance();
        boolean christmas = calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
        TEXTURES_CHEST.put(PropertyMaterial.Type.WOOD, new ResourceLocation("textures/entity/chest/" + (christmas ? "christmas" : "normal") + ".png"));
        TEXTURES_CHEST.put(PropertyMaterial.Type.COPPER, new ResourceLocation("colossalchests", (String)ColossalChests._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_MODELS) + "chest_copper.png"));
        TEXTURES_CHEST.put(PropertyMaterial.Type.IRON, new ResourceLocation("colossalchests", (String)ColossalChests._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_MODELS) + "chest_iron.png"));
        TEXTURES_CHEST.put(PropertyMaterial.Type.SILVER, new ResourceLocation("colossalchests", (String)ColossalChests._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_MODELS) + "chest_silver.png"));
        TEXTURES_CHEST.put(PropertyMaterial.Type.GOLD, new ResourceLocation("colossalchests", (String)ColossalChests._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_MODELS) + "chest_gold.png"));
        TEXTURES_CHEST.put(PropertyMaterial.Type.DIAMOND, new ResourceLocation("colossalchests", (String)ColossalChests._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_MODELS) + "chest_diamond.png"));
        TEXTURES_CHEST.put(PropertyMaterial.Type.OBSIDIAN, new ResourceLocation("colossalchests", (String)ColossalChests._instance.getReferenceValue(ModBase.REFKEY_TEXTURE_PATH_MODELS) + "chest_obsidian.png"));
        TEXTURES_INTERFACE.put(PropertyMaterial.Type.WOOD, new ResourceLocation("colossalchests", "textures/blocks/interface_wood.png"));
        TEXTURES_INTERFACE.put(PropertyMaterial.Type.COPPER, new ResourceLocation("colossalchests", "textures/blocks/interface_copper.png"));
        TEXTURES_INTERFACE.put(PropertyMaterial.Type.IRON, new ResourceLocation("colossalchests", "textures/blocks/interface_iron.png"));
        TEXTURES_INTERFACE.put(PropertyMaterial.Type.SILVER, new ResourceLocation("colossalchests", "textures/blocks/interface_silver.png"));
        TEXTURES_INTERFACE.put(PropertyMaterial.Type.GOLD, new ResourceLocation("colossalchests", "textures/blocks/interface_gold.png"));
        TEXTURES_INTERFACE.put(PropertyMaterial.Type.DIAMOND, new ResourceLocation("colossalchests", "textures/blocks/interface_diamond.png"));
        TEXTURES_INTERFACE.put(PropertyMaterial.Type.OBSIDIAN, new ResourceLocation("colossalchests", "textures/blocks/interface_obsidian.png"));
    }
}

