/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.network.packets.gsi;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import sonar.core.SonarCore;
import sonar.logistics.base.ServerInfoHandler;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.gsi.packets.GSIClickPacketHelper;

public class PacketGSIClick
implements IMessage {
    public NBTTagCompound clickTag;
    public DisplayScreenClick click;
    public int elementIdentity;

    public PacketGSIClick() {
    }

    public PacketGSIClick(int elementIdentity, DisplayScreenClick click, NBTTagCompound clickTag) {
        this.elementIdentity = elementIdentity;
        this.click = click;
        this.clickTag = clickTag;
    }

    public void fromBytes(ByteBuf buf) {
        this.elementIdentity = buf.readInt();
        this.clickTag = ByteBufUtils.readTag((ByteBuf)buf);
        this.click = DisplayScreenClick.readClick(this.clickTag);
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.elementIdentity);
        DisplayScreenClick.writeClick(this.click, this.clickTag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.clickTag);
    }

    public static class Handler
    implements IMessageHandler<PacketGSIClick, IMessage> {
        public IMessage onMessage(PacketGSIClick message, MessageContext ctx) {
            if (ctx.side == Side.SERVER) {
                SonarCore.proxy.getThreadListener(ctx.side).func_152344_a(() -> {
                    EntityPlayer player = SonarCore.proxy.getPlayerEntity(ctx);
                    DisplayGSI gsi = ServerInfoHandler.instance().getGSIMap().get(message.click.identity);
                    if (gsi != null) {
                        message.click.gsi = gsi;
                        GSIClickPacketHelper.handler.runGSIClickPacket(gsi, message.click, player, message.clickTag);
                    }
                });
            }
            return null;
        }
    }
}

