/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.gsi.storage;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.SyncableList;
import sonar.logistics.PL2ASMLoader;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.base.guidance.errors.IInfoError;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayElementContainer;

public class DisplayGSISaveHandler {
    public static void readGSIData(DisplayGSI gsi, NBTTagCompound nbt, NBTHelper.SyncType type, DisplayGSISavedData data) {
        data.readHandler.readData(gsi, nbt, type);
    }

    public static NBTTagCompound writeGSIData(DisplayGSI gsi, NBTTagCompound nbt, NBTHelper.SyncType type, DisplayGSISavedData data) {
        return data.writeHandler.writeData(gsi, nbt, type);
    }

    public static void readGSIData(DisplayGSI gsi, NBTTagCompound nbt, NBTHelper.SyncType type, Collection<DisplayGSISavedData> data) {
        for (DisplayGSISavedData save : DisplayGSISavedData.values()) {
            if (!data.contains((Object)save)) continue;
            save.readHandler.readData(gsi, nbt, type);
        }
    }

    public static NBTTagCompound writeGSIData(DisplayGSI gsi, NBTTagCompound nbt, NBTHelper.SyncType type, Collection<DisplayGSISavedData> data) {
        for (DisplayGSISavedData save : DisplayGSISavedData.values()) {
            if (!data.contains((Object)save)) continue;
            save.writeHandler.writeData(gsi, nbt, type);
        }
        return nbt;
    }

    private static void readAllGSIData(DisplayGSI gsi, NBTTagCompound nbt, NBTHelper.SyncType type) {
        for (DisplayGSISavedData save : DisplayGSISavedData.values()) {
            if (save == DisplayGSISavedData.ALL_DATA) continue;
            save.readHandler.readData(gsi, nbt, type);
        }
    }

    private static NBTTagCompound writeAllGSIData(DisplayGSI gsi, NBTTagCompound nbt, NBTHelper.SyncType type) {
        for (DisplayGSISavedData save : DisplayGSISavedData.values()) {
            if (save == DisplayGSISavedData.ALL_DATA) continue;
            save.writeHandler.writeData(gsi, nbt, type);
        }
        return nbt;
    }

    private static void readInfoReferences(DisplayGSI gsi, NBTTagCompound nbt, NBTHelper.SyncType type) {
        gsi.references = InfoUUID.readInfoList(nbt, "refs");
        gsi.cleanSavedErrors();
    }

    private static NBTTagCompound writeInfoReferences(DisplayGSI gsi, NBTTagCompound nbt, NBTHelper.SyncType type) {
        nbt = InfoUUID.writeInfoList(nbt, gsi.references, "refs");
        return nbt;
    }

    private static void readErrors(DisplayGSI gsi, NBTTagCompound nbt, NBTHelper.SyncType type) {
        gsi.errors = PL2ASMLoader.readListFromNBT(IInfoError.class, nbt);
        if (gsi.getWorld().field_72995_K) {
            gsi.updateErroredElements();
        }
    }

    private static NBTTagCompound writeErrors(DisplayGSI gsi, NBTTagCompound nbt, NBTHelper.SyncType type) {
        PL2ASMLoader.writeListToNBT(IInfoError.class, gsi.errors, nbt);
        return nbt;
    }

    private static void readContainers(DisplayGSI gsi, NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (!type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE})) {
            return;
        }
        ArrayList<Integer> loaded = new ArrayList<Integer>();
        NBTTagList tagList = nbt.func_150295_c("containers", 10);
        tagList.forEach(tag -> {
            DisplayElementContainer c = DisplayGSISaveHandler.loadContainer(gsi, (NBTTagCompound)tag, type);
            if (c.getElements().getElementCount() != 0) {
                loaded.add(c.getContainerIdentity());
            }
        });
        loaded.add(0);
        ArrayList toDelete = new ArrayList();
        gsi.forEachContainer(c -> {
            if (!loaded.contains(c.getContainerIdentity())) {
                toDelete.add(c.getContainerIdentity());
            }
        });
        toDelete.forEach(del -> {
            gsi.invalidateContainer(gsi.containers.get(del));
            gsi.containers.remove(del);
        });
    }

    private static NBTTagCompound writeContainers(DisplayGSI gsi, NBTTagCompound nbt, NBTHelper.SyncType type) {
        if (!type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE})) {
            return nbt;
        }
        NBTTagList tagList = new NBTTagList();
        gsi.forEachContainer(c -> {
            NBTTagCompound tag = DisplayGSISaveHandler.saveContainer(gsi, c, type);
            if (!tag.func_82582_d()) {
                tagList.func_74742_a((NBTBase)tag);
            }
        });
        nbt.func_74782_a("containers", (NBTBase)tagList);
        return nbt;
    }

    public static NBTTagCompound saveContainer(DisplayGSI gsi, DisplayElementContainer c, NBTHelper.SyncType type) {
        if (gsi.isEditContainer(c) && !((Boolean)gsi.edit_mode.getObject()).booleanValue()) {
            return new NBTTagCompound();
        }
        if (c.getElements().getElementCount() == 0) {
            gsi.invalidateContainer(c);
            return new NBTTagCompound();
        }
        return c.writeData(new NBTTagCompound(), type);
    }

    public static DisplayElementContainer loadContainer(DisplayGSI gsi, NBTTagCompound nbt, NBTHelper.SyncType type) {
        int identity = nbt.func_74762_e("iden");
        DisplayElementContainer container = gsi.containers.get(identity);
        if (container == null) {
            container = new DisplayElementContainer();
            container.gsi = gsi;
            container.readData(nbt, type);
            if (container.getElements().getElementCount() != 0) {
                gsi.containers.put(identity, container);
                gsi.validateContainer(container);
            }
        } else {
            ArrayList elements = new ArrayList();
            container.getElements().forEach(e -> elements.add(e.getElementIdentity()));
            container.readData(nbt, type);
            ArrayList loaded = new ArrayList();
            container.getElements().forEach(e -> loaded.add(e.getElementIdentity()));
            elements.removeAll(loaded);
            for (Integer del : elements) {
                gsi.invalidateElement(container.getElements().getElementFromIdentity(del));
            }
        }
        return container;
    }

    private static void readSyncParts(DisplayGSI gsi, NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound tag = nbt.func_74775_l(gsi.getTagName());
        if (!tag.func_82582_d()) {
            NBTHelper.readSyncParts((NBTTagCompound)tag, (NBTHelper.SyncType)type, (SyncableList)gsi.syncParts);
        }
    }

    private static NBTTagCompound writeSyncParts(DisplayGSI gsi, NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTTagCompound tag = NBTHelper.writeSyncParts((NBTTagCompound)new NBTTagCompound(), (NBTHelper.SyncType)type, (SyncableList)gsi.syncParts, (boolean)type.mustSync());
        if (!tag.func_82582_d()) {
            nbt.func_74782_a(gsi.getTagName(), (NBTBase)tag);
        }
        return nbt;
    }

    public static interface IGSIDataWriteHandler {
        public NBTTagCompound writeData(DisplayGSI var1, NBTTagCompound var2, NBTHelper.SyncType var3);
    }

    public static interface IGSIDataReadHandler {
        public void readData(DisplayGSI var1, NBTTagCompound var2, NBTHelper.SyncType var3);
    }

    public static enum DisplayGSISavedData {
        ALL_DATA((x$0, x$1, x$2) -> DisplayGSISaveHandler.access$900(x$0, x$1, x$2), (x$0, x$1, x$2) -> DisplayGSISaveHandler.access$800(x$0, x$1, x$2)),
        SYNC_PARTS((x$0, x$1, x$2) -> DisplayGSISaveHandler.access$700(x$0, x$1, x$2), (x$0, x$1, x$2) -> DisplayGSISaveHandler.access$600(x$0, x$1, x$2)),
        INFO_REFERENCES((x$0, x$1, x$2) -> DisplayGSISaveHandler.access$500(x$0, x$1, x$2), (x$0, x$1, x$2) -> DisplayGSISaveHandler.access$400(x$0, x$1, x$2)),
        ERRORS((x$0, x$1, x$2) -> DisplayGSISaveHandler.access$300(x$0, x$1, x$2), (x$0, x$1, x$2) -> DisplayGSISaveHandler.access$200(x$0, x$1, x$2)),
        CONTAINERS((x$0, x$1, x$2) -> DisplayGSISaveHandler.access$100(x$0, x$1, x$2), (x$0, x$1, x$2) -> DisplayGSISaveHandler.access$000(x$0, x$1, x$2));

        IGSIDataReadHandler readHandler;
        IGSIDataWriteHandler writeHandler;

        private DisplayGSISavedData(IGSIDataReadHandler readHandler, IGSIDataWriteHandler writeHandler) {
            this.readHandler = readHandler;
            this.writeHandler = writeHandler;
        }
    }
}

