/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.filters;

import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;
import sonar.core.api.IFlexibleGui;
import sonar.core.api.fluids.StoredFluidStack;
import sonar.core.api.inventories.StoredItemStack;
import sonar.core.client.gui.GuiHelpOverlay;
import sonar.core.client.gui.GuiSonar;
import sonar.core.client.gui.SonarButtons;
import sonar.core.helpers.FontHelper;
import sonar.core.helpers.RenderHelper;
import sonar.core.network.FlexibleGuiHandler;
import sonar.logistics.PL2;
import sonar.logistics.PL2Translate;
import sonar.logistics.api.core.tiles.nodes.NodeTransferMode;
import sonar.logistics.api.core.tiles.nodes.TransferType;
import sonar.logistics.base.filters.ContainerFilterList;
import sonar.logistics.base.filters.EnumFilterListType;
import sonar.logistics.base.filters.IFilteredTile;
import sonar.logistics.base.filters.INodeFilter;
import sonar.logistics.base.filters.ITransferFilteredTile;
import sonar.logistics.base.filters.types.BaseFilter;
import sonar.logistics.base.filters.types.FluidFilter;
import sonar.logistics.base.filters.types.ItemFilter;
import sonar.logistics.base.filters.types.OreDictFilter;
import sonar.logistics.base.gui.GuiSelectionList;
import sonar.logistics.base.gui.PL2Colours;
import sonar.logistics.base.gui.buttons.LogisticsButton;
import sonar.logistics.base.utils.ListPacket;
import sonar.logistics.network.packets.PacketNodeFilter;

public class GuiFilterList
extends GuiSelectionList {
    public boolean isTransferTile = false;
    public ITransferFilteredTile transferTile;
    public IFilteredTile tile;
    public int channelID;
    public GuiState state = GuiState.LIST;
    public int coolDown = 0;
    public INodeFilter lastFilter;
    public INodeFilter currentFilter;
    public EntityPlayer player;
    public GuiTextField oreDictField;
    public static final ResourceLocation filterButtons = new ResourceLocation("practicallogistics2:textures/gui/filter_buttons.png");

    public GuiFilterList(EntityPlayer player, IFilteredTile tile, int channelID) {
        super((Container)new ContainerFilterList(player, tile), tile);
        this.tile = tile;
        this.isTransferTile = tile instanceof ITransferFilteredTile;
        if (this.isTransferTile) {
            this.transferTile = (ITransferFilteredTile)tile;
        }
        this.player = player;
        this.channelID = channelID;
        this.listHeight = 32;
        this.field_146999_f = 248;
        this.field_147000_g = this.state.ySize;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        switch (this.state) {
            case FLUID_FILTER: {
                this.field_146292_n.add(new GuiButton(-1, this.field_147003_i + 6, this.field_147009_r + 6, 60, 20, this.currentFilter.getTransferMode().name()));
                this.field_146292_n.add(new FluidFilterButton(this, 0, this.field_147003_i + 70, this.field_147009_r + 8));
                break;
            }
            case ITEM_FILTER: {
                this.field_146292_n.add(new GuiButton(-1, this.field_147003_i + 6, this.field_147009_r + 6, 60, 20, this.currentFilter.getTransferMode().name()));
                for (int i = 0; i < 5; ++i) {
                    this.field_146292_n.add(new ItemFilterButton(this, i, this.field_147003_i + 70 + i * 20, this.field_147009_r + 8));
                }
                break;
            }
            case LIST: {
                int start = 7;
                int gap = 18;
                this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 0, this.field_147003_i + start + gap, this.field_147009_r + 6, 32, 48, PL2Translate.FILTERS_ITEM_FILTER.t(), "button.ItemFilter"));
                this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 1, this.field_147003_i + start + gap * 2, this.field_147009_r + 6, 32, 80, PL2Translate.FILTERS_ORE_FILTER.t(), "button.OreFilter"));
                this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 2, this.field_147003_i + start + gap * 3, this.field_147009_r + 6, 32, 64, PL2Translate.FILTERS_FLUID_FILTER.t(), "button.FluidFilter"));
                this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 3, this.field_147003_i + start + gap * 4, this.field_147009_r + 6, 32, 0, PL2Translate.BUTTON_MOVE_UP.t(), "button.MoveUpFilter"));
                this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 4, this.field_147003_i + start + gap * 5, this.field_147009_r + 6, 32, 16, PL2Translate.BUTTON_MOVE_DOWN.t(), "button.MoveDownFilter"));
                this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 5, this.field_147003_i + start + gap * 6, this.field_147009_r + 6, 32, 32, PL2Translate.BUTTON_DELETE.t(), "button.DeleteFilter"));
                this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 6, this.field_147003_i + start + gap * 7, this.field_147009_r + 6, 32, 96, PL2Translate.BUTTON_CLEAR_ALL.t(), "button.ClearAllFilter"));
                this.field_146292_n.add(new LogisticsButton.CHANNELS((GuiSonar)this, 7, this.field_147003_i + start + gap * 8, this.field_147009_r + 6));
                if (!this.isTransferTile) break;
                this.field_146292_n.add(new LogisticsButton((GuiSonar)this, -1, this.field_147003_i + start, this.field_147009_r + 6, 80, 16 * this.transferTile.getTransferMode().ordinal(), "Transfer Mode: " + (Object)((Object)this.transferTile.getTransferMode()), "button.TransferMode"));
                boolean itemTransfer = this.transferTile.isTransferEnabled(TransferType.ITEMS);
                this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 8, this.field_147003_i + start + gap * 9, this.field_147009_r + 6, itemTransfer ? 16 : 0, 80, "Item Transfer: " + itemTransfer, "button.ItemTransfer"));
                boolean fluidTransfer = this.transferTile.isTransferEnabled(TransferType.FLUID);
                this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 9, this.field_147003_i + start + gap * 10, this.field_147009_r + 6, fluidTransfer ? 16 : 0, 96, "Fluid Transfer: " + fluidTransfer, "button.FluidTransfer"));
                boolean energyTransfer = this.transferTile.isTransferEnabled(TransferType.ENERGY);
                this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 10, this.field_147003_i + start + gap * 11, this.field_147009_r + 6, energyTransfer ? 16 : 0, 112, "Energy Transfer: " + energyTransfer, "button.EnergyTransfer"));
                this.field_146292_n.add(new LogisticsButton((GuiSonar)this, 11, this.field_147003_i + start + gap * 12, this.field_147009_r + 6, 32, 192 + (GuiHelpOverlay.enableHelp ? 16 : 0), "Help Enabled: " + GuiHelpOverlay.enableHelp, "button.HelpButton"));
                break;
            }
            case ORE_FILTER: {
                this.field_146292_n.add(new GuiButton(-1, this.field_147003_i + 6, this.field_147009_r + 6, 60, 20, this.currentFilter.getTransferMode().name()));
                this.field_146292_n.add(new FluidFilterButton(this, 0, this.field_147003_i + 70, this.field_147009_r + 8));
                this.field_146292_n.add(new GuiButton(1, this.field_147003_i + 184, this.field_147009_r + 6, 20, 20, "+"));
                Keyboard.enableRepeatEvents((boolean)true);
                this.oreDictField = new GuiTextField(0, this.field_146289_q, 90, 8, 90, 16);
                this.oreDictField.func_146203_f(20);
                this.oreDictField.func_146180_a("");
                break;
            }
        }
    }

    protected void func_146285_a(ItemStack stack, int x, int y) {
        List list = stack.func_82840_a((EntityPlayer)this.field_146297_k.field_71439_g, (ITooltipFlag)(this.field_146297_k.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
        ArrayList<String> newList = new ArrayList<String>();
        boolean matches = this.tile.getFilter().test(stack);
        for (int i = 0; i < list.size(); ++i) {
            if (i == 0) {
                newList.add(stack.func_77953_t().field_77937_e + (String)list.get(i));
                newList.add(TextFormatting.GRAY + "Matches Filter: " + (matches ? TextFormatting.GREEN + "TRUE" : TextFormatting.RED + "FALSE"));
                continue;
            }
            newList.add(TextFormatting.GRAY + (String)list.get(i));
        }
        FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
        GuiUtils.preItemToolTip((ItemStack)stack);
        this.drawHoveringText(newList, x, y, font == null ? this.field_146289_q : font);
        GuiUtils.postItemToolTip();
    }

    @Override
    public void func_73863_a(int x, int y, float var) {
        super.func_73863_a(x, y, var);
        if (this.coolDown != 0) {
            --this.coolDown;
        }
    }

    @Override
    public int ySize() {
        return 256;
    }

    @Override
    public void func_146284_a(GuiButton button) {
        super.func_146284_a(button);
        switch (this.state) {
            case FLUID_FILTER: {
                FluidFilter fluidFilter = (FluidFilter)this.currentFilter;
                switch (button.field_146127_k) {
                    case -1: {
                        fluidFilter.transferMode.incrementEnum();
                        this.reset();
                    }
                }
                break;
            }
            case ITEM_FILTER: {
                ItemFilter filter = (ItemFilter)this.currentFilter;
                switch (button.field_146127_k) {
                    case -1: {
                        filter.transferMode.incrementEnum();
                        this.reset();
                        break;
                    }
                    case 0: {
                        filter.matchNBT.invert();
                        this.reset();
                        break;
                    }
                    case 1: {
                        filter.matchOreDict.invert();
                        this.reset();
                        break;
                    }
                    case 2: {
                        filter.ignoreDamage.invert();
                        this.reset();
                        break;
                    }
                    case 3: {
                        filter.matchModid.invert();
                        this.reset();
                        break;
                    }
                    case 4: {
                        filter.listType.incrementEnum();
                        this.reset();
                    }
                }
                break;
            }
            case LIST: {
                NodeTransferMode mode;
                if (button instanceof GuiSelectionList.SelectionButton) {
                    return;
                }
                NodeTransferMode nodeTransferMode = mode = this.isTransferTile ? this.transferTile.getTransferMode() : NodeTransferMode.ADD_REMOVE;
                if (this.isTransferTile) {
                    switch (button.field_146127_k) {
                        case -1: {
                            this.transferTile.incrementTransferMode();
                            this.reset();
                            break;
                        }
                        case 8: {
                            this.transferTile.setTransferType(TransferType.ITEMS, !this.transferTile.isTransferEnabled(TransferType.ITEMS));
                            this.reset();
                            break;
                        }
                        case 9: {
                            this.transferTile.setTransferType(TransferType.FLUID, !this.transferTile.isTransferEnabled(TransferType.FLUID));
                            this.reset();
                            break;
                        }
                        case 10: {
                            this.transferTile.setTransferType(TransferType.ENERGY, !this.transferTile.isTransferEnabled(TransferType.ENERGY));
                            this.reset();
                        }
                    }
                }
                switch (button.field_146127_k) {
                    case 0: {
                        ItemFilter filter = new ItemFilter();
                        filter.transferMode.setObject((Enum)mode);
                        this.lastFilter = filter;
                        this.currentFilter = filter;
                        this.changeState(GuiState.ITEM_FILTER);
                        break;
                    }
                    case 1: {
                        OreDictFilter orefilter = new OreDictFilter();
                        orefilter.transferMode.setObject((Enum)mode);
                        this.lastFilter = orefilter;
                        this.currentFilter = orefilter;
                        this.changeState(GuiState.ORE_FILTER);
                        break;
                    }
                    case 2: {
                        FluidFilter fluidFilter = new FluidFilter();
                        fluidFilter.transferMode.setObject((Enum)mode);
                        this.lastFilter = fluidFilter;
                        this.currentFilter = fluidFilter;
                        this.changeState(GuiState.FLUID_FILTER);
                        break;
                    }
                    case 3: {
                        if (this.currentFilter == null) break;
                        PL2.network.sendToServer((IMessage)new PacketNodeFilter(this.tile.getSlotID(), this.tile.getCoords().getBlockPos(), ListPacket.MOVE_UP, this.currentFilter));
                        break;
                    }
                    case 4: {
                        if (this.currentFilter == null) break;
                        PL2.network.sendToServer((IMessage)new PacketNodeFilter(this.tile.getSlotID(), this.tile.getCoords().getBlockPos(), ListPacket.MOVE_DOWN, this.currentFilter));
                        break;
                    }
                    case 5: {
                        if (this.currentFilter == null) break;
                        PL2.network.sendToServer((IMessage)new PacketNodeFilter(this.tile.getSlotID(), this.tile.getCoords().getBlockPos(), ListPacket.REMOVE, this.currentFilter));
                        break;
                    }
                    case 6: {
                        PL2.network.sendToServer((IMessage)new PacketNodeFilter(this.tile.getSlotID(), this.tile.getCoords().getBlockPos(), ListPacket.CLEAR));
                        break;
                    }
                    case 7: {
                        if (!(this.tile instanceof IFlexibleGui)) break;
                        FlexibleGuiHandler.changeGui((IFlexibleGui)((IFlexibleGui)this.tile), (int)1, (int)0, (World)this.player.func_130014_f_(), (EntityPlayer)this.player);
                        break;
                    }
                    case 11: {
                        GuiHelpOverlay.enableHelp = !GuiHelpOverlay.enableHelp;
                        this.reset();
                    }
                }
                break;
            }
            case ORE_FILTER: {
                OreDictFilter oreFilter = (OreDictFilter)this.currentFilter;
                switch (button.field_146127_k) {
                    case -1: {
                        oreFilter.transferMode.incrementEnum();
                        this.reset();
                        break;
                    }
                    case 0: {
                        oreFilter.listType.incrementEnum();
                        this.reset();
                        break;
                    }
                    case 1: {
                        if (this.oreDictField.func_146179_b().isEmpty()) break;
                        ((OreDictFilter)this.currentFilter).addOreDict(this.oreDictField.func_146179_b());
                        this.oreDictField.func_146180_a("");
                    }
                }
                break;
            }
        }
    }

    public void changeState(GuiState state) {
        if (state == GuiState.LIST && this.currentFilter != null) {
            PL2.network.sendToServer((IMessage)new PacketNodeFilter(this.tile.getSlotID(), this.tile.getCoords().getBlockPos(), this.currentFilter.isValidFilter() ? ListPacket.ADD : ListPacket.REMOVE, this.currentFilter));
        }
        this.state = state;
        this.field_146999_f = 248;
        this.field_147000_g = state.ySize;
        boolean bl = this.enableListRendering = state == GuiState.LIST || state == GuiState.ORE_FILTER;
        if (this.scroller != null) {
            this.scroller.renderScroller = state.hasScroller;
        }
        this.coolDown = state != GuiState.LIST ? 25 : 0;
        this.reset();
    }

    @Override
    public void func_146979_b(int x, int y) {
        switch (this.state) {
            case FLUID_FILTER: 
            case ITEM_FILTER: {
                Object selection;
                int Y;
                int X;
                int i;
                int start;
                net.minecraft.client.renderer.RenderHelper.func_74520_c();
                this.renderStrings(x, y);
                ArrayList list = Lists.newArrayList((Iterable)this.getGridList());
                if (!list.isEmpty()) {
                    start = (int)((float)(this.getGridSize(list) / 12) * this.scroller.getCurrentScroll());
                    int i2 = start * 12;
                    int finish = Math.min(i2 + 84, this.getGridSize(list));
                    for (int Y2 = 0; Y2 < 7; ++Y2) {
                        for (int X2 = 0; X2 < 12; ++X2) {
                            Object selection2;
                            if (i2 < finish && (selection2 = list.get(i2)) != null) {
                                this.renderGridSelection(selection2, X2, Y2);
                            }
                            ++i2;
                        }
                    }
                }
                if (x - this.field_147003_i < 13 || x - this.field_147003_i > 229 || y - this.field_147009_r < 32 || y - this.field_147009_r > 158 || (i = (start = (int)((float)(this.getGridSize(list) / 12) * this.scroller.getCurrentScroll())) * 12 + (X = (x - this.field_147003_i - 13) / 18) + (Y = (y - this.field_147009_r - 32) / 18) * 12) >= list.size() || (selection = list.get(i)) == null) break;
                GL11.glDisable((int)2896);
                this.renderToolTip(selection, x - this.field_147003_i, y - this.field_147009_r);
                GL11.glEnable((int)2896);
                break;
            }
            case LIST: {
                break;
            }
            case ORE_FILTER: {
                this.oreDictField.func_146194_f();
                break;
            }
        }
        super.func_146979_b(x, y);
    }

    public void selectionPressed(GuiButton button, int infoPos, int buttonID, Object info) {
        switch (this.state) {
            case FLUID_FILTER: {
                break;
            }
            case ITEM_FILTER: {
                break;
            }
            case LIST: {
                INodeFilter selection = (INodeFilter)info;
                if (selection instanceof ItemFilter && !this.player.field_71071_by.func_70445_o().func_190926_b()) {
                    ItemFilter filter = (ItemFilter)selection;
                    filter.addItem(new StoredItemStack(this.player.field_71071_by.func_70445_o(), 1L));
                    PL2.network.sendToServer((IMessage)new PacketNodeFilter(this.tile.getSlotID(), this.tile.getCoords().getBlockPos(), ListPacket.ADD, selection));
                    return;
                }
                if (selection instanceof FluidFilter && !this.player.field_71071_by.func_70445_o().func_190926_b()) {
                    this.addFluidToFilter(selection, this.player.field_71071_by.func_70445_o());
                    PL2.network.sendToServer((IMessage)new PacketNodeFilter(this.tile.getSlotID(), this.tile.getCoords().getBlockPos(), ListPacket.ADD, selection));
                    return;
                }
                this.lastFilter = selection;
                this.currentFilter = selection;
                if (buttonID != 1) break;
                if (selection instanceof ItemFilter) {
                    this.changeState(GuiState.ITEM_FILTER);
                    break;
                }
                if (selection instanceof FluidFilter) {
                    this.changeState(GuiState.FLUID_FILTER);
                    break;
                }
                if (!(selection instanceof OreDictFilter)) break;
                this.changeState(GuiState.ORE_FILTER);
                break;
            }
            case ORE_FILTER: {
                if (buttonID != 1) break;
                ((OreDictFilter)this.currentFilter).removeOreDict((String)info);
                break;
            }
        }
    }

    @Override
    public void setInfo() {
        if (this.state == GuiState.LIST) {
            this.infoList = this.tile.getFilters().objs;
        }
        if (this.state == GuiState.ORE_FILTER) {
            this.infoList = ((OreDictFilter)this.currentFilter).getOreIDs();
        }
    }

    public boolean isCategoryHeader(Object info) {
        if (this.state == GuiState.LIST) {
            if (this.currentFilter == null || info == null) {
                return false;
            }
            return info.hashCode() == this.currentFilter.hashCode();
        }
        if (this.state == GuiState.ORE_FILTER) {
            // empty if block
        }
        return false;
    }

    public boolean isSelectedInfo(Object info) {
        return false;
    }

    public boolean isPairedInfo(Object info) {
        return false;
    }

    public void renderInfo(Object info, int yPos) {
        if (this.state == GuiState.LIST) {
            ((INodeFilter)info).renderInfoInList((GuiSonar)this, yPos);
        } else if (this.state == GuiState.ORE_FILTER) {
            GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
            FontHelper.text((String)"Ore Filter", (int)16, (int)((int)((double)(yPos + 2) / 0.75)), (int)Color.white.getRGB());
            FontHelper.text((String)("Type: " + info), (int)88, (int)((int)((double)(yPos + 2) / 0.75)), (int)Color.white.getRGB());
            GlStateManager.func_179139_a((double)1.3333333333333333, (double)1.3333333333333333, (double)1.3333333333333333);
            net.minecraft.client.renderer.RenderHelper.func_74520_c();
            GlStateManager.func_179109_b((float)0.0f, (float)12.0f, (float)0.0f);
            NonNullList ores = OreDictionary.getOres((String)((String)info));
            int yOffset = 0;
            for (int i = 0; i < Math.min(12, ores.size()); ++i) {
                ItemStack item = ((ItemStack)ores.get(i)).func_77946_l();
                if (item.func_77952_i() == Short.MAX_VALUE) {
                    item.func_77964_b(0);
                }
                RenderHelper.renderItem((GuiSonar)this, (int)(13 + i * 18), (int)(-2 + yPos), (ItemStack)item);
                RenderHelper.renderStoredItemStackOverlay((ItemStack)item, (long)0L, (int)(13 + i * 18), (int)(-2 + yPos + yOffset * 18), null, (boolean)true);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)-12.0f, (float)0.0f);
        }
    }

    @Override
    public void func_73864_a(int x, int y, int button) throws IOException {
        if (this.coolDown != 0) {
            return;
        }
        if (this.state == GuiState.ITEM_FILTER || this.state == GuiState.FLUID_FILTER) {
            ItemStack itemstack;
            if (button == 0 || button == 1) {
                List list = this.getGridList();
                if (x - this.field_147003_i >= 13 && x - this.field_147003_i <= 229 && y - this.field_147009_r >= 32 && y - this.field_147009_r <= 158) {
                    Object storedStack;
                    int X;
                    int Y;
                    int start = (int)((float)(this.getGridSize(list) / 12) * this.scroller.getCurrentScroll());
                    int i = start * 12 + 12 * (Y = (y - this.field_147009_r - 32) / 18) + (X = (x - this.field_147003_i - 13) / 18);
                    if (i < list.size() && (storedStack = list.get(i)) != null) {
                        this.onGridClicked(storedStack, i, button, false);
                        return;
                    }
                    this.onGridClicked(null, i, button, true);
                }
            }
            Slot itemSlot = null;
            for (int i = 0; i < this.field_147002_h.field_75151_b.size(); ++i) {
                Slot slot = (Slot)this.field_147002_h.field_75151_b.get(i);
                if (!this.func_146978_c(slot.field_75223_e, slot.field_75221_f, 16, 16, x, y)) continue;
                itemSlot = slot;
                break;
            }
            if (itemSlot != null && !(itemstack = itemSlot.func_75211_c()).func_190926_b()) {
                if (this.state == GuiState.ITEM_FILTER) {
                    ((ItemFilter)this.currentFilter).addItem(new StoredItemStack(itemstack, 1L));
                } else if (this.state == GuiState.FLUID_FILTER) {
                    this.addFluidToFilter(this.currentFilter, itemstack);
                }
            }
        }
        if (this.state == GuiState.ORE_FILTER) {
            this.oreDictField.func_146192_a(x - this.field_147003_i, y - this.field_147009_r, button);
        }
        super.func_73864_a(x, y, button);
    }

    protected void func_73869_a(char c, int i) throws IOException {
        if (this.state == GuiState.ORE_FILTER && this.oreDictField.func_146206_l()) {
            if (c == '\r' || c == '\u001b') {
                this.oreDictField.func_146195_b(false);
            } else {
                this.oreDictField.func_146201_a(c, i);
                String text = this.oreDictField.func_146179_b();
                this.setString(text.isEmpty() ? "" : text);
            }
            return;
        }
        if (this.state != GuiState.LIST && (i == 1 || this.field_146297_k.field_71474_y.field_151445_Q.isActiveAndMatches(i))) {
            this.changeState(GuiState.LIST);
            return;
        }
        super.func_73869_a(c, i);
    }

    public void setString(String string) {
    }

    @Override
    public int getColour(int i, int type) {
        return PL2Colours.getDefaultSelection().getRGB();
    }

    public void onGridClicked(Object selection, int pos, int button, boolean empty) {
        BaseFilter filter;
        if (this.state == GuiState.ITEM_FILTER) {
            filter = (ItemFilter)this.currentFilter;
            if (button == 1 && selection != null) {
                ((ItemFilter)filter).removeItem((StoredItemStack)selection);
            } else {
                this.player.field_71071_by.func_70445_o();
                ((ItemFilter)filter).addItem(new StoredItemStack(this.player.field_71071_by.func_70445_o(), 1L));
                return;
            }
        }
        if (this.state == GuiState.FLUID_FILTER) {
            filter = (FluidFilter)this.currentFilter;
            if (button == 1 && selection != null) {
                ((FluidFilter)filter).removeFluid((StoredFluidStack)selection);
            } else {
                this.addFluidToFilter(this.currentFilter, this.player.field_71071_by.func_70445_o());
                return;
            }
        }
    }

    public void addFluidToFilter(INodeFilter filter, ItemStack stack) {
        IFluidTankProperties properties;
        if (filter != null && stack != null && stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && (properties = ((IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).getTankProperties()[0]).getContents() != null) {
            ((FluidFilter)filter).addFluid(new StoredFluidStack(properties.getContents(), 1L));
        }
    }

    public void renderGridSelection(Object selection, int x, int y) {
        if (selection instanceof StoredItemStack) {
            StoredItemStack stored = (StoredItemStack)selection;
            ItemStack stack = stored.item;
            RenderHelper.renderItem((GuiSonar)this, (int)(13 + x * 18), (int)(32 + y * 18), (ItemStack)stack);
            RenderHelper.renderStoredItemStackOverlay((ItemStack)stack, (long)0L, (int)(13 + x * 18), (int)(32 + y * 18), null, (boolean)true);
        } else if (selection instanceof StoredFluidStack) {
            StoredFluidStack stored = (StoredFluidStack)selection;
            if (stored.fluid != null) {
                GL11.glPushMatrix();
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().getTextureExtry(stored.fluid.getFluid().getStill().toString());
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                this.func_175175_a(13 + x * 18, 32 + y * 18, sprite, 16, 16);
                GL11.glPopMatrix();
            }
        }
    }

    public void renderStrings(int x, int y) {
    }

    public void renderToolTip(Object selection, int x, int y) {
    }

    public List getGridList() {
        if (this.state == GuiState.ITEM_FILTER) {
            return ((ItemFilter)this.currentFilter).list.objs;
        }
        if (this.state == GuiState.FLUID_FILTER) {
            return ((FluidFilter)this.currentFilter).list.objs;
        }
        return null;
    }

    @Override
    public double listScale() {
        return 1.0;
    }

    @Override
    public int listSize() {
        return (int)Math.floor(137 / this.listHeight);
    }

    public int getGridSize(List list) {
        return this.getGridList() == null ? 0 : list.size();
    }

    private boolean needsScrollBars(List list) {
        return this.getGridSize(list) > 84;
    }

    @Override
    public void func_146976_a(float var1, int var2, int var3) {
        super.func_146976_a(var1, var2, var3);
        this.renderPlayerInventory(40, 173);
        if (this.state == GuiState.FLUID_FILTER || this.state == GuiState.ITEM_FILTER) {
            GuiFilterList.drawTransparentRect((int)(this.field_147003_i + 12), (int)(this.field_147009_r + 31), (int)(this.field_147003_i + 228), (int)(this.field_147009_r + 157), (int)PL2Colours.grey_base.getRGB());
            GuiFilterList.drawTransparentRect((int)(this.field_147003_i + 13), (int)(this.field_147009_r + 32), (int)(this.field_147003_i + 227), (int)(this.field_147009_r + 156), (int)PL2Colours.blue_overlay.getRGB());
        }
        GuiFilterList.drawTransparentRect((int)(this.field_147003_i + 12), (int)(this.field_147009_r + 170), (int)(this.field_147003_i + this.field_146999_f - 12), (int)(this.field_147009_r + 252), (int)PL2Colours.grey_base.getRGB());
        GuiFilterList.drawTransparentRect((int)(this.field_147003_i + 13), (int)(this.field_147009_r + 171), (int)(this.field_147003_i + this.field_146999_f - 13), (int)(this.field_147009_r + 251), (int)PL2Colours.blue_overlay.getRGB());
    }

    @SideOnly(value=Side.CLIENT)
    public class FluidFilterButton
    extends SonarButtons.AnimatedButton {
        public GuiFilterList list;

        public FluidFilterButton(GuiFilterList list, int id, int x, int y) {
            super(id, x, y, filterButtons, 15, 15);
            this.list = list;
        }

        public void func_146111_b(int x, int y) {
            String text = "BUTTON TEXT";
            BaseFilter filter = (BaseFilter)this.list.currentFilter;
            switch (this.field_146127_k) {
                case 0: {
                    text = ((EnumFilterListType)filter.listType.getObject()).name();
                }
            }
            GuiFilterList.this.drawSonarCreativeTabHoveringText(text, x, y);
        }

        public void onClicked() {
        }

        public int getTextureX() {
            boolean secondary = false;
            BaseFilter filter = (BaseFilter)this.list.currentFilter;
            switch (this.field_146127_k) {
                case 0: {
                    secondary = filter.listType.getObject() != EnumFilterListType.WHITELIST;
                }
            }
            return !secondary ? 0 : 16;
        }

        public int getTextureY() {
            return 64;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public class ItemFilterButton
    extends SonarButtons.AnimatedButton {
        public GuiFilterList list;

        public ItemFilterButton(GuiFilterList list, int id, int x, int y) {
            super(id, x, y, filterButtons, 15, 15);
            this.list = list;
        }

        public void func_146111_b(int x, int y) {
            String text = "BUTTON TEXT";
            ItemFilter filter = (ItemFilter)this.list.currentFilter;
            switch (this.field_146127_k) {
                case 0: {
                    text = ((Boolean)filter.matchNBT.getObject() != false ? TextFormatting.WHITE : TextFormatting.GRAY) + "Use NBT: " + filter.matchNBT;
                    break;
                }
                case 1: {
                    text = ((Boolean)filter.matchOreDict.getObject() != false ? TextFormatting.WHITE : TextFormatting.GRAY) + "Use OreDict: " + filter.matchOreDict;
                    break;
                }
                case 2: {
                    text = ((Boolean)filter.ignoreDamage.getObject() != false ? TextFormatting.WHITE : TextFormatting.GRAY) + "Ignore Damage: " + filter.ignoreDamage;
                    break;
                }
                case 3: {
                    text = ((Boolean)filter.matchModid.getObject() != false ? TextFormatting.WHITE : TextFormatting.GRAY) + "Use MODID: " + filter.matchModid;
                    break;
                }
                case 4: {
                    text = ((EnumFilterListType)filter.listType.getObject()).name();
                }
            }
            GuiFilterList.this.drawSonarCreativeTabHoveringText(text, x, y);
        }

        public void onClicked() {
        }

        public int getTextureX() {
            boolean secondary = false;
            ItemFilter filter = (ItemFilter)this.list.currentFilter;
            switch (this.field_146127_k) {
                case 0: {
                    secondary = (Boolean)filter.matchNBT.getObject() == false;
                    break;
                }
                case 1: {
                    secondary = (Boolean)filter.matchOreDict.getObject() == false;
                    break;
                }
                case 2: {
                    secondary = (Boolean)filter.ignoreDamage.getObject() == false;
                    break;
                }
                case 3: {
                    secondary = (Boolean)filter.matchModid.getObject() == false;
                    break;
                }
                case 4: {
                    secondary = filter.listType.getObject() != EnumFilterListType.WHITELIST;
                }
            }
            return !secondary ? 0 : 16;
        }

        public int getTextureY() {
            return this.field_146127_k * 16;
        }
    }

    public static enum GuiState {
        LIST(176, 166, 11, true),
        ITEM_FILTER(100, 100, 16, true),
        ORE_FILTER(100, 100, 11, true),
        FLUID_FILTER(100, 100, 16, true);

        int xSize;
        int ySize;
        boolean hasScroller;
        int listSize;

        private GuiState(int xSize, int ySize, int listSize, boolean hasScroller) {
            this.xSize = xSize;
            this.ySize = ySize;
            this.hasScroller = hasScroller;
        }
    }
}

