/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.api.core.tiles.readers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import sonar.core.api.nbt.INBTSyncable;
import sonar.core.api.utils.BlockCoords;
import sonar.core.helpers.NBTHelper;
import sonar.core.network.sync.ISyncPart;
import sonar.core.network.sync.SyncCoords;
import sonar.core.network.sync.SyncPart;
import sonar.core.network.sync.SyncTagType;
import sonar.logistics.api.core.tiles.readers.ILogicListSorter;
import sonar.logistics.api.core.tiles.wireless.emitters.ClientWirelessEmitter;
import sonar.logistics.base.ClientInfoHandler;
import sonar.logistics.base.listeners.ILogicListenable;
import sonar.logistics.core.tiles.readers.SortingHelper;

public class ClientLocalProvider
implements INBTSyncable {
    public List<ISyncPart> syncParts = new ArrayList<ISyncPart>();
    public SyncTagType.INT identity = new SyncTagType.INT(0);
    public SyncCoords coords = new SyncCoords(1);
    public ItemStack stack;
    public ILogicListSorter sorter;

    public ClientLocalProvider() {
        this.syncParts.addAll(Lists.newArrayList((Object[])new SyncPart[]{this.identity, this.coords}));
    }

    public ClientLocalProvider(ILogicListenable monitor, ILogicListSorter sorter, ItemStack stack) {
        this.syncParts.addAll(Lists.newArrayList((Object[])new SyncPart[]{this.identity, this.coords}));
        this.identity.setObject((Object)monitor.getIdentity());
        this.coords.setCoords(monitor.getCoords());
        this.sorter = sorter;
        this.stack = stack;
    }

    public ClientLocalProvider(int uuid, BlockCoords coords, ILogicListSorter sorter, ItemStack stack) {
        this.syncParts.addAll(Lists.newArrayList((Object[])new SyncPart[]{this.identity, this.coords}));
        this.identity.setObject((Object)uuid);
        this.coords.setCoords(coords);
        this.sorter = sorter;
        this.stack = stack;
    }

    public ClientLocalProvider copy() {
        return new ClientLocalProvider((Integer)this.identity.getObject(), this.coords.getCoords(), SortingHelper.copySorter(this.sorter), this.stack.func_77946_l());
    }

    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTHelper.readSyncParts((NBTTagCompound)nbt, (NBTHelper.SyncType)type, this.syncParts);
        if (nbt.func_74764_b("sorter")) {
            this.sorter = SortingHelper.loadListSorter(nbt.func_74775_l("sorter"));
        }
        this.stack = new ItemStack(nbt.func_74775_l("stack"));
    }

    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        NBTHelper.writeSyncParts((NBTTagCompound)nbt, (NBTHelper.SyncType)type, this.syncParts, (boolean)type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE}));
        if (this.sorter != null) {
            nbt.func_74782_a("sorter", (NBTBase)SortingHelper.saveListSorter(new NBTTagCompound(), this.sorter, NBTHelper.SyncType.SAVE));
        }
        nbt.func_74782_a("stack", (NBTBase)this.stack.func_77955_b(new NBTTagCompound()));
        return nbt;
    }

    public ILogicListenable getViewable() {
        return ClientInfoHandler.instance().getNetworkTileMap().get(this.identity.getObject());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ClientWirelessEmitter) {
            return this.hashCode() == obj.hashCode() && this.coords.getCoords().equals((Object)((ClientWirelessEmitter)obj).coords.getCoords());
        }
        return false;
    }

    public int hashCode() {
        return (Integer)this.identity.getObject();
    }
}

