/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.storage.fluid;

import com.cjm721.overloaded.storage.INBTConvertible;
import com.cjm721.overloaded.storage.LongFluidStack;
import com.cjm721.overloaded.storage.fluid.IHyperHandlerFluid;
import com.cjm721.overloaded.util.FluidUtil;
import com.cjm721.overloaded.util.IDataUpdate;
import com.cjm721.overloaded.util.NumberUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class LongFluidStorage
implements IFluidHandler,
IHyperHandlerFluid,
INBTConvertible {
    @Nonnull
    private final IDataUpdate dataUpdate;
    @Nonnull
    private LongFluidStack storedFluid;

    public LongFluidStorage(@Nonnull IDataUpdate dataUpdate) {
        this.dataUpdate = dataUpdate;
        this.storedFluid = new LongFluidStack(null, 0L);
    }

    public IFluidTankProperties[] getTankProperties() {
        if (this.storedFluid.fluidStack != null) {
            this.storedFluid.fluidStack.amount = (int)Math.min(Integer.MAX_VALUE, this.storedFluid.amount);
        }
        return new FluidTankProperties[]{new FluidTankProperties(this.storedFluid.fluidStack, Integer.MAX_VALUE, true, true)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        LongFluidStack fluidStack = this.give(new LongFluidStack(resource, resource.amount), doFill);
        return (int)((long)resource.amount - fluidStack.amount);
    }

    @Nullable
    public FluidStack drain(@Nonnull FluidStack resource, boolean doDrain) {
        LongFluidStack result = this.take(new LongFluidStack(resource, resource.amount), doDrain);
        if (result.amount == 0L) {
            return null;
        }
        FluidStack toReturn = resource.copy();
        toReturn.amount = (int)result.amount;
        return toReturn;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        LongFluidStack result = this.take(new LongFluidStack(null, maxDrain), doDrain);
        if (result.amount == 0L) {
            return null;
        }
        FluidStack toReturn = result.fluidStack.copy();
        toReturn.amount = (int)result.amount;
        return toReturn;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        FluidStack fluidStack = compound.func_74764_b("Fluid") ? FluidStack.loadFluidStackFromNBT((NBTTagCompound)compound.func_74775_l("Fluid")) : null;
        long amount = compound.func_74764_b("Count") ? compound.func_74763_f("Count") : 0L;
        this.storedFluid = new LongFluidStack(fluidStack, amount);
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        if (this.storedFluid.fluidStack != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.storedFluid.fluidStack.writeToNBT(tag);
            compound.func_74782_a("Fluid", (NBTBase)tag);
            compound.func_74772_a("Count", this.storedFluid.amount);
        }
        return compound;
    }

    public LongFluidStack getFluidStack() {
        return this.storedFluid;
    }

    @Override
    @Nonnull
    public LongFluidStack status() {
        return this.storedFluid;
    }

    @Override
    @Nonnull
    public LongFluidStack take(@Nonnull LongFluidStack stack, boolean doAction) {
        if (this.storedFluid.fluidStack == null) {
            return LongFluidStack.EMPTY_STACK;
        }
        LongFluidStack toReturn = new LongFluidStack(this.storedFluid.fluidStack, Math.min(this.storedFluid.amount, stack.amount));
        if (doAction) {
            this.storedFluid.amount -= toReturn.amount;
            if (this.storedFluid.amount == 0L) {
                this.storedFluid = LongFluidStack.EMPTY_STACK;
            }
            this.dataUpdate.dataUpdated();
        }
        return toReturn;
    }

    @Override
    @Nonnull
    public LongFluidStack give(@Nonnull LongFluidStack fluidStack, boolean doAction) {
        if (this.storedFluid.fluidStack == null) {
            if (doAction) {
                this.storedFluid = fluidStack;
                this.dataUpdate.dataUpdated();
            }
            return LongFluidStack.EMPTY_STACK;
        }
        if (FluidUtil.fluidsAreEqual(this.storedFluid.fluidStack, fluidStack.fluidStack)) {
            NumberUtil.AddReturn<Long> value = NumberUtil.addToMax(this.storedFluid.amount, fluidStack.amount);
            if (doAction) {
                this.storedFluid.amount = (Long)value.result;
                this.dataUpdate.dataUpdated();
            }
            return new LongFluidStack(this.storedFluid.fluidStack, (Long)value.overflow);
        }
        return fluidStack;
    }
}

