/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.client.gui.button;

import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiTextField;

public class GuiPositiveFloatTextField
extends GuiTextField {
    private final float min;
    private final float max;

    public GuiPositiveFloatTextField(int componentId, FontRenderer fontrendererObj, int x, int y, int width, int height, float currentValue, float min, float max) {
        super(componentId, fontrendererObj, x, y, width, height);
        this.min = min;
        this.max = max;
        this.func_175205_a(this::floatValidate);
        this.func_146180_a(Float.toString(currentValue));
    }

    private boolean floatValidate(String text) {
        String validChars = "0123456789.-Ee";
        for (char c : text.toCharArray()) {
            if (validChars.contains(c + "")) continue;
            return false;
        }
        return true;
    }

    public void func_146195_b(boolean isFocusedIn) {
        super.func_146195_b(isFocusedIn);
        if (!isFocusedIn) {
            this.func_146180_a(Float.toString(this.getFloatValue()));
        }
    }

    public float getFloatValue() {
        String text = this.func_146179_b();
        if (text.isEmpty()) {
            return this.min;
        }
        try {
            float value = text.endsWith(".") ? Float.parseFloat(text.substring(0, text.length() - 1)) : Float.parseFloat(text);
            if (value < this.min) {
                value = this.min;
            }
            if (value > this.max) {
                value = this.max;
            }
            return value;
        }
        catch (NumberFormatException ignored) {
            return this.min;
        }
    }
}

