/*
 * Decompiled with CFR 0.152.
 */
package com.cjm721.overloaded.block.tile;

import com.cjm721.overloaded.Overloaded;
import com.cjm721.overloaded.proxy.CommonProxy;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileMatterPurifier
extends TileEntity
implements ITickable,
IItemHandler {
    private final FluidTank fluidStorage = new FluidTank(Integer.MAX_VALUE);
    private EnergyStorage energyStorage = new EnergyStorage(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private ItemStack stack = ItemStack.field_190927_a;

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            return;
        }
        if (this.stack.func_190926_b()) {
            return;
        }
        float hardness = ((ItemBlock)this.stack.func_77973_b()).func_179223_d().func_176195_g(null, null, null);
        if (hardness <= 0.0f) {
            return;
        }
        float ecFloat = (float)Overloaded.cachedConfig.purifierConfig.energyPerOperation + (float)Overloaded.cachedConfig.purifierConfig.energyPerHardness * hardness;
        int energyCost = Math.round(ecFloat);
        if (this.energyStorage.extractEnergy(energyCost, true) != energyCost) {
            return;
        }
        int createdFluid = Math.round(hardness);
        FluidStack fluidStack = new FluidStack(CommonProxy.pureMatter, createdFluid);
        int storedFluid = this.fluidStorage.fill(fluidStack, false);
        if (storedFluid != createdFluid) {
            return;
        }
        this.stack.func_190918_g(1);
        if (this.stack.func_190916_E() == 0) {
            this.stack = ItemStack.field_190927_a;
        }
        this.fluidStorage.fill(fluidStack, true);
        this.energyStorage.extractEnergy(energyCost, false);
        this.func_70296_d();
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.fluidStorage.readFromNBT(compound.func_74775_l("Fluid"));
        this.energyStorage = new EnergyStorage(compound.func_74762_e("Energy"), Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        NBTTagCompound fluid = new NBTTagCompound();
        this.fluidStorage.writeToNBT(fluid);
        compound.func_74782_a("Fluid", (NBTBase)fluid);
        compound.func_74768_a("Energy", this.energyStorage.getEnergyStored());
        return super.func_189515_b(compound);
    }

    @Nullable
    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)this.fluidStorage;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)this.energyStorage;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        if (capability == CapabilityEnergy.ENERGY) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public int getSlots() {
        return 1;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.stack;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.stack.func_190926_b()) {
            if (!simulate) {
                this.stack = stack;
            }
            return ItemStack.field_190927_a;
        }
        if (ItemHandlerHelper.canItemStacksStack((ItemStack)this.stack, (ItemStack)stack)) {
            int maxSize = this.stack.func_77976_d();
            int toTake = Math.min(maxSize - this.stack.func_190916_E(), stack.func_190916_E());
            if (!simulate) {
                this.stack.func_190920_e(this.stack.func_190916_E() + toTake);
            }
            ItemStack toReturn = stack.func_77946_l();
            toReturn.func_190920_e(stack.func_190916_E() - toTake);
            return toReturn;
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        return this.stack.func_77976_d();
    }
}

