/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.controlpanel;

import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import malte0811.industrialwires.client.RawQuad;
import malte0811.industrialwires.client.gui.GuiPanelCreator;
import malte0811.industrialwires.client.panelmodel.RawModelFontRenderer;
import malte0811.industrialwires.controlpanel.ControlPanelNetwork;
import malte0811.industrialwires.controlpanel.IConfigurableComponent;
import malte0811.industrialwires.controlpanel.PanelComponent;
import malte0811.industrialwires.controlpanel.PanelUtils;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.util.vector.Vector3f;

public class PanelMeter
extends PanelComponent
implements IConfigurableComponent {
    @Nonnull
    private ControlPanelNetwork.RSChannel primary = ControlPanelNetwork.RSChannel.DEFAULT_CHANNEL;
    @Nonnull
    private ControlPanelNetwork.RSChannel secondary = ControlPanelNetwork.RSChannel.INVALID_CHANNEL;
    private int rsInput;
    private boolean wide = true;
    private static final float SIZE = 0.25f;
    private static final float WIDTH = 0.375f;
    private static final float BORDER = 0.0125f;
    private static final float[] BLACK = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    private static final float[] WHITE = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    public PanelMeter() {
        super("panel_meter");
    }

    public PanelMeter(@Nonnull ControlPanelNetwork.RSChannel primary, @Nonnull ControlPanelNetwork.RSChannel secondary, boolean wide) {
        this();
        this.primary = primary;
        this.secondary = secondary;
        this.wide = wide;
    }

    @Override
    protected void writeCustomNBT(NBTTagCompound nbt, boolean toItem) {
        nbt.func_74768_a("rsId", this.primary.getController());
        nbt.func_74774_a("rsChannel", this.primary.getColor());
        nbt.func_74768_a("rsId2", this.secondary.getController());
        nbt.func_74774_a("rsChannel2", this.secondary.getColor());
        nbt.func_74757_a("wide", this.wide);
        if (!toItem) {
            nbt.func_74768_a("rsInput", this.rsInput);
        }
    }

    @Override
    protected void readCustomNBT(NBTTagCompound nbt) {
        int rsController = nbt.func_74762_e("rsId");
        byte rsColor = nbt.func_74771_c("rsChannel");
        this.primary = new ControlPanelNetwork.RSChannel(rsController, rsColor);
        this.rsInput = nbt.func_74762_e("rsInput");
        this.wide = nbt.func_74767_n("wide");
        if (nbt.func_74764_b("rsId2")) {
            rsController = nbt.func_74762_e("rsId2");
            rsColor = nbt.func_74771_c("rsChannel2");
            this.secondary = new ControlPanelNetwork.RSChannel(rsController, rsColor);
        } else {
            this.secondary = ControlPanelNetwork.RSChannel.INVALID_CHANNEL;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<RawQuad> getQuads() {
        ArrayList<RawQuad> ret = new ArrayList<RawQuad>();
        float width = this.wide ? 0.375f : 0.25f;
        PanelUtils.addColoredQuad(ret, new Vector3f(), new Vector3f(0.0f, 0.0f, 0.25f), new Vector3f(width, 0.0f, 0.25f), new Vector3f(width, 0.0f, 0.0f), EnumFacing.UP, BLACK);
        PanelUtils.addColoredQuad(ret, new Vector3f(0.0125f, 0.001f, 0.0125f), new Vector3f(0.0125f, 0.001f, 0.2375f), new Vector3f(width - 0.0125f, 0.001f, 0.2375f), new Vector3f(width - 0.0125f, 0.001f, 0.0125f), EnumFacing.UP, WHITE);
        RawModelFontRenderer r = RawModelFontRenderer.get();
        r.setScale(0.5f);
        r.transform = new Matrix4();
        for (int i = 0; i <= 3; ++i) {
            this.transformNumber(r.transform, 85 * i);
            String asString = Integer.toString(5 * i);
            int lengthHalf = r.func_78256_a(asString) / 2;
            r.transform.translate((double)((float)(-lengthHalf) * r.getScale()), 0.0, -3.5 * (double)r.getScale());
            r.func_78276_b(asString, 0, 0, -16777216);
            ret.addAll((Collection<RawQuad>)r.build());
        }
        r.transform = null;
        Matrix4 mat = new Matrix4();
        this.transformNeedle(mat, this.rsInput);
        float wHalf = 0.00625f;
        float length = this.getLength();
        PanelUtils.addColoredQuad(ret, new Vector3f(wHalf, 0.0f, 0.0f), new Vector3f(-wHalf, 0.0f, 0.0f), new Vector3f(-wHalf, 0.0f, length), new Vector3f(wHalf, 0.0f, length), EnumFacing.UP, BLACK, mat);
        return ret;
    }

    private void transformNumber(Matrix4 mat, int value) {
        if (this.wide) {
            this.transformNeedle(mat, value);
            mat.translate(0.0, 0.0, (double)this.getLength() + 0.018750000279396772);
            mat.scale(-1.0, 1.0, -1.0);
        } else {
            mat.setIdentity().translate(0.0, (double)0.001f, 0.25);
            mat.translate((double)0.2125f, 0.0, (double)-0.0375f);
            float angle = 90.0f * (1.0f - (float)value / 255.0f);
            angle = (float)((double)angle * Math.PI / 180.0);
            float length = this.getLength() + 0.0125f;
            mat.translate((double)((float)(-Math.sin(angle) * (double)length)), 0.0, (double)((float)(-Math.cos(angle) * (double)length)));
        }
    }

    private void transformNeedle(Matrix4 mat, int value) {
        float angle;
        mat.setIdentity().translate(0.0, (double)0.002f, 0.25);
        if (this.wide) {
            mat.translate(0.1875, 0.0, (double)-0.025f);
            angle = 50.0f - 100.0f * ((float)value / 255.0f);
        } else {
            mat.translate((double)0.2125f, 0.0, (double)-0.0375f);
            angle = 90.0f - 90.0f * ((float)value / 255.0f);
        }
        angle = (float)((double)(180.0f + angle) * Math.PI / 180.0);
        mat.rotate((double)angle, 0.0, 1.0, 0.0);
    }

    private float getLength() {
        return 0.25f - (float)(this.wide ? 6 : 7) * 0.0125f;
    }

    @Override
    @Nonnull
    public PanelComponent copyOf() {
        PanelMeter ret = new PanelMeter(this.primary, this.secondary, this.wide);
        ret.rsInput = this.rsInput;
        ret.setX(this.x);
        ret.setY(this.y);
        ret.panelHeight = this.panelHeight;
        return ret;
    }

    @Override
    @Nonnull
    public AxisAlignedBB getBlockRelativeAABB() {
        if (this.aabb == null) {
            this.aabb = new AxisAlignedBB((double)this.x, 0.0, (double)this.y, (double)(this.x + (this.wide ? 0.375f : 0.25f)), 0.0, (double)(this.y + 0.25f));
        }
        return this.aabb;
    }

    @Override
    public void interactWith(Vec3d hitRelative, EntityPlayerMP player) {
    }

    @Override
    public void update() {
    }

    @Override
    public void setNetwork(ControlPanelNetwork net) {
        super.setNetwork(net);
        Consumer<ControlPanelNetwork.RSChannelState> listenerPrimary = input -> {
            byte strength = input.getStrength();
            if (strength != this.rsInput >> 4) {
                this.rsInput = this.secondary.isValid() ? strength << 4 | this.rsInput & 0xF : strength * 17;
                this.panel.func_70296_d();
                this.panel.triggerRenderUpdate();
            }
        };
        net.addListener(this, listenerPrimary, this.primary);
        if (this.secondary.isValid()) {
            Consumer<ControlPanelNetwork.RSChannelState> listenerSec = input -> {
                if (input.getStrength() != (this.rsInput & 0xF)) {
                    this.rsInput = input.getStrength() & 0xF | this.rsInput & 0xF0;
                    this.panel.func_70296_d();
                    this.panel.triggerRenderUpdate();
                }
            };
            net.addListener(this, listenerSec, this.secondary);
        }
    }

    @Override
    public float getHeight() {
        return 0.0f;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PanelMeter that = (PanelMeter)o;
        if (this.rsInput != that.rsInput) {
            return false;
        }
        if (this.wide != that.wide) {
            return false;
        }
        if (!this.primary.equals(that.primary)) {
            return false;
        }
        return this.secondary.equals(that.secondary);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.primary.hashCode();
        result = 31 * result + this.secondary.hashCode();
        result = 31 * result + this.rsInput;
        result = 31 * result + (this.wide ? 1 : 0);
        return result;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInGUI(GuiPanelCreator gui) {
        this.renderInGUIDefault(gui, 0);
        AxisAlignedBB aabb = this.getBlockRelativeAABB();
        int left = (int)Math.ceil((double)gui.getX0() + (aabb.field_72340_a + (double)0.0125f) * (double)gui.panelSize);
        int top = (int)Math.ceil((double)gui.getY0() + (aabb.field_72339_c + (double)0.0125f) * (double)gui.panelSize);
        int right = (int)Math.floor((double)gui.getX0() + (aabb.field_72336_d - (double)0.0125f) * (double)gui.panelSize);
        int bottom = (int)Math.floor((double)gui.getY0() + (aabb.field_72334_f - (double)0.0125f) * (double)gui.panelSize);
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)-1);
        GlStateManager.func_179094_E();
        int border = (int)Math.ceil(0.0125f * (float)gui.panelSize);
        int width = right - left;
        if (this.wide) {
            GlStateManager.func_179137_b((double)((double)left + (double)width / 2.0), (double)(bottom - 2 * border), (double)0.0);
            GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        } else {
            GlStateManager.func_179109_b((float)(right - 2 * border), (float)(bottom - 2 * border), (float)0.0f);
            GlStateManager.func_179114_b((float)120.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        left = (int)Math.floor(-0.0125f * (float)gui.panelSize / 2.0f);
        top = 0;
        right = (int)Math.ceil(0.0125f * (float)gui.panelSize / 2.0f);
        bottom = (int)Math.floor(this.getLength() * (float)gui.panelSize);
        Gui.func_73734_a((int)left, (int)top, (int)right, (int)bottom, (int)-16777216);
        GlStateManager.func_179121_F();
    }

    @Override
    public void applyConfigOption(IConfigurableComponent.ConfigType type, int id, NBTBase value) {
        switch (type) {
            case RS_CHANNEL: {
                if (id == 0) {
                    this.primary = this.primary.withColor(value);
                    break;
                }
                this.secondary = this.secondary.withColor(value);
                break;
            }
            case INT: {
                if (id == 0) {
                    this.primary = this.primary.withController(value);
                    break;
                }
                this.secondary = this.secondary.withController(value);
                break;
            }
            case BOOL: {
                this.wide = ((NBTTagByte)value).func_150290_f() != 0;
            }
        }
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigName(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case FLOAT: {
                return I18n.func_135052_a((String)("industrialwires.desc." + (id == 0 ? "red" : (id == 1 ? "green" : "blue"))), (Object[])new Object[0]);
            }
            case BOOL: {
                return I18n.func_135052_a((String)"industrialwires.desc.wide_info", (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public String fomatConfigDescription(IConfigurableComponent.ConfigType type, int id) {
        switch (type) {
            case FLOAT: {
                return null;
            }
            case RS_CHANNEL: {
                return I18n.func_135052_a((String)("industrialwires.desc.rschannel_info" + (id == 1 ? "2" : "")), (Object[])new Object[0]);
            }
            case INT: {
                return I18n.func_135052_a((String)("industrialwires.desc.rsid_info" + (id == 1 ? "2" : "")), (Object[])new Object[0]);
            }
        }
        return null;
    }

    @Override
    public IConfigurableComponent.RSColorConfig[] getRSChannelOptions() {
        return new IConfigurableComponent.RSColorConfig[]{new IConfigurableComponent.RSColorConfig("channel", 0, 0, this.primary.getColor(), false), new IConfigurableComponent.RSColorConfig("channel2", 60, 0, this.secondary.getColor(), false)};
    }

    @Override
    public IConfigurableComponent.IntConfig[] getIntegerOptions() {
        return new IConfigurableComponent.IntConfig[]{new IConfigurableComponent.IntConfig("rsId", 0, 60, this.primary.getController(), 2, false), new IConfigurableComponent.IntConfig("rsId2", 60, 60, this.secondary.getController(), 2, true)};
    }

    @Override
    public IConfigurableComponent.BoolConfig[] getBooleanOptions() {
        return new IConfigurableComponent.BoolConfig[]{new IConfigurableComponent.BoolConfig("wide", 0, 80, this.wide)};
    }

    @Override
    public int getColor() {
        return -1;
    }
}

