/*
 * Decompiled with CFR 0.152.
 */
package malte0811.industrialwires.client.render;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import malte0811.industrialwires.blocks.converter.TileEntityMechMB;
import malte0811.industrialwires.client.ClientUtilsIW;
import malte0811.industrialwires.client.RawQuad;
import malte0811.industrialwires.mech_mb.MechMBPart;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.lwjgl.util.vector.ReadableVector3f;
import org.lwjgl.util.vector.Vector3f;

public class TileRenderMechMB
extends TileEntitySpecialRenderer<TileEntityMechMB>
implements IResourceManagerReloadListener {
    public static final Map<ResourceLocation, IBakedModel> BASE_MODELS = new HashMap<ResourceLocation, IBakedModel>();
    private static final Set<TileEntityMechMB> TES_WITH_MODELS = Collections.newSetFromMap(new WeakHashMap());

    public void render(TileEntityMechMB te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        if (te.mechanical != null) {
            if (te.rotatingModel == null) {
                this.generateModel(te);
            }
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            RenderHelper.func_74518_a();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(0.5 + x), (double)(0.5 + y), (double)(0.5 + z));
            GlStateManager.func_179114_b((float)(180.0f - te.facing.func_185119_l()), (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)((float)(te.angle + te.energyState.getSpeed() * 2.864788975654116 * (double)partialTicks)), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
            Tessellator tes = Tessellator.func_178181_a();
            BufferBuilder bb = tes.func_178180_c();
            bb.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            ClientUtils.renderModelTESRFast(te.rotatingModel, (BufferBuilder)bb, (World)te.func_145831_w(), (BlockPos)te.func_174877_v());
            tes.func_78381_a();
            GlStateManager.func_179121_F();
            RenderHelper.func_74519_b();
        }
    }

    public void func_110549_a(@Nonnull IResourceManager resourceManager) {
        TileRenderMechMB.clearCache();
    }

    private static void clearCache() {
        for (TileEntityMechMB te : TES_WITH_MODELS) {
            te.rotatingModel = null;
        }
        TES_WITH_MODELS.clear();
    }

    private void generateModel(TileEntityMechMB te) {
        te.rotatingModel = new ArrayList<BakedQuad>();
        int offset = 1;
        for (MechMBPart part : te.mechanical) {
            this.addQuadsForPart(part, offset, te.rotatingModel);
            offset += part.getLength();
        }
        List<BakedQuad> shaftQuads = MechMBPart.INSTANCES.get("shaft").getRotatingQuads();
        Vector3f tmp = new Vector3f();
        Matrix4 id = new Matrix4();
        Matrix4 translate = new Matrix4();
        translate.translate(0.0, 0.0, (double)offset);
        for (BakedQuad q : shaftQuads) {
            RawQuad raw = RawQuad.unbake(q);
            Vector3f.add((Vector3f)raw.vertices[0], (Vector3f)raw.vertices[1], (Vector3f)tmp);
            tmp.scale(0.5f);
            Vector3f middle01 = new Vector3f((ReadableVector3f)tmp);
            Vector3f.add((Vector3f)raw.vertices[2], (Vector3f)raw.vertices[3], (Vector3f)tmp);
            tmp.scale(0.5f);
            Vector3f middle23 = new Vector3f((ReadableVector3f)tmp);
            RawQuad start = new RawQuad(raw.vertices[0], middle01, middle23, raw.vertices[3], raw.facing, raw.tex, raw.colorA, raw.normal, new float[][]{raw.uvs[0], {raw.uvs[1][0], 8.0f}, {raw.uvs[2][0], 8.0f}, raw.uvs[3]}, -1);
            te.rotatingModel.add(ClientUtilsIW.bakeQuad(start, id, id));
            RawQuad end = new RawQuad(middle01, raw.vertices[1], raw.vertices[2], middle23, raw.facing, raw.tex, raw.colorA, raw.normal, new float[][]{{raw.uvs[0][0], 8.0f}, raw.uvs[1], raw.uvs[2], {raw.uvs[3][0], 8.0f}}, -1);
            te.rotatingModel.add(ClientUtilsIW.bakeQuad(end, translate, id));
        }
        TES_WITH_MODELS.add(te);
    }

    private void addQuadsForPart(MechMBPart part, int offset, List<BakedQuad> out) {
        List<BakedQuad> quadsForPart = part.getRotatingQuads();
        if (offset != 0) {
            for (BakedQuad b : quadsForPart) {
                out.add(this.translateQuadZ(b, offset));
            }
        } else {
            out.addAll(quadsForPart);
        }
    }

    private BakedQuad translateQuadZ(BakedQuad b, float offset) {
        int[] data = Arrays.copyOf(b.func_178209_a(), b.func_178209_a().length);
        int pos = 0;
        for (VertexFormatElement ele : b.getFormat().func_177343_g()) {
            if (ele.func_177375_c() == VertexFormatElement.EnumUsage.POSITION) {
                for (int i = 0; i < 4; ++i) {
                    data[i * b.getFormat().func_181719_f() + pos + 2] = Float.floatToRawIntBits(Float.intBitsToFloat(data[i * b.getFormat().func_181719_f() + pos + 2]) + offset);
                }
                break;
            }
            pos += ele.func_177368_f() / 4;
        }
        return new BakedQuad(data, b.func_178211_c(), b.func_178210_d(), b.func_187508_a(), b.shouldApplyDiffuseLighting(), b.getFormat());
    }

    static {
        IEApi.renderCacheClearers.add(TileRenderMechMB::clearCache);
    }
}

