/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.tile;

import javax.annotation.Nullable;
import mekanism.api.Coord4D;
import mekanism.common.base.FluidHandlerWrapper;
import mekanism.common.base.IFluidHandlerWrapper;
import mekanism.common.content.boiler.BoilerSteamTank;
import mekanism.common.content.boiler.BoilerTank;
import mekanism.common.content.boiler.BoilerWaterTank;
import mekanism.common.content.boiler.SynchronizedBoilerData;
import mekanism.common.integration.computer.IComputerIntegration;
import mekanism.common.tile.TileEntityBoilerCasing;
import mekanism.common.util.CapabilityUtils;
import mekanism.common.util.PipeUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityBoilerValve
extends TileEntityBoilerCasing
implements IFluidHandlerWrapper,
IComputerIntegration {
    private static final String[] methods = new String[]{"isFormed", "getSteam", "getWater", "getBoilRate", "getMaxBoilRate", "getTemp"};
    public BoilerTank waterTank = new BoilerWaterTank(this);
    public BoilerTank steamTank = new BoilerSteamTank(this);

    public TileEntityBoilerValve() {
        super("BoilerValve");
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (!this.field_145850_b.field_72995_K && this.structure != null && ((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() >= ((SynchronizedBoilerData)this.structure).upperRenderLocation.y - 1 && ((SynchronizedBoilerData)this.structure).steamStored != null && ((SynchronizedBoilerData)this.structure).steamStored.amount > 0) {
            for (EnumFacing side : EnumFacing.values()) {
                IFluidHandler handler;
                TileEntity tile = Coord4D.get(this).offset(side).getTileEntity((IBlockAccess)this.field_145850_b);
                if (tile == null || tile instanceof TileEntityBoilerValve || !CapabilityUtils.hasCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d()) || !PipeUtils.canFill(handler = (IFluidHandler)CapabilityUtils.getCapability((ICapabilityProvider)tile, CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d()), ((SynchronizedBoilerData)this.structure).steamStored)) continue;
                ((SynchronizedBoilerData)this.structure).steamStored.amount -= handler.fill(((SynchronizedBoilerData)this.structure).steamStored, true);
                if (((SynchronizedBoilerData)this.structure).steamStored.amount > 0) continue;
                ((SynchronizedBoilerData)this.structure).steamStored = null;
            }
        }
    }

    @Override
    public FluidTankInfo[] getTankInfo(EnumFacing from) {
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            if (((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() >= ((SynchronizedBoilerData)this.structure).upperRenderLocation.y - 1) {
                return new FluidTankInfo[]{this.steamTank.getInfo()};
            }
            return new FluidTankInfo[]{this.waterTank.getInfo()};
        }
        return PipeUtils.EMPTY;
    }

    @Override
    public FluidTankInfo[] getAllTanks() {
        return new FluidTankInfo[]{this.steamTank.getInfo(), this.waterTank.getInfo()};
    }

    @Override
    public int fill(EnumFacing from, FluidStack resource, boolean doFill) {
        if (this.structure != null && ((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() < ((SynchronizedBoilerData)this.structure).upperRenderLocation.y - 1) {
            return this.waterTank.fill(resource, doFill);
        }
        return 0;
    }

    @Override
    public FluidStack drain(EnumFacing from, FluidStack resource, boolean doDrain) {
        if (this.structure != null && ((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() >= ((SynchronizedBoilerData)this.structure).upperRenderLocation.y - 1 && ((SynchronizedBoilerData)this.structure).steamStored != null && resource.getFluid() == ((SynchronizedBoilerData)this.structure).steamStored.getFluid()) {
            return this.steamTank.drain(resource.amount, doDrain);
        }
        return null;
    }

    @Override
    public FluidStack drain(EnumFacing from, int maxDrain, boolean doDrain) {
        if (this.structure != null && ((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() >= ((SynchronizedBoilerData)this.structure).upperRenderLocation.y - 1) {
            return this.steamTank.drain(maxDrain, doDrain);
        }
        return null;
    }

    @Override
    public boolean canFill(EnumFacing from, FluidStack fluid) {
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            return ((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() < ((SynchronizedBoilerData)this.structure).upperRenderLocation.y - 1;
        }
        return false;
    }

    @Override
    public boolean canDrain(EnumFacing from, @Nullable FluidStack fluid) {
        if (!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) {
            return ((SynchronizedBoilerData)this.structure).upperRenderLocation != null && this.func_174877_v().func_177956_o() >= ((SynchronizedBoilerData)this.structure).upperRenderLocation.y - 1;
        }
        return false;
    }

    @Override
    public String[] getMethods() {
        return methods;
    }

    @Override
    public Object[] invoke(int method, Object[] arguments) throws Exception {
        if (method == 0) {
            return new Object[]{this.structure != null};
        }
        if (this.structure == null) {
            return new Object[]{"Unformed"};
        }
        switch (method) {
            case 1: {
                return new Object[]{((SynchronizedBoilerData)this.structure).steamStored != null ? ((SynchronizedBoilerData)this.structure).steamStored.amount : 0};
            }
            case 2: {
                return new Object[]{((SynchronizedBoilerData)this.structure).waterStored != null ? ((SynchronizedBoilerData)this.structure).waterStored.amount : 0};
            }
            case 3: {
                return new Object[]{((SynchronizedBoilerData)this.structure).lastBoilRate};
            }
            case 4: {
                return new Object[]{((SynchronizedBoilerData)this.structure).lastMaxBoil};
            }
            case 5: {
                return new Object[]{((SynchronizedBoilerData)this.structure).temperature};
            }
        }
        throw new NoSuchMethodException();
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing side) {
        if ((!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, side);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if ((!this.field_145850_b.field_72995_K && this.structure != null || this.field_145850_b.field_72995_K && this.clientHasStructure) && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)new FluidHandlerWrapper(this, side);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public int[] func_180463_a(EnumFacing side) {
        return INV_SLOTS;
    }
}

