/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.network;

import io.netty.buffer.ByteBuf;
import java.util.Set;
import java.util.UUID;
import mekanism.common.Mekanism;
import mekanism.common.PacketHandler;
import mekanism.common.item.ItemJetpack;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketJetpackData
implements IMessageHandler<JetpackDataMessage, IMessage> {
    public IMessage onMessage(JetpackDataMessage message, MessageContext context) {
        EntityPlayer player = PacketHandler.getPlayer(context);
        PacketHandler.handlePacket(() -> {
            ItemStack stack;
            if (message.packetType == JetpackPacket.UPDATE) {
                if (message.value) {
                    Mekanism.jetpackOn.add(message.userId);
                } else {
                    Mekanism.jetpackOn.remove(message.userId);
                }
                if (!player.field_70170_p.field_72995_K) {
                    Mekanism.packetHandler.sendToDimension(new JetpackDataMessage(JetpackPacket.UPDATE, message.userId, message.value), player.field_70170_p.field_73011_w.getDimension());
                }
            } else if (message.packetType == JetpackPacket.MODE && !(stack = player.func_184582_a(EntityEquipmentSlot.CHEST)).func_190926_b() && stack.func_77973_b() instanceof ItemJetpack) {
                if (!message.value) {
                    ((ItemJetpack)stack.func_77973_b()).incrementMode(stack);
                } else {
                    ((ItemJetpack)stack.func_77973_b()).setMode(stack, ItemJetpack.JetpackMode.DISABLED);
                }
            }
        }, player);
        return null;
    }

    public static class JetpackDataMessage
    implements IMessage {
        public JetpackPacket packetType;
        public UUID userId;
        public boolean value;

        public JetpackDataMessage() {
        }

        public JetpackDataMessage(JetpackPacket type, UUID name, boolean state) {
            this.packetType = type;
            this.value = state;
            if (this.packetType == JetpackPacket.UPDATE) {
                this.userId = name;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void toBytes(ByteBuf dataStream) {
            dataStream.writeInt(this.packetType.ordinal());
            if (this.packetType == JetpackPacket.MODE) {
                dataStream.writeBoolean(this.value);
            } else if (this.packetType == JetpackPacket.UPDATE) {
                PacketHandler.writeUUID(dataStream, this.userId);
                dataStream.writeBoolean(this.value);
            } else if (this.packetType == JetpackPacket.FULL) {
                dataStream.writeInt(Mekanism.jetpackOn.size());
                Set<UUID> set = Mekanism.jetpackOn;
                synchronized (set) {
                    for (UUID uuid : Mekanism.jetpackOn) {
                        PacketHandler.writeUUID(dataStream, uuid);
                    }
                }
            }
        }

        public void fromBytes(ByteBuf dataStream) {
            this.packetType = JetpackPacket.values()[dataStream.readInt()];
            if (this.packetType == JetpackPacket.MODE) {
                this.value = dataStream.readBoolean();
            } else if (this.packetType == JetpackPacket.UPDATE) {
                this.userId = PacketHandler.readUUID(dataStream);
                this.value = dataStream.readBoolean();
            } else if (this.packetType == JetpackPacket.FULL) {
                Mekanism.jetpackOn.clear();
                int amount = dataStream.readInt();
                for (int i = 0; i < amount; ++i) {
                    Mekanism.jetpackOn.add(PacketHandler.readUUID(dataStream));
                }
            }
        }
    }

    public static enum JetpackPacket {
        UPDATE,
        FULL,
        MODE;

    }
}

