/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.handlers;

import com.blamejared.mtlib.helpers.InputHelper;
import com.blamejared.mtlib.helpers.LogHelper;
import com.blamejared.mtlib.helpers.StackHelper;
import crafttweaker.IAction;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IIngredient;
import crafttweaker.api.item.IItemStack;
import crafttweaker.api.item.IngredientAny;
import java.util.HashMap;
import java.util.Map;
import mekanism.api.infuse.InfuseRegistry;
import mekanism.common.integration.crafttweaker.CrafttweakerIntegration;
import mekanism.common.integration.crafttweaker.util.AddMekanismRecipe;
import mekanism.common.integration.crafttweaker.util.RemoveMekanismRecipe;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.InfusionInput;
import mekanism.common.recipe.machines.MetallurgicInfuserRecipe;
import mekanism.common.recipe.outputs.ItemStackOutput;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.infuser")
@ModOnly(value="mtlib")
@ZenRegister
public class Infuser {
    public static final String NAME = "Mekanism Metallurgic Infuser";

    @ZenMethod
    public static void addRecipe(String infuseType, int infuseAmount, IItemStack itemInput, IItemStack itemOutput) {
        if (itemInput == null || itemOutput == null || infuseType == null || infuseType.isEmpty()) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        InfusionInput input = new InfusionInput(InfuseRegistry.get(infuseType), infuseAmount, InputHelper.toStack((IItemStack)itemInput));
        ItemStackOutput output = new ItemStackOutput(InputHelper.toStack((IItemStack)itemOutput));
        MetallurgicInfuserRecipe recipe = new MetallurgicInfuserRecipe(input, output);
        CrafttweakerIntegration.LATE_ADDITIONS.add((IAction)new AddMekanismRecipe<InfusionInput, MetallurgicInfuserRecipe>(NAME, RecipeHandler.Recipe.METALLURGIC_INFUSER.get(), recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient itemOutput, @Optional IIngredient itemInput, @Optional String infuseType) {
        if (itemOutput == null) {
            LogHelper.logError((String)String.format("Required parameters missing for %s Recipe.", NAME));
            return;
        }
        if (itemInput == null) {
            itemInput = IngredientAny.INSTANCE;
        }
        if (infuseType == null) {
            infuseType = "";
        }
        CrafttweakerIntegration.LATE_REMOVALS.add((IAction)new Remove(NAME, RecipeHandler.Recipe.METALLURGIC_INFUSER.get(), itemOutput, itemInput, infuseType));
    }

    private static class Remove
    extends RemoveMekanismRecipe<InfusionInput, MetallurgicInfuserRecipe> {
        private IIngredient itemOutput;
        private IIngredient itemInput;
        private String infuseType;

        public Remove(String name, Map<InfusionInput, MetallurgicInfuserRecipe> map, IIngredient itemOutput, IIngredient itemInput, String infuseType) {
            super(name, map);
            this.itemOutput = itemOutput;
            this.itemInput = itemInput;
            this.infuseType = infuseType;
        }

        @Override
        public void addRecipes() {
            HashMap<InfusionInput, MetallurgicInfuserRecipe> recipesToRemove = new HashMap<InfusionInput, MetallurgicInfuserRecipe>();
            for (Map.Entry<InfusionInput, MetallurgicInfuserRecipe> entry : RecipeHandler.Recipe.METALLURGIC_INFUSER.get().entrySet()) {
                IItemStack inputItem = InputHelper.toIItemStack((ItemStack)entry.getKey().inputStack);
                String typeInfuse = entry.getKey().infuse.type.name;
                IItemStack outputItem = InputHelper.toIItemStack((ItemStack)((ItemStackOutput)entry.getValue().recipeOutput).output);
                if (!StackHelper.matches((IIngredient)this.itemOutput, (IItemStack)outputItem) || !StackHelper.matches((IIngredient)this.itemInput, (IItemStack)inputItem) || !this.infuseType.isEmpty() && !this.infuseType.equalsIgnoreCase(typeInfuse)) continue;
                recipesToRemove.put(entry.getKey(), entry.getValue());
            }
            if (!recipesToRemove.isEmpty()) {
                this.recipes.putAll(recipesToRemove);
            } else {
                LogHelper.logInfo((String)String.format("No %s recipe found for %s and %s. Command ignored!", Infuser.NAME, this.itemInput.toString(), this.itemOutput.toString()));
            }
        }
    }
}

