/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.gas;

import crafttweaker.CraftTweakerAPI;
import crafttweaker.annotations.BracketHandler;
import crafttweaker.annotations.ModOnly;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.item.IngredientAny;
import crafttweaker.zenscript.IBracketHandler;
import java.util.List;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasRegistry;
import mekanism.api.gas.GasStack;
import mekanism.common.integration.crafttweaker.gas.CraftTweakerGasStack;
import mekanism.common.integration.crafttweaker.gas.IGasStack;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.expression.ExpressionCallStatic;
import stanhebben.zenscript.expression.ExpressionString;
import stanhebben.zenscript.expression.partial.IPartialExpression;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.util.ZenPosition;

@BracketHandler(priority=100)
@ModOnly(value="mtlib")
@ZenRegister
public class GasBracketHandler
implements IBracketHandler {
    private final IZenSymbol symbolAny = CraftTweakerAPI.getJavaStaticFieldSymbol(IngredientAny.class, (String)"INSTANCE");
    private final IJavaMethod method = CraftTweakerAPI.getJavaMethod(GasBracketHandler.class, (String)"getGas", (Class[])new Class[]{String.class});

    public static IGasStack getGas(String name) {
        Gas gas = GasRegistry.getGas(name);
        if (gas != null) {
            return new CraftTweakerGasStack(new GasStack(gas, 1));
        }
        return null;
    }

    public IZenSymbol resolve(IEnvironmentGlobal environment, List<Token> tokens) {
        if (tokens.size() == 1 && tokens.get(0).getValue().equals("*")) {
            return this.symbolAny;
        }
        if (tokens.size() > 2 && tokens.get(0).getValue().equals("gas") && tokens.get(1).getValue().equals(":")) {
            return this.find(environment, tokens, 2, tokens.size());
        }
        return null;
    }

    private IZenSymbol find(IEnvironmentGlobal environment, List<Token> tokens, int startIndex, int endIndex) {
        StringBuilder valueBuilder = new StringBuilder();
        for (int i = startIndex; i < endIndex; ++i) {
            Token token = tokens.get(i);
            valueBuilder.append(token.getValue());
        }
        Gas gas = GasRegistry.getGas(valueBuilder.toString());
        if (gas != null) {
            return new GasReferenceSymbol(environment, valueBuilder.toString());
        }
        return null;
    }

    private class GasReferenceSymbol
    implements IZenSymbol {
        private final IEnvironmentGlobal environment;
        private final String name;

        public GasReferenceSymbol(IEnvironmentGlobal environment, String name) {
            this.environment = environment;
            this.name = name;
        }

        public IPartialExpression instance(ZenPosition zenPosition) {
            return new ExpressionCallStatic(zenPosition, this.environment, GasBracketHandler.this.method, new Expression[]{new ExpressionString(zenPosition, this.name)});
        }
    }
}

