/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.integration.aelib;

import c4.conarm.lib.materials.ArmorMaterialType;
import java.util.HashMap;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.softc.armoryexpansion.integration.plugins.tinkers_construct.TiCMaterial;

public class Config {
    private static final String TRAIT = "trait";
    static final String CATEGORY_MATERIAL = "material";
    private static final String CATEGORY_ARMOR = "armor";
    private static final String CATEGORY_TOOL = "tool";
    private static final String CATEGORY_BOW = "bow";
    private Map<String, Map<String, Property>> properties = new HashMap<String, Map<String, Property>>();
    private Configuration configuration;

    Config(Configuration configuration) {
        this.configuration = configuration;
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    public Property getProperty(String material, String property) {
        return this.getProperties(material).get(property);
    }

    Map<String, Property> getProperties(String material) {
        return this.properties.get(material);
    }

    private Property addMaterialProperty(TiCMaterial material) {
        return this.configuration.get(material.getIdentifier(), "enable_material", "true", "Whether " + material.getIdentifier() + " should be available");
    }

    private Property addMaterialPartProperty(TiCMaterial material, String part, String category) {
        return this.configuration.get(material.getIdentifier() + "." + category, "enable_" + part, "true", "Whether " + material.getIdentifier() + " should be available for " + part);
    }

    private Property addMaterialTraitProperty(TiCMaterial material) {
        return this.configuration.get(material.getIdentifier(), "enable_traits", "true", "Whether " + material.getIdentifier() + " should be assigned traits");
    }

    private void putSubcategoryProperty(Map<String, Property> materialProperties, String subcategory, String part, TiCMaterial material) {
        this.configuration.getCategory(material.getIdentifier() + "." + subcategory);
        materialProperties.put(part, this.addMaterialPartProperty(material, part, subcategory));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void syncConfig(Map<String, TiCMaterial> materials) {
        try {
            this.configuration.load();
            for (TiCMaterial material : materials.values()) {
                HashMap<String, Property> materialProperties = new HashMap<String, Property>();
                if (!this.properties.containsKey(material.getIdentifier())) {
                    this.configuration.getCategory(material.getIdentifier());
                    materialProperties.put(CATEGORY_MATERIAL, this.addMaterialProperty(material));
                    materialProperties.put(TRAIT, this.addMaterialTraitProperty(material));
                    if (material.isArmorMaterial()) {
                        this.putSubcategoryProperty(materialProperties, CATEGORY_ARMOR, ArmorMaterialType.CORE, material);
                        this.putSubcategoryProperty(materialProperties, CATEGORY_ARMOR, ArmorMaterialType.TRIM, material);
                        this.putSubcategoryProperty(materialProperties, CATEGORY_ARMOR, ArmorMaterialType.PLATES, material);
                    }
                    if (material.isToolMaterial()) {
                        this.putSubcategoryProperty(materialProperties, CATEGORY_TOOL, "head", material);
                        this.putSubcategoryProperty(materialProperties, CATEGORY_TOOL, "handle", material);
                        this.putSubcategoryProperty(materialProperties, CATEGORY_TOOL, "extra", material);
                    }
                    if (material.isFletchingMaterial()) {
                        this.putSubcategoryProperty(materialProperties, CATEGORY_BOW, "fletching", material);
                    }
                    if (material.isBowMaterial()) {
                        this.putSubcategoryProperty(materialProperties, CATEGORY_BOW, CATEGORY_BOW, material);
                        this.putSubcategoryProperty(materialProperties, CATEGORY_BOW, "shaft", material);
                    }
                    if (material.isProjectileMaterial()) {
                        this.putSubcategoryProperty(materialProperties, CATEGORY_BOW, "projectile", material);
                    }
                }
                this.properties.put(material.getIdentifier(), materialProperties);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (this.configuration.hasChanged()) {
                this.configuration.save();
            }
        }
    }
}

