/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.dynamic_systems.dynamic_materials;

import java.util.ArrayList;
import net.minecraftforge.common.config.Property;
import org.softc.armoryexpansion.ArmoryExpansion;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.Material;

public final class Config {
    private static final ArrayList<Property> propertiesMaterials = new ArrayList();
    private static final ArrayList<Property> propertiesCore = new ArrayList();
    private static final ArrayList<Property> propertiesPlates = new ArrayList();
    private static final ArrayList<Property> propertiesTrim = new ArrayList();
    private static final ArrayList<Property> propertiesTrait = new ArrayList();
    private static final String CORES = "cores";
    private static final String EXTRA = "extra";
    private static final String HANDLE = "handle";
    private static final String HEAD = "head";
    private static final String PLATES = "plates";
    private static final String TRIMS = "trims";

    public static ArrayList<Property> getPropertiesMaterials() {
        return propertiesMaterials;
    }

    private static Property getProperty(ArrayList<Property> list, int index) {
        return list.get(index);
    }

    private static Boolean hasProperty(ArrayList<Property> list, int index) {
        return list.size() >= index && Config.getProperty(list, index) != null;
    }

    public static Property getMaterialProperty(int index) {
        return Config.getProperty(propertiesMaterials, index);
    }

    public static Boolean hasMaterialProperty(int index) {
        return Config.hasProperty(propertiesMaterials, index);
    }

    public static Property getCoreProperty(int index) {
        return Config.getProperty(propertiesCore, index);
    }

    public static Boolean hasCoreProperty(int index) {
        return Config.hasProperty(propertiesCore, index);
    }

    public static Property getPlatesProperty(int index) {
        return Config.getProperty(propertiesPlates, index);
    }

    public static Boolean hasPlatesProperty(int index) {
        return Config.hasProperty(propertiesPlates, index);
    }

    public static Property getTrimProperty(int index) {
        return Config.getProperty(propertiesTrim, index);
    }

    public static Boolean hasTrimProperty(int index) {
        return Config.hasProperty(propertiesTrim, index);
    }

    public static Property getTraitProperty(int index) {
        return Config.getProperty(propertiesTrait, index);
    }

    public static Boolean hasTraitProperty(int index) {
        return Config.hasProperty(propertiesTrait, index);
    }

    private static void addMaterialProperty(Material material, String part) {
        ArrayList<Object> properties = new ArrayList();
        switch (part) {
            case "cores": {
                properties = propertiesCore;
                break;
            }
            case "plates": {
                properties = propertiesPlates;
                break;
            }
            case "trims": {
                properties = propertiesTrim;
                break;
            }
        }
        if (material != null) {
            properties.add(ArmoryExpansion.config.get(material.getIdentifier(), "enable_" + part, "true", "Whether " + material.getLocalizedName() + " should be used for " + part));
        } else {
            properties.add(null);
        }
    }

    private static void addTraitProperty(Material material) {
        if (material != null) {
            propertiesTrait.add(ArmoryExpansion.config.get(material.getIdentifier(), "enable_traits", "true", "Whether " + material.getLocalizedName() + " should be assigned traits"));
        } else {
            propertiesTrait.add(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void syncConfig() {
        try {
            ArmoryExpansion.config.load();
            for (Material material : TinkerRegistry.getAllMaterials()) {
                boolean core = !material.hasStats("core") && material.hasStats(HEAD);
                boolean plates = !material.hasStats(PLATES) && material.hasStats(HANDLE);
                boolean trim = !material.hasStats("trim") && material.hasStats(EXTRA);
                boolean mat = core || plates || trim;
                if (!mat) continue;
                ArmoryExpansion.config.getCategory(material.getIdentifier());
                propertiesMaterials.add(ArmoryExpansion.config.get(material.getIdentifier(), "enable_" + material.getIdentifier(), "true", "Global toggle for the " + material.getLocalizedName() + " material"));
                if (core) {
                    Config.addMaterialProperty(material, CORES);
                } else {
                    Config.addMaterialProperty(null, CORES);
                }
                if (plates) {
                    Config.addMaterialProperty(material, PLATES);
                } else {
                    Config.addMaterialProperty(null, PLATES);
                }
                if (trim) {
                    Config.addMaterialProperty(material, TRIMS);
                } else {
                    Config.addMaterialProperty(null, TRIMS);
                }
                Config.addTraitProperty(material);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (ArmoryExpansion.config.hasChanged()) {
                ArmoryExpansion.config.save();
            }
        }
    }
}

