/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.integration.jei.transmutator;

import java.awt.Color;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.translation.I18n;

public class TransmutationRecipe
implements IRecipeWrapper {
    @Nonnull
    private final List<List<ItemStack>> input;
    @Nonnull
    private final List<ItemStack> outputs;
    @Nullable
    private final String experienceString;

    public TransmutationRecipe(@Nonnull List<ItemStack> input, @Nonnull ItemStack output, float experience) {
        this.input = Collections.singletonList(input);
        this.outputs = Collections.singletonList(output);
        this.experienceString = (double)experience > 0.0 ? I18n.func_74837_a((String)"gui.jei.category.smelting.experience", (Object[])new Object[]{Float.valueOf(experience)}) : null;
    }

    @Nonnull
    public List<List<ItemStack>> getInputs() {
        return this.input;
    }

    @Nonnull
    public List<ItemStack> getOutputs() {
        return this.outputs;
    }

    public void drawInfo(@Nonnull Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        if (this.experienceString != null) {
            FontRenderer fontRendererObj = minecraft.field_71466_p;
            fontRendererObj.func_78276_b(this.experienceString, 69 - fontRendererObj.func_78256_a(this.experienceString) / 2, 0, Color.gray.getRGB());
        }
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInputLists(ItemStack.class, this.input);
        ingredients.setOutputs(ItemStack.class, this.outputs);
    }
}

