/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.common.structures.dreadlands.mineshaft;

import com.shinoow.abyssalcraft.api.block.ACBlocks;
import com.shinoow.abyssalcraft.lib.ACLoot;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityMinecartChest;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.MapGenStructureIO;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class StructureDreadlandsMinePieces {
    public static void registerStructurePieces() {
        MapGenStructureIO.func_143031_a(Corridor.class, (String)"DLMSCorridor");
        MapGenStructureIO.func_143031_a(Cross.class, (String)"DLMSCrossing");
        MapGenStructureIO.func_143031_a(Room.class, (String)"DLMSRoom");
        MapGenStructureIO.func_143031_a(Stairs.class, (String)"DLMSStairs");
    }

    private static StructureComponent getRandomComponent(List<StructureComponent> par0List, Random par1Random, int par2, int par3, int par4, EnumFacing par5, int par6) {
        int j1 = par1Random.nextInt(100);
        if (j1 >= 80) {
            StructureBoundingBox structureboundingbox = Cross.findValidPlacement(par0List, par1Random, par2, par3, par4, par5);
            if (structureboundingbox != null) {
                return new Cross(par6, par1Random, structureboundingbox, par5);
            }
        } else if (j1 >= 70) {
            StructureBoundingBox structureboundingbox = Stairs.findValidPlacement(par0List, par1Random, par2, par3, par4, par5);
            if (structureboundingbox != null) {
                return new Stairs(par6, par1Random, structureboundingbox, par5);
            }
        } else {
            StructureBoundingBox structureboundingbox = Corridor.findValidPlacement(par0List, par1Random, par2, par3, par4, par5);
            if (structureboundingbox != null) {
                return new Corridor(par6, par1Random, structureboundingbox, par5);
            }
        }
        return null;
    }

    private static StructureComponent getNextMineShaftComponent(StructureComponent par0StructureComponent, List<StructureComponent> par1List, Random par2Random, int par3, int par4, int par5, EnumFacing par6, int par7) {
        if (par7 > 8) {
            return null;
        }
        if (Math.abs(par3 - par0StructureComponent.func_74874_b().field_78897_a) <= 80 && Math.abs(par5 - par0StructureComponent.func_74874_b().field_78896_c) <= 80) {
            StructureComponent structurecomponent1 = StructureDreadlandsMinePieces.getRandomComponent(par1List, par2Random, par3, par4, par5, par6, par7 + 1);
            if (structurecomponent1 != null) {
                par1List.add(structurecomponent1);
                structurecomponent1.func_74861_a(par0StructureComponent, par1List, par2Random);
            }
            return structurecomponent1;
        }
        return null;
    }

    public static class Stairs
    extends StructureComponent {
        public Stairs() {
        }

        public Stairs(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, EnumFacing par4) {
            super(par1);
            this.func_186164_a(par4);
            this.field_74887_e = par3StructureBoundingBox;
        }

        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
        }

        protected void func_143011_b(NBTTagCompound par1NBTTagCompound, TemplateManager p_143011_2_) {
        }

        public static StructureBoundingBox findValidPlacement(List<StructureComponent> par0List, Random par1Random, int par2, int par3, int par4, EnumFacing par5) {
            StructureBoundingBox structureboundingbox = new StructureBoundingBox(par2, par3 - 5, par4, par2, par3 + 2, par4);
            switch (par5) {
                case SOUTH: {
                    structureboundingbox.field_78893_d = par2 + 2;
                    structureboundingbox.field_78892_f = par4 + 8;
                    break;
                }
                case WEST: {
                    structureboundingbox.field_78897_a = par2 - 8;
                    structureboundingbox.field_78892_f = par4 + 2;
                    break;
                }
                case NORTH: {
                    structureboundingbox.field_78893_d = par2 + 2;
                    structureboundingbox.field_78896_c = par4 - 8;
                    break;
                }
                case EAST: {
                    structureboundingbox.field_78893_d = par2 + 8;
                    structureboundingbox.field_78892_f = par4 + 2;
                }
            }
            return StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) != null ? null : structureboundingbox;
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            int i = this.func_74877_c();
            switch (this.func_186165_e()) {
                case SOUTH: {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                    break;
                }
                case WEST: {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.WEST, i);
                    break;
                }
                case NORTH: {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                    break;
                }
                case EAST: {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, EnumFacing.EAST, i);
                }
            }
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_175804_a(par1World, par3StructureBoundingBox, 0, 5, 0, 2, 7, 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(par1World, par3StructureBoundingBox, 0, 0, 7, 2, 2, 8, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            for (int i = 0; i < 5; ++i) {
                this.func_175804_a(par1World, par3StructureBoundingBox, 0, 5 - i - (i < 4 ? 1 : 0), 2 + i, 2, 7 - i, 2 + i, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            return true;
        }
    }

    public static class Room
    extends StructureComponent {
        private List<StructureBoundingBox> roomsLinkedToTheRoom = new LinkedList<StructureBoundingBox>();

        public Room() {
        }

        public Room(int par1, Random par2Random, int par3, int par4) {
            super(par1);
            this.field_74887_e = new StructureBoundingBox(par3, 50, par4, par3 + 7 + par2Random.nextInt(6), 54 + par2Random.nextInt(6), par4 + 7 + par2Random.nextInt(6));
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            StructureBoundingBox structureboundingbox;
            StructureComponent structurecomponent1;
            int j;
            int i = this.func_74877_c();
            int k = this.field_74887_e.func_78882_c() - 3 - 1;
            if (k <= 0) {
                k = 1;
            }
            for (j = 0; j < this.field_74887_e.func_78883_b() && (j += par3Random.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); j += 4) {
                structurecomponent1 = StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + j, this.field_74887_e.field_78895_b + par3Random.nextInt(k) + 1, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                if (structurecomponent1 == null) continue;
                structureboundingbox = structurecomponent1.func_74874_b();
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(structureboundingbox.field_78897_a, structureboundingbox.field_78895_b, this.field_74887_e.field_78896_c, structureboundingbox.field_78893_d, structureboundingbox.field_78894_e, this.field_74887_e.field_78896_c + 1));
            }
            for (j = 0; j < this.field_74887_e.func_78883_b() && (j += par3Random.nextInt(this.field_74887_e.func_78883_b())) + 3 <= this.field_74887_e.func_78883_b(); j += 4) {
                structurecomponent1 = StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + j, this.field_74887_e.field_78895_b + par3Random.nextInt(k) + 1, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                if (structurecomponent1 == null) continue;
                structureboundingbox = structurecomponent1.func_74874_b();
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(structureboundingbox.field_78897_a, structureboundingbox.field_78895_b, this.field_74887_e.field_78892_f - 1, structureboundingbox.field_78893_d, structureboundingbox.field_78894_e, this.field_74887_e.field_78892_f));
            }
            for (j = 0; j < this.field_74887_e.func_78880_d() && (j += par3Random.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); j += 4) {
                structurecomponent1 = StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + par3Random.nextInt(k) + 1, this.field_74887_e.field_78896_c + j, EnumFacing.WEST, i);
                if (structurecomponent1 == null) continue;
                structureboundingbox = structurecomponent1.func_74874_b();
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(this.field_74887_e.field_78897_a, structureboundingbox.field_78895_b, structureboundingbox.field_78896_c, this.field_74887_e.field_78897_a + 1, structureboundingbox.field_78894_e, structureboundingbox.field_78892_f));
            }
            for (j = 0; j < this.field_74887_e.func_78880_d() && (j += par3Random.nextInt(this.field_74887_e.func_78880_d())) + 3 <= this.field_74887_e.func_78880_d(); j += 4) {
                structurecomponent1 = StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + par3Random.nextInt(k) + 1, this.field_74887_e.field_78896_c + j, EnumFacing.EAST, i);
                if (structurecomponent1 == null) continue;
                structureboundingbox = structurecomponent1.func_74874_b();
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(this.field_74887_e.field_78893_d - 1, structureboundingbox.field_78895_b, structureboundingbox.field_78896_c, this.field_74887_e.field_78893_d, structureboundingbox.field_78894_e, structureboundingbox.field_78892_f));
            }
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            this.func_175804_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f, ACBlocks.dreadlands_grass.func_176223_P(), Blocks.field_150350_a.func_176223_P(), true);
            this.func_175804_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 1, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, Math.min(this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78894_e), this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            for (StructureBoundingBox structureboundingbox1 : this.roomsLinkedToTheRoom) {
                this.func_175804_a(par1World, par3StructureBoundingBox, structureboundingbox1.field_78897_a, structureboundingbox1.field_78894_e - 2, structureboundingbox1.field_78896_c, structureboundingbox1.field_78893_d, structureboundingbox1.field_78894_e, structureboundingbox1.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            this.func_180777_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b + 4, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), false);
            return true;
        }

        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            NBTTagList nbttaglist = new NBTTagList();
            for (StructureBoundingBox structureboundingbox : this.roomsLinkedToTheRoom) {
                nbttaglist.func_74742_a((NBTBase)structureboundingbox.func_151535_h());
            }
            par1NBTTagCompound.func_74782_a("Entrances", (NBTBase)nbttaglist);
        }

        protected void func_143011_b(NBTTagCompound par1NBTTagCompound, TemplateManager p_143011_2_) {
            NBTTagList nbttaglist = par1NBTTagCompound.func_150295_c("Entrances", 11);
            for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
                this.roomsLinkedToTheRoom.add(new StructureBoundingBox(nbttaglist.func_150306_c(i)));
            }
        }
    }

    public static class Cross
    extends StructureComponent {
        private EnumFacing corridorDirection;
        private boolean isMultipleFloors;

        public Cross() {
        }

        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            par1NBTTagCompound.func_74757_a("tf", this.isMultipleFloors);
            par1NBTTagCompound.func_74768_a("D", this.corridorDirection.func_176736_b());
        }

        protected void func_143011_b(NBTTagCompound par1NBTTagCompound, TemplateManager p_143011_2_) {
            this.isMultipleFloors = par1NBTTagCompound.func_74767_n("tf");
            this.corridorDirection = EnumFacing.func_176731_b((int)par1NBTTagCompound.func_74762_e("D"));
        }

        public Cross(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, EnumFacing par4) {
            super(par1);
            this.corridorDirection = par4;
            this.field_74887_e = par3StructureBoundingBox;
            this.isMultipleFloors = par3StructureBoundingBox.func_78882_c() > 3;
        }

        public static StructureBoundingBox findValidPlacement(List<StructureComponent> par0List, Random par1Random, int par2, int par3, int par4, EnumFacing par5) {
            StructureBoundingBox structureboundingbox = new StructureBoundingBox(par2, par3, par4, par2, par3 + 2, par4);
            if (par1Random.nextInt(4) == 0) {
                structureboundingbox.field_78894_e += 4;
            }
            switch (par5) {
                case SOUTH: {
                    structureboundingbox.field_78897_a = par2 - 1;
                    structureboundingbox.field_78893_d = par2 + 3;
                    structureboundingbox.field_78892_f = par4 + 4;
                    break;
                }
                case WEST: {
                    structureboundingbox.field_78897_a = par2 - 4;
                    structureboundingbox.field_78896_c = par4 - 1;
                    structureboundingbox.field_78892_f = par4 + 3;
                    break;
                }
                case NORTH: {
                    structureboundingbox.field_78897_a = par2 - 1;
                    structureboundingbox.field_78893_d = par2 + 3;
                    structureboundingbox.field_78896_c = par4 - 4;
                    break;
                }
                case EAST: {
                    structureboundingbox.field_78893_d = par2 + 4;
                    structureboundingbox.field_78896_c = par4 - 1;
                    structureboundingbox.field_78892_f = par4 + 3;
                }
            }
            return StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) != null ? null : structureboundingbox;
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            int i = this.func_74877_c();
            switch (this.corridorDirection) {
                case SOUTH: {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, i);
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, i);
                    break;
                }
                case WEST: {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, i);
                    break;
                }
                case NORTH: {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, i);
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, i);
                    break;
                }
                case EAST: {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, i);
                }
            }
            if (this.isMultipleFloors) {
                if (par3Random.nextBoolean()) {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                }
                if (par3Random.nextBoolean()) {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, EnumFacing.WEST, i);
                }
                if (par3Random.nextBoolean()) {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78896_c + 1, EnumFacing.EAST, i);
                }
                if (par3Random.nextBoolean()) {
                    StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3 + 1, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                }
            }
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            if (this.isMultipleFloors) {
                this.func_175804_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78895_b + 3 - 1, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78894_e - 2, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b + 3, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            } else {
                this.func_175804_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            }
            this.func_175804_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78896_c + 1, ACBlocks.dreadlands_planks.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78897_a + 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, ACBlocks.dreadlands_planks.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c + 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78896_c + 1, ACBlocks.dreadlands_planks.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_175804_a(par1World, par3StructureBoundingBox, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f - 1, this.field_74887_e.field_78893_d - 1, this.field_74887_e.field_78894_e, this.field_74887_e.field_78892_f - 1, ACBlocks.dreadlands_planks.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            for (int i = this.field_74887_e.field_78897_a; i <= this.field_74887_e.field_78893_d; ++i) {
                for (int j = this.field_74887_e.field_78896_c; j <= this.field_74887_e.field_78892_f; ++j) {
                    if (this.func_175807_a(par1World, i, this.field_74887_e.field_78895_b - 1, j, par3StructureBoundingBox).func_185904_a() != Material.field_151579_a) continue;
                    this.func_175811_a(par1World, ACBlocks.dreadlands_planks.func_176223_P(), i, this.field_74887_e.field_78895_b - 1, j, par3StructureBoundingBox);
                }
            }
            return true;
        }
    }

    public static class Corridor
    extends StructureComponent {
        private boolean hasRails;
        private int sectionCount;

        public Corridor() {
        }

        protected void func_143012_a(NBTTagCompound par1NBTTagCompound) {
            par1NBTTagCompound.func_74757_a("hr", this.hasRails);
            par1NBTTagCompound.func_74768_a("Num", this.sectionCount);
        }

        protected void func_143011_b(NBTTagCompound par1NBTTagCompound, TemplateManager p_143011_2_) {
            this.hasRails = par1NBTTagCompound.func_74767_n("hr");
            this.sectionCount = par1NBTTagCompound.func_74762_e("Num");
        }

        public Corridor(int par1, Random par2Random, StructureBoundingBox par3StructureBoundingBox, EnumFacing par4) {
            super(par1);
            this.func_186164_a(par4);
            this.field_74887_e = par3StructureBoundingBox;
            this.hasRails = par2Random.nextInt(3) == 0;
            this.sectionCount = this.func_186165_e() != EnumFacing.NORTH && this.func_186165_e() != EnumFacing.SOUTH ? par3StructureBoundingBox.func_78883_b() / 5 : par3StructureBoundingBox.func_78880_d() / 5;
        }

        public static StructureBoundingBox findValidPlacement(List<StructureComponent> par0List, Random par1Random, int par2, int par3, int par4, EnumFacing par5) {
            int i1;
            StructureBoundingBox structureboundingbox = new StructureBoundingBox(par2, par3, par4, par2, par3 + 2, par4);
            for (i1 = par1Random.nextInt(3) + 2; i1 > 0; --i1) {
                int j1 = i1 * 5;
                switch (par5) {
                    case SOUTH: {
                        structureboundingbox.field_78893_d = par2 + 2;
                        structureboundingbox.field_78892_f = par4 + j1 - 1;
                        break;
                    }
                    case WEST: {
                        structureboundingbox.field_78897_a = par2 - (j1 - 1);
                        structureboundingbox.field_78892_f = par4 + 2;
                        break;
                    }
                    case NORTH: {
                        structureboundingbox.field_78893_d = par2 + 2;
                        structureboundingbox.field_78896_c = par4 - (j1 - 1);
                        break;
                    }
                    case EAST: {
                        structureboundingbox.field_78893_d = par2 + j1 - 1;
                        structureboundingbox.field_78892_f = par4 + 2;
                    }
                }
                if (StructureComponent.func_74883_a(par0List, (StructureBoundingBox)structureboundingbox) == null) break;
            }
            return i1 > 0 ? structureboundingbox : null;
        }

        public void func_74861_a(StructureComponent par1StructureComponent, List par2List, Random par3Random) {
            block24: {
                int i = this.func_74877_c();
                int j = par3Random.nextInt(4);
                switch (this.func_186165_e()) {
                    case SOUTH: {
                        if (j <= 1) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78892_f + 1, this.func_186165_e(), i);
                            break;
                        }
                        if (j == 2) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78892_f - 3, EnumFacing.WEST, i);
                            break;
                        }
                        StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78892_f - 3, EnumFacing.EAST, i);
                        break;
                    }
                    case WEST: {
                        if (j <= 1) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78896_c, this.func_186165_e(), i);
                            break;
                        }
                        if (j == 2) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                            break;
                        }
                        StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                        break;
                    }
                    case NORTH: {
                        if (j <= 1) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78896_c - 1, this.func_186165_e(), i);
                            break;
                        }
                        if (j == 2) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78896_c, EnumFacing.WEST, i);
                            break;
                        }
                        StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78896_c, EnumFacing.EAST, i);
                        break;
                    }
                    case EAST: {
                        if (j <= 1) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78896_c, this.func_186165_e(), i);
                            break;
                        }
                        if (j == 2) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i);
                            break;
                        }
                        StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d - 3, this.field_74887_e.field_78895_b - 1 + par3Random.nextInt(3), this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i);
                    }
                }
                if (i >= 8) break block24;
                if (this.func_186165_e() != EnumFacing.NORTH && this.func_186165_e() != EnumFacing.SOUTH) {
                    int k = this.field_74887_e.field_78897_a + 3;
                    while (k + 3 <= this.field_74887_e.field_78893_d) {
                        int l = par3Random.nextInt(5);
                        if (l == 0) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, k, this.field_74887_e.field_78895_b, this.field_74887_e.field_78896_c - 1, EnumFacing.NORTH, i + 1);
                        } else if (l == 1) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, k, this.field_74887_e.field_78895_b, this.field_74887_e.field_78892_f + 1, EnumFacing.SOUTH, i + 1);
                        }
                        k += 5;
                    }
                } else {
                    int k = this.field_74887_e.field_78896_c + 3;
                    while (k + 3 <= this.field_74887_e.field_78892_f) {
                        int l = par3Random.nextInt(5);
                        if (l == 0) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78897_a - 1, this.field_74887_e.field_78895_b, k, EnumFacing.SOUTH, i + 1);
                        } else if (l == 1) {
                            StructureDreadlandsMinePieces.getNextMineShaftComponent(par1StructureComponent, par2List, par3Random, this.field_74887_e.field_78893_d + 1, this.field_74887_e.field_78895_b, k, EnumFacing.WEST, i + 1);
                        }
                        k += 5;
                    }
                }
            }
        }

        protected boolean func_186167_a(World world, StructureBoundingBox structureboundingbox, Random rand, int x, int y, int z, ResourceLocation loot) {
            BlockPos blockpos = new BlockPos(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
            if (structureboundingbox.func_175898_b((Vec3i)blockpos) && world.func_180495_p(blockpos).func_185904_a() == Material.field_151579_a) {
                IBlockState iblockstate = Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)(rand.nextBoolean() ? BlockRailBase.EnumRailDirection.NORTH_SOUTH : BlockRailBase.EnumRailDirection.EAST_WEST));
                this.func_175811_a(world, iblockstate, x, y, z, structureboundingbox);
                EntityMinecartChest entityminecartchest = new EntityMinecartChest(world, (double)((float)blockpos.func_177958_n() + 0.5f), (double)((float)blockpos.func_177956_o() + 0.5f), (double)((float)blockpos.func_177952_p() + 0.5f));
                entityminecartchest.func_184289_a(loot, rand.nextLong());
                world.func_72838_d((Entity)entityminecartchest);
                return true;
            }
            return false;
        }

        public boolean func_74875_a(World par1World, Random par2Random, StructureBoundingBox par3StructureBoundingBox) {
            int k;
            int j;
            if (this.func_74860_a(par1World, par3StructureBoundingBox)) {
                return false;
            }
            int i = this.sectionCount * 5 - 1;
            this.func_175804_a(par1World, par3StructureBoundingBox, 0, 0, 0, 2, 1, i, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
            this.func_189914_a(par1World, par3StructureBoundingBox, par2Random, 0.8f, 0, 2, 0, 2, 2, i, Blocks.field_150350_a.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false, 0);
            for (j = 0; j < this.sectionCount; ++j) {
                k = 2 + j * 5;
                this.func_175804_a(par1World, par3StructureBoundingBox, 0, 0, k, 0, 1, k, ACBlocks.dreadlands_wood_fence.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                this.func_175804_a(par1World, par3StructureBoundingBox, 2, 0, k, 2, 1, k, ACBlocks.dreadlands_wood_fence.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                if (par2Random.nextInt(4) == 0) {
                    this.func_175804_a(par1World, par3StructureBoundingBox, 0, 2, k, 0, 2, k, ACBlocks.dreadlands_planks.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                    this.func_175804_a(par1World, par3StructureBoundingBox, 2, 2, k, 2, 2, k, ACBlocks.dreadlands_planks.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                } else {
                    this.func_175804_a(par1World, par3StructureBoundingBox, 0, 2, k, 2, 2, k, ACBlocks.dreadlands_planks.func_176223_P(), Blocks.field_150350_a.func_176223_P(), false);
                }
                this.func_175809_a(par1World, par3StructureBoundingBox, par2Random, 0.05f, 1, 2, k - 1, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH));
                this.func_175809_a(par1World, par3StructureBoundingBox, par2Random, 0.05f, 1, 2, k + 1, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH));
                if (par2Random.nextInt(100) == 0) {
                    this.func_186167_a(par1World, par3StructureBoundingBox, par2Random, 2, 0, k - 1, ACLoot.CHEST_DREADLANDS_MINESHAFT);
                }
                if (par2Random.nextInt(100) != 0) continue;
                this.func_186167_a(par1World, par3StructureBoundingBox, par2Random, 2, 0, k + 1, ACLoot.CHEST_DREADLANDS_MINESHAFT);
            }
            for (j = 0; j <= 2; ++j) {
                for (k = 0; k <= i; ++k) {
                    int b0 = -1;
                    IBlockState block1 = this.func_175807_a(par1World, j, b0, k, par3StructureBoundingBox);
                    if (block1.func_185904_a() != Material.field_151579_a) continue;
                    int b1 = -1;
                    this.func_175811_a(par1World, ACBlocks.dreadlands_planks.func_176223_P(), j, b1, k, par3StructureBoundingBox);
                }
            }
            if (this.hasRails) {
                IBlockState iblockstate = Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH);
                for (j = 0; j <= i; ++j) {
                    IBlockState block = this.func_175807_a(par1World, 1, -1, j, par3StructureBoundingBox);
                    if (block.func_185904_a() == Material.field_151579_a || !block.func_185913_b()) continue;
                    this.func_175809_a(par1World, par3StructureBoundingBox, par2Random, 0.7f, 1, 0, j, iblockstate);
                }
            }
            return true;
        }
    }
}

