/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.client.gui.necronomicon;

import com.google.common.collect.Lists;
import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.spell.Spell;
import com.shinoow.abyssalcraft.api.spell.SpellRegistry;
import com.shinoow.abyssalcraft.client.gui.necronomicon.GuiNecronomicon;
import com.shinoow.abyssalcraft.client.gui.necronomicon.buttons.ButtonHome;
import com.shinoow.abyssalcraft.client.gui.necronomicon.buttons.ButtonNextPage;
import com.shinoow.abyssalcraft.lib.NecronomiconResources;
import java.util.List;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import org.lwjgl.input.Keyboard;

public class GuiNecronomiconSpellEntry
extends GuiNecronomicon {
    private ButtonNextPage buttonNextPage;
    private ButtonNextPage buttonNextPageLong;
    private ButtonNextPage buttonPreviousPage;
    private ButtonNextPage buttonPreviousPageLong;
    private GuiButton buttonDone;
    private ButtonHome buttonHome;
    private GuiNecronomicon parent;
    private List<Spell> spells = Lists.newArrayList();

    public GuiNecronomiconSpellEntry(int bookType, GuiNecronomicon gui) {
        super(bookType);
        this.parent = gui;
        this.isInfo = true;
    }

    @Override
    public GuiNecronomicon withBookType(int par1) {
        return super.withBookType(par1);
    }

    @Override
    public void func_73866_w_() {
        if (this.isInvalid) {
            this.field_146297_k.func_147108_a((GuiScreen)this.parent.withBookType(this.getBookType()));
        }
        currentNecro = this;
        if (this.spells.isEmpty()) {
            this.initStuff();
        }
        this.field_146292_n.clear();
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonDone = new GuiButton(0, this.field_146294_l / 2 - 100, 196, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]));
        this.field_146292_n.add(this.buttonDone);
        int i = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        this.buttonNextPage = new ButtonNextPage(1, i + 215, b0 + 154, true, false);
        this.field_146292_n.add(this.buttonNextPage);
        this.buttonNextPageLong = new ButtonNextPage(2, i + 203, b0 + 167, true, true);
        this.field_146292_n.add(this.buttonNextPageLong);
        this.buttonPreviousPage = new ButtonNextPage(3, i + 18, b0 + 154, false, false);
        this.field_146292_n.add(this.buttonPreviousPage);
        this.buttonPreviousPageLong = new ButtonNextPage(4, i + 23, b0 + 167, false, true);
        this.field_146292_n.add(this.buttonPreviousPageLong);
        this.buttonHome = new ButtonHome(5, i + 118, b0 + 167);
        this.field_146292_n.add(this.buttonHome);
        this.updateButtons();
    }

    private void updateButtons() {
        this.buttonNextPage.field_146125_m = this.currTurnup < this.getTurnupLimit() - 1;
        this.buttonNextPageLong.field_146125_m = this.currTurnup < this.getTurnupLimit() - 5;
        this.buttonPreviousPage.field_146125_m = true;
        this.buttonPreviousPageLong.field_146125_m = this.currTurnup > 4;
        this.buttonDone.field_146125_m = true;
        this.buttonHome.field_146125_m = true;
    }

    @Override
    protected void func_146284_a(GuiButton button) {
        if (button.field_146124_l) {
            if (button.field_146127_k == 0) {
                this.field_146297_k.func_147108_a((GuiScreen)null);
            } else if (button.field_146127_k == 1) {
                if (this.currTurnup < this.getTurnupLimit() - 1) {
                    ++this.currTurnup;
                }
            } else if (button.field_146127_k == 2) {
                if (this.currTurnup < this.getTurnupLimit() - 5) {
                    this.currTurnup += 5;
                }
            } else if (button.field_146127_k == 3) {
                if (this.currTurnup == 0) {
                    this.isInfo = false;
                    this.field_146297_k.func_147108_a((GuiScreen)this.parent.withBookType(this.getBookType()));
                } else if (this.currTurnup > 0) {
                    --this.currTurnup;
                }
            } else if (button.field_146127_k == 4) {
                if (this.currTurnup > 4) {
                    this.currTurnup -= 5;
                }
            } else if (button.field_146127_k == 5) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiNecronomicon(this.getBookType()));
            }
        }
        this.updateButtons();
    }

    @Override
    protected void drawInformationText(int x, int y) {
        this.drawPage(this.spells.get(this.currTurnup), x, y);
    }

    private void drawPage(Spell spell, int x, int y) {
        int k = (this.field_146294_l - 255) / 2;
        int b0 = 2;
        String title = spell.getLocalizedName();
        this.field_146289_q.func_78279_b(title, k + 20, b0 + 16, 116, 0xC40000);
        this.writeText(1, "PE per cast: " + spell.getReqEnergy() + " PE", 125);
        this.writeText(1, "Spell Type: " + (spell.requiresCharging() ? "Charging" : "Instant"), 135);
        this.writeText(2, spell.getDescription());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(NecronomiconResources.SPELL);
        this.func_73729_b(k, b0, 0, 0, 256, 256);
        this.tooltipStack = null;
        ItemStack[] offerings = new ItemStack[5];
        if (spell.getReagents().length < 5) {
            for (int i = 0; i < spell.getReagents().length; ++i) {
                offerings[i] = APIUtils.convertToStack(spell.getReagents()[i]);
            }
        } else {
            offerings = this.getStacks(spell.getReagents());
        }
        this.renderItem(k + 58, b0 + 41, offerings[0], x, y);
        this.renderItem(k + 83, b0 + 62, offerings[1], x, y);
        this.renderItem(k + 72, b0 + 91, offerings[2], x, y);
        this.renderItem(k + 45, b0 + 91, offerings[3], x, y);
        this.renderItem(k + 33, b0 + 62, offerings[4], x, y);
        this.renderItem(k + 58, b0 + 66, spell.getParchment(), x, y);
        this.renderTooltip(x, y);
    }

    private ItemStack[] getStacks(Object[] objects) {
        ItemStack[] stacks = new ItemStack[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            stacks[i] = APIUtils.convertToStack(objects[i]);
        }
        return stacks;
    }

    private void initStuff() {
        for (Spell spell : SpellRegistry.instance().getSpells()) {
            if (!this.isUnlocked(spell.getUnlockCondition()) || spell.getBookType() > this.getBookType()) continue;
            this.spells.add(spell);
        }
        this.setTurnupLimit(this.spells.size());
    }
}

