/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.ritual;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.ritual.NecronomiconRitual;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;

public class RitualRegistry {
    private final Map<Integer, Integer> dimToBookType = Maps.newHashMap();
    private final Map<Integer, String> dimToName = Maps.newHashMap();
    private final Map<NecronomiconRitual, Integer> ritualToBookType = Maps.newHashMap();
    private final List<NecronomiconRitual> rituals = Lists.newArrayList();
    private static final RitualRegistry instance = new RitualRegistry();

    public static RitualRegistry instance() {
        return instance;
    }

    public void addDimensionToBookType(int dim, int bookType) {
        if (bookType <= 4 && bookType >= 0) {
            if (dim != -1 && dim != 1) {
                this.dimToBookType.put(dim, bookType);
            } else {
                FMLLog.log((String)"RitualRegistry", (Level)Level.ERROR, (String)"You're not allowed to register that Dimension ID: %d", (Object[])new Object[]{dim});
            }
        } else {
            FMLLog.log((String)"RitualRegistry", (Level)Level.ERROR, (String)"Necronomicon book type does not exist: %d", (Object[])new Object[]{bookType});
        }
    }

    public void addDimensionToName(int dim, String name) {
        if (dim != -1 && dim != 1) {
            this.dimToName.put(dim, name);
        } else {
            FMLLog.log((String)"RitualRegistry", (Level)Level.ERROR, (String)"You're not allowed to register that Dimension ID: %d", (Object[])new Object[]{dim});
        }
    }

    public void addDimensionToBookTypeAndName(int dim, int bookType, String name) {
        this.addDimensionToBookType(dim, bookType);
        this.addDimensionToName(dim, name);
    }

    public boolean canPerformAction(int dim, int bookType) {
        if (!this.dimToBookType.containsKey(dim)) {
            return false;
        }
        return bookType >= this.dimToBookType.get(dim);
    }

    public boolean sameBookType(int dim, int bookType) {
        if (!this.dimToBookType.containsKey(dim)) {
            return false;
        }
        return bookType == this.dimToBookType.get(dim);
    }

    public void registerRitual(NecronomiconRitual ritual) {
        if (ritual.getBookType() <= 4 && ritual.getBookType() >= 0) {
            for (NecronomiconRitual entry : this.rituals) {
                if (!ritual.getUnlocalizedName().equals(entry.getUnlocalizedName())) continue;
                FMLLog.log((String)"RitualRegistry", (Level)Level.ERROR, (String)"Necronomicon Ritual already registered: %s", (Object[])new Object[]{ritual.getUnlocalizedName()});
                return;
            }
            this.rituals.add(ritual);
        } else {
            FMLLog.log((String)"RitualRegistry", (Level)Level.ERROR, (String)"Necronomicon book type does not exist: %d", (Object[])new Object[]{ritual.getBookType()});
        }
    }

    public List<NecronomiconRitual> getRituals() {
        return this.rituals;
    }

    public Map<Integer, String> getDimensionNameMappings() {
        return this.dimToName;
    }

    public NecronomiconRitual getRitual(int dimension, int bookType, ItemStack[] offerings, ItemStack sacrifice) {
        for (NecronomiconRitual ritual : this.rituals) {
            if (!this.areRitualsSame(ritual, dimension, bookType, offerings, sacrifice)) continue;
            return ritual;
        }
        return null;
    }

    private boolean areRitualsSame(NecronomiconRitual ritual, int dimension, int bookType, ItemStack[] offerings, ItemStack sacrifice) {
        return (ritual.getDimension() == dimension || ritual.getDimension() == -1) && ritual.getBookType() <= bookType && ritual.getOfferings() != null && offerings != null && APIUtils.areItemStackArraysEqual(ritual.getOfferings(), offerings, ritual.isNBTSensitive()) && (ritual.requiresItemSacrifice() || ritual.getSacrifice() == null && sacrifice.func_190926_b() || APIUtils.areObjectsEqual(sacrifice, ritual.getSacrifice(), ritual.isSacrificeNBTSensitive()));
    }

    @Deprecated
    public boolean areObjectsEqual(ItemStack stack, Object obj, boolean nbt) {
        return APIUtils.areObjectsEqual(stack, obj, nbt);
    }

    @Deprecated
    public boolean areStacksEqual(ItemStack stack1, ItemStack stack2, boolean nbt) {
        return APIUtils.areStacksEqual(stack1, stack2, nbt);
    }

    @Deprecated
    public boolean areStacksEqual(ItemStack stack1, ItemStack stack2) {
        return APIUtils.areStacksEqual(stack1, stack2);
    }
}

