/*
 * Decompiled with CFR 0.152.
 */
package com.shinoow.abyssalcraft.api.recipe;

import com.google.common.collect.Lists;
import com.shinoow.abyssalcraft.api.APIUtils;
import com.shinoow.abyssalcraft.api.recipe.Materialization;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class MaterializerRecipes {
    private static final MaterializerRecipes materializerBase = new MaterializerRecipes();
    private final List<Materialization> materializationList = Lists.newArrayList();

    public static MaterializerRecipes instance() {
        return materializerBase;
    }

    private MaterializerRecipes() {
    }

    public void materialize(ItemStack[] input, ItemStack output) {
        this.materialize(new Materialization(input, output));
    }

    public void materialize(Materialization materialization) {
        this.materializationList.add(materialization);
    }

    public List<ItemStack> getMaterializationResult(ItemStack stack) {
        ItemStack[] inventory = this.extractItemsFromBag(stack);
        if (inventory == null) {
            return Collections.emptyList();
        }
        ArrayList displayList = Lists.newArrayList();
        for (Materialization mat : this.materializationList) {
            if (!this.arrayContainsOtherArray(inventory, mat.input)) continue;
            displayList.add(mat.output.func_77946_l());
        }
        return displayList;
    }

    public void processMaterialization(ItemStack output, ItemStack bag) {
        int count;
        ItemStack[] inventory = this.extractItemsFromBag(bag);
        if (inventory == null) {
            return;
        }
        Materialization mat = this.getMaterializationFor(output);
        if (mat == null) {
            return;
        }
        int num = output.func_190916_E();
        if (num > 1) {
            for (count = 0; count < num && this.consumeCrystals(inventory, (ItemStack[])mat.input.clone()); ++count) {
            }
        } else {
            this.consumeCrystals(inventory, (ItemStack[])mat.input.clone());
        }
        if (num == 1 || count == num) {
            this.replaceBagContents(bag, inventory);
        }
    }

    public boolean consumeCrystals(ItemStack[] inventory, ItemStack[] input) {
        ItemStack[] invTemp = (ItemStack[])inventory.clone();
        List<ItemStack> recipe = this.makeNonWriteThroughList(input);
        block0: for (int i = 0; i < invTemp.length; ++i) {
            Iterator<ItemStack> iterator = recipe.iterator();
            while (iterator.hasNext()) {
                ItemStack invItem = invTemp[i];
                ItemStack recipeItem = iterator.next();
                if (!this.areStacksEqual(invItem, recipeItem)) continue;
                if (invItem.func_190916_E() >= recipeItem.func_190916_E()) {
                    invItem.func_190918_g(recipeItem.func_190916_E());
                    if (invItem.func_190926_b()) {
                        invTemp[i] = ItemStack.field_190927_a;
                    }
                    recipe.remove(recipeItem);
                    continue block0;
                }
                recipeItem.func_190918_g(invItem.func_190916_E());
                invTemp[i] = ItemStack.field_190927_a;
                continue block0;
            }
        }
        if (recipe.isEmpty()) {
            inventory = invTemp;
            return true;
        }
        return recipe.isEmpty();
    }

    public Materialization getMaterializationFor(ItemStack output) {
        for (Materialization mat : this.materializationList) {
            if (!this.areStacksEqual(output, mat.output)) continue;
            return mat;
        }
        return null;
    }

    public ItemStack[] extractItemsFromBag(ItemStack bag) {
        ItemStack[] inventory = null;
        if (bag.func_77978_p() == null) {
            bag.func_77982_d(new NBTTagCompound());
        }
        if (bag.func_77978_p().func_74764_b("ItemInventory")) {
            NBTTagList items = bag.func_77978_p().func_150295_c("ItemInventory", 10);
            inventory = new ItemStack[items.func_74745_c()];
            for (int i = 0; i < items.func_74745_c(); ++i) {
                NBTTagCompound item = items.func_150305_b(i);
                inventory[i] = new ItemStack(item);
            }
        }
        if (inventory == null) {
            return null;
        }
        for (ItemStack item : inventory) {
            if (APIUtils.isCrystal(item)) continue;
            return null;
        }
        return inventory;
    }

    private void replaceBagContents(ItemStack bag, ItemStack[] inventory) {
        if (!bag.func_77942_o()) {
            bag.func_77982_d(new NBTTagCompound());
        }
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < inventory.length; ++i) {
            if (inventory[i].func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74768_a("Slot", i);
            inventory[i].func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        bag.func_77978_p().func_74782_a("ItemInventory", (NBTBase)items);
    }

    private boolean areStacksEqual(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        if (par1ItemStack.func_190926_b() || par2ItemStack.func_190926_b()) {
            return false;
        }
        return par2ItemStack.func_77973_b() == par1ItemStack.func_77973_b() && (par2ItemStack.func_77952_i() == Short.MAX_VALUE || par2ItemStack.func_77952_i() == par1ItemStack.func_77952_i());
    }

    private boolean arrayContainsOtherArray(ItemStack[] array1, ItemStack[] array2) {
        ArrayList inventory = Lists.newArrayList((Object[])array1);
        List<ItemStack> recipe = this.makeNonWriteThroughList(array2);
        if (inventory.size() >= recipe.size()) {
            block0: for (ItemStack invItem : inventory) {
                for (ItemStack recipeItem : recipe) {
                    if (!this.areStacksEqual(invItem, recipeItem)) continue;
                    if (invItem.func_190916_E() >= recipeItem.func_190916_E()) {
                        invItem.func_190918_g(recipeItem.func_190916_E());
                        if (invItem.func_190926_b()) {
                            invItem = ItemStack.field_190927_a;
                        }
                        recipe.remove(recipeItem);
                        continue block0;
                    }
                    recipeItem.func_190918_g(invItem.func_190916_E());
                    invItem = ItemStack.field_190927_a;
                    continue block0;
                }
            }
        }
        return recipe.isEmpty();
    }

    private List<ItemStack> makeNonWriteThroughList(ItemStack[] array) {
        Object[] inputTmp = new ItemStack[array.length];
        for (int i = 0; i < array.length; ++i) {
            inputTmp[i] = array[i].func_77946_l();
        }
        return Lists.newArrayList((Object[])inputTmp);
    }

    public List<Materialization> getMaterializationList() {
        return this.materializationList;
    }
}

