/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.station;

import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.RocketEvent;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.stations.SpaceObject;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.util.StationLandingLocation;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.LibVulpesItems;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.inventory.modules.ModuleTextBox;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.IMultiblock;
import zmaster587.libVulpes.tile.multiblock.hatch.TileInventoryHatch;
import zmaster587.libVulpes.util.HashedBlockPosition;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileLandingPad
extends TileInventoryHatch
implements ILinkableTile,
IGuiCallback,
INetworkMachine {
    private List<HashedBlockPosition> blockPos;
    ModuleTextBox moduleNameTextbox;
    String name;

    public TileLandingPad() {
        super(1);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.blockPos = new LinkedList<HashedBlockPosition>();
        this.moduleNameTextbox = new ModuleTextBox((IGuiCallback)this, 40, 30, 60, 12, 9);
        this.name = "";
    }

    public void func_145843_s() {
        super.func_145843_s();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        for (HashedBlockPosition pos : this.blockPos) {
            TileEntity tile = this.field_145850_b.func_175625_s(pos.getBlockPos());
            if (!(tile instanceof IMultiblock)) continue;
            ((IMultiblock)tile).setIncomplete();
        }
    }

    public void onModuleUpdated(ModuleBase module) {
        if (module == this.moduleNameTextbox) {
            this.name = this.moduleNameTextbox.getText();
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
        }
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        List modules = super.getModules(ID, player);
        modules.add(new ModuleText(40, 20, LibVulpes.proxy.getLocalizedString("msg.label.name") + ":", 0x2F2F2F));
        modules.add(this.moduleNameTextbox);
        return modules;
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public boolean onLinkStart(ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        ItemLinker.setMasterCoords((ItemStack)item, (BlockPos)this.func_174877_v());
        ItemLinker.setDimId((ItemStack)item, (int)world.field_73011_w.getDimension());
        return true;
    }

    public String getModularInventoryName() {
        return "tile.landingPad.name";
    }

    public boolean onLinkComplete(ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        TileEntity tile = world.func_175625_s(ItemLinker.getMasterCoords((ItemStack)item));
        if (tile instanceof IInfrastructure) {
            HashedBlockPosition pos = new HashedBlockPosition(tile.func_174877_v());
            if (!this.blockPos.contains(pos)) {
                this.blockPos.add(pos);
            }
            AxisAlignedBB bbCache = new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(1, 2, 1));
            List rockets = world.func_72872_a(EntityRocketBase.class, bbCache);
            for (EntityRocketBase rocket : rockets) {
                rocket.linkInfrastructure((IInfrastructure)tile);
            }
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("msg.linker.success", new Object[0]));
                if (tile instanceof IMultiblock) {
                    ((IMultiblock)tile).setMasterBlock(this.func_174877_v());
                }
            }
            ItemLinker.resetPosition((ItemStack)item);
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void onRocketLand(RocketEvent.RocketLandedEvent event) {
        EntityRocketBase rocket = (EntityRocketBase)event.getEntity();
        AxisAlignedBB bbCache = new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(1, 2, 1));
        if (bbCache.func_72326_a(rocket.func_174813_aQ())) {
            ItemStack stack;
            if (!this.field_145850_b.field_72995_K) {
                for (IInfrastructure infrastructure : this.getConnectedInfrastructure()) {
                    rocket.linkInfrastructure(infrastructure);
                }
            }
            if ((stack = this.func_70301_a(0)).func_77973_b() == LibVulpesItems.itemLinker && ItemLinker.getDimId((ItemStack)stack) != -2147483647 && event.getEntity() instanceof EntityRocket) {
                ((EntityRocket)rocket).setOverriddenCoords(ItemLinker.getDimId((ItemStack)stack), (float)ItemLinker.getMasterX((ItemStack)stack) + 0.5f, Configuration.orbit, (float)ItemLinker.getMasterZ((ItemStack)stack) + 0.5f);
            }
        }
    }

    @SubscribeEvent
    public void onRocketLaunch(RocketEvent.RocketPreLaunchEvent event) {
        ItemStack stack = this.func_70301_a(0);
        if (stack.func_77973_b() == LibVulpesItems.itemLinker && ItemLinker.getDimId((ItemStack)stack) != -2147483647) {
            EntityRocketBase rocket = (EntityRocketBase)event.getEntity();
            AxisAlignedBB bbCache = new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(1, 2, 1));
            if (bbCache.func_72326_a(rocket.func_174813_aQ()) && event.getEntity() instanceof EntityRocket) {
                ((EntityRocket)rocket).setOverriddenCoords(ItemLinker.getDimId((ItemStack)stack), (float)ItemLinker.getMasterX((ItemStack)stack) + 0.5f, Configuration.orbit, (float)ItemLinker.getMasterZ((ItemStack)stack) + 0.5f);
            }
        }
    }

    @SubscribeEvent
    public void onRocketDismantle(RocketEvent.RocketDismantleEvent event) {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.field_73011_w.getDimension() == Configuration.spaceDimId) {
            ISpaceObject spaceObj;
            EntityRocketBase rocket = (EntityRocketBase)event.getEntity();
            AxisAlignedBB bbCache = new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(1, 2, 1));
            if (bbCache.func_72326_a(rocket.func_174813_aQ()) && (spaceObj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c)) instanceof SpaceObject) {
                ((SpaceObject)spaceObj).setPadStatus(this.field_174879_c, false);
            }
        }
    }

    public void registerTileWithStation(World world, BlockPos pos) {
        ISpaceObject spaceObj;
        if (!world.field_72995_K && world.field_73011_w.getDimension() == Configuration.spaceDimId && (spaceObj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos)) instanceof SpaceObject) {
            ((SpaceObject)spaceObj).addLandingPad(pos, this.name);
            AxisAlignedBB bbCache = new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(1, 2, 1));
            List rockets = world.func_72872_a(EntityRocketBase.class, bbCache);
            if (rockets != null && !rockets.isEmpty()) {
                ((SpaceObject)spaceObj).setPadStatus(pos, true);
            }
        }
    }

    public void setAllowAutoLand(World world, BlockPos pos, boolean allow) {
        ISpaceObject spaceObj;
        if (!world.field_72995_K && world.field_73011_w.getDimension() == Configuration.spaceDimId && (spaceObj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos)) instanceof SpaceObject) {
            ((SpaceObject)spaceObj).setLandingPadAutoLandStatus(pos, allow);
        }
    }

    public void unregisterTileWithStation(World world, BlockPos pos) {
        ISpaceObject spaceObj;
        if (!world.field_72995_K && world.field_73011_w.getDimension() == Configuration.spaceDimId && (spaceObj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(pos)) instanceof SpaceObject) {
            ((SpaceObject)spaceObj).removeLandingPad(pos);
        }
    }

    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        if (!stack.func_190926_b()) {
            this.setAllowAutoLand(this.field_145850_b, this.field_174879_c, false);
            AxisAlignedBB bbCache = new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(1, 2, 1));
            List rockets = this.field_145850_b.func_72872_a(EntityRocketBase.class, bbCache);
            for (EntityRocketBase rocket : rockets) {
                if (!(rocket instanceof EntityRocket)) continue;
                if (stack.func_77973_b() == LibVulpesItems.itemLinker && ItemLinker.getDimId((ItemStack)stack) != -2147483647) {
                    ((EntityRocket)rocket).setOverriddenCoords(ItemLinker.getDimId((ItemStack)stack), (float)ItemLinker.getMasterX((ItemStack)stack) + 0.5f, Configuration.orbit, (float)ItemLinker.getMasterZ((ItemStack)stack) + 0.5f);
                    continue;
                }
                ((EntityRocket)rocket).setOverriddenCoords(-2147483647, 0.0f, 0.0f, 0.0f);
            }
        } else {
            this.setAllowAutoLand(this.field_145850_b, this.field_174879_c, true);
            AxisAlignedBB bbCache = new AxisAlignedBB(this.func_174877_v().func_177982_a(-1, 0, -1), this.func_174877_v().func_177982_a(1, 2, 1));
            List rockets = this.field_145850_b.func_72872_a(EntityRocketBase.class, bbCache);
            for (EntityRocketBase rocket : rockets) {
                if (!(rocket instanceof EntityRocket)) continue;
                ((EntityRocket)rocket).setOverriddenCoords(-2147483647, 0.0f, 0.0f, 0.0f);
            }
        }
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return stack.func_77973_b() == LibVulpesItems.itemLinker;
    }

    public List<IInfrastructure> getConnectedInfrastructure() {
        LinkedList<IInfrastructure> infrastructure = new LinkedList<IInfrastructure>();
        Iterator<HashedBlockPosition> iter = this.blockPos.iterator();
        while (iter.hasNext()) {
            HashedBlockPosition position = iter.next();
            TileEntity tile = this.field_145850_b.func_175625_s(position.getBlockPos());
            tile = this.field_145850_b.func_175625_s(position.getBlockPos());
            if (tile instanceof IInfrastructure) {
                infrastructure.add((IInfrastructure)tile);
                continue;
            }
            iter.remove();
        }
        return infrastructure;
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 0) {
            PacketBuffer buff = new PacketBuffer(out);
            buff.writeInt(this.name.length());
            buff.func_180714_a(this.name);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        int len = in.readInt();
        PacketBuffer buff = new PacketBuffer(in);
        nbt.func_74778_a("id", buff.func_150789_c(len));
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.func_145839_a(pkt.func_148857_g());
        this.moduleNameTextbox.setText(this.name);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.moduleNameTextbox.setText(this.name);
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 0) {
            ISpaceObject spaceObj;
            this.name = nbt.func_74779_i("id");
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.field_73011_w.getDimension() == Configuration.spaceDimId && (spaceObj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_174879_c)) instanceof SpaceObject) {
                StationLandingLocation loc = ((SpaceObject)spaceObj).getPadAtLocation(new HashedBlockPosition(this.field_174879_c));
                if (loc != null) {
                    ((SpaceObject)spaceObj).setPadName(this.field_145850_b, new HashedBlockPosition(this.field_174879_c), this.name);
                } else {
                    ((SpaceObject)spaceObj).addLandingPad(this.field_174879_c, this.name);
                }
            }
        }
        this.func_70296_d();
        this.field_145850_b.func_184138_a(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c), this.field_145850_b.func_180495_p(this.field_174879_c), 3);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.blockPos.clear();
        if (nbt.func_74764_b("infrastructureLocations")) {
            int[] array = nbt.func_74759_k("infrastructureLocations");
            for (int counter = 0; counter < array.length; counter += 3) {
                this.blockPos.add(new HashedBlockPosition(array[counter], array[counter + 1], array[counter + 2]));
            }
        }
        this.name = nbt.func_74779_i("name");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (!this.blockPos.isEmpty()) {
            int[] array = new int[this.blockPos.size() * 3];
            int counter = 0;
            for (HashedBlockPosition pos : this.blockPos) {
                array[counter] = pos.x;
                array[counter + 1] = pos.y;
                array[counter + 2] = pos.z;
                counter += 3;
            }
            nbt.func_74783_a("infrastructureLocations", array);
        }
        if (this.name != null && !this.name.isEmpty()) {
            nbt.func_74778_a("name", this.name);
        }
        return nbt;
    }
}

