/*
 * Decompiled with CFR 0.152.
 */
package shadows.plants2.block;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import shadows.placebo.Placebo;
import shadows.placebo.block.BlockEnum;
import shadows.placebo.interfaces.IHasRecipe;
import shadows.placebo.interfaces.IPropertyEnum;
import shadows.placebo.interfaces.ITreeEnum;
import shadows.placebo.registry.RegistryInformation;
import shadows.placebo.util.PlaceboUtil;
import shadows.plants2.Plants2;
import shadows.plants2.block.BlockEnumSapling;

public class BlockEnumLeaves<E extends Enum<E>>
extends BlockEnum<E>
implements IShearable,
IHasRecipe {
    private final BlockEnumSapling<E> sapling;
    private int[] surroundings = new int[32768];

    public BlockEnumLeaves(String name, SoundType s, float hard, float res, BlockEnumSapling<E> sapling, Class<E> clazz, int predicate) {
        super(name, Material.field_151584_j, s, hard, res, clazz, "type", e -> ((ITreeEnum)e).getPredicateIndex() == predicate, (RegistryInformation)Plants2.INFO);
        this.func_180632_j(this.func_176194_O().func_177621_b().func_177226_a((IProperty)this.property, (Comparable)this.types.get(0)).func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)));
        this.sapling = sapling;
        this.func_149675_a(true);
        this.func_149713_g(1);
        if (this.types.size() > 4) {
            throw new IllegalArgumentException("Attempting to create a BlockEnumLeaves with more than 4 values is invalid.");
        }
    }

    public BlockEnumLeaves(String name, BlockEnumSapling<E> sapling, Class<E> clazz, int predicate) {
        this(name, SoundType.field_185850_c, 0.2f, 0.0f, sapling, clazz, predicate);
    }

    public void initRecipes(RegistryEvent.Register<IRecipe> e) {
        OreDictionary.registerOre((String)"treeLeaves", (ItemStack)new ItemStack((Block)this, 1, Short.MAX_VALUE));
    }

    public boolean func_149662_c(IBlockState state) {
        return Blocks.field_150362_t.func_176223_P().func_185914_p();
    }

    public boolean isLeaves(IBlockState state, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public String func_149739_a() {
        return "tile.plants2.leaves";
    }

    public IBlockState getStateFor(E e) {
        return this.func_176223_P().func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)this.property, e);
    }

    public void initModels(ModelRegistryEvent e) {
        for (int i = 0; i < this.types.size(); ++i) {
            PlaceboUtil.sMRL((String)"leaves", (Block)this, (int)i, (String)("check_decay=false,decayable=false," + this.property.func_177701_a() + "=" + ((IPropertyEnum)((Enum)this.types.get(i))).func_176610_l()));
        }
        Placebo.PROXY.useRenamedMapper((Block)this, "leaves");
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)this.property, (Comparable)this.types.get(meta));
    }

    public BlockRenderLayer func_180664_k() {
        return Blocks.field_150362_t.func_180664_k();
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)new ItemStack(this.sapling, this.func_149745_a(RANDOM), this.func_180651_a(state)));
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        IBlockState state = world.func_180495_p(pos);
        ArrayList<ItemStack> k = new ArrayList<ItemStack>();
        k.add(new ItemStack((Block)this, 1, this.func_180651_a(state)));
        return k;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        Blocks.field_150362_t.func_180663_b(world, pos, state);
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return Blocks.field_150362_t.func_176223_P().func_185890_d(world, pos);
    }

    public boolean func_176205_b(IBlockAccess world, BlockPos pos) {
        return Blocks.field_150362_t.func_176205_b(world, pos);
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entity) {
        Blocks.field_150362_t.func_180634_a(world, pos, state, entity);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!world.field_72995_K && ((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176236_b)).booleanValue() && ((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176237_a)).booleanValue()) {
            int l2;
            int i1;
            int l;
            int k = pos.func_177958_n();
            if (world.func_175707_a(new BlockPos(k - 5, (l = pos.func_177956_o()) - 5, (i1 = pos.func_177952_p()) - 5), new BlockPos(k + 5, l + 5, i1 + 5))) {
                BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
                for (int i2 = -4; i2 <= 4; ++i2) {
                    for (int j2 = -4; j2 <= 4; ++j2) {
                        for (int k2 = -4; k2 <= 4; ++k2) {
                            IBlockState iblockstate = world.func_180495_p((BlockPos)blockpos$mutableblockpos.func_181079_c(k + i2, l + j2, i1 + k2));
                            Block block = iblockstate.func_177230_c();
                            if (!block.canSustainLeaves(iblockstate, (IBlockAccess)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(k + i2, l + j2, i1 + k2))) {
                                if (block.isLeaves(iblockstate, (IBlockAccess)world, (BlockPos)blockpos$mutableblockpos.func_181079_c(k + i2, l + j2, i1 + k2))) {
                                    this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = -2;
                                    continue;
                                }
                                this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = -1;
                                continue;
                            }
                            this.surroundings[(i2 + 16) * 1024 + (j2 + 16) * 32 + k2 + 16] = 0;
                        }
                    }
                }
                for (int i3 = 1; i3 <= 4; ++i3) {
                    for (int j3 = -4; j3 <= 4; ++j3) {
                        for (int k3 = -4; k3 <= 4; ++k3) {
                            for (int l3 = -4; l3 <= 4; ++l3) {
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16] != i3 - 1) continue;
                                if (this.surroundings[(j3 + 16 - 1) * 1024 + (k3 + 16) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16 - 1) * 1024 + (k3 + 16) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16 + 1) * 1024 + (k3 + 16) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16 + 1) * 1024 + (k3 + 16) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16 - 1) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16 - 1) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16 + 1) * 32 + l3 + 16] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16 + 1) * 32 + l3 + 16] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 - 1] == -2) {
                                    this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 - 1] = i3;
                                }
                                if (this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 + 1] != -2) continue;
                                this.surroundings[(j3 + 16) * 1024 + (k3 + 16) * 32 + l3 + 16 + 1] = i3;
                            }
                        }
                    }
                }
            }
            if ((l2 = this.surroundings[16912]) >= 0) {
                world.func_180501_a(pos, state.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), 4);
            } else {
                this.destroy(world, pos);
            }
        }
    }

    private void destroy(World world, BlockPos pos) {
        this.func_176226_b(world, pos, world.func_180495_p(pos), 0);
        world.func_175698_g(pos);
    }

    public void beginLeavesDecay(IBlockState state, World world, BlockPos pos) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true)), 4);
    }

    public int func_180651_a(IBlockState state) {
        return ((ITreeEnum)((Enum)((Object)state.func_177229_b((IProperty)this.property)))).getMetadata();
    }

    public int func_149745_a(Random rand) {
        return rand.nextInt(20) == 0 ? 1 : 0;
    }

    public int func_176201_c(IBlockState state) {
        int i = ((ITreeEnum)((Enum)((Object)state.func_177229_b((IProperty)this.property)))).getMetadata();
        i *= 4;
        if (((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176236_b)).booleanValue()) {
            ++i;
        }
        if (((Boolean)state.func_177229_b((IProperty)BlockLeaves.field_176237_a)).booleanValue()) {
            i += 2;
        }
        return i;
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        float i = meta;
        state = state.func_177226_a((IProperty)this.property, (Comparable)this.types.get((int)(i /= 4.0f)));
        if (i - 0.5f >= 0.0f) {
            state = state.func_177226_a((IProperty)BlockLeaves.field_176237_a, (Comparable)Boolean.valueOf(true));
            i -= 0.5f;
        }
        if (i - 0.25f >= 0.0f) {
            state = state.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }

    public BlockStateContainer createStateContainer() {
        return new BlockStateContainer((Block)this, new IProperty[]{this.property, BlockLeaves.field_176236_b, BlockLeaves.field_176237_a});
    }

    public BlockEnumSapling<E> getSapling() {
        return this.sapling;
    }

    public int getFlammability(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 60;
    }

    public int getFireSpreadSpeed(IBlockAccess world, BlockPos pos, EnumFacing face) {
        return 30;
    }

    public boolean func_176214_u(IBlockState state) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    @Deprecated
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return !Minecraft.func_71410_x().field_71474_y.field_74347_j && blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() == this ? false : super.func_176225_a(blockState, blockAccess, pos, side);
    }
}

