/*
 * Decompiled with CFR 0.152.
 */
package mods.waterstrainer.jei;

import java.util.HashSet;
import java.util.Set;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientBlacklist;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mods.waterstrainer.Config;
import mods.waterstrainer.gui.GuiStrainer;
import mods.waterstrainer.jei.StrainerCategory;
import mods.waterstrainer.jei.StrainerRecipeMaker;
import mods.waterstrainer.registry.ItemRegistry;
import mods.waterstrainer.util.Patcher;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@JEIPlugin
public class WaterStrainerJeiPlugin
implements IModPlugin {
    public static final String CAT_STRAINER = "waterstrainer.strainer";
    public static Set<ItemStack> blacklisted_items = new HashSet<ItemStack>();

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new StrainerCategory(guiHelper)});
    }

    public void register(IModRegistry registry) {
        IJeiHelpers jeiHelpers = registry.getJeiHelpers();
        IIngredientBlacklist blacklist = jeiHelpers.getIngredientBlacklist();
        registry.addRecipeCatalyst((Object)new ItemStack((Item)ItemRegistry.strainer_survivalist_dense), new String[]{CAT_STRAINER});
        registry.addRecipeClickArea(GuiStrainer.class, 155, 5, 15, 15, new String[]{CAT_STRAINER});
        registry.addRecipes(StrainerRecipeMaker.getStrainerLoot(jeiHelpers), CAT_STRAINER);
        registry.addIngredientInfo((Object)new ItemStack((Item)ItemRegistry.worm), ItemStack.class, new String[]{"Dig Dirt blocks with a Garden Trowel to gather Worms."});
        if (Config.miscEnableEnchanting) {
            registry.addIngredientInfo((Object)new ItemStack((Item)ItemRegistry.strainer_survivalist_reinforced), ItemStack.class, new String[]{"*** Valid Enchantments ***\nEfficiency:\n- Increases the efficiency\nUnbreaking:\n- Increases the durability\nFortune:\n- Increases item output\nLuck of the Sea:\n- Increases rare item drop"});
            registry.addIngredientInfo((Object)new ItemStack((Item)ItemRegistry.strainer_survivalist_dense_reinforced), ItemStack.class, new String[]{"*** Valid Enchantments ***\nEfficiency:\n- Increases the efficiency\nUnbreaking:\n- Increases the durability\nFortune:\n- Increases item output\nLuck of the Sea:\n- Increases rare item drop"});
        }
        for (ItemStack stack : blacklisted_items) {
            blacklist.addIngredientToBlacklist((Object)stack);
        }
    }

    public static void BlacklistItem(ItemStack stack) {
        if (stack != null && !Patcher.isStackEmpty(stack)) {
            blacklisted_items.add(stack);
        }
    }
}

