/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.world;

import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.dave.compactmachines3.misc.ConfigurationHandler;
import org.dave.compactmachines3.reference.EnumMachineSize;
import org.dave.compactmachines3.tile.TileEntityMachine;
import org.dave.compactmachines3.utility.DimensionBlockPos;
import org.dave.compactmachines3.utility.Logz;
import org.dave.compactmachines3.world.data.RedstoneTunnelData;
import org.dave.compactmachines3.world.tools.DimensionTools;
import org.dave.compactmachines3.world.tools.StructureTools;

public class WorldSavedDataMachines
extends WorldSavedData {
    public int nextCoord = 0;
    public HashMap<Integer, double[]> spawnPoints = new HashMap();
    public HashMap<Integer, HashMap<EnumFacing, BlockPos>> tunnels = new HashMap();
    public HashMap<Integer, HashMap<EnumFacing, RedstoneTunnelData>> redstoneTunnels = new HashMap();
    public HashMap<Integer, DimensionBlockPos> machinePositions = new HashMap();
    public HashMap<Integer, EnumMachineSize> machineSizes = new HashMap();
    public HashMap<UUID, Integer> bedCoords = new HashMap();
    public static WorldSavedDataMachines INSTANCE;

    public void setBedCoords(EntityPlayer player) {
        int coords = StructureTools.getCoordsForPos(new BlockPos(player.field_70165_t, player.field_70163_u, player.field_70161_v));
        this.bedCoords.put(player.func_110124_au(), coords);
        this.func_76185_a();
    }

    public int getBedCoords(EntityPlayer player) {
        return this.bedCoords.getOrDefault(player.func_110124_au(), -1);
    }

    public DimensionBlockPos getMachinePosition(int coord) {
        return this.machinePositions.get(coord);
    }

    public TileEntityMachine getMachine(int coord) {
        if (!this.machinePositions.containsKey(coord)) {
            return null;
        }
        DimensionBlockPos dimPos = this.getMachinePosition(coord);
        WorldServer world = DimensionTools.getWorldServerForDimension(dimPos.getDimension());
        TileEntity result = world.func_175625_s(dimPos.getBlockPos());
        if (result == null || !(result instanceof TileEntityMachine)) {
            return null;
        }
        return (TileEntityMachine)result;
    }

    public void addMachinePosition(int coord, BlockPos pos, int dimension, EnumMachineSize size) {
        this.machinePositions.put(coord, new DimensionBlockPos(pos, dimension));
        this.machineSizes.put(coord, size);
        Logz.debug("Adding machine position: coords=%d, pos=%s, dimension=%d, size=%s", coord, pos, dimension, size.func_176610_l());
        this.func_76185_a();
    }

    public void addSpawnPoint(int coord, double[] destination) {
        if (destination.length != 3) {
            Logz.warn("Trying to set spawn point with invalid double[]=%s", new Object[]{destination});
            return;
        }
        this.spawnPoints.put(coord, destination);
        Logz.debug("Setting spawn point: coords=%d, x=%.2f, y=%.2f, z=%.2f", coord, destination[0], destination[1], destination[2]);
        this.func_76185_a();
    }

    public void addSpawnPoint(int coord, double x, double y, double z) {
        this.addSpawnPoint(coord, new double[]{x, y, z});
    }

    public void removeMachinePosition(int coord) {
        this.machinePositions.remove(coord);
        Logz.debug("Removing machine position by coord: coords=%d", coord);
        this.func_76185_a();
    }

    public static int reserveMachineId() {
        int val = WorldSavedDataMachines.INSTANCE.nextCoord++;
        INSTANCE.func_76185_a();
        return val;
    }

    public WorldSavedDataMachines(String name) {
        super(name);
    }

    @SubscribeEvent
    public static void loadWorld(WorldEvent.Load event) {
        if (event.getWorld().field_72995_K || event.getWorld().field_73011_w.getDimension() != ConfigurationHandler.Settings.dimensionId) {
            return;
        }
        Logz.info("Loading saved data for machine world", new Object[0]);
        WorldSavedDataMachines wsd = (WorldSavedDataMachines)event.getWorld().func_175693_T().func_75742_a(WorldSavedDataMachines.class, "WorldSavedDataMachines");
        if (wsd == null) {
            wsd = new WorldSavedDataMachines("WorldSavedDataMachines");
            wsd.func_76185_a();
        }
        Logz.info(" > %d spawn points", wsd.spawnPoints.size());
        Logz.info(" > Next machine id: %d", wsd.nextCoord);
        Logz.info(" > Players with beds in CM dimension: %d", wsd.bedCoords.size());
        INSTANCE = wsd;
        event.getWorld().func_175693_T().func_75745_a("WorldSavedDataMachines", (WorldSavedData)wsd);
    }

    public void removeTunnel(BlockPos pos) {
        int coords = StructureTools.getCoordsForPos(pos);
        HashMap<EnumFacing, BlockPos> sideMapping = this.tunnels.get(coords);
        if (sideMapping == null) {
            return;
        }
        EnumFacing sideToRemove = null;
        for (EnumFacing side : sideMapping.keySet()) {
            if (!sideMapping.get(side).equals((Object)pos)) continue;
            sideToRemove = side;
            break;
        }
        if (sideToRemove != null) {
            Logz.debug("Removing tunnel mapping by blockpos: pos=%s --> coords=%d, side=%s", pos, coords, sideToRemove);
            sideMapping.remove(sideToRemove);
        }
        this.func_76185_a();
    }

    public void removeTunnel(BlockPos position, EnumFacing side) {
        int coords = StructureTools.getCoordsForPos(position);
        HashMap<EnumFacing, BlockPos> sideMapping = this.tunnels.get(coords);
        if (sideMapping == null) {
            return;
        }
        Logz.debug("Removing tunnel mapping by pos+side: coords=%d, side=%s", coords, side);
        sideMapping.remove(side);
        this.func_76185_a();
    }

    public void addTunnel(BlockPos position, EnumFacing side) {
        this.addTunnel(position, side, false);
    }

    private void addTunnel(BlockPos position, EnumFacing side, boolean isLoading) {
        int coords = StructureTools.getCoordsForPos(position);
        HashMap<Object, Object> sideMapping = this.tunnels.get(coords);
        if (sideMapping == null) {
            sideMapping = new HashMap();
            this.tunnels.put(coords, sideMapping);
        }
        sideMapping.put(side, position);
        Logz.debug("Adding tunnel mapping: side=%s, pos=%s --> coords=%d", side, position, coords);
        if (!isLoading) {
            this.func_76185_a();
        }
    }

    public void toggleRedstoneTunnelOutput(BlockPos pos) {
        int coords = StructureTools.getCoordsForPos(pos);
        HashMap<EnumFacing, RedstoneTunnelData> sideMapping = this.redstoneTunnels.get(coords);
        if (sideMapping == null) {
            return;
        }
        EnumFacing sideToRemove = null;
        for (EnumFacing side : sideMapping.keySet()) {
            if (!sideMapping.get((Object)side).pos.equals((Object)pos)) continue;
            sideToRemove = side;
            break;
        }
        if (sideToRemove != null) {
            sideMapping.get(sideToRemove).isOutput = !sideMapping.get(sideToRemove).isOutput;
            Logz.debug("Toggle tunnel output by blockpos: pos=%s --> coords=%d, side=%s, output=%s", pos, coords, sideToRemove, sideMapping.get((Object)sideToRemove).isOutput);
        }
        this.func_76185_a();
    }

    public void removeRedstoneTunnel(BlockPos pos) {
        int coords = StructureTools.getCoordsForPos(pos);
        HashMap<EnumFacing, RedstoneTunnelData> sideMapping = this.redstoneTunnels.get(coords);
        if (sideMapping == null) {
            return;
        }
        EnumFacing sideToRemove = null;
        for (EnumFacing side : sideMapping.keySet()) {
            if (!sideMapping.get((Object)side).pos.equals((Object)pos)) continue;
            sideToRemove = side;
            break;
        }
        if (sideToRemove != null) {
            Logz.debug("Removing tunnel mapping by blockpos: pos=%s --> coords=%d, side=%s", pos, coords, sideToRemove);
            sideMapping.remove(sideToRemove);
        }
        this.func_76185_a();
    }

    public void removeRedstoneTunnel(BlockPos position, EnumFacing side) {
        int coords = StructureTools.getCoordsForPos(position);
        HashMap<EnumFacing, RedstoneTunnelData> sideMapping = this.redstoneTunnels.get(coords);
        if (sideMapping == null) {
            return;
        }
        Logz.debug("Removing tunnel mapping by pos+side: coords=%d, side=%s", coords, side);
        sideMapping.remove(side);
        this.func_76185_a();
    }

    public void addRedstoneTunnel(BlockPos position, EnumFacing side, boolean isOutput) {
        this.addRedstoneTunnel(position, side, isOutput, false);
    }

    private void addRedstoneTunnel(BlockPos position, EnumFacing side, boolean isOutput, boolean isLoading) {
        int coords = StructureTools.getCoordsForPos(position);
        HashMap<Object, RedstoneTunnelData> sideMapping = this.redstoneTunnels.get(coords);
        if (sideMapping == null) {
            sideMapping = new HashMap();
            this.redstoneTunnels.put(coords, sideMapping);
        }
        sideMapping.put(side, new RedstoneTunnelData(position, isOutput));
        Logz.debug("Adding redstone tunnel mapping: side=%s, pos=%s, isOutput=%s --> coords=%d", side, position, isOutput, coords);
        if (!isLoading) {
            this.func_76185_a();
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        compound.func_74768_a("nextMachineCoord", this.nextCoord);
        NBTTagCompound bedCoordsMap = new NBTTagCompound();
        for (UUID uUID : this.bedCoords.keySet()) {
            int coords = this.bedCoords.get(uUID);
            bedCoordsMap.func_74768_a(uUID.toString(), coords);
        }
        NBTTagCompound machineSizesTag = new NBTTagCompound();
        for (int coord : this.machineSizes.keySet()) {
            int size = this.machineSizes.get(coord).getMeta();
            machineSizesTag.func_74768_a("" + coord, size);
        }
        NBTTagList nBTTagList = new NBTTagList();
        for (int coords : this.spawnPoints.keySet()) {
            double[] positions = this.spawnPoints.get(coords);
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("coords", coords);
            tag.func_74780_a("x", positions[0]);
            tag.func_74780_a("y", positions[1]);
            tag.func_74780_a("z", positions[2]);
            nBTTagList.func_74742_a((NBTBase)tag);
        }
        NBTTagList tunnelList = new NBTTagList();
        for (int coords : this.tunnels.keySet()) {
            HashMap<EnumFacing, BlockPos> sideMappings = this.tunnels.get(coords);
            for (EnumFacing enumFacing : sideMappings.keySet()) {
                BlockPos position = sideMappings.get(enumFacing);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("side", enumFacing.func_176745_a());
                tag.func_74768_a("x", position.func_177958_n());
                tag.func_74768_a("y", position.func_177956_o());
                tag.func_74768_a("z", position.func_177952_p());
                tunnelList.func_74742_a((NBTBase)tag);
            }
        }
        NBTTagList redstoneTunnelList = new NBTTagList();
        for (int coords : this.redstoneTunnels.keySet()) {
            HashMap<EnumFacing, RedstoneTunnelData> sideMappings = this.redstoneTunnels.get(coords);
            for (EnumFacing side : sideMappings.keySet()) {
                RedstoneTunnelData info = sideMappings.get(side);
                NBTTagCompound tag = new NBTTagCompound();
                tag.func_74768_a("side", side.func_176745_a());
                tag.func_74768_a("x", info.pos.func_177958_n());
                tag.func_74768_a("y", info.pos.func_177956_o());
                tag.func_74768_a("z", info.pos.func_177952_p());
                tag.func_74757_a("output", info.isOutput);
                redstoneTunnelList.func_74742_a((NBTBase)tag);
            }
        }
        NBTTagList machineList = new NBTTagList();
        for (int coords : this.machinePositions.keySet()) {
            DimensionBlockPos dimensionBlockPos = this.machinePositions.get(coords);
            NBTTagCompound tag = dimensionBlockPos.getAsNBT();
            tag.func_74768_a("coords", coords);
            machineList.func_74742_a((NBTBase)tag);
        }
        compound.func_74782_a("spawnpoints", (NBTBase)nBTTagList);
        compound.func_74782_a("tunnels", (NBTBase)tunnelList);
        compound.func_74782_a("machines", (NBTBase)machineList);
        compound.func_74782_a("bedcoords", (NBTBase)bedCoordsMap);
        compound.func_74782_a("sizes", (NBTBase)machineSizesTag);
        compound.func_74782_a("redstoneTunnels", (NBTBase)redstoneTunnelList);
        return compound;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagCompound tag;
        NBTTagList tagList;
        this.nextCoord = nbt.func_74762_e("nextMachineCoord");
        if (nbt.func_74764_b("bedcoords")) {
            this.bedCoords.clear();
            NBTTagCompound bedCoordsMap = nbt.func_74775_l("bedcoords");
            for (String uuidString : bedCoordsMap.func_150296_c()) {
                UUID uuid = UUID.fromString(uuidString);
                int coords = bedCoordsMap.func_74762_e(uuidString);
                this.bedCoords.put(uuid, coords);
            }
        }
        if (nbt.func_74764_b("sizes")) {
            this.machineSizes.clear();
            NBTTagCompound machineSizesTag = nbt.func_74775_l("sizes");
            for (String coordString : machineSizesTag.func_150296_c()) {
                int coord = Integer.parseInt(coordString);
                int size = machineSizesTag.func_74762_e(coordString);
                this.machineSizes.put(coord, EnumMachineSize.getFromMeta(size));
            }
        }
        if (nbt.func_74764_b("spawnpoints")) {
            this.spawnPoints.clear();
            tagList = nbt.func_150295_c("spawnpoints", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                tag = tagList.func_150305_b(i);
                int coords = tag.func_74762_e("coords");
                double[] positions = new double[]{tag.func_74769_h("x"), tag.func_74769_h("y"), tag.func_74769_h("z")};
                this.spawnPoints.put(coords, positions);
            }
        }
        if (nbt.func_74764_b("tunnels")) {
            this.tunnels.clear();
            tagList = nbt.func_150295_c("tunnels", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                tag = tagList.func_150305_b(i);
                BlockPos position = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
                EnumFacing side = EnumFacing.func_82600_a((int)tag.func_74762_e("side"));
                this.addTunnel(position, side, true);
            }
        }
        if (nbt.func_74764_b("redstoneTunnels")) {
            this.redstoneTunnels.clear();
            tagList = nbt.func_150295_c("redstoneTunnels", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                tag = tagList.func_150305_b(i);
                BlockPos position = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
                EnumFacing side = EnumFacing.func_82600_a((int)tag.func_74762_e("side"));
                boolean isOutput = tag.func_74767_n("output");
                this.addRedstoneTunnel(position, side, isOutput, true);
            }
        }
        if (nbt.func_74764_b("machines")) {
            this.machinePositions.clear();
            tagList = nbt.func_150295_c("machines", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                tag = tagList.func_150305_b(i);
                this.machinePositions.put(tag.func_74762_e("coords"), new DimensionBlockPos(tag));
            }
        }
    }
}

