/*
 * Decompiled with CFR 0.152.
 */
package org.dave.compactmachines3.tile;

import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.dave.compactmachines3.integration.CapabilityNullHandlerRegistry;
import org.dave.compactmachines3.tile.BaseTileEntityTunnel;
import org.dave.compactmachines3.tile.TileEntityMachine;
import org.dave.compactmachines3.utility.DimensionBlockPos;
import org.dave.compactmachines3.world.WorldSavedDataMachines;
import org.dave.compactmachines3.world.tools.DimensionTools;
import org.dave.compactmachines3.world.tools.StructureTools;

public class TileEntityTunnel
extends BaseTileEntityTunnel
implements ICapabilityProvider {
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (this.func_145831_w().field_72995_K || facing == null) {
            if (CapabilityNullHandlerRegistry.hasNullHandler(capability)) {
                return true;
            }
            return super.hasCapability(capability, facing);
        }
        DimensionBlockPos dimpos = WorldSavedDataMachines.INSTANCE.machinePositions.get(StructureTools.getCoordsForPos(this.func_174877_v()));
        if (dimpos == null) {
            return false;
        }
        WorldServer realWorld = DimensionTools.getWorldServerForDimension(dimpos.getDimension());
        if (realWorld == null || !(realWorld.func_175625_s(dimpos.getBlockPos()) instanceof TileEntityMachine)) {
            return false;
        }
        EnumFacing machineSide = this.getMachineSide();
        BlockPos outsetPos = dimpos.getBlockPos().func_177972_a(machineSide);
        TileEntity te = realWorld.func_175625_s(outsetPos);
        if (te instanceof ICapabilityProvider && te.hasCapability(capability, machineSide.func_176734_d())) {
            return true;
        }
        return CapabilityNullHandlerRegistry.hasNullHandler(capability);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (this.func_145831_w().field_72995_K) {
            if (CapabilityNullHandlerRegistry.hasNullHandler(capability)) {
                return CapabilityNullHandlerRegistry.getNullHandler(capability);
            }
            return (T)super.getCapability(capability, facing);
        }
        DimensionBlockPos dimpos = WorldSavedDataMachines.INSTANCE.machinePositions.get(StructureTools.getCoordsForPos(this.func_174877_v()));
        if (dimpos == null) {
            return null;
        }
        WorldServer realWorld = DimensionTools.getWorldServerForDimension(dimpos.getDimension());
        if (realWorld == null || !(realWorld.func_175625_s(dimpos.getBlockPos()) instanceof TileEntityMachine)) {
            return null;
        }
        EnumFacing machineSide = this.getMachineSide();
        BlockPos outsetPos = dimpos.getBlockPos().func_177972_a(machineSide);
        TileEntity te = realWorld.func_175625_s(outsetPos);
        if (te instanceof ICapabilityProvider && te.hasCapability(capability, machineSide.func_176734_d())) {
            return (T)realWorld.func_175625_s(outsetPos).getCapability(capability, machineSide.func_176734_d());
        }
        if (CapabilityNullHandlerRegistry.hasNullHandler(capability)) {
            return CapabilityNullHandlerRegistry.getNullHandler(capability);
        }
        return null;
    }
}

