/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.data.numbers.operation;

import cofh.cofhworld.data.numbers.INumberProvider;
import java.util.Locale;
import java.util.Random;
import net.minecraft.world.World;

public class MathProvider
implements INumberProvider {
    protected final INumberProvider valueA;
    protected final INumberProvider valueB;
    protected final Operation operation;

    public MathProvider(INumberProvider valueA, INumberProvider valueB, String type) {
        this.valueA = valueA;
        this.valueB = valueB;
        this.operation = Operation.valueOf(type.toUpperCase(Locale.US));
    }

    @Override
    public long longValue(World world, Random rand, INumberProvider.DataHolder data) {
        return this.operation.perform(this.valueA.longValue(world, rand, data), this.valueB.longValue(world, rand, data));
    }

    @Override
    public double doubleValue(World world, Random rand, INumberProvider.DataHolder data) {
        return this.operation.perform(this.valueA.doubleValue(world, rand, data), this.valueB.doubleValue(world, rand, data));
    }

    private static enum Operation {
        ADD{

            @Override
            public long perform(long a, long b) {
                return a + b;
            }

            @Override
            public double perform(double a, double b) {
                return a + b;
            }
        }
        ,
        SUBTRACT{

            @Override
            public long perform(long a, long b) {
                return a - b;
            }

            @Override
            public double perform(double a, double b) {
                return a - b;
            }
        }
        ,
        MULTIPLY{

            @Override
            public long perform(long a, long b) {
                return a * b;
            }

            @Override
            public double perform(double a, double b) {
                return a * b;
            }
        }
        ,
        DIVIDE{

            @Override
            public long perform(long a, long b) {
                return a / b;
            }

            @Override
            public double perform(double a, double b) {
                return a / b;
            }
        }
        ,
        MODULO{

            @Override
            public long perform(long a, long b) {
                return a % b;
            }

            @Override
            public double perform(double a, double b) {
                return a % b;
            }
        }
        ,
        MINIMUM{

            @Override
            public long perform(long a, long b) {
                return a <= b ? a : b;
            }

            @Override
            public double perform(double a, double b) {
                return a <= b ? a : b;
            }
        }
        ,
        MAXIMUM{

            @Override
            public long perform(long a, long b) {
                return a >= b ? a : b;
            }

            @Override
            public double perform(double a, double b) {
                return a >= b ? a : b;
            }
        };


        public abstract long perform(long var1, long var3);

        public abstract double perform(double var1, double var3);
    }
}

