/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.shape3d;

import code.elix_x.excomms.math.MathUtils;
import code.elix_x.excore.utils.pos.BlockPos;
import code.elix_x.excore.utils.shape3d.Shape3D;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class AxisAlignedBox
extends Shape3D {
    protected double minX;
    protected double minY;
    protected double minZ;
    protected double maxX;
    protected double maxY;
    protected double maxZ;

    private AxisAlignedBox() {
        super(0.0, 0.0, 0.0);
    }

    public AxisAlignedBox(double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        super(MathUtils.average(minX, maxX), MathUtils.average(minY, maxY), MathUtils.average(minZ, maxZ));
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    public AxisAlignedBox(AxisAlignedBB box) {
        this(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f);
    }

    public AxisAlignedBB toAxisAlignedBB() {
        return new AxisAlignedBB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    @Override
    public AxisAlignedBox getBounds() {
        return this;
    }

    @Override
    public Set<BlockPos> getAffectedBlocks(World world) {
        HashSet<BlockPos> set = new HashSet<BlockPos>();
        int i = (int)this.minX;
        while ((double)i <= this.maxX) {
            int j = (int)this.minY;
            while ((double)j <= this.maxY) {
                int k = (int)this.minZ;
                while ((double)k <= this.maxZ) {
                    set.add(new BlockPos(i, j, k));
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return set;
    }

    @Override
    public <E extends Entity> Set<E> getAffectedEntities(World world, Class<E> clazz) {
        return Sets.newHashSet((Iterable)world.func_72872_a(clazz, this.toAxisAlignedBB()));
    }

    @Override
    public boolean isInside(World world, Vec3d vec) {
        return this.toAxisAlignedBB().func_72318_a(vec);
    }

    @Override
    public boolean isInside(World world, Shape3D shape) {
        AxisAlignedBox box = shape.getBounds();
        return this.minX < box.minX && this.maxX > box.maxX && this.minY < box.minY && this.maxY > box.maxY && this.minZ < box.minZ && this.maxZ > box.maxZ;
    }

    @Override
    public boolean intersectsWith(World world, Shape3D shape) {
        return this.toAxisAlignedBB().func_72326_a(shape.getBounds().toAxisAlignedBB());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.maxX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxZ);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minX);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minY);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minZ);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AxisAlignedBox other = (AxisAlignedBox)obj;
        if (Double.doubleToLongBits(this.maxX) != Double.doubleToLongBits(other.maxX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxY) != Double.doubleToLongBits(other.maxY)) {
            return false;
        }
        if (Double.doubleToLongBits(this.maxZ) != Double.doubleToLongBits(other.maxZ)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minX) != Double.doubleToLongBits(other.minX)) {
            return false;
        }
        if (Double.doubleToLongBits(this.minY) != Double.doubleToLongBits(other.minY)) {
            return false;
        }
        return Double.doubleToLongBits(this.minZ) == Double.doubleToLongBits(other.minZ);
    }
}

