/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.pos;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class BlockPos {
    public int x;
    public int y;
    public int z;

    private BlockPos() {
    }

    public BlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public BlockPos(net.minecraft.util.math.BlockPos pos) {
        this(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public BlockPos(TileEntity te) {
        this(te.func_174877_v());
    }

    public int getX() {
        return this.x;
    }

    public void setX(int x) {
        this.x = x;
    }

    public int getY() {
        return this.y;
    }

    public void setY(int y) {
        this.y = y;
    }

    public int getZ() {
        return this.z;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public BlockPos offset(EnumFacing direction) {
        return this.offsetX(direction.func_176730_m().func_177958_n()).offsetY(direction.func_176730_m().func_177956_o()).offsetZ(direction.func_176730_m().func_177952_p());
    }

    public BlockPos offsetX(int xx) {
        this.x += xx;
        return this;
    }

    public BlockPos offsetY(int yy) {
        this.y += yy;
        return this;
    }

    public BlockPos offsetZ(int zz) {
        this.z += zz;
        return this;
    }

    public BlockPos offsetNew(EnumFacing direction) {
        return this.offsetXNew(direction.func_176730_m().func_177958_n()).offsetYNew(direction.func_176730_m().func_177956_o()).offsetZNew(direction.func_176730_m().func_177952_p());
    }

    public BlockPos offsetXNew(int xx) {
        return new BlockPos(this.x + xx, this.y, this.z);
    }

    public BlockPos offsetYNew(int yy) {
        return new BlockPos(this.x, this.y + yy, this.z);
    }

    public BlockPos offsetZNew(int zz) {
        return new BlockPos(this.x, this.y, this.z + zz);
    }

    public Vec3d toVec3() {
        return new Vec3d((double)this.x, (double)this.y, (double)this.z);
    }

    public net.minecraft.util.math.BlockPos toBlockPos() {
        return new net.minecraft.util.math.BlockPos(this.x, this.y, this.z);
    }

    public IBlockState getBlockState(World world) {
        return world.func_180495_p(this.toBlockPos());
    }

    public Block getBlock(World world) {
        return this.getBlockState(world).func_177230_c();
    }

    public int getMetadata(World world) {
        return this.getBlock(world).func_176201_c(this.getBlockState(world));
    }

    public TileEntity getTileEntity(World world) {
        return world.func_175625_s(this.toBlockPos());
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("x", this.x);
        nbt.func_74768_a("y", this.y);
        nbt.func_74768_a("z", this.z);
        return nbt;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.x = nbt.func_74762_e("x");
        this.y = nbt.func_74762_e("y");
        this.z = nbt.func_74762_e("z");
    }

    public static BlockPos createFromNBT(NBTTagCompound nbt) {
        return new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BlockPos other = (BlockPos)obj;
        if (this.x != other.x) {
            return false;
        }
        if (this.y != other.y) {
            return false;
        }
        return this.z == other.z;
    }

    public String toString() {
        return "BlockPos [" + this.x + ", " + this.y + ", " + this.z + "]";
    }
}

