/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excore.utils.client.render.wtw;

import code.elix_x.excore.utils.client.render.IVertexBuffer;
import code.elix_x.excore.utils.client.render.vbo.VertexBufferSingleVBO;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Stack;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import org.lwjgl.opengl.GL11;

public class WTWRenderer
implements Runnable {
    private static final WTWRenderer INSTANCE = new WTWRenderer();
    private static Stack<WTWRenderer> current = new Stack();
    private static int depth = 0;
    private static int stencilDepth = 0;
    private static IVertexBuffer depthOverridePlane;
    private static boolean reuploadDOP;
    private Multimap<Phase, Consumer<WTWRenderer>> renderers = ArrayListMultimap.create();

    private static IVertexBuffer getDepthOverridePlane() {
        if (reuploadDOP && depthOverridePlane != null) {
            depthOverridePlane.cleanUp();
            depthOverridePlane = null;
            reuploadDOP = false;
        }
        if (depthOverridePlane == null) {
            BufferBuilder buff = new BufferBuilder(8);
            buff.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            buff.func_181662_b(-1.0, -1.0, 1.0).func_181666_a(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            buff.func_181662_b(1.0, -1.0, 1.0).func_181666_a(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            buff.func_181662_b(1.0, 1.0, 1.0).func_181666_a(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            buff.func_181662_b(-1.0, 1.0, 1.0).func_181666_a(0.0f, 1.0f, 0.0f, 1.0f).func_181675_d();
            buff.func_178977_d();
            depthOverridePlane = new VertexBufferSingleVBO(buff);
        }
        return depthOverridePlane;
    }

    public static void drawDepthOverridePlane() {
        GlStateManager.func_179143_c((int)519);
        GlStateManager.func_179129_p();
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179090_x();
        WTWRenderer.getDepthOverridePlane().draw();
        GlStateManager.func_179098_w();
        GlStateManager.func_179128_n((int)5889);
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n((int)5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179089_o();
        GlStateManager.func_179143_c((int)515);
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void renderWorldLast(RenderWorldLastEvent event) {
        GL11.glClearStencil((int)0);
        GL11.glClear((int)1024);
        INSTANCE.run();
    }

    public static WTWRenderer instance() {
        return current.peek();
    }

    public static void pushInstance() {
        current.push(new WTWRenderer());
    }

    public static WTWRenderer popInstance() {
        return current.pop();
    }

    private void render(@Nonnull Phase phase, Consumer<WTWRenderer> renderer) {
        this.renderers.put((Object)phase, renderer);
    }

    private void render(@Nonnull Phase phase, Runnable renderer) {
        this.render(phase, (WTWRenderer wtw) -> renderer.run());
    }

    @Override
    public void run() {
        if (depth > 16) {
            return;
        }
        ++depth;
        for (Phase phase : Phase.values()) {
            if (!this.renderers.containsKey((Object)phase)) continue;
            phase.phasePre(this);
            this.renderers.get((Object)phase).forEach(renderer -> renderer.accept(this));
            phase.phasePost(this);
        }
        this.renderers.clear();
        --depth;
    }

    static {
        reuploadDOP = false;
        MinecraftForge.EVENT_BUS.register(WTWRenderer.class);
        current.push(INSTANCE);
    }

    public static enum Phase {
        NORMAL{

            @Override
            public void render(Runnable ... phaseSpecifics) {
                WTWRenderer.instance().render(this, phaseSpecifics[0]);
            }
        }
        ,
        DEPTHREADONLY{

            @Override
            void phasePre(WTWRenderer wtw) {
                GlStateManager.func_179132_a((boolean)false);
            }

            @Override
            public void render(Runnable ... phaseSpecifics) {
                WTWRenderer.instance().render(this, phaseSpecifics[0]);
            }

            @Override
            void phasePost(WTWRenderer wtw) {
                GlStateManager.func_179132_a((boolean)true);
            }
        }
        ,
        STENCIL{

            @Override
            void phasePre(WTWRenderer wtw) {
                assert (Minecraft.func_71410_x().func_147110_a().isStencilEnabled()) : "WTW Renderer can't work without stencils. Please enable them";
                if (stencilDepth == 0) {
                    GL11.glEnable((int)2960);
                }
                stencilDepth++;
            }

            @Override
            public void render(Runnable ... phaseSpecifics) {
                WTWRenderer.instance().render(this, wtw -> {
                    GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    GlStateManager.func_179132_a((boolean)false);
                    GL11.glStencilFunc((int)514, (int)(stencilDepth - 1), (int)255);
                    GL11.glStencilOp((int)7680, (int)7680, (int)7682);
                    GL11.glStencilMask((int)255);
                    phaseSpecifics[0].run();
                    GL11.glStencilOp((int)7680, (int)7680, (int)7680);
                    GL11.glStencilFunc((int)514, (int)stencilDepth, (int)255);
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    phaseSpecifics[1].run();
                    GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    GlStateManager.func_179132_a((boolean)false);
                    GL11.glStencilFunc((int)514, (int)stencilDepth, (int)255);
                    GL11.glStencilOp((int)7680, (int)7680, (int)7683);
                    GL11.glStencilMask((int)255);
                    phaseSpecifics[0].run();
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                });
            }

            @Override
            void phasePost(WTWRenderer wtw) {
                stencilDepth--;
                if (stencilDepth == 0) {
                    GL11.glDisable((int)2960);
                }
            }
        }
        ,
        STENCILDEPTHREADWRITE{

            @Override
            void phasePre(WTWRenderer wtw) {
                assert (Minecraft.func_71410_x().func_147110_a().isStencilEnabled()) : "WTW Renderer can't work without stencils. Please enable them";
                if (stencilDepth == 0) {
                    GL11.glEnable((int)2960);
                }
                stencilDepth++;
            }

            @Override
            public void render(Runnable ... phaseSpecifics) {
                WTWRenderer.instance().render(this, wtw -> {
                    GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    GlStateManager.func_179132_a((boolean)false);
                    GL11.glStencilFunc((int)514, (int)(stencilDepth - 1), (int)255);
                    GL11.glStencilOp((int)7680, (int)7680, (int)7682);
                    GL11.glStencilMask((int)255);
                    phaseSpecifics[0].run();
                    GL11.glStencilOp((int)7680, (int)7680, (int)7680);
                    GL11.glStencilFunc((int)514, (int)stencilDepth, (int)255);
                    GlStateManager.func_179132_a((boolean)true);
                    WTWRenderer.drawDepthOverridePlane();
                    GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                    phaseSpecifics[1].run();
                    GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
                    GlStateManager.func_179132_a((boolean)false);
                    GL11.glStencilFunc((int)514, (int)stencilDepth, (int)255);
                    GL11.glStencilOp((int)7680, (int)7680, (int)7683);
                    GL11.glStencilMask((int)255);
                    phaseSpecifics[0].run();
                    GlStateManager.func_179132_a((boolean)true);
                    GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
                });
            }

            @Override
            void phasePost(WTWRenderer wtw) {
                stencilDepth--;
                if (stencilDepth == 0) {
                    GL11.glDisable((int)2960);
                }
            }
        };


        public abstract void render(Runnable ... var1);

        void phasePre(WTWRenderer wtw) {
        }

        void phasePost(WTWRenderer wtw) {
        }
    }
}

