/*
 * Decompiled with CFR 0.152.
 */
package code.elix_x.excomms.reflection;

import code.elix_x.excomms.optional.NullableOptional;
import com.google.common.primitives.Primitives;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;

public class ReflectionHelper {
    private static final Field fieldConstructorModifiers;
    private static final Field fieldFieldModifiers;
    private static final Field fieldMethodModifiers;
    private static final Supplier<IllegalArgumentException> MODIFIERSEXC;
    private static final Supplier<IllegalArgumentException> ENUMEXC;

    public static Optional<Field> findField(Class<?> claz, String ... names) {
        Class<?> clas = claz;
        while (claz != null) {
            for (String name : names) {
                try {
                    return Optional.of(clas.getDeclaredField(name));
                }
                catch (Exception exception) {
                }
            }
            clas = claz.getSuperclass();
        }
        return Optional.empty();
    }

    public static Optional<Method> findMethod(Class<?> claz, String[] names, Class<?> ... args) {
        Class<?> clas = claz;
        while (claz != null) {
            for (String name : names) {
                try {
                    return Optional.of(clas.getDeclaredMethod(name, args));
                }
                catch (Exception exception) {
                }
            }
            clas = claz.getSuperclass();
        }
        return Optional.empty();
    }

    public static Class<?> wrapIfPrimitive(Class<?> c) {
        return c.isPrimitive() ? Primitives.wrap(c) : c;
    }

    public static boolean canArgApply(Class<?> param, Class<?> arg) {
        return arg == null ? !param.isPrimitive() : ReflectionHelper.wrapIfPrimitive(param).isAssignableFrom(ReflectionHelper.wrapIfPrimitive(arg));
    }

    public static boolean canArgApply(Class<?> param, Object arg) {
        return arg == null ? !param.isPrimitive() : ReflectionHelper.wrapIfPrimitive(param).isInstance(arg);
    }

    public static boolean allArgsApplicable(Class[] params, Class[] args) {
        if (params.length != args.length) {
            return false;
        }
        for (int a = 0; a < params.length; ++a) {
            if (ReflectionHelper.canArgApply(params[a], args[a])) continue;
            return false;
        }
        return true;
    }

    public static boolean allArgsApplicable(Class[] params, Object[] args) {
        if (params.length != args.length) {
            return false;
        }
        for (int a = 0; a < params.length; ++a) {
            if (ReflectionHelper.canArgApply(params[a], args[a])) continue;
            return false;
        }
        return true;
    }

    static /* synthetic */ Supplier access$000() {
        return MODIFIERSEXC;
    }

    static /* synthetic */ Supplier access$500() {
        return ENUMEXC;
    }

    static {
        try {
            fieldConstructorModifiers = Constructor.class.getDeclaredField("modifiers");
            fieldConstructorModifiers.setAccessible(true);
            fieldFieldModifiers = Field.class.getDeclaredField("modifiers");
            fieldFieldModifiers.setAccessible(true);
            fieldMethodModifiers = Method.class.getDeclaredField("modifiers");
            fieldMethodModifiers.setAccessible(true);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not initialize reflection framework - required internals not found!");
        }
        MODIFIERSEXC = () -> new IllegalArgumentException("Could not initialize modifiers manipulation framework - required internals not found!");
        ENUMEXC = () -> new IllegalArgumentException("Could not initialize enum manipulation framework - required internals not found!");
    }

    public static class AMethod<C, T>
    extends AccessibleReflectionObject<C, Method, AMethod<C, T>> {
        private AMethod(AClass<C> clas, Method method) {
            super(clas, method, null);
        }

        @Override
        public boolean is(Modifier modifier) {
            return modifier.is(((Method)this.get()).getModifiers());
        }

        @Override
        public AMethod<C, T> set(Modifier modifier, boolean on) {
            try {
                fieldMethodModifiers.setInt(this.get(), modifier.set(((Method)this.get()).getModifiers(), on));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public <I extends C> NullableOptional<T> invoke(I instance, Object ... args) {
            try {
                return NullableOptional.of(((Method)this.get()).invoke(instance, args));
            }
            catch (Exception exception) {
                return NullableOptional.empty();
            }
        }
    }

    public static class AField<C, T>
    extends AccessibleReflectionObject<C, Field, AField<C, T>> {
        private AField(AClass<C> clas, Field field) {
            super(clas, field, null);
        }

        @Override
        public boolean is(Modifier modifier) {
            return modifier.is(((Field)this.get()).getModifiers());
        }

        @Override
        public AField<C, T> set(Modifier modifier, boolean on) {
            try {
                fieldFieldModifiers.setInt(this.get(), modifier.set(((Field)this.get()).getModifiers(), on));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public AField<C, T> setFinal(boolean finall) {
            return this.set(Modifier.FINAL, finall);
        }

        public <I extends C> NullableOptional<T> get(I instance) {
            try {
                return NullableOptional.of(((Field)this.get()).get(instance));
            }
            catch (Exception exception) {
                return NullableOptional.empty();
            }
        }

        public <I extends C> boolean set(I instance, Object t) {
            try {
                ((Field)this.get()).set(instance, t);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        public <I extends C> Mutable<T> asMutable(final I instance) {
            return new Mutable<T>(){

                public T getValue() {
                    return this.get(instance).orElseThrow(() -> new IllegalArgumentException(String.format("Could not get field (%s) value!", this.get())));
                }

                public void setValue(T value) {
                    if (!this.set(instance, value)) {
                        throw new IllegalArgumentException(String.format("Could not set field (%s) value (to %s)!", this.get(), value));
                    }
                }
            };
        }
    }

    public static class AConstructor<C>
    extends AccessibleReflectionObject<C, Constructor<C>, AConstructor<C>> {
        private AConstructor(AClass<C> clas, Constructor<C> constructor) {
            super(clas, constructor, null);
        }

        @Override
        public boolean is(Modifier modifier) {
            return modifier.is(((Constructor)this.get()).getModifiers());
        }

        @Override
        public AConstructor<C> set(Modifier modifier, boolean on) {
            try {
                fieldConstructorModifiers.setInt(this.get(), modifier.set(((Constructor)this.get()).getModifiers(), on));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return this;
        }

        public Optional<C> newInstance(Object ... args) {
            try {
                return Optional.of(((Constructor)this.get()).newInstance(args));
            }
            catch (Exception exception) {
                return Optional.empty();
            }
        }
    }

    private static abstract class AccessibleReflectionObject<C, T extends AccessibleObject, R extends AccessibleReflectionObject<C, T, R>>
    extends ReflectionObject<C, T, R> {
        private AccessibleReflectionObject(AClass<C> clas, T t) {
            super(clas, t);
        }

        public boolean isAccessible() {
            return ((AccessibleObject)this.get()).isAccessible();
        }

        public R setAccessible(boolean accessible) {
            ((AccessibleObject)this.get()).setAccessible(accessible);
            return (R)this;
        }

        /* synthetic */ AccessibleReflectionObject(AClass x0, AccessibleObject x1, 1 x2) {
            this(x0, x1);
        }
    }

    private static abstract class ReflectionObject<C, T, R extends ReflectionObject<C, T, R>> {
        private final AClass<C> clas;
        private final T t;

        private ReflectionObject(AClass<C> clas, T t) {
            this.clas = clas;
            this.t = t;
        }

        public AClass<C> clas() {
            return this.clas;
        }

        public final T get() {
            return this.t;
        }

        public List<Modifier> modifiers() {
            return Arrays.stream(Modifier.values()).filter(this::is).collect(Collectors.toList());
        }

        public abstract boolean is(Modifier var1);

        public abstract R set(Modifier var1, boolean var2);
    }

    public static class AClass<C> {
        protected final Class<C> clas;

        public static <C> Optional<AClass<C>> find(String ... names) {
            for (String name : names) {
                try {
                    return Optional.of(Class.forName(name)).map(AClass::new);
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            return Optional.empty();
        }

        public AClass(Class<C> clas) {
            this.clas = clas;
        }

        public Class<C> get() {
            return this.clas;
        }

        public Optional<AClass<? super C>> getSuperclass() {
            return Optional.ofNullable(this.clas.getSuperclass()).map(AClass::new);
        }

        public boolean isInterface() {
            return this.clas.isInterface();
        }

        public AInterface<C> asInterface() {
            return new AInterface(this.clas);
        }

        public boolean isEnum() {
            return this.clas.isEnum();
        }

        public <E extends Enum<E>> AEnum<E> asEnum() {
            return new AEnum(this.clas);
        }

        public boolean isAnnotation() {
            return this.clas.isAnnotation();
        }

        public AAnnotation<C> asAnnotation() {
            return new AAnnotation(this.clas);
        }

        public Optional<AConstructor<C>> getDeclaredConstructor(Class<?> ... args) {
            try {
                return Optional.of(new AConstructor(this, this.clas.getDeclaredConstructor(args)));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                return Optional.empty();
            }
        }

        public Stream<AConstructor<C>> getDeclaredConstructors() {
            return Arrays.stream(this.clas.getDeclaredConstructors()).map(constructor -> new AConstructor(this, (Constructor)constructor));
        }

        public Stream<AConstructor<C>> findConstructorsForArgs(Class<?> ... args) {
            return this.getDeclaredConstructors().filter(ac -> ReflectionHelper.allArgsApplicable((Class[])((Constructor)ac.get()).getParameterTypes(), args));
        }

        public Stream<AConstructor<C>> findConstructorsForArgs(Object ... args) {
            return this.getDeclaredConstructors().filter(ac -> ReflectionHelper.allArgsApplicable((Class[])((Constructor)ac.get()).getParameterTypes(), args));
        }

        public <T> Optional<AField<C, T>> getDeclaredField(String ... names) {
            return ReflectionHelper.findField(this.clas, names).map(f -> new AField(this, (Field)f));
        }

        public <T> Stream<AField<C, T>> getDeclaredFields() {
            return Arrays.stream(this.clas.getDeclaredFields()).map(f -> new AField(this, (Field)f));
        }

        public <T> Stream<AField<? super C, T>> getFields() {
            MutableObject stream = new MutableObject(this.getDeclaredFields());
            this.getSuperclass().ifPresent(clas -> stream.setValue(Stream.concat((Stream)stream.getValue(), clas.getFields())));
            return (Stream)stream.getValue();
        }

        public <T> Optional<AMethod<C, T>> getDeclaredMethod(String[] names, Class<?> ... args) {
            return ReflectionHelper.findMethod(this.clas, names, args).map(m -> new AMethod(this, (Method)m));
        }

        public <T> Stream<AMethod<C, T>> getDeclaredMethods() {
            return Arrays.stream(this.clas.getDeclaredMethods()).map(m -> new AMethod(this, (Method)m));
        }

        public <T> Stream<AMethod<C, T>> findDeclaredMethodsForArgs(Class<?> ... args) {
            return this.getDeclaredMethods().filter(am -> ReflectionHelper.allArgsApplicable((Class[])((Method)am.get()).getParameterTypes(), args));
        }

        public <T> Stream<AMethod<C, T>> findDeclaredMethodsForArgs(Object ... args) {
            return this.getDeclaredMethods().filter(am -> ReflectionHelper.allArgsApplicable((Class[])((Method)am.get()).getParameterTypes(), args));
        }

        public <T> Stream<AMethod<? super C, T>> getMethods() {
            MutableObject stream = new MutableObject(this.getDeclaredMethods());
            this.getSuperclass().ifPresent(clas -> stream.setValue(Stream.concat((Stream)stream.getValue(), clas.getMethods())));
            return (Stream)stream.getValue();
        }

        public <T> Stream<AMethod<? super C, T>> findMethodsForArgs(Object ... args) {
            return this.getMethods().filter(am -> ReflectionHelper.allArgsApplicable((Class[])((Method)am.get()).getParameterTypes(), args));
        }

        public static class AAnnotation<C>
        extends AClass<C> {
            private AAnnotation(Class<C> clas) {
                super(clas);
            }
        }

        public static class AEnum<C extends Enum<C>>
        extends AClass<C> {
            private static final AClass<?> reflectionFactory = AClass.find("sun.reflect.ReflectionFactory").orElseThrow(ReflectionHelper.access$500());
            private static final AMethod<?, ?> getReflectionFactory = (AMethod)reflectionFactory.getDeclaredMethod(new String[]{"getReflectionFactory"}, new Class[0]).orElseThrow(ReflectionHelper.access$500()).setAccessible(true);
            private static final AMethod newConstructorAccessor = (AMethod)reflectionFactory.getDeclaredMethod(new String[]{"newConstructorAccessor"}, Constructor.class).orElseThrow(ReflectionHelper.access$500()).setAccessible(true);
            private static final AClass<?> constructorAccessor = AClass.find("sun.reflect.ConstructorAccessor").orElseThrow(ReflectionHelper.access$500());
            private static final AMethod newInstance = (AMethod)constructorAccessor.getDeclaredMethod(new String[]{"newInstance"}, Object[].class).orElseThrow(ReflectionHelper.access$500()).setAccessible(true);
            private final AField<C, C[]> VALUES = ((AField)this.getDeclaredField("$VALUES", "ENUM$VALUES").orElseThrow(() -> new IllegalArgumentException(String.format("Could not initialize enum (%s) reflector - VALUES[] not found!", clas.getName()))).setAccessible(true)).setFinal(false);
            private final Object factory = getReflectionFactory.invoke(null, new Object[0]).orElseThrow(() -> new IllegalArgumentException(String.format("Could not initialize enum (%s) reflector - could not get ReflectionFactory!", clas.getName())));

            private AEnum(Class<C> clas) {
                super(clas);
            }

            public C[] enums() {
                return (Enum[])this.clas.getEnumConstants();
            }

            public C getEnum(int ordinal) {
                return (C)this.enums()[ordinal];
            }

            public C getEnum(String name) {
                return (C)Enum.valueOf(this.clas, name);
            }

            public Optional<EnumCreator> findEnumCreatorForArgs(Class<?> ... args) {
                return this.findConstructorsForArgs((Class[])ArrayUtils.addAll((Object[])new Class[]{String.class, Integer.TYPE}, (Object[])args)).findAny().map(x$0 -> new EnumCreator((AConstructor)x$0));
            }

            public Optional<EnumCreator> findEnumCreatorForArgs(Object ... args) {
                return this.findConstructorsForArgs(ArrayUtils.addAll((Object[])new Object[]{"", 0}, (Object[])args)).findAny().map(x$0 -> new EnumCreator((AConstructor)x$0));
            }

            public Optional<C> createEnum(String name, Object ... args) {
                return this.findEnumCreatorForArgs(args).flatMap(creator -> creator.create(name, args));
            }

            public Optional<C> addEnum(String name, Object ... args) {
                return this.findEnumCreatorForArgs(args).flatMap(creator -> creator.add(name, args));
            }

            public void removeEnum(C c) {
                this.VALUES.set(null, ArrayUtils.removeElement((Object[])this.enums(), c));
            }

            public class EnumCreator {
                private final AConstructor<C> constructor;

                private EnumCreator(AConstructor<C> constructor) {
                    this.constructor = constructor;
                }

                public Optional<C> create(String name, Object ... args) {
                    return newConstructorAccessor.invoke(AEnum.this.factory, this.constructor.get()).orElseOpt(Optional.empty()).flatMap(ca -> newInstance.invoke(ca, new Object[]{ArrayUtils.addAll((Object[])new Object[]{name, AEnum.this.enums().length}, (Object[])args)}).orElseOpt(Optional.empty()));
                }

                public Optional<C> add(String name, Object ... args) {
                    return this.create(name, args).map(c -> {
                        AEnum.this.VALUES.set(null, ArrayUtils.add((Object[])AEnum.this.clas.getEnumConstants(), (Object)c));
                        return c;
                    });
                }
            }
        }

        public static class AInterface<C>
        extends AClass<C> {
            private AInterface(Class<C> clas) {
                super(clas);
            }

            public C proxy(InvocationHandler handler, AInterface<?> ... interfaces) {
                return this.proxy(this.clas.getClassLoader(), handler, interfaces);
            }

            public C proxy(ClassLoader loader, InvocationHandler handler, AInterface<?> ... interfaces) {
                return (C)Proxy.newProxyInstance(loader, (Class[])Stream.concat(Stream.of(this), Arrays.stream(interfaces)).map(iface -> iface.clas).toArray(Class[]::new), handler);
            }
        }
    }

    public static enum Modifier {
        PUBLIC,
        PRIVATE,
        PROTECTED,
        STATIC,
        FINAL,
        SYNCHRONIZED,
        VOLATILE,
        TRANSIENT,
        NATIVE,
        INTERFACE,
        ABSTRACT,
        STRICT,
        BRIDGE,
        VARARGS,
        SYNTHETIC,
        ANNOTATION,
        ENUM,
        MANDATED;

        final int modifier = (Integer)((AField)new AClass<java.lang.reflect.Modifier>(java.lang.reflect.Modifier.class).getDeclaredField(this.name()).orElseThrow(ReflectionHelper.access$000()).setAccessible(true)).get(null).orElseThrow(ReflectionHelper.access$000());

        private boolean is(int original) {
            return (original & this.modifier) != 0;
        }

        private int set(int original, boolean on) {
            if (on) {
                return original | this.modifier;
            }
            return original & ~this.modifier;
        }
    }
}

