/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.dataloader.sources;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import net.darkhax.bookshelf.dataloader.DataLoader;
import net.darkhax.bookshelf.dataloader.sources.DataProviderPredicate;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;

public class DataProviderAddons
extends DataProviderPredicate {
    private final File addonsDir;

    public DataProviderAddons(String modid) {
        this(new File("addons/" + modid));
    }

    public DataProviderAddons(File addonsDir) {
        this.addonsDir = addonsDir;
        if (!this.addonsDir.exists()) {
            this.addonsDir.mkdirs();
        }
    }

    private void loadFromPath(DataLoader loader, Path filePath, File file, BiConsumer<ResourceLocation, BufferedReader> processor) {
        if (this.getPathValidator().test(filePath)) {
            try (BufferedReader reader = Files.newBufferedReader(filePath);){
                processor.accept(null, reader);
            }
            catch (Exception e) {
                loader.getLogger().error("Failed to read file {} from pack {}. The file was not valid.", (Object)filePath.toString(), (Object)file.getName());
                loader.getLogger().catching((Throwable)e);
            }
        }
    }

    private boolean isValidPackFile(File file) {
        return !file.isDirectory() && "zip".equalsIgnoreCase(FilenameUtils.getExtension((String)file.getPath()));
    }

    @Override
    public void provideDataToProcessors(DataLoader loader) {
        if (this.addonsDir.exists() && this.addonsDir.isDirectory()) {
            for (File file : this.addonsDir.listFiles()) {
                if (!this.isValidPackFile(file)) continue;
                try (FileSystem fs = FileSystems.newFileSystem(file.toPath(), null);){
                    for (Map.Entry<String, BiConsumer<ResourceLocation, BufferedReader>> entry : loader.getProcessors().entrySet()) {
                        Path root = fs.getPath("/", entry.getKey());
                        if (!Files.exists(root, new LinkOption[0])) continue;
                        Stream<Path> stream = Files.walk(root, new FileVisitOption[0]);
                        Throwable throwable = null;
                        try {
                            stream.forEach(path -> this.loadFromPath(loader, (Path)path, file, (BiConsumer)entry.getValue()));
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            stream.close();
                        }
                    }
                }
                catch (IOException e) {
                    loader.getLogger().info("Unable to load from {}", (Object)file.getName());
                    loader.getLogger().error((Object)e);
                }
            }
        }
    }
}

