/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidBlock;
import teamroots.embers.EventManager;
import teamroots.embers.block.BlockPump;
import teamroots.embers.power.DefaultMechCapability;
import teamroots.embers.power.MechCapabilityProvider;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityPumpTop;
import teamroots.embers.util.FluidUtil;

public class TileEntityPumpBottom
extends TileEntity
implements ITileEntityBase,
ITickable {
    int ticksExisted = 0;
    int progress = 0;
    EnumFacing front = EnumFacing.UP;
    public DefaultMechCapability capability = new DefaultMechCapability(){

        @Override
        public double getPower(EnumFacing face) {
            if (face != null) {
                return 0.0;
            }
            return super.getPower(face);
        }

        @Override
        public void onContentsChanged() {
            TileEntityPumpBottom.this.func_70296_d();
        }
    };
    public boolean dirty = false;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        tag.func_74768_a("progress", this.progress);
        tag.func_74768_a("front", this.front.func_176745_a());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
        this.front = EnumFacing.func_82600_a((int)tag.func_74762_e("front"));
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == MechCapabilityProvider.mechCapability) {
            return facing.func_176740_k() == this.front.func_176740_k();
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == MechCapabilityProvider.mechCapability) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public boolean attemptPump(BlockPos pos) {
        TileEntityPumpTop t;
        int filled;
        FluidStack stack;
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        if ((state.func_177230_c() instanceof IFluidBlock && ((IFluidBlock)state.func_177230_c()).canDrain(this.field_145850_b, pos) || state.func_177230_c() instanceof BlockStaticLiquid) && (this.capability.getPower(null) > 0.0 || state.func_177230_c() == Blocks.field_150355_j) && (stack = FluidUtil.getFluid(this.field_145850_b, pos, state)) != null && (filled = (t = (TileEntityPumpTop)this.field_145850_b.func_175625_s(this.func_174877_v().func_177984_a())).getTank().fill(stack, false)) == stack.amount) {
            if (!this.field_145850_b.field_72995_K) {
                t.getTank().fill(stack, true);
            }
            t.func_70296_d();
            this.field_145850_b.func_175698_g(pos);
            this.field_145850_b.func_184138_a(pos, state, Blocks.field_150350_a.func_176223_P(), 8);
            this.field_145850_b.func_175685_c(pos.func_177978_c(), Blocks.field_150350_a, true);
            this.field_145850_b.func_175685_c(pos.func_177968_d(), Blocks.field_150350_a, true);
            this.field_145850_b.func_175685_c(pos.func_177974_f(), Blocks.field_150350_a, true);
            this.field_145850_b.func_175685_c(pos.func_177976_e(), Blocks.field_150350_a, true);
            this.field_145850_b.func_175685_c(pos.func_177984_a(), Blocks.field_150350_a, true);
            this.field_145850_b.func_175685_c(pos.func_177977_b(), Blocks.field_150350_a, true);
            this.field_145850_b.func_175685_c(pos, Blocks.field_150350_a, true);
            return false;
        }
        return true;
    }

    public void func_73660_a() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockPump) {
            this.front = (EnumFacing)state.func_177229_b((IProperty)BlockPump.facing);
        }
        this.progress += Math.min(100, Math.max(0, (int)Math.floor(0.5 * this.capability.getPower(null))));
        if (this.progress > 400) {
            this.progress -= 400;
            boolean doContinue = true;
            for (int r = 0; r < 6 && doContinue; ++r) {
                for (int i = -r; i < r + 1 && doContinue; ++i) {
                    for (int j = -r; j < 1 && doContinue; ++j) {
                        for (int k = -r; k < r + 1 && doContinue; ++k) {
                            doContinue = this.attemptPump(this.func_174877_v().func_177982_a(i, j - 1, k));
                        }
                    }
                }
            }
        }
        this.func_70296_d();
    }
}

