/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.EventManager;
import teamroots.embers.block.BlockEmberInjector;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.power.EmberCapabilityProvider;
import teamroots.embers.power.IEmberCapability;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntitySeed;

public class TileEntityEmberInjector
extends TileEntity
implements ITileEntityBase,
ITickable {
    public IEmberCapability capability = new DefaultEmberCapability();
    int ticksExisted = 0;
    int progress = -1;
    Random random = new Random();
    public boolean dirty = false;

    public TileEntityEmberInjector() {
        this.capability.setEmberCapacity(24000.0);
        this.capability.setEmber(0.0);
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmberCapabilityProvider.emberCapability) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmberCapabilityProvider.emberCapability) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175690_a(pos, null);
    }

    public void func_73660_a() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a((EnumFacing)state.func_177229_b((IProperty)BlockEmberInjector.facing)));
        if (tile instanceof TileEntitySeed && this.capability.getEmber() > 1.0) {
            ++((TileEntitySeed)tile).size;
            ((TileEntitySeed)tile).func_70296_d();
            this.capability.removeAmount(1.0, true);
            this.func_70296_d();
            if (this.field_145850_b.field_72995_K) {
                for (int i = 0; i < 2; ++i) {
                    ParticleUtil.spawnParticleLineGlow(this.field_145850_b, (float)this.field_174879_c.func_177958_n() + 0.5f + 0.25f * (this.random.nextFloat() - 0.5f), (float)this.field_174879_c.func_177956_o() + 0.625f, (float)this.field_174879_c.func_177952_p() + 0.5f + 0.25f * (this.random.nextFloat() - 0.5f), (float)tile.func_174877_v().func_177958_n() + 0.5f + (float)((EnumFacing)state.func_177229_b((IProperty)BlockEmberInjector.facing)).func_176730_m().func_177958_n() + 0.5f * (this.random.nextFloat() - 0.5f), (float)tile.func_174877_v().func_177956_o() + 0.5f + (float)((EnumFacing)state.func_177229_b((IProperty)BlockEmberInjector.facing)).func_176730_m().func_177956_o() + 0.5f * (this.random.nextFloat() - 0.5f), (float)tile.func_174877_v().func_177952_p() + 0.5f + (float)((EnumFacing)state.func_177229_b((IProperty)BlockEmberInjector.facing)).func_176730_m().func_177952_p() + 0.5f * (this.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, 4.0f + this.random.nextFloat() * 2.0f, 40);
                }
            }
        }
    }
}

