/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.EventManager;
import teamroots.embers.RegistryManager;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageAnvilSparksFX;
import teamroots.embers.network.message.MessageStamperFX;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityBin;
import teamroots.embers.util.ItemModUtil;
import teamroots.embers.util.Misc;

public class TileEntityDawnstoneAnvil
extends TileEntity
implements ITileEntityBase {
    int ticksExisted = 0;
    int progress = 0;
    public ItemStackHandler inventory = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            TileEntityDawnstoneAnvil.this.func_70296_d();
        }
    };
    Random random = new Random();
    public boolean dirty = false;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("progress", this.progress);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        this.progress = tag.func_74762_e("progress");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        block5: {
            ItemStack heldItem;
            block4: {
                heldItem = player.func_184586_b(hand);
                if (!heldItem.func_190926_b() || hand != EnumHand.MAIN_HAND) break block4;
                boolean doContinue = true;
                for (int i = 1; i >= 0 && doContinue; --i) {
                    if (this.inventory.getStackInSlot(i).func_190926_b() || world.field_72995_K) continue;
                    world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, this.inventory.getStackInSlot(i)));
                    this.inventory.setStackInSlot(i, ItemStack.field_190927_a);
                    doContinue = false;
                    this.progress = 0;
                    this.func_70296_d();
                    return true;
                }
                break block5;
            }
            if (heldItem.func_77973_b() == RegistryManager.tinker_hammer) {
                this.onHit();
                return true;
            }
            if (heldItem.func_190926_b() || hand != EnumHand.MAIN_HAND) break block5;
            ItemStack stack = heldItem.func_77946_l();
            ItemStack stack2 = heldItem.func_77946_l();
            stack2.func_190920_e(1);
            boolean doContinue = true;
            for (int i = 0; i < 2 && doContinue; ++i) {
                if (!this.inventory.getStackInSlot(i).func_190926_b()) continue;
                this.inventory.insertItem(i, stack2, false);
                doContinue = false;
                player.func_184586_b(hand).func_190918_g(1);
                if (player.func_184586_b(hand).func_190916_E() == 0) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
                this.progress = 0;
                this.func_70296_d();
                return true;
            }
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        world.func_175690_a(pos, null);
    }

    public boolean isValid(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() instanceof ItemTool || stack1.func_77973_b() instanceof ItemSword || stack1.func_77973_b() instanceof ItemArmor) {
            if (!ItemModUtil.hasHeat(stack1) && stack2.func_77973_b() == RegistryManager.ancient_motive_core) {
                return true;
            }
            if (ItemModUtil.hasHeat(stack1) && ItemModUtil.modifierRegistry.containsKey(stack2.func_77973_b()) && ItemModUtil.getLevel(stack1) > ItemModUtil.getTotalModLevel(stack1) && ItemModUtil.isModValid(stack1, stack2)) {
                return true;
            }
            if (ItemModUtil.hasHeat(stack1) && stack1.func_77978_p().func_74775_l("embers:heat_tag").func_150295_c("modifiers", 10).func_74745_c() > 0 && stack2.func_190926_b()) {
                return true;
            }
        }
        if (stack1.func_77973_b().func_82789_a(stack1, stack2) || stack1.func_77973_b().isRepairable() && stack2.func_77973_b() == RegistryManager.isolated_materia) {
            return true;
        }
        return !Misc.getRepairItem(stack1).func_190926_b() && stack1.func_77973_b().func_82789_a(stack1, Misc.getRepairItem(stack1)) && Misc.getResourceCount(stack1) != -1 && stack2.func_190926_b();
    }

    public ItemStack[] getResult(ItemStack stack1, ItemStack stack2) {
        if (stack1.func_77973_b() instanceof ItemTool || stack1.func_77973_b() instanceof ItemSword || stack1.func_77973_b() instanceof ItemArmor) {
            if (!(ItemModUtil.hasHeat(stack1) && ItemModUtil.hasModifier(stack1, ItemModUtil.modifierRegistry.get((Object)RegistryManager.ancient_motive_core).name) || stack2.func_77973_b() != RegistryManager.ancient_motive_core)) {
                ItemModUtil.checkForTag(stack1);
                ItemModUtil.addModifier(stack1, stack2.func_77946_l());
                ItemStack result = stack1.func_77946_l();
                this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                this.func_70296_d();
                return new ItemStack[]{result};
            }
            if (ItemModUtil.hasHeat(stack1) && ItemModUtil.modifierRegistry.containsKey(stack2.func_77973_b())) {
                ItemModUtil.checkForTag(stack1);
                ItemModUtil.addModifier(stack1, stack2);
                ItemStack result = stack1.func_77946_l();
                this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                this.func_70296_d();
                return new ItemStack[]{result};
            }
            if (ItemModUtil.hasHeat(stack1) && stack2.func_190926_b() && stack1.func_77978_p().func_74775_l("embers:heat_tag").func_150295_c("modifiers", 10).func_74745_c() > 0) {
                ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
                for (int i = 0; i < stack1.func_77978_p().func_74775_l("embers:heat_tag").func_150295_c("modifiers", 10).func_74745_c(); ++i) {
                    ItemStack s = new ItemStack(stack1.func_77978_p().func_74775_l("embers:heat_tag").func_150295_c("modifiers", 10).func_150305_b(i).func_74775_l("item"));
                    if (ItemModUtil.modifierRegistry.get(s.func_77973_b()) == null || !ItemModUtil.modifierRegistry.get((Object)s.func_77973_b()).countTowardsTotalLevel) continue;
                    for (int j = 0; j < stack1.func_77978_p().func_74775_l("embers:heat_tag").func_150295_c("modifiers", 10).func_150305_b(i).func_74762_e("level"); ++j) {
                        stacks.add(new ItemStack(stack1.func_77978_p().func_74775_l("embers:heat_tag").func_150295_c("modifiers", 10).func_150305_b(i).func_74775_l("item")));
                    }
                }
                stack1.func_77978_p().func_74775_l("embers:heat_tag").func_74782_a("modifiers", (NBTBase)new NBTTagList());
                stacks.add(stack1.func_77946_l());
                this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
                this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
                this.func_70296_d();
                return stacks.toArray(new ItemStack[stacks.size()]);
            }
        }
        if (stack1.func_77973_b().func_82789_a(stack1, stack2) || stack1.func_77973_b().isRepairable() && stack2.func_77973_b() == RegistryManager.isolated_materia) {
            this.inventory.setStackInSlot(1, ItemStack.field_190927_a);
            this.inventory.getStackInSlot(0).func_77964_b(Math.max(0, this.inventory.getStackInSlot(0).func_77952_i() - this.inventory.getStackInSlot(0).func_77958_k()));
            ItemStack result = this.inventory.getStackInSlot(0).func_77946_l();
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            this.func_70296_d();
            return new ItemStack[]{result};
        }
        if (stack1.func_77973_b().func_82789_a(stack1, Misc.getRepairItem(stack1)) && Misc.getResourceCount(stack1) != -1 && stack2 == ItemStack.field_190927_a) {
            int resourceAmount = Misc.getResourceCount(stack1);
            this.inventory.setStackInSlot(0, ItemStack.field_190927_a);
            this.func_70296_d();
            return new ItemStack[]{new ItemStack(Misc.getRepairItem(stack1).func_77973_b(), resourceAmount, Misc.getRepairItem(stack1).func_77952_i())};
        }
        return new ItemStack[0];
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }

    public void onHit() {
        if (this.isValid(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1))) {
            ++this.progress;
            this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.25f, 2.0f + this.random.nextFloat(), false);
            if (this.progress > 40) {
                this.progress = 0;
                ItemStack[] results = this.getResult(this.inventory.getStackInSlot(0), this.inventory.getStackInSlot(1));
                for (int i = 0; i < results.length; ++i) {
                    ItemStack result = results[i];
                    if (this.func_145831_w().func_175625_s(this.func_174877_v().func_177977_b()) instanceof TileEntityBin) {
                        TileEntityBin bin = (TileEntityBin)this.func_145831_w().func_175625_s(this.func_174877_v().func_177977_b());
                        ItemStack remainder = bin.inventory.insertItem(0, result, false);
                        if (remainder != ItemStack.field_190927_a && !this.func_145831_w().field_72995_K) {
                            EntityItem item = new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)((float)this.func_174877_v().func_177956_o() + 1.0625f), (double)this.func_174877_v().func_177952_p() + 0.5, remainder);
                            this.func_145831_w().func_72838_d((Entity)item);
                        }
                        bin.func_70296_d();
                        this.func_70296_d();
                        continue;
                    }
                    if (this.field_145850_b.field_72995_K) continue;
                    EntityItem item = new EntityItem(this.func_145831_w(), (double)this.func_174877_v().func_177958_n() + 0.5, (double)((float)this.func_174877_v().func_177956_o() + 1.0625f), (double)this.func_174877_v().func_177952_p() + 0.5, result);
                    this.func_145831_w().func_72838_d((Entity)item);
                }
                if (!this.func_145831_w().field_72995_K) {
                    PacketHandler.INSTANCE.sendToAll((IMessage)new MessageStamperFX((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.0625, (double)this.func_174877_v().func_177952_p() + 0.5));
                }
                this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187689_f, SoundCategory.BLOCKS, 1.0f, 0.95f + this.random.nextFloat() * 0.1f, false);
            }
            this.func_70296_d();
            if (!this.func_145831_w().field_72995_K) {
                PacketHandler.INSTANCE.sendToAll((IMessage)new MessageAnvilSparksFX((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.0625, (double)this.func_174877_v().func_177952_p() + 0.5));
            }
        }
    }
}

