/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBucket;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.TileFluidHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.EventManager;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageEmberActivationFX;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityBoilerTop;
import teamroots.embers.util.EmberGenUtil;
import teamroots.embers.util.Misc;

public class TileEntityBoilerBottom
extends TileFluidHandler
implements ITileEntityBase,
ITickable {
    public static int capacity = 8000;
    Random random = new Random();
    int progress = -1;
    public ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileEntityBoilerBottom.this.func_70296_d();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (EmberGenUtil.getEmberForItem(stack.func_77973_b()) == 0.0) {
                return stack;
            }
            return super.insertItem(slot, stack, simulate);
        }
    };
    public boolean dirty = false;

    public TileEntityBoilerBottom() {
        this.tank = new FluidTank(capacity);
        this.tank.setTileEntity((TileEntity)this);
        this.tank.setCanFill(true);
        this.tank.setCanDrain(true);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        tag.func_74768_a("progress", this.progress);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (heldItem.func_77973_b() instanceof ItemBucket || heldItem.func_77973_b() instanceof UniversalBucket) {
            boolean didFill = FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)hand, (IFluidHandler)((IFluidHandler)this.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side)));
            this.func_70296_d();
            return didFill;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        Misc.spawnInventoryInWorld(this.func_145831_w(), (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (IItemHandler)this.inventory);
        world.func_175690_a(pos, null);
    }

    public float getMultiplier() {
        float metalMultiplier = EmberGenUtil.getMetalCoefficient(this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()));
        float totalMult = 1.5f;
        IBlockState north = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b().func_177978_c());
        IBlockState south = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b().func_177968_d());
        IBlockState east = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b().func_177974_f());
        IBlockState west = this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b().func_177976_e());
        if (north.func_177230_c() == Blocks.field_150353_l || north.func_177230_c() == Blocks.field_150356_k || north.func_177230_c() == Blocks.field_150480_ab) {
            totalMult += 0.375f * metalMultiplier;
        }
        if (south.func_177230_c() == Blocks.field_150353_l || south.func_177230_c() == Blocks.field_150356_k || south.func_177230_c() == Blocks.field_150480_ab) {
            totalMult += 0.375f * metalMultiplier;
        }
        if (east.func_177230_c() == Blocks.field_150353_l || east.func_177230_c() == Blocks.field_150356_k || east.func_177230_c() == Blocks.field_150480_ab) {
            totalMult += 0.375f * metalMultiplier;
        }
        if (west.func_177230_c() == Blocks.field_150353_l || west.func_177230_c() == Blocks.field_150356_k || west.func_177230_c() == Blocks.field_150480_ab) {
            totalMult += 0.375f * metalMultiplier;
        }
        return totalMult;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        TileEntityBoilerTop top;
        TileEntity tile = this.func_145831_w().func_175625_s(this.func_174877_v().func_177984_a());
        if (!this.inventory.getStackInSlot(0).func_190926_b() && this.tank.getFluid() != null && this.tank.getFluid().getFluid() == FluidRegistry.WATER && this.tank.getFluidAmount() > 25 && tile instanceof TileEntityBoilerTop && (top = (TileEntityBoilerTop)tile) != null) {
            ++this.progress;
            if (this.progress > 20) {
                this.progress = 0;
                int i = this.random.nextInt(this.inventory.getSlots());
                if (this.inventory != null && this.inventory.getStackInSlot(i) != ItemStack.field_190927_a && EmberGenUtil.getEmberForItem(this.inventory.getStackInSlot(i).func_77973_b()) > 0.0) {
                    double ember = EmberGenUtil.getEmberForItem(this.inventory.getStackInSlot(i).func_77973_b()) * (double)this.getMultiplier();
                    if (top.capability.getEmber() <= top.capability.getEmberCapacity() - ember) {
                        if (!this.field_145850_b.field_72995_K) {
                            PacketHandler.INSTANCE.sendToAll((IMessage)new MessageEmberActivationFX((float)this.func_174877_v().func_177958_n() + 0.5f, (float)this.func_174877_v().func_177956_o() + 1.5f, (float)this.func_174877_v().func_177952_p() + 0.5f));
                        }
                        top.capability.addAmount(ember, true);
                        this.inventory.extractItem(i, 1, false);
                        this.func_70296_d();
                        IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
                        top.func_70296_d();
                        state = this.func_145831_w().func_180495_p(this.func_174877_v().func_177984_a());
                    }
                }
            }
            this.func_70296_d();
        }
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), (TileEntity)this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }
}

