/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.recipe;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import teamroots.embers.ConfigManager;
import teamroots.embers.RegistryManager;
import teamroots.embers.item.EnumStampType;
import teamroots.embers.recipe.AlchemyRecipe;
import teamroots.embers.recipe.AshenCloakSocketRecipe;
import teamroots.embers.recipe.AshenCloakUnsocketRecipe;
import teamroots.embers.recipe.FluidMixingRecipe;
import teamroots.embers.recipe.ItemMeltingOreRecipe;
import teamroots.embers.recipe.ItemMeltingRecipe;
import teamroots.embers.recipe.ItemStampingOreRecipe;
import teamroots.embers.recipe.ItemStampingRecipe;
import teamroots.embers.recipe.ItemWasteStampingRecipe;

public class RecipeRegistry {
    public static ArrayList<ItemMeltingRecipe> meltingRecipes = new ArrayList();
    public static ArrayList<ItemMeltingOreRecipe> meltingOreRecipes = new ArrayList();
    public static ArrayList<ItemStampingRecipe> stampingRecipes = new ArrayList();
    public static ArrayList<ItemStampingOreRecipe> stampingOreRecipes = new ArrayList();
    public static ArrayList<FluidMixingRecipe> mixingRecipes = new ArrayList();
    public static ArrayList<AlchemyRecipe> alchemyRecipes = new ArrayList();

    public static ResourceLocation getRL(String s) {
        return new ResourceLocation("embers:" + s);
    }

    public static void registerMaterialSet(RegistryEvent.Register<IRecipe> event, String ingotKey, String nuggetKey, String blockKey, Item ingot, Item nugget, Item plate, Block block, Item pickaxe, Item axe, Item shovel, Item hoe, Item sword) {
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL(ingotKey + "_block"), new ItemStack(block), new Object[]{true, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), ingotKey}}).setRegistryName(RecipeRegistry.getRL(ingotKey + "_block")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL(ingotKey + "_ingot"), new ItemStack(ingot), new Object[]{true, new Object[]{"XXX", "XXX", "XXX", Character.valueOf('X'), nuggetKey}}).setRegistryName(RecipeRegistry.getRL(ingotKey + "_ingot")));
        event.getRegistry().register(new ShapelessOreRecipe(RecipeRegistry.getRL(ingotKey + "_block_decomp"), new ItemStack(ingot, 9), new Object[]{blockKey}).setRegistryName(RecipeRegistry.getRL(ingotKey + "_block_decomp")));
        event.getRegistry().register(new ShapelessOreRecipe(RecipeRegistry.getRL(ingotKey + "_ingot_decomp"), new ItemStack(nugget, 9), new Object[]{ingotKey}).setRegistryName(RecipeRegistry.getRL(ingotKey + "_ingot_decomp")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL(ingotKey + "_sword"), new ItemStack(sword, 1), new Object[]{true, new Object[]{" C ", " C ", " S ", Character.valueOf('C'), ingotKey, Character.valueOf('S'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL(ingotKey + "_sword")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL(ingotKey + "_pickaxe"), new ItemStack(pickaxe, 1), new Object[]{true, new Object[]{"CCC", " S ", " S ", Character.valueOf('C'), ingotKey, Character.valueOf('S'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL(ingotKey + "_pickaxe")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL(ingotKey + "_shovel"), new ItemStack(shovel, 1), new Object[]{true, new Object[]{" C ", " S ", " S ", Character.valueOf('C'), ingotKey, Character.valueOf('S'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL(ingotKey + "_shovel")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL(ingotKey + "_axe"), new ItemStack(axe, 1), new Object[]{true, new Object[]{" CC", " SC", " S ", Character.valueOf('C'), ingotKey, Character.valueOf('S'), "stickWood"}}).setMirrored(true).setRegistryName(RecipeRegistry.getRL(ingotKey + "_axe")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL(ingotKey + "_hoe"), new ItemStack(hoe, 1), new Object[]{true, new Object[]{" CC", " S ", " S ", Character.valueOf('C'), ingotKey, Character.valueOf('S'), "stickWood"}}).setMirrored(true).setRegistryName(RecipeRegistry.getRL(ingotKey + "_hoe")));
        event.getRegistry().register(new ShapelessOreRecipe(RecipeRegistry.getRL(ingotKey + "_plate"), new ItemStack(plate, 1), new Object[]{ingotKey, ingotKey, ingotKey, ingotKey, RegistryManager.tinker_hammer}).setRegistryName(RecipeRegistry.getRL(ingotKey + "_plate")));
    }

    public static void initOreDict() {
        OreDictionary.registerOre((String)"nuggetIron", (Item)RegistryManager.nugget_iron);
        OreDictionary.registerOre((String)"ingotCopper", (Item)RegistryManager.ingot_copper);
        OreDictionary.registerOre((String)"ingotLead", (Item)RegistryManager.ingot_lead);
        OreDictionary.registerOre((String)"ingotSilver", (Item)RegistryManager.ingot_silver);
        OreDictionary.registerOre((String)"ingotDawnstone", (Item)RegistryManager.ingot_dawnstone);
        OreDictionary.registerOre((String)"nuggetCopper", (Item)RegistryManager.nugget_copper);
        OreDictionary.registerOre((String)"nuggetLead", (Item)RegistryManager.nugget_lead);
        OreDictionary.registerOre((String)"nuggetSilver", (Item)RegistryManager.nugget_silver);
        OreDictionary.registerOre((String)"nuggetDawnstone", (Item)RegistryManager.nugget_dawnstone);
        OreDictionary.registerOre((String)"plateGold", (Item)RegistryManager.plate_gold);
        OreDictionary.registerOre((String)"plateIron", (Item)RegistryManager.plate_iron);
        OreDictionary.registerOre((String)"plateCopper", (Item)RegistryManager.plate_copper);
        OreDictionary.registerOre((String)"plateLead", (Item)RegistryManager.plate_lead);
        OreDictionary.registerOre((String)"plateSilver", (Item)RegistryManager.plate_silver);
        OreDictionary.registerOre((String)"plateDawnstone", (Item)RegistryManager.plate_dawnstone);
        OreDictionary.registerOre((String)"blockCopper", (Block)RegistryManager.block_copper);
        OreDictionary.registerOre((String)"blockLead", (Block)RegistryManager.block_lead);
        OreDictionary.registerOre((String)"blockSilver", (Block)RegistryManager.block_silver);
        OreDictionary.registerOre((String)"blockDawnstone", (Block)RegistryManager.block_dawnstone);
        OreDictionary.registerOre((String)"oreCopper", (Block)RegistryManager.ore_copper);
        OreDictionary.registerOre((String)"oreLead", (Block)RegistryManager.ore_lead);
        OreDictionary.registerOre((String)"oreSilver", (Block)RegistryManager.ore_silver);
        OreDictionary.registerOre((String)"oreQuartz", (Block)RegistryManager.ore_quartz);
        OreDictionary.registerOre((String)"slimeball", (Item)RegistryManager.adhesive);
        OreDictionary.registerOre((String)"nuggetIron", (Item)RegistryManager.nugget_iron);
        OreDictionary.registerOre((String)"dustAsh", (Item)RegistryManager.dust_ash);
        OreDictionary.registerOre((String)"dustAshes", (Item)RegistryManager.dust_ash);
        if (ConfigManager.enableAluminum) {
            OreDictionary.registerOre((String)"blockAluminum", (Block)RegistryManager.block_aluminum);
            OreDictionary.registerOre((String)"ingotAluminum", (Item)RegistryManager.ingot_aluminum);
            OreDictionary.registerOre((String)"nuggetAluminum", (Item)RegistryManager.nugget_aluminum);
            OreDictionary.registerOre((String)"plateAluminum", (Item)RegistryManager.plate_aluminum);
            OreDictionary.registerOre((String)"oreAluminum", (Block)RegistryManager.ore_aluminum);
        }
        if (ConfigManager.enableTin) {
            OreDictionary.registerOre((String)"blockTin", (Block)RegistryManager.block_tin);
            OreDictionary.registerOre((String)"ingotTin", (Item)RegistryManager.ingot_tin);
            OreDictionary.registerOre((String)"nuggetTin", (Item)RegistryManager.nugget_tin);
            OreDictionary.registerOre((String)"plateTin", (Item)RegistryManager.plate_tin);
            OreDictionary.registerOre((String)"oreTin", (Block)RegistryManager.ore_tin);
        }
        if (ConfigManager.enableNickel) {
            OreDictionary.registerOre((String)"blockNickel", (Block)RegistryManager.block_nickel);
            OreDictionary.registerOre((String)"ingotNickel", (Item)RegistryManager.ingot_nickel);
            OreDictionary.registerOre((String)"nuggetNickel", (Item)RegistryManager.nugget_nickel);
            OreDictionary.registerOre((String)"plateNickel", (Item)RegistryManager.plate_nickel);
            OreDictionary.registerOre((String)"oreNickel", (Block)RegistryManager.ore_nickel);
        }
        if (ConfigManager.enableBronze) {
            OreDictionary.registerOre((String)"blockBronze", (Block)RegistryManager.block_bronze);
            OreDictionary.registerOre((String)"ingotBronze", (Item)RegistryManager.ingot_bronze);
            OreDictionary.registerOre((String)"nuggetBronze", (Item)RegistryManager.nugget_bronze);
            OreDictionary.registerOre((String)"plateBronze", (Item)RegistryManager.plate_bronze);
        }
        if (ConfigManager.enableElectrum) {
            OreDictionary.registerOre((String)"blockElectrum", (Block)RegistryManager.block_electrum);
            OreDictionary.registerOre((String)"ingotElectrum", (Item)RegistryManager.ingot_electrum);
            OreDictionary.registerOre((String)"nuggetElectrum", (Item)RegistryManager.nugget_electrum);
            OreDictionary.registerOre((String)"plateElectrum", (Item)RegistryManager.plate_electrum);
        }
    }

    @SubscribeEvent
    public void init(RegistryEvent.Register<IRecipe> event) {
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("crystal_ember"), new ItemStack(RegistryManager.crystal_ember, 1), new Object[]{true, new Object[]{"XXX", "XXX", Character.valueOf('X'), RegistryManager.shard_ember}}).setRegistryName(RecipeRegistry.getRL("crystal_ember")));
        event.getRegistry().register(new ShapelessOreRecipe(RecipeRegistry.getRL("shard_ember"), new ItemStack(RegistryManager.shard_ember, 6), new Object[]{RegistryManager.crystal_ember}).setRegistryName(RecipeRegistry.getRL("shard_ember")));
        event.getRegistry().register(new ShapelessOreRecipe(RecipeRegistry.getRL("iron_nugget"), new ItemStack(RegistryManager.nugget_iron, 9), new Object[]{"ingotIron"}).setRegistryName(RecipeRegistry.getRL("iron_nugget")));
        event.getRegistry().register(new ShapelessOreRecipe(RecipeRegistry.getRL("plate_gold"), new ItemStack(RegistryManager.plate_gold, 1), new Object[]{"ingotGold", "ingotGold", "ingotGold", "ingotGold", RegistryManager.tinker_hammer}).setRegistryName(RecipeRegistry.getRL("plate_gold")));
        event.getRegistry().register(new ShapelessOreRecipe(RecipeRegistry.getRL("plate_iron"), new ItemStack(RegistryManager.plate_iron, 1), new Object[]{"ingotIron", "ingotIron", "ingotIron", "ingotIron", RegistryManager.tinker_hammer}).setRegistryName(RecipeRegistry.getRL("plate_iron")));
        RecipeRegistry.registerMaterialSet(event, "ingotLead", "nuggetLead", "blockLead", RegistryManager.ingot_lead, RegistryManager.nugget_lead, RegistryManager.plate_lead, RegistryManager.block_lead, RegistryManager.pickaxe_lead, RegistryManager.axe_lead, RegistryManager.shovel_lead, RegistryManager.hoe_lead, RegistryManager.sword_lead);
        RecipeRegistry.registerMaterialSet(event, "ingotCopper", "nuggetCopper", "blockCopper", RegistryManager.ingot_copper, RegistryManager.nugget_copper, RegistryManager.plate_copper, RegistryManager.block_copper, RegistryManager.pickaxe_copper, RegistryManager.axe_copper, RegistryManager.shovel_copper, RegistryManager.hoe_copper, RegistryManager.sword_copper);
        RecipeRegistry.registerMaterialSet(event, "ingotSilver", "nuggetSilver", "blockSilver", RegistryManager.ingot_silver, RegistryManager.nugget_silver, RegistryManager.plate_silver, RegistryManager.block_silver, RegistryManager.pickaxe_silver, RegistryManager.axe_silver, RegistryManager.shovel_silver, RegistryManager.hoe_silver, RegistryManager.sword_silver);
        RecipeRegistry.registerMaterialSet(event, "ingotDawnstone", "nuggetDawnstone", "blockDawnstone", RegistryManager.ingot_dawnstone, RegistryManager.nugget_dawnstone, RegistryManager.plate_dawnstone, RegistryManager.block_dawnstone, RegistryManager.pickaxe_dawnstone, RegistryManager.axe_dawnstone, RegistryManager.shovel_dawnstone, RegistryManager.hoe_dawnstone, RegistryManager.sword_dawnstone);
        if (ConfigManager.enableAluminum) {
            RecipeRegistry.registerMaterialSet(event, "ingotAluminum", "nuggetAluminum", "blockAluminum", RegistryManager.ingot_aluminum, RegistryManager.nugget_aluminum, RegistryManager.plate_aluminum, RegistryManager.block_aluminum, RegistryManager.pickaxe_aluminum, RegistryManager.axe_aluminum, RegistryManager.shovel_aluminum, RegistryManager.hoe_aluminum, RegistryManager.sword_aluminum);
        }
        if (ConfigManager.enableBronze) {
            RecipeRegistry.registerMaterialSet(event, "ingotBronze", "nuggetBronze", "blockBronze", RegistryManager.ingot_bronze, RegistryManager.nugget_bronze, RegistryManager.plate_bronze, RegistryManager.block_bronze, RegistryManager.pickaxe_bronze, RegistryManager.axe_bronze, RegistryManager.shovel_bronze, RegistryManager.hoe_bronze, RegistryManager.sword_bronze);
        }
        if (ConfigManager.enableElectrum) {
            RecipeRegistry.registerMaterialSet(event, "ingotElectrum", "nuggetElectrum", "blockElectrum", RegistryManager.ingot_electrum, RegistryManager.nugget_electrum, RegistryManager.plate_electrum, RegistryManager.block_electrum, RegistryManager.pickaxe_electrum, RegistryManager.axe_electrum, RegistryManager.shovel_electrum, RegistryManager.hoe_electrum, RegistryManager.sword_electrum);
        }
        if (ConfigManager.enableNickel) {
            RecipeRegistry.registerMaterialSet(event, "ingotNickel", "nuggetNickel", "blockNickel", RegistryManager.ingot_nickel, RegistryManager.nugget_nickel, RegistryManager.plate_nickel, RegistryManager.block_nickel, RegistryManager.pickaxe_nickel, RegistryManager.axe_nickel, RegistryManager.shovel_nickel, RegistryManager.hoe_nickel, RegistryManager.sword_nickel);
        }
        if (ConfigManager.enableTin) {
            RecipeRegistry.registerMaterialSet(event, "ingotTin", "nuggetTin", "blockTin", RegistryManager.ingot_tin, RegistryManager.nugget_tin, RegistryManager.plate_tin, RegistryManager.block_tin, RegistryManager.pickaxe_tin, RegistryManager.axe_tin, RegistryManager.shovel_tin, RegistryManager.hoe_tin, RegistryManager.sword_tin);
        }
        event.getRegistry().register(new ShapelessOreRecipe(RecipeRegistry.getRL("blend_caminite"), new ItemStack(RegistryManager.blend_caminite, 8), new Object[]{Items.field_151119_aD, Items.field_151119_aD, Items.field_151119_aD, Items.field_151119_aD, "sand"}).setRegistryName(RecipeRegistry.getRL("blend_caminite")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("plate_caminite_raw"), new ItemStack(RegistryManager.plate_caminite_raw, 1), new Object[]{true, new Object[]{"XX", "XX", Character.valueOf('X'), RegistryManager.blend_caminite}}).setRegistryName(RecipeRegistry.getRL("plate_caminite_raw")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stamp_bar_raw"), new ItemStack(RegistryManager.stamp_bar_raw, 1), new Object[]{true, new Object[]{" X ", "X X", " X ", Character.valueOf('X'), RegistryManager.blend_caminite}}).setRegistryName(RecipeRegistry.getRL("stamp_bar_raw")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stamp_flat_raw"), new ItemStack(RegistryManager.stamp_flat_raw, 1), new Object[]{true, new Object[]{"XXX", "X X", "XXX", Character.valueOf('X'), RegistryManager.blend_caminite}}).setRegistryName(RecipeRegistry.getRL("stamp_flat_raw")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stamp_plate_raw"), new ItemStack(RegistryManager.stamp_plate_raw, 1), new Object[]{true, new Object[]{"X X", "   ", "X X", Character.valueOf('X'), RegistryManager.blend_caminite}}).setRegistryName(RecipeRegistry.getRL("stamp_plate_raw")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("block_caminite_brick"), new ItemStack(RegistryManager.block_caminite_brick, 1), new Object[]{true, new Object[]{"XX", "XX", Character.valueOf('X'), RegistryManager.brick_caminite}}).setRegistryName(RecipeRegistry.getRL("block_caminite_brick")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("block_caminite_brick_slab"), new ItemStack(RegistryManager.block_caminite_brick_slab, 6), new Object[]{true, new Object[]{"XXX", Character.valueOf('X'), RegistryManager.block_caminite_brick}}).setRegistryName(RecipeRegistry.getRL("block_caminite_brick_slab")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stairs_caminite_brick"), new ItemStack(RegistryManager.stairs_caminite_brick, 4), new Object[]{true, new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), RegistryManager.block_caminite_brick}}).setRegistryName(RecipeRegistry.getRL("stairs_caminite_brick")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("wall_caminite_brick"), new ItemStack(RegistryManager.wall_caminite_brick, 6), new Object[]{true, new Object[]{"XXX", "XXX", Character.valueOf('X'), RegistryManager.block_caminite_brick}}).setRegistryName(RecipeRegistry.getRL("wall_caminite_brick")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_stone"), new ItemStack(RegistryManager.ashen_stone, 4), new Object[]{true, new Object[]{" S ", "SAS", " S ", Character.valueOf('S'), "stone", Character.valueOf('A'), "dustAsh"}}).setRegistryName(RecipeRegistry.getRL("ashen_stone")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_stone_slab"), new ItemStack(RegistryManager.ashen_stone_slab, 6), new Object[]{true, new Object[]{"XXX", Character.valueOf('X'), RegistryManager.ashen_stone}}).setRegistryName(RecipeRegistry.getRL("ashen_stone_slab")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stairs_ashen_stone"), new ItemStack(RegistryManager.stairs_ashen_stone, 4), new Object[]{true, new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), RegistryManager.ashen_stone}}).setRegistryName(RecipeRegistry.getRL("stairs_ashen_stone")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("wall_ashen_stone"), new ItemStack(RegistryManager.wall_ashen_stone, 6), new Object[]{true, new Object[]{"XXX", "XXX", Character.valueOf('X'), RegistryManager.ashen_stone}}).setRegistryName(RecipeRegistry.getRL("wall_ashen_stone")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_brick"), new ItemStack(RegistryManager.ashen_brick, 4), new Object[]{true, new Object[]{" S ", "SAS", " S ", Character.valueOf('S'), Blocks.field_150417_aV, Character.valueOf('A'), "dustAsh"}}).setRegistryName(RecipeRegistry.getRL("ashen_brick")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_brick"), new ItemStack(RegistryManager.ashen_brick, 4), new Object[]{true, new Object[]{"SS", "SS", Character.valueOf('S'), RegistryManager.ashen_stone}}).setRegistryName(RecipeRegistry.getRL("ashen_brick2")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_brick_slab"), new ItemStack(RegistryManager.ashen_brick_slab, 6), new Object[]{true, new Object[]{"XXX", Character.valueOf('X'), RegistryManager.ashen_brick}}).setRegistryName(RecipeRegistry.getRL("ashen_brick_slab")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stairs_ashen_brick"), new ItemStack(RegistryManager.stairs_ashen_brick, 4), new Object[]{true, new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), RegistryManager.ashen_brick}}).setRegistryName(RecipeRegistry.getRL("stairs_ashen_brick")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("wall_ashen_brick"), new ItemStack(RegistryManager.wall_ashen_brick, 6), new Object[]{true, new Object[]{"XXX", "XXX", Character.valueOf('X'), RegistryManager.ashen_brick}}).setRegistryName(RecipeRegistry.getRL("wall_ashen_brick")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_tile"), new ItemStack(RegistryManager.ashen_tile, 4), new Object[]{true, new Object[]{"SS", "SS", Character.valueOf('S'), RegistryManager.ashen_brick}}).setRegistryName(RecipeRegistry.getRL("ashen_tile")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_tile_slab"), new ItemStack(RegistryManager.ashen_tile_slab, 6), new Object[]{true, new Object[]{"XXX", Character.valueOf('X'), RegistryManager.ashen_tile}}).setRegistryName(RecipeRegistry.getRL("ashen_tile_slab")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stairs_ashen_tile"), new ItemStack(RegistryManager.stairs_ashen_tile, 4), new Object[]{true, new Object[]{"X  ", "XX ", "XXX", Character.valueOf('X'), RegistryManager.ashen_tile}}).setRegistryName(RecipeRegistry.getRL("stairs_ashen_tile")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("wall_ashen_tile"), new ItemStack(RegistryManager.wall_ashen_tile, 6), new Object[]{true, new Object[]{"XXX", "XXX", Character.valueOf('X'), RegistryManager.ashen_tile}}).setRegistryName(RecipeRegistry.getRL("wall_ashen_tile")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_stone"), new ItemStack(RegistryManager.ashen_stone, 4), new Object[]{true, new Object[]{"SS", "SS", Character.valueOf('S'), RegistryManager.ashen_tile}}).setRegistryName(RecipeRegistry.getRL("ashen_stone2")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("block_tank"), new ItemStack(RegistryManager.block_tank, 1), new Object[]{true, new Object[]{"B B", "P P", "BIB", Character.valueOf('I'), "ingotIron", Character.valueOf('P'), "plateIron", Character.valueOf('B'), RegistryManager.brick_caminite}}).setRegistryName(RecipeRegistry.getRL("block_tank")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("pipe"), new ItemStack(RegistryManager.pipe, 8), new Object[]{true, new Object[]{"IPI", Character.valueOf('P'), "plateIron", Character.valueOf('I'), "ingotIron"}}).setRegistryName(RecipeRegistry.getRL("pipe")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("pump"), new ItemStack(RegistryManager.pump, 1), new Object[]{true, new Object[]{" R ", "PBP", " R ", Character.valueOf('P'), RegistryManager.pipe, Character.valueOf('B'), RegistryManager.plate_caminite, Character.valueOf('R'), "dustRedstone"}}).setRegistryName(RecipeRegistry.getRL("pump")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("block_furnace"), new ItemStack(RegistryManager.block_furnace, 1), new Object[]{true, new Object[]{"BPB", "BCB", "IFI", Character.valueOf('P'), RegistryManager.plate_caminite, Character.valueOf('B'), RegistryManager.brick_caminite, Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "ingotCopper"}}).setRegistryName(RecipeRegistry.getRL("block_furnace")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_receiver"), new ItemStack(RegistryManager.ember_receiver, 4), new Object[]{true, new Object[]{"I I", "CPC", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "ingotCopper", Character.valueOf('P'), RegistryManager.plate_caminite}}).setRegistryName(RecipeRegistry.getRL("ember_receiver")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_emitter"), new ItemStack(RegistryManager.ember_emitter, 4), new Object[]{true, new Object[]{" C ", " C ", "IPI", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "ingotCopper", Character.valueOf('P'), RegistryManager.plate_caminite}}).setRegistryName(RecipeRegistry.getRL("ember_emitter")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("copper_cell"), new ItemStack(RegistryManager.copper_cell, 1), new Object[]{true, new Object[]{"BIB", "ICI", "BIB", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "blockCopper", Character.valueOf('B'), RegistryManager.block_caminite_brick}}).setRegistryName(RecipeRegistry.getRL("copper_cell")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("item_pipe"), new ItemStack(RegistryManager.item_pipe, 8), new Object[]{true, new Object[]{"IPI", Character.valueOf('P'), "plateLead", Character.valueOf('I'), "ingotLead"}}).setRegistryName(RecipeRegistry.getRL("item_pipe")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("item_pump"), new ItemStack(RegistryManager.item_pump, 1), new Object[]{true, new Object[]{" R ", "PBP", " R ", Character.valueOf('P'), RegistryManager.item_pipe, Character.valueOf('B'), RegistryManager.plate_caminite, Character.valueOf('R'), "dustRedstone"}}).setRegistryName(RecipeRegistry.getRL("item_pump")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("bin"), new ItemStack(RegistryManager.bin, 1), new Object[]{true, new Object[]{"I I", "I I", "IPI", Character.valueOf('P'), "plateIron", Character.valueOf('I'), "ingotIron"}}).setRegistryName(RecipeRegistry.getRL("bin")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stamper"), new ItemStack(RegistryManager.stamper, 1), new Object[]{true, new Object[]{"XCX", "XBX", "X X", Character.valueOf('B'), "blockIron", Character.valueOf('C'), "ingotCopper", Character.valueOf('X'), RegistryManager.brick_caminite}}).setRegistryName(RecipeRegistry.getRL("stamper")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stamp_base"), new ItemStack(RegistryManager.stamp_base, 1), new Object[]{true, new Object[]{"I I", "XBX", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), Items.field_151133_ar, Character.valueOf('X'), RegistryManager.block_caminite_brick}}).setRegistryName(RecipeRegistry.getRL("stamp_base")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_bore"), new ItemStack(RegistryManager.ember_bore, 1), new Object[]{true, new Object[]{"YCY", "YBY", "III", Character.valueOf('I'), "ingotIron", Character.valueOf('B'), RegistryManager.mech_core, Character.valueOf('Y'), RegistryManager.stairs_caminite_brick, Character.valueOf('C'), "ingotCopper"}}).setRegistryName(RecipeRegistry.getRL("ember_bore")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("mech_core"), new ItemStack(RegistryManager.mech_core, 1), new Object[]{true, new Object[]{"IBI", " P ", "I I", Character.valueOf('I'), "ingotIron", Character.valueOf('P'), "plateLead", Character.valueOf('B'), Items.field_151111_aL}}).setRegistryName(RecipeRegistry.getRL("mech_core")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("mech_accessor"), new ItemStack(RegistryManager.mech_accessor, 1), new Object[]{true, new Object[]{"SPI", Character.valueOf('P'), "plateIron", Character.valueOf('S'), RegistryManager.stairs_caminite_brick, Character.valueOf('I'), "ingotIron"}}).setRegistryName(RecipeRegistry.getRL("mech_accessor")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_activator"), new ItemStack(RegistryManager.ember_activator, 1), new Object[]{true, new Object[]{"CCC", "CCC", "IFI", Character.valueOf('C'), "ingotCopper", Character.valueOf('F'), Blocks.field_150460_al, Character.valueOf('I'), "plateIron"}}).setRegistryName(RecipeRegistry.getRL("ember_activator")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("stone_edge"), new ItemStack(RegistryManager.stone_edge, 1), new Object[]{true, new Object[]{"XXX", "Y Y", "XXX", Character.valueOf('Y'), RegistryManager.brick_caminite, Character.valueOf('X'), RegistryManager.wall_caminite_brick}}).setRegistryName(RecipeRegistry.getRL("stone_edge")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("mixer"), new ItemStack(RegistryManager.mixer, 1), new Object[]{true, new Object[]{"PPP", "PCP", "IMI", Character.valueOf('P'), "plateIron", Character.valueOf('C'), "ingotCopper", Character.valueOf('M'), RegistryManager.mech_core, Character.valueOf('I'), "ingotIron"}}).setRegistryName(RecipeRegistry.getRL("mixer")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("heat_coil"), new ItemStack(RegistryManager.heat_coil, 1), new Object[]{true, new Object[]{"PPP", "IBI", " M ", Character.valueOf('P'), "plateCopper", Character.valueOf('B'), "blockCopper", Character.valueOf('M'), RegistryManager.mech_core, Character.valueOf('I'), "ingotIron"}}).setRegistryName(RecipeRegistry.getRL("heat_coil")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("item_dropper"), new ItemStack(RegistryManager.item_dropper, 1), new Object[]{true, new Object[]{" P ", "I I", Character.valueOf('P'), RegistryManager.pipe, Character.valueOf('I'), "ingotIron"}}).setRegistryName(RecipeRegistry.getRL("item_dropper")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("large_tank"), new ItemStack(RegistryManager.large_tank, 1), new Object[]{true, new Object[]{"Y Y", "I I", "YTY", Character.valueOf('Y'), RegistryManager.stairs_caminite_brick, Character.valueOf('I'), "ingotIron", Character.valueOf('T'), RegistryManager.block_tank}}).setRegistryName(RecipeRegistry.getRL("large_tank")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_gauge"), new ItemStack(RegistryManager.ember_gauge, 1), new Object[]{true, new Object[]{"B", "P", "C", Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('B'), Items.field_151111_aL, Character.valueOf('C'), "ingotCopper"}}).setRegistryName(RecipeRegistry.getRL("ember_gauge")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("fluid_gauge"), new ItemStack(RegistryManager.fluid_gauge, 1), new Object[]{true, new Object[]{"B", "P", "I", Character.valueOf('P'), Items.field_151121_aF, Character.valueOf('I'), "ingotIron", Character.valueOf('B'), Items.field_151111_aL}}).setRegistryName(RecipeRegistry.getRL("fluid_gauge")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("block_lantern"), new ItemStack(RegistryManager.block_lantern, 4), new Object[]{true, new Object[]{"P", "E", "I", Character.valueOf('E'), RegistryManager.shard_ember, Character.valueOf('I'), "ingotIron", Character.valueOf('P'), "plateIron"}}).setRegistryName(RecipeRegistry.getRL("block_lantern")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("tinker_hammer"), new ItemStack(RegistryManager.tinker_hammer, 1), new Object[]{true, new Object[]{"IBI", "ISI", " S ", Character.valueOf('B'), "ingotLead", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL("tinker_hammer")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_detector"), new ItemStack(RegistryManager.ember_detector, 1), new Object[]{true, new Object[]{" I ", "CRC", "CIC", Character.valueOf('C'), "ingotCopper", Character.valueOf('I'), "ingotIron", Character.valueOf('R'), "dustRedstone"}}).setRegistryName(RecipeRegistry.getRL("ember_detector")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("beam_splitter"), new ItemStack(RegistryManager.beam_splitter, 1), new Object[]{true, new Object[]{" D ", "CPC", " I ", Character.valueOf('C'), "ingotCopper", Character.valueOf('I'), "ingotIron", Character.valueOf('P'), "plateIron", Character.valueOf('D'), "ingotDawnstone"}}).setRegistryName(RecipeRegistry.getRL("beam_splitter")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_relay"), new ItemStack(RegistryManager.ember_relay, 4), new Object[]{true, new Object[]{" C ", "C C", " P ", Character.valueOf('C'), "ingotCopper", Character.valueOf('P'), "plateIron"}}).setRegistryName(RecipeRegistry.getRL("ember_relay")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("crystal_cell"), new ItemStack(RegistryManager.crystal_cell, 1), new Object[]{true, new Object[]{" E ", "DED", "CBC", Character.valueOf('C'), "blockCopper", Character.valueOf('B'), "blockDawnstone", Character.valueOf('D'), "plateDawnstone", Character.valueOf('E'), RegistryManager.crystal_ember}}).setRegistryName(RecipeRegistry.getRL("crystal_cell")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_jar"), new ItemStack(RegistryManager.ember_jar, 1), new Object[]{true, new Object[]{" C ", "ISI", " G ", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), RegistryManager.shard_ember, Character.valueOf('C'), "ingotCopper", Character.valueOf('G'), "blockGlass"}}).setRegistryName(RecipeRegistry.getRL("ember_jar")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_cartridge"), new ItemStack(RegistryManager.ember_cartridge, 1), new Object[]{true, new Object[]{"ICI", "GSG", " G ", Character.valueOf('I'), "ingotIron", Character.valueOf('S'), RegistryManager.crystal_ember, Character.valueOf('C'), "plateCopper", Character.valueOf('G'), "blockGlass"}}).setRegistryName(RecipeRegistry.getRL("ember_cartridge")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("charger"), new ItemStack(RegistryManager.charger, 1), new Object[]{true, new Object[]{" X ", "DCD", "IPI", Character.valueOf('D'), "ingotDawnstone", Character.valueOf('P'), "plateCopper", Character.valueOf('C'), "ingotCopper", Character.valueOf('I'), "ingotIron", Character.valueOf('X'), "plateIron"}}).setRegistryName(RecipeRegistry.getRL("charger")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("axe_clockwork"), new ItemStack(RegistryManager.axe_clockwork, 1), new Object[]{true, new Object[]{"PCP", "ISI", " W ", Character.valueOf('C'), "plateCopper", Character.valueOf('P'), "plateDawnstone", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('S'), RegistryManager.shard_ember, Character.valueOf('W'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL("axe_clockwork")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("pickaxe_clockwork"), new ItemStack(RegistryManager.pickaxe_clockwork, 1), new Object[]{true, new Object[]{"ISI", " C ", " W ", Character.valueOf('C'), "ingotCopper", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('S'), RegistryManager.shard_ember, Character.valueOf('W'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL("pickaxe_clockwork")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("grandhammer"), new ItemStack(RegistryManager.grandhammer, 1), new Object[]{true, new Object[]{"BIB", " C ", " W ", Character.valueOf('C'), "ingotCopper", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('B'), "blockDawnstone", Character.valueOf('W'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL("grandhammer")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("staff_ember"), new ItemStack(RegistryManager.staff_ember, 1), new Object[]{true, new Object[]{"SES", "IWI", " W ", Character.valueOf('S'), "plateSilver", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('E'), RegistryManager.shard_ember, Character.valueOf('W'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL("staff_ember")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ignition_cannon"), new ItemStack(RegistryManager.ignition_cannon, 1), new Object[]{true, new Object[]{" DP", "DPI", "SW ", Character.valueOf('I'), "ingotIron", Character.valueOf('D'), "ingotDawnstone", Character.valueOf('P'), "plateDawnstone", Character.valueOf('S'), RegistryManager.shard_ember, Character.valueOf('W'), "stickWood"}}).setRegistryName(RecipeRegistry.getRL("ignition_cannon")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("cinder_plinth"), new ItemStack(RegistryManager.cinder_plinth, 1), new Object[]{true, new Object[]{" P ", "SFS", "PBP", Character.valueOf('P'), "plateLead", Character.valueOf('B'), RegistryManager.block_caminite_brick, Character.valueOf('S'), "ingotSilver", Character.valueOf('F'), Blocks.field_150460_al}}).setRegistryName(RecipeRegistry.getRL("cinder_plinth")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("alchemy_pedestal"), new ItemStack(RegistryManager.alchemy_pedestal, 1), new Object[]{true, new Object[]{"D D", "ICI", "SBS", Character.valueOf('D'), "plateDawnstone", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('B'), "blockCopper", Character.valueOf('S'), RegistryManager.stairs_caminite_brick, Character.valueOf('C'), RegistryManager.crystal_ember}}).setRegistryName(RecipeRegistry.getRL("alchemy_pedestal")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("alchemy_tablet"), new ItemStack(RegistryManager.alchemy_tablet, 1), new Object[]{true, new Object[]{" D ", "SXS", "BIB", Character.valueOf('D'), "plateDawnstone", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('B'), RegistryManager.block_caminite_brick, Character.valueOf('S'), RegistryManager.stairs_caminite_brick, Character.valueOf('X'), "plateCopper"}}).setRegistryName(RecipeRegistry.getRL("alchemy_tablet")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("item_transfer"), new ItemStack(RegistryManager.item_transfer, 2), new Object[]{true, new Object[]{"PLP", "ILI", "I I", Character.valueOf('P'), "plateLead", Character.valueOf('I'), "ingotLead", Character.valueOf('L'), RegistryManager.item_pipe}}).setRegistryName(RecipeRegistry.getRL("item_transfer")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("beam_cannon"), new ItemStack(RegistryManager.beam_cannon, 1), new Object[]{true, new Object[]{"PSP", "PSP", "IBI", Character.valueOf('S'), RegistryManager.crystal_ember, Character.valueOf('P'), "plateCopper", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('B'), RegistryManager.block_caminite_brick}}).setRegistryName(RecipeRegistry.getRL("beam_cannon")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_cloak_head"), new ItemStack(RegistryManager.ashen_cloak_head, 1), new Object[]{true, new Object[]{" S ", "C C", "DCD", Character.valueOf('S'), "string", Character.valueOf('D'), "ingotDawnstone", Character.valueOf('C'), RegistryManager.ashen_cloth}}).setRegistryName(RecipeRegistry.getRL("ashen_cloak_head")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_cloak_chest"), new ItemStack(RegistryManager.ashen_cloak_chest, 1), new Object[]{true, new Object[]{"P P", "CDC", "CDC", Character.valueOf('D'), "ingotDawnstone", Character.valueOf('P'), "plateDawnstone", Character.valueOf('C'), RegistryManager.ashen_cloth}}).setRegistryName(RecipeRegistry.getRL("ashen_cloak_chest")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_cloak_legs"), new ItemStack(RegistryManager.ashen_cloak_legs, 1), new Object[]{true, new Object[]{"CCC", "D D", "D D", Character.valueOf('D'), "ingotDawnstone", Character.valueOf('C'), RegistryManager.ashen_cloth}}).setRegistryName(RecipeRegistry.getRL("ashen_cloak_legs")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ashen_cloak_boots"), new ItemStack(RegistryManager.ashen_cloak_boots, 1), new Object[]{true, new Object[]{"C C", "C C", "C C", Character.valueOf('C'), RegistryManager.ashen_cloth}}).setRegistryName(RecipeRegistry.getRL("ashen_cloak_boots")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("sealed_planks"), new ItemStack(RegistryManager.sealed_planks, 8), new Object[]{true, new Object[]{"PPP", "PSP", "PPP", Character.valueOf('S'), "slimeball", Character.valueOf('P'), "plankWood"}}).setRegistryName(RecipeRegistry.getRL("sealed_planks")));
        event.getRegistry().register(new ShapelessOreRecipe(RecipeRegistry.getRL("wrapped_sealed_planks"), new ItemStack(RegistryManager.wrapped_sealed_planks, 1), new Object[]{Blocks.field_150411_aY, RegistryManager.sealed_planks}).setRegistryName(RecipeRegistry.getRL("wrapped_sealed_planks")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("archaic_bricks"), new ItemStack(RegistryManager.archaic_bricks, 1), new Object[]{true, new Object[]{"BB", "BB", Character.valueOf('B'), RegistryManager.archaic_brick}}).setRegistryName(RecipeRegistry.getRL("archaic_bricks")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("archaic_light"), new ItemStack(RegistryManager.archaic_light, 1), new Object[]{true, new Object[]{" B ", "BSB", " B ", Character.valueOf('B'), RegistryManager.archaic_brick, Character.valueOf('S'), RegistryManager.shard_ember}}).setRegistryName(RecipeRegistry.getRL("archaic_light")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("dawnstone_anvil"), new ItemStack(RegistryManager.dawnstone_anvil, 1), new Object[]{true, new Object[]{"BBB", "cIc", "CCC", Character.valueOf('B'), "blockDawnstone", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('C'), RegistryManager.block_caminite_brick, Character.valueOf('c'), RegistryManager.brick_caminite}}).setRegistryName(RecipeRegistry.getRL("dawnstone_anvil")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("auto_hammer"), new ItemStack(RegistryManager.auto_hammer, 1), new Object[]{true, new Object[]{"cc ", "CIB", "cc ", Character.valueOf('B'), "blockIron", Character.valueOf('I'), "ingotIron", Character.valueOf('C'), "blockCopper", Character.valueOf('c'), RegistryManager.stairs_caminite_brick}}).setMirrored(true).setRegistryName(RecipeRegistry.getRL("auto_hammer")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("vacuum"), new ItemStack(RegistryManager.vacuum, 1), new Object[]{true, new Object[]{" LL", "P  ", " LL", Character.valueOf('P'), RegistryManager.item_pipe, Character.valueOf('L'), "ingotLead"}}).setMirrored(true).setRegistryName(RecipeRegistry.getRL("vacuum")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("archaic_edge"), new ItemStack(RegistryManager.archaic_edge, 2), new Object[]{true, new Object[]{"BBB", "BCB", "BBB", Character.valueOf('B'), RegistryManager.archaic_brick, Character.valueOf('C'), RegistryManager.shard_ember}}).setRegistryName(RecipeRegistry.getRL("archaic_edge")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("archaic_tile"), new ItemStack(RegistryManager.archaic_tile, 4), new Object[]{true, new Object[]{"BB", "BB", Character.valueOf('B'), RegistryManager.archaic_bricks}}).setRegistryName(RecipeRegistry.getRL("archaic_tile")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("archaic_bricks_2"), new ItemStack(RegistryManager.archaic_bricks, 4), new Object[]{true, new Object[]{"BB", "BB", Character.valueOf('B'), RegistryManager.archaic_tile}}).setRegistryName(RecipeRegistry.getRL("archaic_bricks_2")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("breaker"), new ItemStack(RegistryManager.breaker, 1), new Object[]{true, new Object[]{"PIP", "LRL", "L L", Character.valueOf('P'), "plateIron", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('L'), "ingotLead", Character.valueOf('R'), Items.field_151137_ax}}).setRegistryName(RecipeRegistry.getRL("breaker")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_injector"), new ItemStack(RegistryManager.ember_injector, 1), new Object[]{true, new Object[]{"S S", "DCD", "BPB", Character.valueOf('P'), "plateSilver", Character.valueOf('S'), "ingotSilver", Character.valueOf('D'), "plateDawnstone", Character.valueOf('B'), RegistryManager.block_caminite_brick, Character.valueOf('C'), RegistryManager.wildfire_core}}).setRegistryName(RecipeRegistry.getRL("ember_injector")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("boiler"), new ItemStack(RegistryManager.boiler, 1), new Object[]{true, new Object[]{"CCC", "IFI", "IBI", Character.valueOf('B'), "blockCopper", Character.valueOf('I'), Items.field_151042_j, Character.valueOf('C'), "ingotCopper", Character.valueOf('F'), Blocks.field_150460_al}}).setRegistryName(RecipeRegistry.getRL("boiler")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("reactor"), new ItemStack(RegistryManager.reactor, 1), new Object[]{true, new Object[]{"CCC", "CWC", "SBS", Character.valueOf('B'), RegistryManager.block_caminite_brick, Character.valueOf('W'), RegistryManager.wildfire_core, Character.valueOf('C'), "ingotCopper", Character.valueOf('S'), "plateSilver"}}).setRegistryName(RecipeRegistry.getRL("reactor")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("combustor"), new ItemStack(RegistryManager.combustor, 1), new Object[]{true, new Object[]{" C ", "PEP", "CMC", Character.valueOf('M'), RegistryManager.mech_core, Character.valueOf('P'), "plateCopper", Character.valueOf('C'), "ingotCopper", Character.valueOf('E'), RegistryManager.ember_cluster}}).setRegistryName(RecipeRegistry.getRL("combustor")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("catalyzer"), new ItemStack(RegistryManager.catalyzer, 1), new Object[]{true, new Object[]{" C ", "PEP", "CMC", Character.valueOf('M'), RegistryManager.mech_core, Character.valueOf('P'), "plateSilver", Character.valueOf('C'), "ingotSilver", Character.valueOf('E'), RegistryManager.ember_cluster}}).setRegistryName(RecipeRegistry.getRL("catalyzer")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("codex"), new ItemStack(RegistryManager.codex, 1), new Object[]{true, new Object[]{" B ", " E ", " B ", Character.valueOf('B'), RegistryManager.archaic_brick, Character.valueOf('E'), RegistryManager.ancient_motive_core}}).setRegistryName(RecipeRegistry.getRL("codex")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("field_chart"), new ItemStack(RegistryManager.field_chart, 1), new Object[]{true, new Object[]{"BBB", "BCB", "BBB", Character.valueOf('B'), RegistryManager.archaic_brick, Character.valueOf('C'), RegistryManager.ember_cluster}}).setRegistryName(RecipeRegistry.getRL("field_chart")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("archaic_circuit"), new ItemStack(RegistryManager.archaic_circuit, 1), new Object[]{true, new Object[]{" B ", "BCB", " B ", Character.valueOf('B'), RegistryManager.archaic_brick, Character.valueOf('C'), "ingotCopper"}}).setRegistryName(RecipeRegistry.getRL("archaic_circuit")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("inferno_forge"), new ItemStack(RegistryManager.inferno_forge, 1), new Object[]{true, new Object[]{"BPB", "DCD", "SWS", Character.valueOf('B'), RegistryManager.block_dawnstone, Character.valueOf('D'), "ingotDawnstone", Character.valueOf('C'), "blockCopper", Character.valueOf('W'), RegistryManager.wildfire_core, Character.valueOf('P'), "plateIron", Character.valueOf('S'), RegistryManager.block_caminite_brick}}).setRegistryName(RecipeRegistry.getRL("inferno_forge")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("superheater"), new ItemStack(RegistryManager.superheater, 1), new Object[]{true, new Object[]{" ID", "PPI", "PP ", Character.valueOf('I'), "ingotDawnstone", Character.valueOf('D'), "plateDawnstone", Character.valueOf('P'), "ingotCopper"}}).setRegistryName(RecipeRegistry.getRL("superheater")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("resonating_bell"), new ItemStack(RegistryManager.resonating_bell, 1), new Object[]{true, new Object[]{"IIP", " sI", "S I", Character.valueOf('I'), "ingotIron", Character.valueOf('s'), "ingotSilver", Character.valueOf('P'), "plateIron", Character.valueOf('S'), "plateSilver"}}).setRegistryName(RecipeRegistry.getRL("resonating_bell")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("jet_augment"), new ItemStack(RegistryManager.jet_augment, 1), new Object[]{true, new Object[]{"PP ", "IsD", "PP ", Character.valueOf('I'), "ingotIron", Character.valueOf('s'), RegistryManager.shard_ember, Character.valueOf('P'), "plateDawnstone", Character.valueOf('D'), "ingotDawnstone"}}).setRegistryName(RecipeRegistry.getRL("jet_augment")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("caster_orb"), new ItemStack(RegistryManager.caster_orb, 1), new Object[]{true, new Object[]{"DCD", "D D", " P ", Character.valueOf('C'), RegistryManager.crystal_ember, Character.valueOf('P'), "plateDawnstone", Character.valueOf('D'), "ingotDawnstone"}}).setRegistryName(RecipeRegistry.getRL("caster_orb")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("ember_pulser"), new ItemStack(RegistryManager.ember_pulser, 1), new Object[]{true, new Object[]{"D", "E", "I", Character.valueOf('E'), RegistryManager.ember_emitter, Character.valueOf('I'), "ingotIron", Character.valueOf('D'), "plateDawnstone"}}).setRegistryName(RecipeRegistry.getRL("ember_pulser")));
        event.getRegistry().register(new ShapedOreRecipe(RecipeRegistry.getRL("caminite_lever"), new ItemStack(RegistryManager.caminite_lever, 4), new Object[]{true, new Object[]{"S", "P", Character.valueOf('S'), "stickWood", Character.valueOf('P'), new ItemStack(RegistryManager.plate_caminite)}}).setRegistryName(RecipeRegistry.getRL("caminite_lever")));
        event.getRegistry().register(new AshenCloakSocketRecipe().setRegistryName(RecipeRegistry.getRL("cloak_socketing")));
        event.getRegistry().register(new AshenCloakUnsocketRecipe().setRegistryName(RecipeRegistry.getRL("cloak_unsocketing")));
        GameRegistry.addSmelting((ItemStack)new ItemStack(RegistryManager.ore_copper), (ItemStack)new ItemStack(RegistryManager.ingot_copper), (float)0.65f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(RegistryManager.ore_silver), (ItemStack)new ItemStack(RegistryManager.ingot_silver), (float)0.35f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(RegistryManager.ore_lead), (ItemStack)new ItemStack(RegistryManager.ingot_lead), (float)0.35f);
        if (ConfigManager.enableAluminum) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(RegistryManager.ore_aluminum), (ItemStack)new ItemStack(RegistryManager.ingot_aluminum), (float)0.55f);
        }
        if (ConfigManager.enableTin) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(RegistryManager.ore_tin), (ItemStack)new ItemStack(RegistryManager.ingot_tin), (float)0.55f);
        }
        if (ConfigManager.enableNickel) {
            GameRegistry.addSmelting((ItemStack)new ItemStack(RegistryManager.ore_nickel), (ItemStack)new ItemStack(RegistryManager.ingot_nickel), (float)0.55f);
        }
        GameRegistry.addSmelting((ItemStack)new ItemStack(RegistryManager.ore_quartz), (ItemStack)new ItemStack(Items.field_151128_bU), (float)0.35f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(RegistryManager.blend_caminite), (ItemStack)new ItemStack(RegistryManager.brick_caminite), (float)0.35f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(RegistryManager.plate_caminite_raw), (ItemStack)new ItemStack(RegistryManager.plate_caminite), (float)0.35f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(RegistryManager.stamp_bar_raw), (ItemStack)new ItemStack(RegistryManager.stamp_bar), (float)0.35f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(RegistryManager.stamp_plate_raw), (ItemStack)new ItemStack(RegistryManager.stamp_plate), (float)0.35f);
        GameRegistry.addSmelting((ItemStack)new ItemStack(RegistryManager.stamp_flat_raw), (ItemStack)new ItemStack(RegistryManager.stamp_flat), (float)0.35f);
        meltingOreRecipes.add(new ItemMeltingOreRecipe("oreIron", new FluidStack(RegistryManager.fluid_molten_iron, 288)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("ingotIron", new FluidStack(RegistryManager.fluid_molten_iron, 144)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("nuggetIron", new FluidStack(RegistryManager.fluid_molten_iron, 16)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("plateIron", new FluidStack(RegistryManager.fluid_molten_iron, 144)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("oreGold", new FluidStack(RegistryManager.fluid_molten_gold, 288)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("ingotGold", new FluidStack(RegistryManager.fluid_molten_gold, 144)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("nuggetGold", new FluidStack(RegistryManager.fluid_molten_gold, 16)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("plateGold", new FluidStack(RegistryManager.fluid_molten_gold, 144)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("oreSilver", new FluidStack(RegistryManager.fluid_molten_silver, 288)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("ingotSilver", new FluidStack(RegistryManager.fluid_molten_silver, 144)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("nuggetSilver", new FluidStack(RegistryManager.fluid_molten_silver, 16)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("plateSilver", new FluidStack(RegistryManager.fluid_molten_silver, 144)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("oreCopper", new FluidStack(RegistryManager.fluid_molten_copper, 288)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("ingotCopper", new FluidStack(RegistryManager.fluid_molten_copper, 144)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("nuggetCopper", new FluidStack(RegistryManager.fluid_molten_copper, 16)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("plateCopper", new FluidStack(RegistryManager.fluid_molten_copper, 144)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("oreLead", new FluidStack(RegistryManager.fluid_molten_lead, 288)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("ingotLead", new FluidStack(RegistryManager.fluid_molten_lead, 144)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("nuggetLead", new FluidStack(RegistryManager.fluid_molten_lead, 16)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("plateLead", new FluidStack(RegistryManager.fluid_molten_lead, 144)));
        if (ConfigManager.enableAluminum) {
            meltingOreRecipes.add(new ItemMeltingOreRecipe("oreAluminum", new FluidStack(RegistryManager.fluid_molten_aluminum, 288)));
            meltingOreRecipes.add(new ItemMeltingOreRecipe("ingotAluminum", new FluidStack(RegistryManager.fluid_molten_aluminum, 144)));
            meltingOreRecipes.add(new ItemMeltingOreRecipe("nuggetAluminum", new FluidStack(RegistryManager.fluid_molten_aluminum, 16)));
            meltingOreRecipes.add(new ItemMeltingOreRecipe("plateAluminum", new FluidStack(RegistryManager.fluid_molten_aluminum, 144)));
        }
        if (ConfigManager.enableNickel) {
            meltingOreRecipes.add(new ItemMeltingOreRecipe("oreNickel", new FluidStack(RegistryManager.fluid_molten_nickel, 288)));
            meltingOreRecipes.add(new ItemMeltingOreRecipe("ingotNickel", new FluidStack(RegistryManager.fluid_molten_nickel, 144)));
            meltingOreRecipes.add(new ItemMeltingOreRecipe("nuggetNickel", new FluidStack(RegistryManager.fluid_molten_nickel, 16)));
            meltingOreRecipes.add(new ItemMeltingOreRecipe("plateNickel", new FluidStack(RegistryManager.fluid_molten_nickel, 144)));
        }
        if (ConfigManager.enableTin) {
            meltingOreRecipes.add(new ItemMeltingOreRecipe("oreTin", new FluidStack(RegistryManager.fluid_molten_tin, 288)));
            meltingOreRecipes.add(new ItemMeltingOreRecipe("ingotTin", new FluidStack(RegistryManager.fluid_molten_tin, 144)));
            meltingOreRecipes.add(new ItemMeltingOreRecipe("nuggetTin", new FluidStack(RegistryManager.fluid_molten_tin, 16)));
            meltingOreRecipes.add(new ItemMeltingOreRecipe("plateTin", new FluidStack(RegistryManager.fluid_molten_tin, 144)));
        }
        meltingOreRecipes.add(new ItemMeltingOreRecipe("ingotDawnstone", new FluidStack(RegistryManager.fluid_molten_dawnstone, 144)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("nuggetDawnstone", new FluidStack(RegistryManager.fluid_molten_dawnstone, 16)));
        meltingOreRecipes.add(new ItemMeltingOreRecipe("plateDawnstone", new FluidStack(RegistryManager.fluid_molten_dawnstone, 144)));
        if (ConfigManager.enableBronze) {
            meltingOreRecipes.add(new ItemMeltingOreRecipe("ingotBronze", new FluidStack(RegistryManager.fluid_molten_bronze, 144)));
            meltingOreRecipes.add(new ItemMeltingOreRecipe("nuggetBronze", new FluidStack(RegistryManager.fluid_molten_bronze, 16)));
            meltingOreRecipes.add(new ItemMeltingOreRecipe("plateBronze", new FluidStack(RegistryManager.fluid_molten_bronze, 144)));
        }
        if (ConfigManager.enableElectrum) {
            meltingOreRecipes.add(new ItemMeltingOreRecipe("ingotElectrum", new FluidStack(RegistryManager.fluid_molten_electrum, 144)));
            meltingOreRecipes.add(new ItemMeltingOreRecipe("nuggetElectrum", new FluidStack(RegistryManager.fluid_molten_electrum, 16)));
            meltingOreRecipes.add(new ItemMeltingOreRecipe("plateElectrum", new FluidStack(RegistryManager.fluid_molten_electrum, 144)));
        }
        stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_iron, 144), EnumStampType.TYPE_BAR, new ItemStack(Items.field_151042_j, 1), false, false));
        stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_gold, 144), EnumStampType.TYPE_BAR, new ItemStack(Items.field_151043_k, 1), false, false));
        stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_lead, 144), EnumStampType.TYPE_BAR, new ItemStack(RegistryManager.ingot_lead, 1), false, false));
        stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_silver, 144), EnumStampType.TYPE_BAR, new ItemStack(RegistryManager.ingot_silver, 1), false, false));
        stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_copper, 144), EnumStampType.TYPE_BAR, new ItemStack(RegistryManager.ingot_copper, 1), false, false));
        stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_dawnstone, 144), EnumStampType.TYPE_BAR, new ItemStack(RegistryManager.ingot_dawnstone, 1), false, false));
        if (ConfigManager.enableAluminum) {
            stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_aluminum, 144), EnumStampType.TYPE_BAR, new ItemStack(RegistryManager.ingot_aluminum, 1), false, false));
        }
        if (ConfigManager.enableBronze) {
            stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_bronze, 144), EnumStampType.TYPE_BAR, new ItemStack(RegistryManager.ingot_bronze, 1), false, false));
        }
        if (ConfigManager.enableElectrum) {
            stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_electrum, 144), EnumStampType.TYPE_BAR, new ItemStack(RegistryManager.ingot_electrum, 1), false, false));
        }
        if (ConfigManager.enableNickel) {
            stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_nickel, 144), EnumStampType.TYPE_BAR, new ItemStack(RegistryManager.ingot_nickel, 1), false, false));
        }
        if (ConfigManager.enableTin) {
            stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_tin, 144), EnumStampType.TYPE_BAR, new ItemStack(RegistryManager.ingot_tin, 1), false, false));
        }
        stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_iron, 144), EnumStampType.TYPE_PLATE, new ItemStack(RegistryManager.plate_iron, 1), false, false));
        stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_gold, 144), EnumStampType.TYPE_PLATE, new ItemStack(RegistryManager.plate_gold, 1), false, false));
        stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_lead, 144), EnumStampType.TYPE_PLATE, new ItemStack(RegistryManager.plate_lead, 1), false, false));
        stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_silver, 144), EnumStampType.TYPE_PLATE, new ItemStack(RegistryManager.plate_silver, 1), false, false));
        stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_copper, 144), EnumStampType.TYPE_PLATE, new ItemStack(RegistryManager.plate_copper, 1), false, false));
        stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_dawnstone, 144), EnumStampType.TYPE_PLATE, new ItemStack(RegistryManager.plate_dawnstone, 1), false, false));
        if (ConfigManager.enableAluminum) {
            stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_aluminum, 144), EnumStampType.TYPE_PLATE, new ItemStack(RegistryManager.plate_aluminum, 1), false, false));
        }
        if (ConfigManager.enableBronze) {
            stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_bronze, 144), EnumStampType.TYPE_PLATE, new ItemStack(RegistryManager.plate_bronze, 1), false, false));
        }
        if (ConfigManager.enableElectrum) {
            stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_electrum, 144), EnumStampType.TYPE_PLATE, new ItemStack(RegistryManager.plate_electrum, 1), false, false));
        }
        if (ConfigManager.enableNickel) {
            stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_nickel, 144), EnumStampType.TYPE_PLATE, new ItemStack(RegistryManager.plate_nickel, 1), false, false));
        }
        if (ConfigManager.enableTin) {
            stampingRecipes.add(new ItemStampingRecipe(ItemStack.field_190927_a, new FluidStack(RegistryManager.fluid_molten_tin, 144), EnumStampType.TYPE_PLATE, new ItemStack(RegistryManager.plate_tin, 1), false, false));
        }
        stampingRecipes.add(new ItemWasteStampingRecipe());
        stampingRecipes.add(new ItemStampingRecipe(new ItemStack(RegistryManager.shard_ember, 1), new FluidStack(RegistryManager.fluid_molten_iron, 144), EnumStampType.TYPE_PLATE, new ItemStack(RegistryManager.aspectus_iron, 1), false, false));
        stampingRecipes.add(new ItemStampingRecipe(new ItemStack(RegistryManager.shard_ember, 1), new FluidStack(RegistryManager.fluid_molten_lead, 144), EnumStampType.TYPE_PLATE, new ItemStack(RegistryManager.aspectus_lead, 1), false, false));
        stampingRecipes.add(new ItemStampingRecipe(new ItemStack(RegistryManager.shard_ember, 1), new FluidStack(RegistryManager.fluid_molten_silver, 144), EnumStampType.TYPE_PLATE, new ItemStack(RegistryManager.aspectus_silver, 1), false, false));
        stampingRecipes.add(new ItemStampingRecipe(new ItemStack(RegistryManager.shard_ember, 1), new FluidStack(RegistryManager.fluid_molten_copper, 144), EnumStampType.TYPE_PLATE, new ItemStack(RegistryManager.aspectus_copper, 1), false, false));
        stampingRecipes.add(new ItemStampingRecipe(new ItemStack(RegistryManager.shard_ember, 1), new FluidStack(RegistryManager.fluid_molten_dawnstone, 144), EnumStampType.TYPE_PLATE, new ItemStack(RegistryManager.aspectus_dawnstone, 1), false, false));
        mixingRecipes.add(new FluidMixingRecipe(new FluidStack[]{new FluidStack(RegistryManager.fluid_molten_copper, 4), new FluidStack(RegistryManager.fluid_molten_gold, 4)}, new FluidStack(RegistryManager.fluid_molten_dawnstone, 8)));
        if (ConfigManager.enableElectrum) {
            mixingRecipes.add(new FluidMixingRecipe(new FluidStack[]{new FluidStack(RegistryManager.fluid_molten_silver, 4), new FluidStack(RegistryManager.fluid_molten_gold, 4)}, new FluidStack(RegistryManager.fluid_molten_electrum, 8)));
        }
        if (ConfigManager.enableTin && ConfigManager.enableBronze) {
            mixingRecipes.add(new FluidMixingRecipe(new FluidStack[]{new FluidStack(RegistryManager.fluid_molten_copper, 6), new FluidStack(RegistryManager.fluid_molten_tin, 2)}, new FluidStack(RegistryManager.fluid_molten_bronze, 8)));
        }
        alchemyRecipes.add(new AlchemyRecipe(48, 64, 0, 0, 48, 64, 0, 0, 0, 0, new ItemStack(Items.field_151128_bU), new ItemStack(RegistryManager.ingot_copper), new ItemStack(RegistryManager.ingot_copper), new ItemStack(RegistryManager.shard_ember), new ItemStack(RegistryManager.shard_ember), new ItemStack(RegistryManager.seed, 1, 2)));
        alchemyRecipes.add(new AlchemyRecipe(48, 64, 0, 0, 0, 0, 48, 64, 0, 0, new ItemStack(Items.field_151128_bU), new ItemStack(RegistryManager.ingot_silver), new ItemStack(RegistryManager.ingot_silver), new ItemStack(RegistryManager.shard_ember), new ItemStack(RegistryManager.shard_ember), new ItemStack(RegistryManager.seed, 1, 4)));
        alchemyRecipes.add(new AlchemyRecipe(48, 64, 0, 0, 0, 0, 0, 0, 48, 64, new ItemStack(Items.field_151128_bU), new ItemStack(RegistryManager.ingot_lead), new ItemStack(RegistryManager.ingot_lead), new ItemStack(RegistryManager.shard_ember), new ItemStack(RegistryManager.shard_ember), new ItemStack(RegistryManager.seed, 1, 3)));
        alchemyRecipes.add(new AlchemyRecipe(48, 64, 48, 64, 0, 0, 0, 0, 0, 0, new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151043_k), new ItemStack(Items.field_151043_k), new ItemStack(RegistryManager.shard_ember), new ItemStack(RegistryManager.shard_ember), new ItemStack(RegistryManager.seed, 1, 1)));
        alchemyRecipes.add(new AlchemyRecipe(96, 128, 0, 0, 0, 0, 0, 0, 0, 0, new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151042_j), new ItemStack(RegistryManager.shard_ember), new ItemStack(RegistryManager.shard_ember), new ItemStack(RegistryManager.seed, 1, 0)));
        alchemyRecipes.add(new AlchemyRecipe(12, 24, 0, 0, 0, 0, 0, 0, 12, 24, new ItemStack(Blocks.field_150325_L), new ItemStack(RegistryManager.dust_ash), new ItemStack(RegistryManager.dust_ash), new ItemStack(Items.field_151007_F), new ItemStack(Items.field_151007_F), new ItemStack(RegistryManager.ashen_cloth, 2)));
        alchemyRecipes.add(new AlchemyRecipe(0, 0, 32, 48, 0, 0, 0, 0, 24, 40, new ItemStack(Items.field_151045_i), new ItemStack(RegistryManager.ingot_dawnstone), new ItemStack(Items.field_151044_h), new ItemStack(Items.field_151044_h), new ItemStack(Items.field_151044_h), new ItemStack(RegistryManager.inflictor_gem, 1)));
        alchemyRecipes.add(new AlchemyRecipe(0, 0, 64, 80, 0, 0, 0, 0, 0, 0, new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151016_H), new ItemStack(Items.field_151016_H), new ItemStack(RegistryManager.shard_ember), new ItemStack(RegistryManager.shard_ember), new ItemStack(RegistryManager.glimmer_shard, 1)));
        alchemyRecipes.add(new AlchemyRecipe(24, 36, 0, 0, 0, 0, 0, 0, 0, 0, new ItemStack(Items.field_151042_j), new ItemStack(Items.field_151128_bU), new ItemStack(Items.field_151119_aD), new ItemStack(Items.field_151100_aR, 1, 4), ItemStack.field_190927_a, new ItemStack(RegistryManager.isolated_materia, 4)));
        alchemyRecipes.add(new AlchemyRecipe(12, 18, 0, 0, 0, 0, 0, 0, 0, 0, new ItemStack(Items.field_151119_aD), new ItemStack(Items.field_151100_aR, 1, 15), new ItemStack(Items.field_151100_aR, 1, 15), ItemStack.field_190927_a, ItemStack.field_190927_a, new ItemStack(RegistryManager.adhesive, 6)));
        alchemyRecipes.add(new AlchemyRecipe(0, 0, 0, 0, 8, 16, 0, 0, 0, 0, new ItemStack(Items.field_151137_ax), new ItemStack(RegistryManager.dust_ash), new ItemStack(RegistryManager.dust_ash), new ItemStack(Blocks.field_150347_e, 1), new ItemStack(Blocks.field_150347_e), new ItemStack(Blocks.field_150424_aL, 2)));
        alchemyRecipes.add(new AlchemyRecipe(0, 0, 0, 0, 8, 16, 0, 0, 0, 0, new ItemStack(RegistryManager.dust_ash), new ItemStack((Block)Blocks.field_150354_m), new ItemStack((Block)Blocks.field_150354_m), new ItemStack((Block)Blocks.field_150354_m), new ItemStack((Block)Blocks.field_150354_m), new ItemStack(Blocks.field_150425_aM, 4)));
        alchemyRecipes.add(new AlchemyRecipe(0, 0, 0, 0, 0, 0, 64, 96, 64, 96, new ItemStack(RegistryManager.sword_lead, 1), new ItemStack(Blocks.field_150402_ci), new ItemStack(Blocks.field_150343_Z), new ItemStack(RegistryManager.ingot_lead), new ItemStack(RegistryManager.ingot_lead), new ItemStack(RegistryManager.tyrfing, 1)));
        alchemyRecipes.add(new AlchemyRecipe(0, 0, 24, 48, 24, 48, 0, 0, 0, 0, new ItemStack(RegistryManager.crystal_ember, 1), new ItemStack(Items.field_151016_H), new ItemStack(RegistryManager.shard_ember), new ItemStack(RegistryManager.shard_ember), new ItemStack(RegistryManager.shard_ember), new ItemStack(RegistryManager.ember_cluster, 1)));
        alchemyRecipes.add(new AlchemyRecipe(32, 48, 0, 0, 0, 0, 24, 32, 0, 0, new ItemStack(RegistryManager.ancient_motive_core, 1), new ItemStack(RegistryManager.ingot_dawnstone), new ItemStack(RegistryManager.ember_cluster), new ItemStack(RegistryManager.ingot_dawnstone), new ItemStack(RegistryManager.plate_copper), new ItemStack(RegistryManager.wildfire_core, 1)));
        alchemyRecipes.add(new AlchemyRecipe(0, 0, 4, 8, 0, 0, 0, 0, 0, 0, new ItemStack(RegistryManager.archaic_brick, 1), new ItemStack(Blocks.field_150425_aM), new ItemStack(Blocks.field_150425_aM), new ItemStack(Items.field_151119_aD), new ItemStack(Items.field_151119_aD), new ItemStack(RegistryManager.archaic_brick, 5)));
        alchemyRecipes.add(new AlchemyRecipe(0, 0, 24, 32, 0, 0, 0, 0, 0, 0, new ItemStack(RegistryManager.shard_ember, 1), new ItemStack(RegistryManager.archaic_brick), new ItemStack(RegistryManager.archaic_brick), new ItemStack(RegistryManager.archaic_brick), new ItemStack(RegistryManager.archaic_brick), new ItemStack(RegistryManager.ancient_motive_core, 1)));
        alchemyRecipes.add(new AlchemyRecipe(0, 0, 0, 0, 16, 24, 0, 0, 0, 0, new ItemStack(Items.field_151016_H, 1), new ItemStack(RegistryManager.plate_iron), new ItemStack(RegistryManager.plate_iron), new ItemStack(RegistryManager.plate_iron), new ItemStack(RegistryManager.ingot_copper), new ItemStack(RegistryManager.blasting_core, 1)));
        alchemyRecipes.add(new AlchemyRecipe(0, 0, 16, 32, 0, 0, 0, 0, 48, 72, new ItemStack(RegistryManager.archaic_circuit, 1), new ItemStack(RegistryManager.archaic_brick), new ItemStack(Items.field_151044_h), new ItemStack(RegistryManager.archaic_brick), new ItemStack(Items.field_151044_h), new ItemStack(RegistryManager.eldritch_insignia, 1)));
        alchemyRecipes.add(new AlchemyRecipe(0, 0, 0, 0, 24, 48, 0, 0, 40, 64, new ItemStack(RegistryManager.plate_copper, 1), new ItemStack(RegistryManager.archaic_circuit), new ItemStack(RegistryManager.ingot_copper), new ItemStack(RegistryManager.archaic_circuit), new ItemStack(RegistryManager.ingot_copper), new ItemStack(RegistryManager.intelligent_apparatus, 1)));
        alchemyRecipes.add(new AlchemyRecipe(0, 0, 16, 32, 0, 0, 16, 32, 0, 0, new ItemStack(RegistryManager.crystal_ember, 1), new ItemStack(RegistryManager.plate_dawnstone), new ItemStack(RegistryManager.plate_dawnstone), new ItemStack(RegistryManager.plate_dawnstone), new ItemStack(RegistryManager.ingot_silver), new ItemStack(RegistryManager.flame_barrier, 1)));
    }

    public static ItemStampingRecipe getStampingRecipe(ItemStack stack, FluidStack fluid, EnumStampType type) {
        for (int i = 0; i < stampingRecipes.size(); ++i) {
            if (!stampingRecipes.get(i).matches(stack, fluid, type)) continue;
            return stampingRecipes.get(i);
        }
        return null;
    }

    public static ItemStampingOreRecipe getStampingOreRecipe(ItemStack stack, FluidStack fluid, EnumStampType type) {
        for (int i = 0; i < stampingOreRecipes.size(); ++i) {
            if (!stampingOreRecipes.get(i).matches(stack, fluid, type)) continue;
            return stampingOreRecipes.get(i);
        }
        return null;
    }

    public static ItemMeltingRecipe getMeltingRecipe(ItemStack stack) {
        for (int i = 0; i < meltingRecipes.size(); ++i) {
            if (!meltingRecipes.get(i).matches(stack)) continue;
            return meltingRecipes.get(i);
        }
        return null;
    }

    public static ItemMeltingOreRecipe getMeltingOreRecipe(ItemStack stack) {
        for (int i = 0; i < meltingOreRecipes.size(); ++i) {
            if (!meltingOreRecipes.get(i).matches(stack)) continue;
            return meltingOreRecipes.get(i);
        }
        return null;
    }

    public static FluidMixingRecipe getMixingRecipe(ArrayList<FluidStack> fluids) {
        for (int i = 0; i < mixingRecipes.size(); ++i) {
            if (!mixingRecipes.get(i).matches(fluids)) continue;
            return mixingRecipes.get(i);
        }
        return null;
    }

    public static AlchemyRecipe getAlchemyRecipe(ItemStack center, ItemStack stack1, ItemStack stack2, ItemStack stack3, ItemStack stack4) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        if (stack1 != ItemStack.field_190927_a) {
            list.add(stack1);
        }
        if (stack2 != ItemStack.field_190927_a) {
            list.add(stack2);
        }
        if (stack3 != ItemStack.field_190927_a) {
            list.add(stack3);
        }
        if (stack4 != ItemStack.field_190927_a) {
            list.add(stack4);
        }
        for (int i = 0; i < alchemyRecipes.size(); ++i) {
            if (!alchemyRecipes.get(i).matches(center, list)) continue;
            return alchemyRecipes.get(i);
        }
        return null;
    }
}

