/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.itemmod;

import java.util.ArrayList;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import teamroots.embers.RegistryManager;
import teamroots.embers.itemmod.ModifierBase;
import teamroots.embers.network.PacketHandler;
import teamroots.embers.network.message.MessageRemovePlayerEmber;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.util.EmberInventoryUtil;
import teamroots.embers.util.ItemModUtil;
import teamroots.embers.util.Misc;

public class ModifierResonatingBell
extends ModifierBase {
    public int cooldown = 0;

    public ModifierResonatingBell() {
        super(ModifierBase.EnumType.TOOL, "resonating_bell", 5.0, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START && this.cooldown > 0) {
            --this.cooldown;
        }
    }

    @SubscribeEvent
    public void onClick(PlayerInteractEvent.RightClickBlock event) {
        ItemStack s = event.getItemStack();
        if (ItemModUtil.hasHeat(s) && this.cooldown == 0) {
            int level = ItemModUtil.getModifierLevel(s, ItemModUtil.modifierRegistry.get((Object)RegistryManager.resonating_bell).name);
            if (event.getWorld().field_72995_K && level > 0 && EmberInventoryUtil.getEmberTotal(event.getEntityPlayer()) > this.cost) {
                this.cooldown = 80;
                IBlockState state = event.getWorld().func_180495_p(event.getPos());
                int count = 0;
                ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
                for (int i = -(1 + 3 * level); i < 2 + 3 * level; ++i) {
                    for (int j = -(1 + 3 * level); j < 2 + 3 * level; ++j) {
                        for (int k = -(1 + 3 * level); k < 2 + 3 * level; ++k) {
                            if (event.getWorld().func_180495_p(event.getPos().func_177982_a(i, j, k)) != state) continue;
                            positions.add(event.getPos().func_177982_a(i, j, k));
                            ++count;
                        }
                    }
                }
                if (count < 200 * level) {
                    for (BlockPos p : positions) {
                        for (int i = 0; i < 3; ++i) {
                            ParticleUtil.spawnParticleGlowThroughBlocks(event.getWorld(), (float)p.func_177958_n() + 0.5f, (float)p.func_177956_o() + 0.5f, (float)p.func_177952_p() + 0.5f, 0.0625f * (Misc.random.nextFloat() - 0.5f), 0.0625f * (Misc.random.nextFloat() - 0.5f), 0.0625f * (Misc.random.nextFloat() - 0.5f), 255.0f, 64.0f, 16.0f, 0.0625f * Misc.random.nextFloat() + 0.0625f, 8.0f + 16.0f * Misc.random.nextFloat(), 200);
                        }
                    }
                }
                PacketHandler.INSTANCE.sendToServer((IMessage)new MessageRemovePlayerEmber(event.getEntityPlayer().func_110124_au(), this.cost));
            }
        }
    }
}

