/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.util;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import me.desht.pneumaticcraft.common.entity.living.EntityDrone;
import me.desht.pneumaticcraft.common.progwidgets.IProgWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetString;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityBoat;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.tuple.Pair;

public class EntityFilter
implements Predicate<Entity>,
com.google.common.base.Predicate<Entity> {
    private static final Pattern ELEMENT_DIVIDER = Pattern.compile(";");
    private static final Pattern ELEMENT_SUBDIVIDER = Pattern.compile("[(),]");
    private static final EntityFilter ALLOW_FILTER = EntityFilter.allow();
    private static final EntityFilter DENY_FILTER = EntityFilter.deny();
    private final List<EntityMatcher> matchers = new ArrayList<EntityMatcher>();
    private final boolean sense;
    private final String rawFilter;

    public EntityFilter(String filter) {
        if (filter.startsWith("!")) {
            filter = filter.substring(1);
            this.sense = false;
        } else {
            this.sense = true;
        }
        this.rawFilter = filter;
        if (!filter.isEmpty()) {
            Arrays.stream(ELEMENT_DIVIDER.split(filter)).map(x$0 -> new EntityMatcher((String)x$0)).forEach(this.matchers::add);
        }
    }

    public static EntityFilter fromProgWidget(IProgWidget widget, boolean whitelist) {
        if (widget.getParameters().length > 1) {
            IProgWidget w = widget.getConnectedParameters()[whitelist ? 1 : widget.getParameters().length + 1];
            ArrayList<String> l = new ArrayList<String>();
            if (w instanceof ProgWidgetString) {
                while (w instanceof ProgWidgetString) {
                    String str = ((ProgWidgetString)w).string;
                    Validate.isTrue((!str.startsWith("!") ? 1 : 0) != 0, (String)"'!' negation can't be used here (put blacklist filters on left of widget)", (Object[])new Object[0]);
                    l.add(str);
                    w = w.getConnectedParameters()[0];
                }
                return new EntityFilter(Strings.join(l, (String)";"));
            }
        }
        return whitelist ? ALLOW_FILTER : DENY_FILTER;
    }

    public static EntityFilter fromString(String s) {
        try {
            return new EntityFilter(s);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static EntityFilter allow() {
        return new ConstantEntityFilter(true);
    }

    public static EntityFilter deny() {
        return new ConstantEntityFilter(false);
    }

    public String toString() {
        return this.rawFilter;
    }

    public boolean apply(@Nullable Entity input) {
        return this.test(input);
    }

    @Override
    public boolean test(Entity entity) {
        if (this.matchers.isEmpty()) {
            return true;
        }
        for (EntityMatcher m : this.matchers) {
            if (!m.test(entity)) continue;
            return this.sense;
        }
        return !this.sense;
    }

    private static String wildcardToRegex(String wildcard) {
        StringBuilder s = new StringBuilder(wildcard.length());
        s.append('^');
        int is = wildcard.length();
        block5: for (int i = 0; i < is; ++i) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    continue block5;
                }
                case '?': {
                    s.append(".");
                    continue block5;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\").append(c);
                    continue block5;
                }
                default: {
                    s.append(c);
                }
            }
        }
        s.append('$');
        return s.toString();
    }

    public static class ConstantEntityFilter
    extends EntityFilter {
        private final boolean allow;

        private ConstantEntityFilter(boolean allow) {
            super("");
            this.allow = allow;
        }

        @Override
        public boolean test(Entity entity) {
            return this.allow;
        }
    }

    private class EntityMatcher
    implements Predicate<Entity> {
        private final Pattern regex;
        private final Class<?> typeClass;
        private final List<Pair<Modifier, String>> modifiers = new ArrayList<Pair<Modifier, String>>();

        private EntityMatcher(String element) {
            String[] splits = ELEMENT_SUBDIVIDER.split(element);
            for (int i = 0; i < splits.length; ++i) {
                splits[i] = splits[i].trim();
            }
            if (splits[0].startsWith("@")) {
                String sub = splits[0].substring(1);
                if (StringUtils.countMatches((CharSequence)element, (CharSequence)"(") != StringUtils.countMatches((CharSequence)element, (CharSequence)")")) {
                    throw new IllegalArgumentException("Mismatched opening/closing braces");
                }
                this.typeClass = this.getClassFor(sub);
                this.regex = null;
            } else {
                this.typeClass = null;
                this.regex = Pattern.compile(EntityFilter.wildcardToRegex(splits[0]), 2);
            }
            for (int i = 1; i < splits.length; ++i) {
                Modifier m;
                String[] modifier = splits[i].split("=");
                Validate.isTrue((modifier.length == 2 ? 1 : 0) != 0, (String)("Invalid modifier syntax: " + splits[i]), (Object[])new Object[0]);
                try {
                    m = Modifier.valueOf(modifier[0].toUpperCase());
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unknown modifier: " + modifier[0]);
                }
                Validate.isTrue((boolean)m.isValid(modifier[1]), (String)("'" + modifier[1] + "' is not a valid value for modifier '" + modifier[0] + "'.  Valid values are: " + Strings.join((Iterable)m.vals, (String)",")), (Object[])new Object[0]);
                this.modifiers.add((Pair<Modifier, String>)Pair.of((Object)((Object)m), (Object)modifier[1]));
            }
        }

        @Override
        public boolean test(Entity entity) {
            boolean ok = false;
            if (this.typeClass != null) {
                ok = this.typeClass.isAssignableFrom(entity.getClass());
            } else if (this.regex != null) {
                Matcher m = this.regex.matcher(entity.func_70005_c_());
                ok = m.matches();
            }
            return ok && this.matchModifiers(entity);
        }

        private boolean matchModifiers(Entity entity) {
            for (Pair<Modifier, String> pair : this.modifiers) {
                Modifier modifier = (Modifier)((Object)pair.getLeft());
                String val = (String)pair.getRight();
                boolean ret = false;
                switch (modifier) {
                    case AGE: {
                        if (!(entity instanceof EntityAgeable)) break;
                        ret = ((EntityAgeable)entity).func_70874_b() >= 0 ? val.equalsIgnoreCase("adult") : val.equalsIgnoreCase("baby");
                        break;
                    }
                    case BREEDABLE: {
                        if (!(entity instanceof EntityAnimal)) break;
                        boolean bl = ret = ((EntityAnimal)entity).func_70874_b() == 0 ? val.equalsIgnoreCase("yes") : val.equalsIgnoreCase("no");
                    }
                }
                if (ret) continue;
                return false;
            }
            return true;
        }

        private Class<?> getClassFor(String substring) {
            Class typeClass;
            switch (substring) {
                case "mob": {
                    typeClass = IMob.class;
                    break;
                }
                case "animal": {
                    typeClass = EntityAnimal.class;
                    break;
                }
                case "living": {
                    typeClass = EntityLivingBase.class;
                    break;
                }
                case "player": {
                    typeClass = EntityPlayer.class;
                    break;
                }
                case "item": {
                    typeClass = EntityItem.class;
                    break;
                }
                case "minecart": {
                    typeClass = EntityMinecart.class;
                    break;
                }
                case "drone": {
                    typeClass = EntityDrone.class;
                    break;
                }
                case "boat": {
                    typeClass = EntityBoat.class;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown entity type specifier: @" + substring);
                }
            }
            return typeClass;
        }
    }

    private static enum Modifier {
        AGE((ImmutableSet<String>)ImmutableSet.of((Object)"adult", (Object)"baby")),
        BREEDABLE((ImmutableSet<String>)ImmutableSet.of((Object)"yes", (Object)"no"));

        private final Set<String> vals;

        private Modifier(ImmutableSet<String> v) {
            this.vals = v;
        }

        boolean isValid(String s) {
            return this.vals.contains(s);
        }
    }
}

