/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import me.desht.pneumaticcraft.common.network.AbstractPacket;
import net.minecraft.entity.player.EntityPlayer;

public class PacketMarkPlayerJetbootsActive
extends AbstractPacket<PacketMarkPlayerJetbootsActive> {
    private static final Set<UUID> rotatedPlayers = new HashSet<UUID>();
    private UUID playerID;
    private boolean flying;

    public PacketMarkPlayerJetbootsActive() {
    }

    public PacketMarkPlayerJetbootsActive(EntityPlayer player, boolean flying) {
        this.playerID = player.func_110124_au();
        this.flying = flying;
    }

    @Override
    public void handleClientSide(PacketMarkPlayerJetbootsActive message, EntityPlayer player) {
        if (message.flying) {
            rotatedPlayers.add(message.playerID);
        } else {
            rotatedPlayers.remove(message.playerID);
        }
    }

    @Override
    public void handleServerSide(PacketMarkPlayerJetbootsActive message, EntityPlayer player) {
    }

    public void fromBytes(ByteBuf buf) {
        long l1 = buf.readLong();
        long l2 = buf.readLong();
        this.playerID = new UUID(l1, l2);
        this.flying = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.playerID.getMostSignificantBits());
        buf.writeLong(this.playerID.getLeastSignificantBits());
        buf.writeBoolean(this.flying);
    }

    public static boolean shouldPlayerBeRotated(EntityPlayer player) {
        return rotatedPlayers.contains(player.func_110124_au());
    }
}

