/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import java.util.HashSet;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.ai.DroneAILiquidExport;
import me.desht.pneumaticcraft.common.ai.DroneAILiquidImport;
import me.desht.pneumaticcraft.common.ai.DroneEntityAIInventoryExport;
import me.desht.pneumaticcraft.common.ai.DroneEntityAIInventoryImport;
import me.desht.pneumaticcraft.common.ai.IDroneBase;
import me.desht.pneumaticcraft.common.ai.LogisticsManager;
import me.desht.pneumaticcraft.common.progwidgets.ICountWidget;
import me.desht.pneumaticcraft.common.progwidgets.ILiquidFiltered;
import me.desht.pneumaticcraft.common.progwidgets.ISidedWidget;
import me.desht.pneumaticcraft.common.progwidgets.ProgWidgetAreaItemBase;
import me.desht.pneumaticcraft.common.semiblock.ISemiBlock;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockLogistics;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import me.desht.pneumaticcraft.common.util.StreamUtils;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class DroneAILogistics
extends EntityAIBase {
    private EntityAIBase curAI;
    private final IDroneBase drone;
    private final ProgWidgetAreaItemBase widget;
    private final LogisticsManager manager = new LogisticsManager();
    private LogisticsManager.LogisticsTask curTask;

    public DroneAILogistics(IDroneBase drone, ProgWidgetAreaItemBase widget) {
        this.drone = drone;
        this.widget = widget;
    }

    public boolean func_75250_a() {
        this.manager.clearLogistics();
        Set<BlockPos> area = this.widget.getCachedAreaSet();
        if (area.size() == 0) {
            return false;
        }
        int minX = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int minY = Integer.MAX_VALUE;
        int maxY = Integer.MIN_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (BlockPos pos : area) {
            minX = Math.min(minX, pos.func_177958_n());
            maxX = Math.max(maxX, pos.func_177958_n());
            minY = Math.min(minY, pos.func_177956_o());
            maxY = Math.max(maxY, pos.func_177956_o());
            minZ = Math.min(minZ, pos.func_177952_p());
            maxZ = Math.max(maxZ, pos.func_177952_p());
        }
        AxisAlignedBB aabb = new AxisAlignedBB(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
        Stream<ISemiBlock> semiBlocksInArea = SemiBlockManager.getInstance(this.drone.world()).getSemiBlocksInArea(this.drone.world(), aabb);
        Stream<ISemiBlock> logisticFrames = StreamUtils.ofType(SemiBlockLogistics.class, semiBlocksInArea);
        logisticFrames.filter(frame -> area.contains(frame.getPos())).forEach(this.manager::addLogisticFrame);
        this.curTask = null;
        return this.doLogistics();
    }

    private boolean doLogistics() {
        ItemStack item = this.drone.getInv().getStackInSlot(0);
        FluidStack fluid = this.drone.getTank().getFluid();
        PriorityQueue<LogisticsManager.LogisticsTask> tasks = this.manager.getTasks(item.func_190926_b() ? fluid : item);
        if (tasks.size() > 0) {
            this.curTask = tasks.poll();
            return this.execute(this.curTask);
        }
        return false;
    }

    public boolean func_75253_b() {
        if (this.curTask == null) {
            return false;
        }
        if (!this.curAI.func_75253_b()) {
            if (this.curAI instanceof DroneEntityAIInventoryImport) {
                this.curTask.requester.clearIncomingStack(this.curTask.transportingItem);
                return this.clearAIAndProvideAgain();
            }
            if (this.curAI instanceof DroneAILiquidImport) {
                this.curTask.requester.clearIncomingStack(this.curTask.transportingFluid);
                return this.clearAIAndProvideAgain();
            }
            this.curAI = null;
            return false;
        }
        this.curTask.informRequester();
        return true;
    }

    private boolean clearAIAndProvideAgain() {
        this.curAI = null;
        if (this.curTask.isStillValid(this.drone.getInv().getStackInSlot(0).func_190926_b() ? this.drone.getTank().getFluid() : this.drone.getInv().getStackInSlot(0)) && this.execute(this.curTask)) {
            return true;
        }
        this.curTask = null;
        return this.doLogistics();
    }

    public boolean execute(LogisticsManager.LogisticsTask task) {
        if (!this.drone.getInv().getStackInSlot(0).func_190926_b()) {
            if (!this.isPosPathfindable(task.requester.getPos())) {
                return false;
            }
            this.curAI = new DroneEntityAIInventoryExport(this.drone, new FakeWidgetLogistics(task.requester.getPos(), task.transportingItem));
        } else if (this.drone.getTank().getFluidAmount() > 0) {
            if (!this.isPosPathfindable(task.requester.getPos())) {
                return false;
            }
            this.curAI = new DroneAILiquidExport(this.drone, new FakeWidgetLogistics(task.requester.getPos(), task.transportingFluid.stack));
        } else if (!task.transportingItem.func_190926_b()) {
            if (!this.isPosPathfindable(task.provider.getPos())) {
                return false;
            }
            this.curAI = new DroneEntityAIInventoryImport(this.drone, new FakeWidgetLogistics(task.provider.getPos(), task.transportingItem));
        } else {
            if (!this.isPosPathfindable(task.provider.getPos())) {
                return false;
            }
            this.curAI = new DroneAILiquidImport(this.drone, new FakeWidgetLogistics(task.provider.getPos(), task.transportingFluid.stack));
        }
        if (this.curAI.func_75250_a()) {
            task.informRequester();
            return true;
        }
        return false;
    }

    private boolean isPosPathfindable(BlockPos pos) {
        for (EnumFacing d : EnumFacing.field_82609_l) {
            if (!this.drone.isBlockValidPathfindBlock(pos.func_177972_a(d))) continue;
            return true;
        }
        return false;
    }

    private static class FakeWidgetLogistics
    extends ProgWidgetAreaItemBase
    implements ISidedWidget,
    ICountWidget,
    ILiquidFiltered {
        @Nonnull
        private final ItemStack stack;
        private final FluidStack fluid;
        private final Set<BlockPos> area;

        FakeWidgetLogistics(BlockPos pos, @Nonnull ItemStack stack) {
            this.stack = stack;
            this.fluid = null;
            this.area = new HashSet<BlockPos>();
            this.area.add(pos);
        }

        FakeWidgetLogistics(BlockPos pos, FluidStack fluid) {
            this.stack = ItemStack.field_190927_a;
            this.fluid = fluid;
            this.area = new HashSet<BlockPos>();
            this.area.add(pos);
        }

        @Override
        public String getWidgetString() {
            return null;
        }

        @Override
        public int getCraftingColorIndex() {
            return 0;
        }

        @Override
        public void getArea(Set<BlockPos> area) {
            area.addAll(this.area);
        }

        @Override
        public void setSides(boolean[] sides) {
        }

        @Override
        public boolean[] getSides() {
            return new boolean[]{true, true, true, true, true, true};
        }

        @Override
        public boolean isItemValidForFilters(@Nonnull ItemStack item) {
            return !item.func_190926_b() && item.func_77969_a(this.stack);
        }

        @Override
        public ResourceLocation getTexture() {
            return null;
        }

        @Override
        public boolean useCount() {
            return true;
        }

        @Override
        public void setUseCount(boolean useCount) {
        }

        @Override
        public int getCount() {
            return !this.stack.func_190926_b() ? this.stack.func_190916_E() : this.fluid.amount;
        }

        @Override
        public void setCount(int count) {
        }

        @Override
        public boolean isFluidValid(Fluid fluid) {
            return fluid == this.fluid.getFluid();
        }
    }
}

