/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumaticArmor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.BlockTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.ChargingUpgradeRenderHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.ChestplateLauncherHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.CoordTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.DroneDebugUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.EntityTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.JetBootsUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.JumpBoostUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.KickUpgradeRenderHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.MagnetUpgradeRenderHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.MainHelmetHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.NightVisionUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.RunSpeedUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.ScubaUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.SearchUpgradeHandler;
import me.desht.pneumaticcraft.client.render.pneumaticArmor.renderHandler.StepAssistUpgradeHandler;
import me.desht.pneumaticcraft.common.CommonHUDHandler;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;

public class UpgradeRenderHandlerList {
    private static UpgradeRenderHandlerList INSTANCE;
    private final List<List<IUpgradeRenderHandler>> upgradeRenderers;
    private final Map<Class<? extends IUpgradeRenderHandler>, IUpgradeRenderHandler> classMap = new HashMap<Class<? extends IUpgradeRenderHandler>, IUpgradeRenderHandler>();
    public static final EntityEquipmentSlot[] ARMOR_SLOTS;

    public static UpgradeRenderHandlerList instance() {
        return INSTANCE;
    }

    public static void init() {
        INSTANCE = new UpgradeRenderHandlerList();
    }

    private UpgradeRenderHandlerList() {
        this.upgradeRenderers = new ArrayList<List<IUpgradeRenderHandler>>(4);
        for (int i = 0; i < 4; ++i) {
            this.upgradeRenderers.add(new ArrayList());
        }
        this.addUpgradeRenderer(new MainHelmetHandler());
        this.addUpgradeRenderer(new BlockTrackUpgradeHandler());
        this.addUpgradeRenderer(new EntityTrackUpgradeHandler());
        this.addUpgradeRenderer(new SearchUpgradeHandler());
        this.addUpgradeRenderer(new CoordTrackUpgradeHandler());
        this.addUpgradeRenderer(new DroneDebugUpgradeHandler());
        this.addUpgradeRenderer(new MagnetUpgradeRenderHandler());
        this.addUpgradeRenderer(new ChargingUpgradeRenderHandler());
        this.addUpgradeRenderer(new StepAssistUpgradeHandler());
        this.addUpgradeRenderer(new RunSpeedUpgradeHandler());
        this.addUpgradeRenderer(new JumpBoostUpgradeHandler());
        this.addUpgradeRenderer(new KickUpgradeRenderHandler());
        this.addUpgradeRenderer(new JetBootsUpgradeHandler());
        this.addUpgradeRenderer(new NightVisionUpgradeHandler());
        this.addUpgradeRenderer(new ScubaUpgradeHandler());
        this.addUpgradeRenderer(new ChestplateLauncherHandler());
    }

    public void addUpgradeRenderer(IUpgradeRenderHandler handler) {
        this.upgradeRenderers.get(handler.getEquipmentSlot().func_188454_b()).add(handler);
        this.classMap.put(handler.getClass(), handler);
    }

    public <T extends IUpgradeRenderHandler> T getRenderHandler(Class<T> clazz) {
        return (T)this.classMap.get(clazz);
    }

    public List<IUpgradeRenderHandler> getHandlersForSlot(EntityEquipmentSlot slot) {
        return this.upgradeRenderers.get(slot.func_188454_b());
    }

    public float getAirUsage(EntityPlayer player, EntityEquipmentSlot slot, boolean countDisabled) {
        float totalUsage = 0.0f;
        for (int i = 0; i < this.upgradeRenderers.get(slot.func_188454_b()).size(); ++i) {
            CommonHUDHandler handler = CommonHUDHandler.getHandlerForPlayer(player);
            if (!handler.isUpgradeRendererInserted(slot, i) || !countDisabled && !handler.isUpgradeRendererEnabled(slot, i)) continue;
            totalUsage += this.upgradeRenderers.get(slot.func_188454_b()).get(i).getEnergyUsage(handler.getUpgradeCount(slot, IItemRegistry.EnumUpgrade.RANGE), player);
        }
        return totalUsage;
    }

    static {
        ARMOR_SLOTS = new EntityEquipmentSlot[4];
        UpgradeRenderHandlerList.ARMOR_SLOTS[0] = EntityEquipmentSlot.HEAD;
        UpgradeRenderHandlerList.ARMOR_SLOTS[1] = EntityEquipmentSlot.CHEST;
        UpgradeRenderHandlerList.ARMOR_SLOTS[2] = EntityEquipmentSlot.LEGS;
        UpgradeRenderHandlerList.ARMOR_SLOTS[3] = EntityEquipmentSlot.FEET;
    }
}

