/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.decoration.tile;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.VanillaDoubleChestItemHandler;
import vazkii.quark.decoration.feature.VariedChests;

public class TileCustomChest
extends TileEntityChest {
    public VariedChests.ChestType chestType = VariedChests.ChestType.NONE;

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74778_a("type", this.chestType.name);
        return nbt;
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        nbt.func_74778_a("type", this.chestType.name);
        return nbt;
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        super.handleUpdateTag(tag);
        this.chestType = VariedChests.ChestType.getType(tag.func_74779_i("type"));
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("type", this.chestType.name);
        return new SPacketUpdateTileEntity(this.field_174879_c, this.func_145832_p(), nbt);
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.chestType = VariedChests.ChestType.getType(pkt.func_148857_g().func_74779_i("type"));
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.chestType = VariedChests.ChestType.getType(nbt.func_74779_i("type"));
    }

    private void setNeighbor(TileEntityChest chestTe, EnumFacing side) {
        if (chestTe.func_145837_r()) {
            this.field_145984_a = false;
        } else if (this.field_145984_a) {
            switch (side) {
                case NORTH: {
                    if (this.field_145992_i == chestTe) break;
                    this.field_145984_a = false;
                    break;
                }
                case SOUTH: {
                    if (this.field_145988_l == chestTe) break;
                    this.field_145984_a = false;
                    break;
                }
                case EAST: {
                    if (this.field_145990_j == chestTe) break;
                    this.field_145984_a = false;
                    break;
                }
                case WEST: {
                    if (this.field_145991_k == chestTe) break;
                    this.field_145984_a = false;
                }
            }
        }
    }

    @Nullable
    protected TileEntityChest func_174911_a(EnumFacing side) {
        TileEntity tileentity;
        BlockPos blockpos = this.field_174879_c.func_177972_a(side);
        if (this.isChestAt(blockpos) && (tileentity = this.func_145831_w().func_175625_s(blockpos)) instanceof TileCustomChest) {
            TileCustomChest tileentitychest = (TileCustomChest)tileentity;
            tileentitychest.setNeighbor(this, side.func_176734_d());
            return tileentitychest;
        }
        return null;
    }

    private boolean isChestAt(BlockPos posIn) {
        if (this.func_145831_w() == null) {
            return false;
        }
        Block block = this.func_145831_w().func_180495_p(posIn).func_177230_c();
        TileEntity te = this.func_145831_w().func_175625_s(posIn);
        return block instanceof BlockChest && ((BlockChest)block).field_149956_a == this.func_145980_j() && te instanceof TileCustomChest && ((TileCustomChest)te).chestType == this.chestType;
    }

    public void func_174889_b(EntityPlayer player) {
        super.func_174889_b(player);
        if (!player.func_175149_v() && this.func_145980_j() == VariedChests.CUSTOM_TYPE_QUARK_TRAP) {
            this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), this.func_145838_q(), false);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        super.func_174886_c(player);
        if (!player.func_175149_v() && this.func_145838_q() instanceof BlockChest && this.func_145980_j() == VariedChests.CUSTOM_TYPE_QUARK_TRAP) {
            this.field_145850_b.func_175685_c(this.field_174879_c.func_177977_b(), this.func_145838_q(), false);
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 1), (double)this.field_174879_c.func_177956_o(), (double)(this.field_174879_c.func_177952_p() - 1), (double)(this.field_174879_c.func_177958_n() + 2), (double)(this.field_174879_c.func_177956_o() + 2), (double)(this.field_174879_c.func_177952_p() + 2));
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (this.doubleChestHandler == null || this.doubleChestHandler.needsRefresh()) {
                this.doubleChestHandler = TileCustomChest.getDoubleChestHandler(this);
            }
            if (this.doubleChestHandler != null && this.doubleChestHandler != VanillaDoubleChestItemHandler.NO_ADJACENT_CHESTS_INSTANCE) {
                return (T)this.doubleChestHandler;
            }
        }
        return (T)super.getCapability(capability, facing);
    }

    @Nullable
    public static VanillaDoubleChestItemHandler getDoubleChestHandler(TileCustomChest chest) {
        World world = chest.func_145831_w();
        BlockPos pos = chest.func_174877_v();
        if (world == null || pos == null || !world.func_175667_e(pos)) {
            return null;
        }
        Block blockType = chest.func_145838_q();
        EnumFacing[] horizontals = EnumFacing.field_176754_o;
        for (int i = horizontals.length - 1; i >= 0; --i) {
            TileEntity otherTE;
            EnumFacing enumfacing = horizontals[i];
            BlockPos blockpos = pos.func_177972_a(enumfacing);
            Block block = world.func_180495_p(blockpos).func_177230_c();
            if (block != blockType || !((otherTE = world.func_175625_s(blockpos)) instanceof TileCustomChest)) continue;
            TileCustomChest otherChest = (TileCustomChest)otherTE;
            if (!otherChest.chestType.equals((Object)chest.chestType)) continue;
            return new VanillaDoubleChestItemHandler((TileEntityChest)chest, (TileEntityChest)otherChest, enumfacing != EnumFacing.WEST && enumfacing != EnumFacing.NORTH);
        }
        return VanillaDoubleChestItemHandler.NO_ADJACENT_CHESTS_INSTANCE;
    }
}

