/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.dimensions.world.terrain.lost;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import mcjty.rftoolsdim.config.LostCityConfiguration;
import mcjty.rftoolsdim.config.WorldgenConfiguration;
import mcjty.rftoolsdim.dimensions.world.ChunkPrimerHelper;
import mcjty.rftoolsdim.dimensions.world.GenericChunkGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.BaseTerrainGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.NormalTerrainGenerator;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.BuildingInfo;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.DamageArea;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.GenInfo;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.Style;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.data.BridgeData;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.data.DataCenterData;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.data.FloorsData;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.data.FountainData;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.data.Level;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.data.LibraryData;
import mcjty.rftoolsdim.dimensions.world.terrain.lost.data.ParkData;
import mcjty.rftoolsdim.varia.GeometryTools;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockRail;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.ChunkPrimer;
import org.apache.commons.lang3.tuple.Pair;

public class LostCitiesTerrainGenerator
extends NormalTerrainGenerator {
    private final byte groundLevel = (byte)63;
    private final byte waterLevel = (byte)(63 - LostCityConfiguration.WATERLEVEL_OFFSET);
    private static IBlockState bedrock;
    private static IBlockState air;
    private IBlockState baseBlock;
    private IBlockState baseLiquid;
    public static final ResourceLocation LOOT;
    private static final int STREETBORDER = 3;
    private static Map<Character, Function<BuildingInfo, IBlockState>> mapping;
    private static Map<Pair<Integer, Integer>, GenInfo> genInfos;
    private static Random globalRandom;

    public static Map<Character, Function<BuildingInfo, IBlockState>> getMapping() {
        if (mapping == null) {
            mapping = new HashMap<Character, Function<BuildingInfo, IBlockState>>();
            mapping.put(Character.valueOf('#'), info -> {
                if (globalRandom.nextFloat() < LostCityConfiguration.STYLE_CHANCE_CRACKED) {
                    return info.getStyle().bricks_cracked;
                }
                if (globalRandom.nextFloat() < LostCityConfiguration.STYLE_CHANCE_MOSSY) {
                    return info.getStyle().bricks_mossy;
                }
                return info.getStyle().bricks;
            });
            mapping.put(Character.valueOf('x'), info -> {
                if (globalRandom.nextFloat() < LostCityConfiguration.STYLE_CHANCE_CRACKED) {
                    return info.getStyle().bricks_cracked;
                }
                if (globalRandom.nextFloat() < LostCityConfiguration.STYLE_CHANCE_MOSSY) {
                    return info.getStyle().bricks_mossy;
                }
                return info.getStyle().bricks;
            });
            mapping.put(Character.valueOf('$'), info -> info.getStyle().bricks_variant);
            mapping.put(Character.valueOf('='), info -> info.getStyle().glass);
            mapping.put(Character.valueOf('+'), info -> info.getStyle().glass_full);
            mapping.put(Character.valueOf('@'), info -> {
                switch (info.glassType) {
                    case 0: {
                        return info.getStyle().glass;
                    }
                    case 1: {
                        return info.getStyle().street;
                    }
                    case 2: {
                        return info.getStyle().bricks;
                    }
                    case 3: {
                        return info.getStyle().quartz;
                    }
                }
                return info.getStyle().glass;
            });
            mapping.put(Character.valueOf(' '), info -> Blocks.field_150350_a.func_176223_P());
            mapping.put(Character.valueOf('l'), info -> Blocks.field_150468_ap.func_176223_P());
            mapping.put(Character.valueOf('1'), info -> Blocks.field_150344_f.func_176223_P());
            mapping.put(Character.valueOf('2'), info -> Blocks.field_150344_f.func_176223_P());
            mapping.put(Character.valueOf('3'), info -> Blocks.field_150344_f.func_176223_P());
            mapping.put(Character.valueOf('4'), info -> Blocks.field_150344_f.func_176223_P());
            mapping.put(Character.valueOf('C'), info -> Blocks.field_150344_f.func_176223_P());
            mapping.put(Character.valueOf('M'), info -> Blocks.field_150344_f.func_176223_P());
            mapping.put(Character.valueOf('F'), info -> Blocks.field_150344_f.func_176223_P());
            mapping.put(Character.valueOf('R'), info -> Blocks.field_150344_f.func_176223_P());
            mapping.put(Character.valueOf(':'), info -> Blocks.field_150411_aY.func_176223_P());
            mapping.put(Character.valueOf('D'), info -> Blocks.field_150346_d.func_176223_P());
            mapping.put(Character.valueOf('G'), info -> Blocks.field_150349_c.func_176223_P());
            mapping.put(Character.valueOf('p'), info -> {
                switch (globalRandom.nextInt(11)) {
                    case 0: 
                    case 1: 
                    case 2: {
                        return Blocks.field_150328_O.func_176223_P();
                    }
                    case 3: 
                    case 4: 
                    case 5: {
                        return Blocks.field_150327_N.func_176223_P();
                    }
                    case 6: {
                        return Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.ACACIA);
                    }
                    case 7: {
                        return Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.BIRCH);
                    }
                    case 8: {
                        return Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.OAK);
                    }
                    case 9: {
                        return Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.SPRUCE);
                    }
                }
                return air;
            });
            mapping.put(Character.valueOf('*'), info -> Blocks.field_150457_bL.func_176223_P());
            mapping.put(Character.valueOf('X'), info -> info.getStyle().bricks_monster);
            mapping.put(Character.valueOf('Q'), info -> Blocks.field_150371_ca.func_176223_P());
            mapping.put(Character.valueOf('L'), info -> Blocks.field_150342_X.func_176223_P());
            mapping.put(Character.valueOf('W'), info -> Blocks.field_150355_j.func_176223_P());
            mapping.put(Character.valueOf('w'), info -> Blocks.field_150463_bK.func_176223_P());
            mapping.put(Character.valueOf('S'), info -> Blocks.field_150334_T.func_176223_P());
            mapping.put(Character.valueOf('<'), info -> Blocks.field_150370_cb.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
            mapping.put(Character.valueOf('>'), info -> Blocks.field_150370_cb.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
            mapping.put(Character.valueOf('_'), info -> Blocks.field_150333_U.func_176223_P());
            mapping.put(Character.valueOf('.'), info -> Blocks.field_180407_aO.func_176223_P());
            mapping.put(Character.valueOf('-'), info -> Blocks.field_150452_aw.func_176223_P());
            mapping.put(Character.valueOf('%'), info -> {
                if (globalRandom.nextFloat() < 0.3f) {
                    return Blocks.field_150321_G.func_176223_P();
                }
                return air;
            });
        }
        return mapping;
    }

    public static Map<Pair<Integer, Integer>, GenInfo> getGenInfos() {
        if (genInfos == null) {
            genInfos = new HashMap<Pair<Integer, Integer>, GenInfo>();
            LostCitiesTerrainGenerator.getGenInfos(FloorsData.FLOORS, 0);
            LostCitiesTerrainGenerator.getGenInfos(FloorsData.FLOORS2, 1);
            LostCitiesTerrainGenerator.getGenInfos(FloorsData.FLOORS3, 2);
            LostCitiesTerrainGenerator.getGenInfos(LibraryData.LIBRARY00, 10);
            LostCitiesTerrainGenerator.getGenInfos(LibraryData.LIBRARY10, 11);
            LostCitiesTerrainGenerator.getGenInfos(LibraryData.LIBRARY01, 12);
            LostCitiesTerrainGenerator.getGenInfos(LibraryData.LIBRARY11, 13);
            LostCitiesTerrainGenerator.getGenInfos(DataCenterData.CENTER00, 20);
            LostCitiesTerrainGenerator.getGenInfos(DataCenterData.CENTER10, 21);
            LostCitiesTerrainGenerator.getGenInfos(DataCenterData.CENTER01, 22);
            LostCitiesTerrainGenerator.getGenInfos(DataCenterData.CENTER11, 23);
        }
        return genInfos;
    }

    private static void getGenInfos(Level[] floors, int floorIdx) {
        for (int i = 0; i < floors.length; ++i) {
            GenInfo gi = new GenInfo();
            Level level = floors[i];
            for (int y = 0; y < 6; ++y) {
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        Character c = level.getC(x, y, z);
                        if (c.charValue() == '1') {
                            gi.addSpawnerType(new BlockPos(x, y, z), 1);
                            continue;
                        }
                        if (c.charValue() == '2') {
                            gi.addSpawnerType(new BlockPos(x, y, z), 2);
                            continue;
                        }
                        if (c.charValue() == '3') {
                            gi.addSpawnerType(new BlockPos(x, y, z), 3);
                            continue;
                        }
                        if (c.charValue() == '4') {
                            gi.addSpawnerType(new BlockPos(x, y, z), 4);
                            continue;
                        }
                        if (c.charValue() == 'C') {
                            gi.addChest(new BlockPos(x, y, z));
                            continue;
                        }
                        if (c.charValue() == 'M') {
                            gi.addModularStorage(new BlockPos(x, y, z));
                            continue;
                        }
                        if (c.charValue() == 'F') {
                            gi.addRandomFeatures(new BlockPos(x, y, z));
                            continue;
                        }
                        if (c.charValue() != 'R') continue;
                        gi.addRandomRFToolsMachine(new BlockPos(x, y, z));
                    }
                }
            }
            genInfos.put((Pair<Integer, Integer>)Pair.of((Object)floorIdx, (Object)i), gi);
        }
    }

    @Override
    public void generate(int chunkX, int chunkZ, ChunkPrimer primer) {
        this.baseBlock = this.provider.dimensionInformation.getBaseBlockForTerrain();
        this.baseLiquid = this.provider.dimensionInformation.getFluidForTerrain().func_176223_P();
        BuildingInfo info = new BuildingInfo(chunkX, chunkZ, this.provider.seed);
        air = Blocks.field_150350_a.func_176223_P();
        bedrock = Blocks.field_150357_h.func_176223_P();
        ChunkPrimerHelper helper = new ChunkPrimerHelper(primer);
        if (info.isCity) {
            this.doCityChunk(chunkX, chunkZ, helper, info);
        } else {
            this.doNormalChunk(chunkX, chunkZ, primer, info);
        }
        this.generateDebris(helper, this.provider.rand, info);
    }

    private void doNormalChunk(int chunkX, int chunkZ, ChunkPrimer primer, BuildingInfo info) {
        int cx = chunkX * 16;
        int cz = chunkZ * 16;
        this.generateHeightmap(chunkX * 4, 0, chunkZ * 4);
        for (int x4 = 0; x4 < 4; ++x4) {
            int l = x4 * 5;
            int i1 = (x4 + 1) * 5;
            for (int z4 = 0; z4 < 4; ++z4) {
                int k1 = (l + z4) * 33;
                int l1 = (l + z4 + 1) * 33;
                int i2 = (i1 + z4) * 33;
                int j2 = (i1 + z4 + 1) * 33;
                for (int height32 = 0; height32 < 32; ++height32) {
                    double d1 = this.heightMap[k1 + height32];
                    double d2 = this.heightMap[l1 + height32];
                    double d3 = this.heightMap[i2 + height32];
                    double d4 = this.heightMap[j2 + height32];
                    double d5 = (this.heightMap[k1 + height32 + 1] - d1) * 0.125;
                    double d6 = (this.heightMap[l1 + height32 + 1] - d2) * 0.125;
                    double d7 = (this.heightMap[i2 + height32 + 1] - d3) * 0.125;
                    double d8 = (this.heightMap[j2 + height32 + 1] - d4) * 0.125;
                    for (int h = 0; h < 8; ++h) {
                        double d10 = d1;
                        double d11 = d2;
                        double d12 = (d3 - d1) * 0.25;
                        double d13 = (d4 - d2) * 0.25;
                        int height = height32 * 8 + h;
                        for (int x = 0; x < 4; ++x) {
                            int index = x + x4 * 4 << 12 | 0 + z4 * 4 << 8 | height;
                            int maxheight = 256;
                            index -= maxheight;
                            double d16 = (d11 - d10) * 0.25;
                            double d15 = d10 - d16;
                            for (int z = 0; z < 4; ++z) {
                                double d;
                                index += maxheight;
                                d15 += d16;
                                if (d > 0.0) {
                                    IBlockState b = info.getDamageArea().damageBlock(this.baseBlock, height < this.waterLevel ? this.baseLiquid : air, this.provider.rand, cx + x4 * 4 + x, height, cz + z4 * 4 + z, index, info.getStyle());
                                    BaseTerrainGenerator.setBlockState(primer, index, b);
                                    continue;
                                }
                                if (height >= this.waterLevel) continue;
                                BaseTerrainGenerator.setBlockState(primer, index, this.baseLiquid);
                            }
                            d10 += d12;
                            d11 += d13;
                        }
                        d1 += d5;
                        d2 += d6;
                        d3 += d7;
                        d4 += d8;
                    }
                }
            }
        }
        this.flattenChunkToCityBorder(chunkX, chunkZ, primer, info);
        this.generateBridges(chunkX, chunkZ, primer, info);
    }

    private void generateBridges(int chunkX, int chunkZ, ChunkPrimer primer, BuildingInfo info) {
        block19: {
            int bt;
            block18: {
                int index;
                int z;
                int x;
                bt = info.hasXBridge(this.provider);
                if (bt < 0) break block18;
                int cx = chunkX * 16;
                int cz = chunkZ * 16;
                DamageArea damageArea = info.getDamageArea();
                Style style = info.getStyle();
                Level level = BridgeData.BRIDGES[bt];
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        index = x << 12 | (z << 8) + this.groundLevel + 1;
                        int height = this.groundLevel + 1;
                        for (int l = 0; l < level.getFloor().length; ++l) {
                            IBlockState b = level.get(info, x, l, z);
                            b = damageArea.damageBlock(b, air, this.provider.rand, cx + x, height, cz + z, index, style);
                            BaseTerrainGenerator.setBlockState(primer, index++, b);
                            ++height;
                        }
                    }
                }
                if (info.getXmin().hasXBridge(this.provider) >= 0 && info.getXmax().hasXBridge(this.provider) >= 0) {
                    for (int y = this.waterLevel - 10; y <= this.groundLevel; ++y) {
                        this.setBridgeSupport(primer, cx, cz, damageArea, style, 7, y, 7);
                        this.setBridgeSupport(primer, cx, cz, damageArea, style, 7, y, 8);
                        this.setBridgeSupport(primer, cx, cz, damageArea, style, 8, y, 7);
                        this.setBridgeSupport(primer, cx, cz, damageArea, style, 8, y, 8);
                    }
                }
                if (info.getXmin().hasXBridge(this.provider) < 0) {
                    x = 0;
                    for (z = 6; z <= 9; ++z) {
                        index = x << 12 | (z << 8) + this.groundLevel;
                        IBlockState b = damageArea.damageBlock(Blocks.field_150417_aV.func_176223_P(), air, this.provider.rand, cx + x, this.groundLevel, cz + z, index, style);
                        BaseTerrainGenerator.setBlockState(primer, index, b);
                    }
                }
                if (info.getXmax().hasXBridge(this.provider) >= 0) break block19;
                x = 15;
                for (z = 6; z <= 9; ++z) {
                    index = x << 12 | (z << 8) + this.groundLevel;
                    IBlockState b = damageArea.damageBlock(Blocks.field_150417_aV.func_176223_P(), air, this.provider.rand, cx + x, this.groundLevel, cz + z, index, style);
                    BaseTerrainGenerator.setBlockState(primer, index, b);
                }
                break block19;
            }
            bt = info.hasZBridge(this.provider);
            if (bt >= 0) {
                int x;
                int z;
                int index;
                int cx = chunkX * 16;
                int cz = chunkZ * 16;
                DamageArea damageArea = info.getDamageArea();
                Style style = info.getStyle();
                Level level = BridgeData.BRIDGES[bt];
                for (int x2 = 0; x2 < 16; ++x2) {
                    for (int z2 = 0; z2 < 16; ++z2) {
                        index = x2 << 12 | (z2 << 8) + this.groundLevel + 1;
                        int height = this.groundLevel + 1;
                        for (int l = 0; l < level.getFloor().length; ++l) {
                            IBlockState b = level.get(info, z2, l, x2);
                            b = damageArea.damageBlock(b, air, this.provider.rand, cx + x2, height, cz + z2, index, style);
                            BaseTerrainGenerator.setBlockState(primer, index++, b);
                            ++height;
                        }
                    }
                }
                if (info.getZmin().hasZBridge(this.provider) >= 0 && info.getZmax().hasZBridge(this.provider) >= 0) {
                    for (int y = this.waterLevel - 10; y <= this.groundLevel; ++y) {
                        this.setBridgeSupport(primer, cx, cz, damageArea, style, 7, y, 7);
                        this.setBridgeSupport(primer, cx, cz, damageArea, style, 7, y, 8);
                        this.setBridgeSupport(primer, cx, cz, damageArea, style, 8, y, 7);
                        this.setBridgeSupport(primer, cx, cz, damageArea, style, 8, y, 8);
                    }
                }
                if (info.getZmin().hasZBridge(this.provider) < 0) {
                    z = 0;
                    for (x = 6; x <= 9; ++x) {
                        index = x << 12 | (z << 8) + this.groundLevel;
                        IBlockState b = damageArea.damageBlock(Blocks.field_150417_aV.func_176223_P(), air, this.provider.rand, cx + x, this.groundLevel, cz + z, index, style);
                        BaseTerrainGenerator.setBlockState(primer, index, b);
                    }
                }
                if (info.getZmax().hasZBridge(this.provider) < 0) {
                    z = 15;
                    for (x = 6; x <= 9; ++x) {
                        index = x << 12 | (z << 8) + this.groundLevel;
                        IBlockState b = damageArea.damageBlock(Blocks.field_150417_aV.func_176223_P(), air, this.provider.rand, cx + x, this.groundLevel, cz + z, index, style);
                        BaseTerrainGenerator.setBlockState(primer, index, b);
                    }
                }
            }
        }
    }

    private void setBridgeSupport(ChunkPrimer primer, int cx, int cz, DamageArea damageArea, Style style, int x, int y, int z) {
        int index = x << 12 | (z << 8) + y;
        IBlockState b = damageArea.damageBlock(Blocks.field_150417_aV.func_176223_P(), air, this.provider.rand, cx + x, y, cz + z, index, style);
        BaseTerrainGenerator.setBlockState(primer, index, b);
    }

    private void flattenChunkToCityBorder(int chunkX, int chunkZ, ChunkPrimer primer, BuildingInfo info) {
        int z;
        int x;
        int cx = chunkX * 16;
        int cz = chunkZ * 16;
        int level = this.groundLevel;
        if (LostCitiesTerrainGenerator.isOcean(this.provider.biomesForGeneration)) {
            level = this.waterLevel + 4;
        }
        ArrayList<GeometryTools.AxisAlignedBB2D> boxes = new ArrayList<GeometryTools.AxisAlignedBB2D>();
        for (x = -1; x <= 1; ++x) {
            for (z = -1; z <= 1; ++z) {
                if (x == 0 && z == 0) continue;
                int ccx = chunkX + x;
                int ccz = chunkZ + z;
                BuildingInfo info2 = new BuildingInfo(ccx, ccz, this.provider.seed);
                if (!info2.isCity) continue;
                boxes.add(new GeometryTools.AxisAlignedBB2D(ccx * 16, ccz * 16, ccx * 16 + 15, ccz * 16 + 15));
            }
        }
        if (!boxes.isEmpty()) {
            for (x = 0; x < 16; ++x) {
                for (z = 0; z < 16; ++z) {
                    double mindist = 1.0E9;
                    for (GeometryTools.AxisAlignedBB2D box : boxes) {
                        double dist = GeometryTools.squaredDistanceBoxPoint(box, cx + x, cz + z);
                        if (!(dist < mindist)) continue;
                        mindist = dist;
                    }
                    int offset = (int)(Math.sqrt(mindist) * 2.0);
                    this.flattenChunkBorder(primer, x, offset, z, this.provider.rand, info, cx, cz, level);
                }
            }
        }
    }

    public static boolean isOcean(Biome[] biomes) {
        for (Biome biome : biomes) {
            if (biome == Biomes.field_76771_b || biome == Biomes.field_150575_M || biome == Biomes.field_76776_l) continue;
            return false;
        }
        return true;
    }

    public static boolean isWaterBiome(GenericChunkGenerator provider, int chunkX, int chunkZ) {
        Biome[] biomes = provider.worldObj.func_72959_q().func_76937_a(null, (chunkX - 1) * 4 - 2, chunkZ * 4 - 2, 10, 10);
        return LostCitiesTerrainGenerator.isWaterBiome(biomes);
    }

    public static boolean isWaterBiome(Biome[] biomes) {
        for (Biome biome : biomes) {
            if (biome == Biomes.field_76771_b || biome == Biomes.field_150575_M || biome == Biomes.field_76776_l || biome == Biomes.field_76781_i || biome == Biomes.field_76777_m || biome == Biomes.field_76787_r || biome == Biomes.field_150577_O) continue;
            return false;
        }
        return true;
    }

    private void flattenChunkBorder(ChunkPrimer primer, int x, int offset, int z, Random rand, BuildingInfo info, int cx, int cz, int level) {
        int index = x << 12 | z << 8;
        for (int y = 0; y <= level - offset - rand.nextInt(2); ++y) {
            IBlockState b = BaseTerrainGenerator.getBlockState(primer, index);
            if (b != bedrock && b != this.baseBlock) {
                b = info.getDamageArea().damageBlock(this.baseBlock, y < this.waterLevel ? this.baseLiquid : air, this.provider.rand, cx + x, y, cz + z, index, info.getStyle());
                BaseTerrainGenerator.setBlockState(primer, index, b);
            }
            ++index;
        }
        int r = rand.nextInt(2);
        index = x << 12 | (z << 8) + level + offset + r;
        for (int y = level + offset + 3; y < 256; ++y) {
            IBlockState b = BaseTerrainGenerator.getBlockState(primer, index);
            if (b != air) {
                BaseTerrainGenerator.setBlockState(primer, index, air);
            }
            ++index;
        }
    }

    private void doCityChunk(int chunkX, int chunkZ, ChunkPrimerHelper helper, BuildingInfo info) {
        ChunkPrimer primer = helper.getPrimer();
        boolean building = info.hasBuilding;
        Random rand = new Random(this.provider.seed * 377L + (long)chunkZ * 341873128712L + (long)chunkX * 132897987541L);
        rand.nextFloat();
        rand.nextFloat();
        int index = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int height;
                for (height = 0; height < WorldgenConfiguration.bedrockLayer; ++height) {
                    BaseTerrainGenerator.setBlockState(primer, index++, bedrock);
                }
                while (height < WorldgenConfiguration.bedrockLayer + 30 + rand.nextInt(3)) {
                    BaseTerrainGenerator.setBlockState(primer, index++, this.baseBlock);
                    ++height;
                }
                index = building ? this.generateBuilding(helper, info, rand, chunkX, chunkZ, index, x, z, height) : this.generateStreet(helper, info, rand, chunkX, chunkZ, index, x, z, height);
            }
        }
        if (building && info.getDamageArea().hasExplosions()) {
            this.fixAfterExplosion(helper, info, rand);
        }
    }

    private Blob findBlob(List<Blob> blobs, int index) {
        for (Blob blob : blobs) {
            if (!blob.contains(index)) continue;
            return blob;
        }
        return null;
    }

    private void fixAfterExplosion(ChunkPrimerHelper helper, BuildingInfo info, Random rand) {
        int start = this.groundLevel - info.floorsBelowGround * 6;
        int end = 63 + (info.floors + 2) * 6;
        int air = Block.field_176229_d.func_148747_b((Object)LostCitiesTerrainGenerator.air);
        int liquid = Block.field_176229_d.func_148747_b((Object)this.provider.dimensionInformation.getFluidForTerrain().func_176223_P());
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int index = x << 12 | (z << 8) + start;
                for (int y = start; y < end; ++y) {
                    Blob blob;
                    int p = helper.getData(index);
                    if (p != air && (blob = this.findBlob(blobs, index)) == null) {
                        blob = new Blob(start, end + 6);
                        blob.scan(info, helper, air, new BlockPos(x, y, z));
                        blobs.add(blob);
                    }
                    ++index;
                }
            }
        }
        blobs.removeIf(o -> !o.destroyOrMoveThis());
        blobs.sort(null);
        Blob blocksToMove = new Blob(0, 256);
        for (Blob blob : blobs) {
            if (rand.nextFloat() < LostCityConfiguration.DESTROY_OR_MOVE_CHANCE && blob.connectedBlocks.size() < LostCityConfiguration.DESTROY_SMALL_SECTIONS_SIZE) {
                for (Integer index : blob.connectedBlocks) {
                    helper.setData(index, (index & 0xFF) < this.waterLevel ? liquid : air);
                }
                continue;
            }
            for (Integer index : blob.connectedBlocks) {
                blocksToMove.connectedBlocks.add(index);
            }
        }
        for (Integer index : blocksToMove.connectedBlocks) {
            int c = helper.getData(index);
            helper.setData(index, (index & 0xFF) < this.waterLevel ? liquid : air);
            while (blocksToMove.contains(index - 1) || helper.getData(index - 1) == air || helper.getData(index - 1) == liquid) {
                index = index - 1;
            }
            helper.setData(index, c);
        }
    }

    private int generateStreet(ChunkPrimerHelper helper, BuildingInfo info, Random rand, int chunkX, int chunkZ, int index, int x, int z, int height) {
        ChunkPrimer primer = helper.getPrimer();
        DamageArea damageArea = info.getDamageArea();
        Style style = info.getStyle();
        int cx = chunkX * 16;
        int cz = chunkZ * 16;
        boolean xRail = info.hasXCorridor();
        boolean zRail = info.hasZCorridor();
        boolean doOceanBorder = this.isDoOceanBorder(info, chunkX, chunkZ, x, z);
        while (height < this.groundLevel) {
            IBlockState railx = Blocks.field_150448_aq.func_176223_P().func_177226_a((IProperty)BlockRail.field_176565_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST);
            IBlockState railz = Blocks.field_150448_aq.func_176223_P();
            IBlockState b = this.baseBlock;
            if (doOceanBorder) {
                b = Blocks.field_150417_aV.func_176223_P();
            } else if (height >= this.groundLevel - 5 && height <= this.groundLevel - 1) {
                if (height <= this.groundLevel - 2 && (xRail && z >= 7 && z <= 10 || zRail && x >= 7 && x <= 10)) {
                    b = air;
                    if (height == this.groundLevel - 5 && xRail && z == 10) {
                        b = railx;
                    }
                    if (height == this.groundLevel - 5 && zRail && x == 10) {
                        b = railz;
                    }
                    if (height == this.groundLevel - 2) {
                        b = xRail && x == 7 && (z == 8 || z == 9) || zRail && z == 7 && (x == 8 || x == 9) ? Blocks.field_150359_w.func_176223_P() : Blocks.field_150417_aV.func_176223_P();
                    }
                } else if (height == this.groundLevel - 1 && (xRail && x == 7 && (z == 8 || z == 9) || zRail && z == 7 && (x == 8 || x == 9))) {
                    b = Blocks.field_150426_aN.func_176223_P();
                }
            }
            BaseTerrainGenerator.setBlockState(primer, index++, damageArea.damageBlock(b, height < this.waterLevel ? this.baseLiquid : air, rand, cx + x, height, cz + z, index, style));
            ++height;
        }
        BuildingInfo.StreetType streetType = info.streetType;
        boolean elevated = info.isElevatedParkSection();
        if (elevated) {
            streetType = BuildingInfo.StreetType.PARK;
            BaseTerrainGenerator.setBlockState(primer, index++, damageArea.damageBlock(Blocks.field_150417_aV.func_176223_P(), air, rand, cx + x, height, cz + z, index, style));
            ++height;
        }
        IBlockState b = this.baseBlock;
        switch (streetType) {
            case NORMAL: {
                if (this.isStreetBorder(x, z)) {
                    if (x <= 3 && z > 3 && z < 12 && (info.getXmin().doesRoadExtendTo() || info.getXmin().hasXBridge(this.provider) >= 0)) {
                        b = style.street;
                        break;
                    }
                    if (x >= 12 && z > 3 && z < 12 && (info.getXmax().doesRoadExtendTo() || info.getXmax().hasXBridge(this.provider) >= 0)) {
                        b = style.street;
                        break;
                    }
                    if (z <= 3 && x > 3 && x < 12 && (info.getZmin().doesRoadExtendTo() || info.getZmin().hasZBridge(this.provider) >= 0)) {
                        b = style.street;
                        break;
                    }
                    if (z < 12 || x <= 3 || x >= 12 || !info.getZmax().doesRoadExtendTo() && info.getZmax().hasZBridge(this.provider) < 0) break;
                    b = style.street;
                    break;
                }
                b = style.street;
                break;
            }
            case FULL: {
                if (this.isSide(x, z)) {
                    b = style.street;
                    break;
                }
                b = style.street2;
                break;
            }
            case PARK: {
                if (x == 0 || x == 15 || z == 0 || z == 15) {
                    b = style.street;
                    if (!elevated) break;
                    boolean el00 = info.getXmin().getZmin().isElevatedParkSection();
                    boolean el10 = info.getZmin().isElevatedParkSection();
                    boolean el20 = info.getXmax().getZmin().isElevatedParkSection();
                    boolean el01 = info.getXmin().isElevatedParkSection();
                    boolean el21 = info.getXmax().isElevatedParkSection();
                    boolean el02 = info.getXmin().getZmax().isElevatedParkSection();
                    boolean el12 = info.getZmax().isElevatedParkSection();
                    boolean el22 = info.getXmax().getZmax().isElevatedParkSection();
                    if (x == 0 && z == 0) {
                        if (!el01 || !el00 || !el10) break;
                        b = Blocks.field_150349_c.func_176223_P();
                        break;
                    }
                    if (x == 15 && z == 0) {
                        if (!el21 || !el20 || !el10) break;
                        b = Blocks.field_150349_c.func_176223_P();
                        break;
                    }
                    if (x == 0 && z == 15) {
                        if (!el01 || !el02 || !el12) break;
                        b = Blocks.field_150349_c.func_176223_P();
                        break;
                    }
                    if (x == 15 && z == 15) {
                        if (!el12 || !el22 || !el21) break;
                        b = Blocks.field_150349_c.func_176223_P();
                        break;
                    }
                    if (x == 0) {
                        if (!el01) break;
                        b = Blocks.field_150349_c.func_176223_P();
                        break;
                    }
                    if (x == 15) {
                        if (!el21) break;
                        b = Blocks.field_150349_c.func_176223_P();
                        break;
                    }
                    if (z == 0) {
                        if (!el10) break;
                        b = Blocks.field_150349_c.func_176223_P();
                        break;
                    }
                    if (z != 15 || !el12) break;
                    b = Blocks.field_150349_c.func_176223_P();
                    break;
                }
                b = Blocks.field_150349_c.func_176223_P();
            }
        }
        if (doOceanBorder) {
            b = Blocks.field_150417_aV.func_176223_P();
        }
        BaseTerrainGenerator.setBlockState(primer, index++, damageArea.damageBlock(b, air, rand, cx + x, height, cz + z, index, style));
        ++height;
        if (streetType == BuildingInfo.StreetType.PARK || info.fountainType >= 0) {
            Level level;
            Level level2 = level = streetType == BuildingInfo.StreetType.PARK ? ParkData.PARKS[info.parkType] : FountainData.FOUNTAINS[info.fountainType];
            for (int l = 0; l < level.getFloor().length; ++l) {
                b = l == 0 && doOceanBorder ? Blocks.field_150463_bK.func_176223_P() : level.get(info, x, l, z);
                b = damageArea.damageBlock(b, air, rand, cx + x, height, cz + z, index, style);
                BaseTerrainGenerator.setBlockState(primer, index++, b);
                ++height;
            }
        } else if (doOceanBorder) {
            b = Blocks.field_150463_bK.func_176223_P();
            b = damageArea.damageBlock(b, air, rand, cx + x, height, cz + z, index, style);
            BaseTerrainGenerator.setBlockState(primer, index++, b);
            ++height;
        }
        int blocks = 256 - height;
        helper.setDataRange(index, index + blocks, Block.field_176229_d.func_148747_b((Object)air));
        return index += blocks;
    }

    private void generateDebris(ChunkPrimerHelper helper, Random rand, BuildingInfo info) {
        this.generateDebrisFromChunk(helper, rand, info.getXmin(), (xx, zz) -> Float.valueOf((15.0f - (float)xx.intValue()) / 16.0f));
        this.generateDebrisFromChunk(helper, rand, info.getXmax(), (xx, zz) -> Float.valueOf((float)xx.intValue() / 16.0f));
        this.generateDebrisFromChunk(helper, rand, info.getZmin(), (xx, zz) -> Float.valueOf((15.0f - (float)zz.intValue()) / 16.0f));
        this.generateDebrisFromChunk(helper, rand, info.getZmax(), (xx, zz) -> Float.valueOf((float)zz.intValue() / 16.0f));
        this.generateDebrisFromChunk(helper, rand, info.getXmin().getZmin(), (xx, zz) -> Float.valueOf((15.0f - (float)xx.intValue()) * (15.0f - (float)zz.intValue()) / 256.0f));
        this.generateDebrisFromChunk(helper, rand, info.getXmax().getZmax(), (xx, zz) -> Float.valueOf((float)(xx * zz) / 256.0f));
        this.generateDebrisFromChunk(helper, rand, info.getXmin().getZmax(), (xx, zz) -> Float.valueOf((15.0f - (float)xx.intValue()) * (float)zz.intValue() / 256.0f));
        this.generateDebrisFromChunk(helper, rand, info.getXmax().getZmin(), (xx, zz) -> Float.valueOf((float)xx.intValue() * (15.0f - (float)zz.intValue()) / 256.0f));
    }

    private void generateDebrisFromChunk(ChunkPrimerHelper helper, Random rand, BuildingInfo adjacentInfo, BiFunction<Integer, Integer, Float> locationFactor) {
        if (adjacentInfo.hasBuilding) {
            int air = Block.field_176229_d.func_148747_b((Object)LostCitiesTerrainGenerator.air);
            int liquid = Block.field_176229_d.func_148747_b((Object)this.provider.dimensionInformation.getFluidForTerrain().func_176223_P());
            float damageFactor = adjacentInfo.getDamageArea().getDamageFactor();
            if (damageFactor > 0.5f) {
                int blocks = (1 + adjacentInfo.floors) * 1000;
                float damage = Math.max(1.0f, damageFactor * 0.7f);
                int destroyedBlocks = (int)((float)blocks * damage);
                destroyedBlocks /= LostCityConfiguration.DEBRIS_TO_NEARBYCHUNK_FACTOR;
                ChunkPrimer primer = helper.getPrimer();
                for (int i = 0; i < destroyedBlocks; ++i) {
                    IBlockState b;
                    int index;
                    int x = rand.nextInt(16);
                    int z = rand.nextInt(16);
                    if (!(rand.nextFloat() < locationFactor.apply(x, z).floatValue())) continue;
                    int minIndex = x << 12 | z << 8;
                    for (index = minIndex + 255; index >= minIndex && (helper.getData(index) == air || helper.getData(index) == liquid); --index) {
                    }
                    ++index;
                    switch (rand.nextInt(5)) {
                        case 0: {
                            b = Blocks.field_150411_aY.func_176223_P();
                            break;
                        }
                        case 1: {
                            b = adjacentInfo.getStyle().bricks;
                            break;
                        }
                        default: {
                            b = adjacentInfo.getStyle().bricks_cracked;
                        }
                    }
                    BaseTerrainGenerator.setBlockState(primer, index, b);
                }
            }
        }
    }

    private boolean isDoOceanBorder(BuildingInfo info, int chunkX, int chunkZ, int x, int z) {
        Biome[] biomes;
        if (x == 0 && !info.getXmin().isCity && info.getXmin().hasXBridge(this.provider) < 0 ? LostCitiesTerrainGenerator.isOcean(biomes = this.provider.worldObj.func_72959_q().func_76937_a(null, (chunkX - 1) * 4 - 2, chunkZ * 4 - 2, 10, 10)) : x == 15 && !info.getXmax().isCity && info.getXmax().hasXBridge(this.provider) < 0 && LostCitiesTerrainGenerator.isOcean(biomes = this.provider.worldObj.func_72959_q().func_76937_a(null, (chunkX + 1) * 4 - 2, chunkZ * 4 - 2, 10, 10))) {
            return true;
        }
        return z == 0 && !info.getZmin().isCity && info.getZmin().hasZBridge(this.provider) < 0 ? LostCitiesTerrainGenerator.isOcean(biomes = this.provider.worldObj.func_72959_q().func_76937_a(null, chunkX * 4 - 2, (chunkZ - 1) * 4 - 2, 10, 10)) : z == 15 && !info.getZmax().isCity && info.getZmax().hasZBridge(this.provider) < 0 && LostCitiesTerrainGenerator.isOcean(biomes = this.provider.worldObj.func_72959_q().func_76937_a(null, chunkX * 4 - 2, (chunkZ + 1) * 4 - 2, 10, 10));
    }

    private int generateBuilding(ChunkPrimerHelper helper, BuildingInfo info, Random rand, int chunkX, int chunkZ, int index, int x, int z, int height) {
        int floortype;
        Level level;
        int f;
        BuildingInfo adjacent;
        ChunkPrimer primer = helper.getPrimer();
        DamageArea damageArea = info.getDamageArea();
        Style style = info.getStyle();
        int cx = chunkX * 16;
        int cz = chunkZ * 16;
        int lowestLevel = this.groundLevel - info.floorsBelowGround * 6;
        int buildingtop = 69 + info.floors * 6;
        boolean corridor = this.isSide(x, z) ? ((adjacent = info.getAdjacent(x, z)).hasXCorridor() || adjacent.hasZCorridor()) && this.isRailDoorway(x, z) : false;
        while (height < lowestLevel) {
            BaseTerrainGenerator.setBlockState(primer, index++, damageArea.damageBlock(this.baseBlock, height < this.waterLevel ? this.baseLiquid : air, rand, cx + x, height, cz + z, index, style));
            ++height;
        }
        while (height < buildingtop) {
            IBlockState b;
            if (corridor && height >= this.groundLevel - 5 && height <= this.groundLevel - 3) {
                b = air;
            } else {
                b = this.getBlockForLevel(info, x, z, height);
                b = damageArea.damageBlock(b, height < this.waterLevel ? this.baseLiquid : air, rand, cx + x, height, cz + z, index, style);
            }
            BaseTerrainGenerator.setBlockState(primer, index++, b);
            ++height;
        }
        while (height < buildingtop + 6 && (f = LostCitiesTerrainGenerator.getFloor(height)) < (level = info.getTopData(floortype = info.topType)).getFloor().length) {
            IBlockState b = level.get(info, x, f, z);
            b = damageArea.damageBlock(b, air, rand, cx + x, height, cz + z, index, style);
            BaseTerrainGenerator.setBlockState(primer, index++, b);
            ++height;
        }
        int blocks = 256 - height;
        helper.setDataRange(index, index + blocks, Block.field_176229_d.func_148747_b((Object)air));
        return index += blocks;
    }

    private IBlockState getBlockForLevel(BuildingInfo info, int x, int z, int height) {
        boolean down;
        BuildingInfo info2;
        int f = LostCitiesTerrainGenerator.getFloor(height);
        int l = LostCitiesTerrainGenerator.getLevel(height);
        Level[] floors = info.getFloorData();
        Level level = floors[info.floorTypes[l + info.floorsBelowGround]];
        IBlockState b = level.get(info, x, f, z);
        Style style = info.getStyle();
        if (!(l >= 0 || b != Blocks.field_150359_w.func_176223_P() && b != style.glass || !this.isSide(x, z) || info.getAdjacent((int)x, (int)z).hasBuilding && info.getAdjacent((int)x, (int)z).floorsBelowGround >= -l)) {
            b = style.bricks;
        }
        if (b == air && height == this.groundLevel && this.isSide(x, z)) {
            b = this.baseBlock;
        }
        if (b == air && f == 0 && l + info.floorsBelowGround == 0) {
            b = style.bricks;
        }
        if (x == 0 && z >= 6 && z <= 9 && f >= 1 && f <= 3 && info.hasConnectionAtX(l + info.floorsBelowGround)) {
            info2 = info.getXmin();
            if (info2.hasBuilding && (l >= 0 && l <= info2.floors || l < 0 && -l <= info2.floorsBelowGround)) {
                b = f == 3 || z == 6 || z == 9 ? style.bricks : air;
            } else if (!info2.hasBuilding && l == 0 || info2.hasBuilding && l == info2.floors + 1) {
                b = f == 3 || z == 6 || z == 9 ? style.bricks : info.doorBlock.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)(f == 1 ? BlockDoor.EnumDoorHalf.LOWER : BlockDoor.EnumDoorHalf.UPPER)).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)(z == 7 ? BlockDoor.EnumHingePosition.LEFT : BlockDoor.EnumHingePosition.RIGHT)).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST);
            }
        } else if (x == 15 && z >= 6 && z <= 9 && f >= 1 && f <= 3) {
            info2 = info.getXmax();
            if (info2.hasBuilding && (l >= 0 && l <= info2.floors || l < 0 && -l <= info2.floorsBelowGround) && info2.hasConnectionAtX(l + info2.floorsBelowGround)) {
                b = f == 3 || z == 6 || z == 9 ? style.bricks : air;
            } else if ((!info2.hasBuilding && l == 0 || info2.hasBuilding && l == info2.floors + 1) && info2.hasConnectionAtX(l + info2.floorsBelowGround)) {
                b = f == 3 || z == 6 || z == 9 ? style.bricks : info.doorBlock.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)(f == 1 ? BlockDoor.EnumDoorHalf.LOWER : BlockDoor.EnumDoorHalf.UPPER)).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)(z == 8 ? BlockDoor.EnumHingePosition.LEFT : BlockDoor.EnumHingePosition.RIGHT)).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.WEST);
            }
        }
        if (z == 0 && x >= 6 && x <= 9 && f >= 1 && f <= 3 && info.hasConnectionAtZ(l + info.floorsBelowGround)) {
            info2 = info.getZmin();
            if (info2.hasBuilding && (l >= 0 && l <= info2.floors || l < 0 && -l <= info2.floorsBelowGround)) {
                b = f == 3 || x == 6 || x == 9 ? style.bricks : air;
            } else if (!info2.hasBuilding && l == 0 || info2.hasBuilding && l == info2.floors + 1) {
                b = f == 3 || x == 6 || x == 9 ? style.bricks : info.doorBlock.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)(f == 1 ? BlockDoor.EnumDoorHalf.LOWER : BlockDoor.EnumDoorHalf.UPPER)).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)(x == 8 ? BlockDoor.EnumHingePosition.LEFT : BlockDoor.EnumHingePosition.RIGHT)).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.SOUTH);
            }
        } else if (z == 15 && x >= 6 && x <= 9 && f >= 1 && f <= 3) {
            info2 = info.getZmax();
            if (info2.hasBuilding && (l >= 0 && l <= info2.floors || l < 0 && -l <= info2.floorsBelowGround) && info2.hasConnectionAtZ(l + info2.floorsBelowGround)) {
                b = f == 3 || x == 6 || x == 9 ? style.bricks : air;
            } else if ((!info2.hasBuilding && l == 0 || info2.hasBuilding && l == info2.floors + 1) && info2.hasConnectionAtZ(l + info2.floorsBelowGround)) {
                b = f == 3 || x == 6 || x == 9 ? style.bricks : info.doorBlock.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)(f == 1 ? BlockDoor.EnumDoorHalf.LOWER : BlockDoor.EnumDoorHalf.UPPER)).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)(x == 7 ? BlockDoor.EnumHingePosition.LEFT : BlockDoor.EnumHingePosition.RIGHT)).func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.NORTH);
            }
        }
        boolean bl = down = f == 0 && l + info.floorsBelowGround == 0;
        if (b.func_177230_c() == Blocks.field_150468_ap && down) {
            b = style.bricks;
        }
        return b;
    }

    public static int getFloor(int height) {
        return (height - 3) % 6;
    }

    public static int getLevel(int height) {
        return (height - 3) / 6 - 10;
    }

    private boolean isCorner(int x, int z) {
        return x == 0 && z == 0 || x == 0 && z == 15 || x == 15 && z == 0 || x == 15 && z == 15;
    }

    private boolean isSide(int x, int z) {
        return x == 0 || x == 15 || z == 0 || z == 15;
    }

    private boolean isStreetBorder(int x, int z) {
        return x <= 3 || x >= 12 || z <= 3 || z >= 12;
    }

    private boolean isRailDoorway(int x, int z) {
        if (x == 0 || x == 15) {
            return z >= 7 && z <= 10;
        }
        if (z == 0 || z == 15) {
            return x >= 7 && x <= 10;
        }
        return false;
    }

    static {
        LOOT = new ResourceLocation("rftoolsdim", "chests/lostcitychest");
        mapping = null;
        genInfos = null;
        globalRandom = new Random();
    }

    private static class Blob
    implements Comparable<Blob> {
        private final int starty;
        private final int endy;
        private final Set<Integer> connectedBlocks = new HashSet<Integer>();
        private int connections = 0;
        private int lowestY;

        public Blob(int starty, int endy) {
            this.starty = starty;
            this.endy = endy;
            this.lowestY = 256;
        }

        public boolean contains(int index) {
            return this.connectedBlocks.contains(index);
        }

        public boolean destroyOrMoveThis() {
            return (float)this.connections / (float)this.connectedBlocks.size() < LostCityConfiguration.DESTROY_LONE_BLOCKS_FACTOR;
        }

        private boolean isOutside(BuildingInfo info, int x, int y, int z) {
            if (x < 0) {
                if (y <= info.getXmin().getMaxHeight()) {
                    ++this.connections;
                }
                return true;
            }
            if (x > 15) {
                if (y <= info.getXmax().getMaxHeight()) {
                    ++this.connections;
                }
                return true;
            }
            if (z < 0) {
                if (y <= info.getZmin().getMaxHeight()) {
                    ++this.connections;
                }
                return true;
            }
            if (z > 15) {
                if (y <= info.getZmax().getMaxHeight()) {
                    ++this.connections;
                }
                return true;
            }
            if (y < this.starty) {
                ++this.connections;
                return true;
            }
            return false;
        }

        public void scan(BuildingInfo info, ChunkPrimerHelper helper, int a, BlockPos pos) {
            ArrayDeque<BlockPos> todo = new ArrayDeque<BlockPos>();
            todo.add(pos);
            while (!todo.isEmpty()) {
                pos = (BlockPos)todo.poll();
                int index = this.calcIndex(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                if (this.connectedBlocks.contains(index) || this.isOutside(info, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p()) || helper.getData(index) == a) continue;
                this.connectedBlocks.add(index);
                if (pos.func_177956_o() < this.lowestY) {
                    this.lowestY = pos.func_177956_o();
                }
                todo.add(pos.func_177984_a());
                todo.add(pos.func_177977_b());
                todo.add(pos.func_177974_f());
                todo.add(pos.func_177976_e());
                todo.add(pos.func_177968_d());
                todo.add(pos.func_177978_c());
            }
        }

        private int calcIndex(int x, int y, int z) {
            return x << 12 | (z << 8) + y;
        }

        @Override
        public int compareTo(Blob o) {
            return this.lowestY - o.lowestY;
        }
    }
}

