/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.careerbees.items;

import com.rwtema.careerbees.BeeMod;
import com.rwtema.careerbees.helpers.NameHelper;
import com.rwtema.careerbees.helpers.StringHelper;
import com.rwtema.careerbees.items.ItemPheremoneFrame;
import com.rwtema.careerbees.lang.Lang;
import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class ItemIngredients
extends Item {
    @Nonnull
    private static final TIntObjectHashMap<IngredientType> map = new TIntObjectHashMap();

    public ItemIngredients() {
        this.func_77627_a(true);
        this.setRegistryName("careerbees", "ingredients");
        this.func_77655_b("careerbees:ingredients");
        if (BeeMod.deobf_folder) {
            for (IngredientType ingredientType : IngredientType.values()) {
                Lang.translate(this.getUnlocalizedName(ingredientType) + ".name", ingredientType.name().toLowerCase());
            }
        }
        this.func_77637_a(BeeMod.creativeTab);
    }

    public static IngredientType getIngredientType(@Nonnull ItemStack stack) {
        IngredientType ingredientType = (IngredientType)map.get(stack.func_77960_j());
        if (ingredientType == null) {
            return IngredientType.BLANK;
        }
        return ingredientType;
    }

    public static Stream<ItemStack> getBarkStacksStream() {
        return OreDictionary.getOres((String)"logWood").stream().flatMap(t -> {
            if (t.func_77960_j() == Short.MAX_VALUE) {
                NonNullList re = NonNullList.func_191196_a();
                t.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, re);
                return re.stream();
            }
            return Stream.of(t);
        }).map(s -> s.func_77955_b(new NBTTagCompound())).map(tag -> {
            ItemStack copy = IngredientType.BARK.get();
            copy.func_77983_a("bark", (NBTBase)tag);
            return copy;
        });
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    @Nullable
    public Entity createEntity(World world, Entity location, @Nonnull ItemStack itemstack) {
        return ItemIngredients.getIngredientType(itemstack).createEntity(world, location, itemstack);
    }

    @Nonnull
    public String func_77667_c(@Nonnull ItemStack stack) {
        return this.getUnlocalizedName(ItemIngredients.getIngredientType(stack));
    }

    @Nonnull
    private String getUnlocalizedName(@Nonnull IngredientType ingredientType) {
        return super.func_77658_a() + "." + ingredientType.name().toLowerCase(Locale.ENGLISH);
    }

    public int getEntityLifespan(@Nonnull ItemStack itemStack, World world) {
        return ItemIngredients.getIngredientType(itemStack).getEntityLifespan(itemStack, world);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (IngredientType ingredientType : IngredientType.values()) {
            if (!ingredientType.isInCreativeTab(tab, this.func_194125_a(tab)) || ingredientType.meta < 0) continue;
            ItemStack stack = ingredientType.get();
            ingredientType.addCreativeStacks(items, tab, stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFromItemstack(@Nonnull ItemStack stack, int tintIndex) {
        IngredientType ingredientType = ItemIngredients.getIngredientType(stack);
        return ingredientType.getColor(stack, tintIndex);
    }

    public void func_77624_a(@Nonnull ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        IngredientType ingredientType = ItemIngredients.getIngredientType(stack);
        ingredientType.addInformation(stack, worldIn, tooltip, flagIn);
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        return ItemIngredients.getIngredientType(stack).onItemRightClick(worldIn, playerIn, handIn, stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        return ItemIngredients.getIngredientType(stack).onItemUse(player, worldIn, pos, hand, facing, hitX, hitY, hitZ);
    }

    public String func_77653_i(ItemStack stack) {
        return ItemIngredients.getIngredientType(stack).getDisplayName(stack);
    }

    static {
        for (IngredientType ingredientType : IngredientType.values()) {
            map.put(ingredientType.meta, (Object)ingredientType);
        }
    }

    public static enum IngredientType implements Supplier<ItemStack>,
    Predicate<ItemStack>
    {
        BLANK(0){

            @Override
            public ItemStack get() {
                return ItemStack.field_190927_a;
            }

            @Override
            public boolean isInCreativeTab(CreativeTabs tab, boolean inCreativeTab) {
                return false;
            }
        }
        ,
        BARK(1){

            @Override
            public int getColor(ItemStack stack, int tintIndex) {
                if (tintIndex == 1) {
                    return -8355712;
                }
                return super.getColor(stack, tintIndex);
            }

            @Override
            public boolean isInCreativeTab(CreativeTabs tab, boolean inCreativeTab) {
                return tab == BeeMod.creativeTabSpammy;
            }

            @Override
            public void addCreativeStacks(@Nonnull NonNullList<ItemStack> items, CreativeTabs tab, ItemStack stack) {
                OreDictionary.getOres((String)"logWood").stream().flatMap(t -> {
                    if (t.func_77960_j() == Short.MAX_VALUE) {
                        NonNullList re = NonNullList.func_191196_a();
                        t.func_77973_b().func_150895_a(CreativeTabs.field_78027_g, re);
                        return re.stream();
                    }
                    return Stream.of(t);
                }).map(s -> s.func_77955_b(new NBTTagCompound())).map(tag -> {
                    ItemStack copy = BARK.get();
                    copy.func_77983_a("bark", (NBTBase)tag);
                    return copy;
                }).forEach(arg_0 -> items.add(arg_0));
            }

            @Override
            public String getDisplayName(@Nonnull ItemStack stack) {
                ItemStack bark;
                NBTTagCompound tagCompound = stack.func_77978_p();
                if (tagCompound != null && !(bark = new ItemStack(tagCompound.func_74775_l("bark"))).func_190926_b()) {
                    return super.getDisplayName(stack) + " - " + bark.func_82833_r();
                }
                return super.getDisplayName(stack);
            }
        }
        ,
        PHEREMONES(2){

            @Override
            @SideOnly(value=Side.CLIENT)
            public int getColor(@Nonnull ItemStack stack, int tintIndex) {
                IAllele species;
                NBTTagCompound tagCompound;
                if (tintIndex > 0 && tintIndex <= 2 && (tagCompound = stack.func_77978_p()) != null && (species = AlleleManager.alleleRegistry.getAllele(tagCompound.func_74779_i("species"))) instanceof IAlleleBeeSpecies) {
                    return ((IAlleleBeeSpecies)species).getSpriteColour(tintIndex - 1);
                }
                return super.getColor(stack, tintIndex);
            }

            @Override
            public boolean isInCreativeTab(CreativeTabs tab, boolean inCreativeTab) {
                return tab == BeeMod.creativeTabSpammy;
            }

            @Override
            public void addCreativeStacks(@Nonnull NonNullList<ItemStack> items, CreativeTabs tab, ItemStack stack) {
                for (IBee iBee : BeeManager.beeRoot.getIndividualTemplates()) {
                    if (iBee.isSecret()) continue;
                    items.add((Object)ItemPheremoneFrame.getPheremoneStack(iBee.getGenome().getPrimary()));
                }
            }

            @Override
            public String getDisplayName(@Nonnull ItemStack stack) {
                IAllele species;
                NBTTagCompound tagCompound = stack.func_77978_p();
                if (tagCompound != null && (species = AlleleManager.alleleRegistry.getAllele(tagCompound.func_74779_i("species"))) instanceof IAlleleBeeSpecies) {
                    return super.getDisplayName(stack) + " - " + species.getAlleleName();
                }
                return super.getDisplayName(stack);
            }
        }
        ,
        DUSTIRON(4, "dustIron"),
        DUSTGOLD(5, "dustGold"),
        DUSTCOPPER(6, "dustCopper"),
        DUSTTIN(7, "dustTin"),
        DUSTBRONZE(8, "dustBronze"),
        REPORT(9){

            @Override
            public int getEntityLifespan(ItemStack itemStack, World world) {
                return 10;
            }

            @Override
            public void addInformation(@Nonnull ItemStack stack, World worldIn, @Nonnull List<String> tooltip, ITooltipFlag flagIn) {
                NBTTagCompound nbt = stack.func_77978_p();
                if (nbt != null) {
                    String name = nbt.func_74764_b("custom_name") ? nbt.func_74779_i("custom_name") : I18n.func_74838_a((String)nbt.func_74779_i("name"));
                    String dimname = Lang.translate("Unknown Dimension");
                    int dim = nbt.func_74762_e("world_dim");
                    if (DimensionManager.isDimensionRegistered((int)dim)) {
                        DimensionType providerType = DimensionManager.getProviderType((int)dim);
                        dimname = StringHelper.capFirst(providerType.func_186065_b());
                    }
                    long time = nbt.func_74763_f("world_time");
                    long time_day = time % 24000L;
                    long time_hour = time_day / 1000L;
                    int time_minute = (int)((float)(time_day % 1000L) / 1000.0f * 60.0f);
                    tooltip.add(Lang.translateArgs("On Day %s at %s, in the \"%s\" dimension, an incident occured in which a subject (identified as \"%s\") was caught trespassing in restricted area. Subject was duly cautioned, and then stung to death.", (int)(time / 24000L), String.format("%02d:%02d", time_hour, time_minute), dimname, name));
                    NBTTagList drops = nbt.func_150295_c("drops", 10);
                    if (drops.func_74745_c() > 0) {
                        tooltip.add("");
                        tooltip.add(Lang.translate("Confiscated Items:"));
                        for (int i = 0; i < drops.func_74745_c(); ++i) {
                            NBTTagCompound compoundTagAt = drops.func_150305_b(i);
                            ItemStack itemStack = new ItemStack(compoundTagAt);
                            itemStack.func_190920_e(compoundTagAt.func_74762_e("Count"));
                            if (itemStack.func_190926_b()) continue;
                            tooltip.add(" -" + itemStack.func_190916_E() + "x " + itemStack.func_82833_r());
                        }
                    }
                    int officer_id = Short.toUnsignedInt(nbt.func_74765_d("officer_name"));
                    tooltip.add("");
                    tooltip.add(Lang.translateArgs("Signed: Officer %s (#%s)", NameHelper.QUEEN_NAMES.getName(officer_id), officer_id));
                }
            }
        }
        ,
        INGOTHONEYCOLM(10, "ingotHoneyComb"),
        YING(11, "careerBeesYing"),
        YANG(12, "careerBeesYang"),
        TRIQUETRA(13){

            @Override
            public EnumActionResult onItemUse(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
                IBlockState state = worldIn.func_180495_p(pos);
                for (IProperty prop : state.func_177228_b().keySet()) {
                    if (!prop.func_177701_a().equals("color") || prop.func_177699_b() != EnumDyeColor.class) continue;
                    EnumDyeColor value = (EnumDyeColor)state.func_177229_b(prop);
                    EnumDyeColor next = EnumDyeColor.values()[(value.ordinal() + 1) % EnumDyeColor.values().length];
                    return state.func_177230_c().recolorBlock(worldIn, pos, facing, next) ? EnumActionResult.SUCCESS : EnumActionResult.FAIL;
                }
                return EnumActionResult.PASS;
            }
        };

        public final int meta;
        @Nullable
        public final String oreDic;
        @SideOnly(value=Side.CLIENT)
        public ModelResourceLocation mrl;

        private IngredientType(int meta) {
            this(meta, (String)null);
        }

        private IngredientType(int meta, String oreDic) {
            this.meta = meta;
            this.oreDic = oreDic;
        }

        @Override
        public ItemStack get() {
            return new ItemStack((Item)BeeMod.instance.itemIngredients, 1, this.meta);
        }

        @Override
        public boolean test(@Nonnull ItemStack stack) {
            return !stack.func_190926_b() && stack.func_77973_b() == BeeMod.instance.itemIngredients && stack.func_77960_j() == this.ordinal();
        }

        @SideOnly(value=Side.CLIENT)
        public int getColor(ItemStack stack, int tintIndex) {
            return 0xFFFFFF;
        }

        public String getDisplayName(ItemStack stack) {
            return I18n.func_74838_a((String)(BeeMod.instance.itemIngredients.func_77658_a() + "." + this.name().toLowerCase(Locale.ENGLISH) + ".name")).trim();
        }

        public boolean isInCreativeTab(CreativeTabs tab, boolean inCreativeTab) {
            return inCreativeTab;
        }

        public void addCreativeStacks(@Nonnull NonNullList<ItemStack> items, CreativeTabs tab, ItemStack stack) {
            items.add((Object)stack);
        }

        @Nonnull
        public ActionResult<ItemStack> onItemRightClick(World worldIn, EntityPlayer playerIn, EnumHand handIn, @Nonnull ItemStack stack) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }

        public void addInformation(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        }

        @Nullable
        public Entity createEntity(World world, Entity location, ItemStack itemstack) {
            return null;
        }

        public int getEntityLifespan(ItemStack itemStack, World world) {
            return 6000;
        }

        public EnumActionResult onItemUse(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
            return EnumActionResult.PASS;
        }
    }
}

